/*
 * Copyright (C) 2008 Instituto Nokia de Tecnologia. All rights reserved.
 *
 * This file is part of QZion.
 *
 * QZion is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QZion is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QZion.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <QtGui>
#include <QtCore>

#include "qgraphicsziongroup.h"
#include "qzionabstractcanvas.h"

QGraphicsZionGroup::QGraphicsZionGroup(QGraphicsItem *parent)
    : QGraphicsItem(parent)
{
    setClipping(true);
    setAcceptHoverEvents(false);
    setHandlesChildEvents(true);
}

QGraphicsZionGroup::~QGraphicsZionGroup()
{
}

bool QGraphicsZionGroup::clipping() const
{
    return (bool) (flags() & QGraphicsItem::ItemClipsChildrenToShape);
}

void QGraphicsZionGroup::setClipping(const bool on)
{
    setFlag(QGraphicsItem::ItemClipsChildrenToShape, on);
}

QSize QGraphicsZionGroup::size() const
{
    return _boundingRect.size().toSize();
}

void QGraphicsZionGroup::setSize(const QSize &size)
{
    if (size == this->size())
        return;

    prepareGeometryChange();
    _boundingRect = QRectF(0, 0, size.width(), size.height());
    update();
}

QRectF QGraphicsZionGroup::boundingRect() const
{
    return _boundingRect;
}

void QGraphicsZionGroup::paint(QPainter*,
                               const QStyleOptionGraphicsItem*,
                               QWidget*)
{

}

void QGraphicsZionGroup::mousePressEvent(QGraphicsSceneMouseEvent *e)
{
    const QPoint np = e->pos().toPoint();
    QMouseEvent event = QMouseEvent(e->type(), np, e->button(),
                                    e->button(), Qt::NoModifier);
    owner->mousePressEvent(&event);
}

void QGraphicsZionGroup::mouseReleaseEvent(QGraphicsSceneMouseEvent *e)
{
    const QPoint np = e->pos().toPoint();
    QMouseEvent event = QMouseEvent(e->type(), np, e->button(),
                                    e->button(), Qt::NoModifier);
    owner->mouseReleaseEvent(&event);
}

void QGraphicsZionGroup::hoverMoveEvent(QGraphicsSceneHoverEvent *e)
{
    const QPoint np = e->pos().toPoint();
    QMouseEvent event = QMouseEvent(e->type(), np, Qt::NoButton,
                                    Qt::NoButton, Qt::NoModifier);
    owner->mouseMoveEvent(&event);
}

void QGraphicsZionGroup::mouseMoveEvent(QGraphicsSceneMouseEvent *e)
{
    const QPoint np = e->pos().toPoint();
    QMouseEvent event = QMouseEvent(e->type(), np, e->button(),
                                    e->button(), Qt::NoModifier);
    owner->mouseMoveEvent(&event);
}
