/****************************************************************************
    NL3W netlist utility for BSch3V
    Copyright (C) 2004-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/


#ifndef NETLIST_H
#define NETLIST_H

#ifdef _MSVC
	#pragma warning (disable: 4786)
#endif

#include <stdio.h>
#include <assert.h>
#include <ctype.h>
#include <string>
#include <algorithm>
#include <list>
using namespace std;
#include "xbschstringlist.h"
#include "ce3io.h"
#include "xbschobj.h"
#include "xbschjunc.h"
#include "xbschlabel.h"
#include "xbschcomment.h"
#include "xbschtag.h"
#include "xbschcomponent.h"

#include "xbschline.h"
#include "xbschwirenl.h"
#include "xbschentry.h"
#include "xbschdelobj.h"
#include "xbschsheetinfo.h"
#include "xbschdoc.h"
#include "nlpin.h"


typedef list<SNlPin*> NlPinList;
typedef list<SNlPin*>::iterator NlPinListIterator;

typedef list<SPoint> PointList;
typedef list<SPoint>::iterator PointListIterator;


typedef SNlPin* PSNlPin;

class SSingleNetList
{
public:
	string m_SignalName;
	SNlPin** m_pPinArray;
	int		m_nPinCount;
	SSingleNetList(){
		m_SignalName=="";
		m_pPinArray	=NULL;
		m_nPinCount =0;
	}
	~SSingleNetList();
};

class SPartsListElement
{
public:
	string	m_prefix;
	int		m_suffix;
	string	m_name;
	string  m_note;
};

typedef SPartsListElement* PSPartsListElement;



typedef list<SSingleNetList*> NetList;
typedef list<SSingleNetList*>::iterator NetListIterator;

//#include "netclass.h"

class SNetList{
protected:
	XBSchObjList m_listTagPower;		//Ÿ
	XBSchObjList m_listNcTagPower;		//ȤʤäŸ
	XBSchObjList m_listWire;			//磻䡼
	XBSchObjList m_listJunc;			//ܹ
	XBSchObjList m_listLabel;			//٥
	NlPinList	 m_listNlPin;			//󤷤ԥ
	NlPinList	 m_listNlNcPin;			//Ȥʤäԥ
	NlPinList	 m_listNlConfPin;		//ʣԥ
	NlPinList	 m_listNoNumPin;		//ԥֹʤԥ
	int			 m_xOffset;				//setData¹Ԥ뤿Ӥ10000
	PSPartsListElement* m_pArrayPlistElem;
public:
	XBSchObjList m_listComponent;		//Ÿʰʳ
	NetList		 m_listNet;

public:
	SNetList();
	~SNetList();
	static string removeWS(const string& str);				//ʸξüΥۥ磻ȥڡκ 
	static void clearXBSchObjList(XBSchObjList& listObj);	//SXBSchObjΥݥ󥿥ꥹȤβ
	static void clearNlPin(NlPinList& listPin);				//SNlPinΥݥ󥿥ꥹȤβ
	void clear();
	void clearNetList(NetList& netlist);
	void setData(XBSchObjList* plistSrc);//SXBSchDocƤǤ鼡Ǥ򥳥ԡƿʬΥꥹȤɲä롣
	void createNetList(bool bExcludeNC);
	void createPartsList();
	void clearPlistElem();
	int writeReport(FILE* fp);			//ݡȥե
	int writePADSNetList(FILE* fp);		//PADSΥͥåȥꥹȽ
	int writeTeleNetList(FILE* fp);		//ƥ쥷ΥͥåȥꥹȽ
	int writePartsList(FILE* fp);		//CSVʥꥹȽ

protected:
	bool testLineJoint(int& al,int& ar,int bl,int br); //ʿޤϿľηƥȤ롣
	void jointWire();			//磻䡼Ϣ
	void divideWire();			//磻䡼ܹʬ䤹
	void nameFromTagPower();	//Ÿʤ򸵤ȥԥ̾Ĥ
	void nameFromLabel();		//٥򸵤̾ɲ

	
	void enumPin();//ͭʤΥԥ󤹤
	bool quaryExist(stringList& strlist,string& str);//ʸʸꥹȤ¸ߤ뤫ɤɤΥå
	bool quaryExist(PointList& pointlist,SPoint point);//ꥹȤ¸ߤ뤫ɤɤΥå
	SSingleNetList* NetList1();//ҤȤĤΥΡɤΥͥå
	void enumConflictingPin();

	static void parseRefNum(const string& refnum,string& prefix,int& suffix);
	static int CompareSNlPin( const void *ppin1, const void *ppin2 );//SNlPinΥԥ̾ˤ羮
	static int CompareSPartsListElement( const void *p1, const void *p2 ); //SPartsListElementֹˤ

};

struct SNetlistOption{
	FILE* fpDst;
	FILE* fpRpt;
	int   listType;
	bool  bPlistMode;
	bool  bExcludeNC;
};


//ͥåȥꥹȤ롣
//int netlist(int srcfiles, const char* srcfile[],const char* cfgpath,FILE* fp,int listtype,bool bPlist);
int netlist(int srcfiles, const char* srcfile[],SNetlistOption& option);







typedef SXBSchObj* PSXBSchObj;

#endif