/* GLIB - Library of useful routines for C programming
 * Copyright (C) 2002  Soeren Sandmann (sandmann@daimi.au.dk)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * This is a modified version of GtkSequence from GTK+-2.6.1 by the
 * Ochusha Project.  See the AUTHORS file for a list of people on the
 * Ochusha Project.  See the ChangeLog files for a list of changes.
 * These files are distributed with ochusha at
 * http://ochusha.sourceforge.jp/.
 *
 * Since libmodifiedgtk2 only has limited set of modified widgets and
 * is intended to be used with original GTK+, I don't want to cause name
 * space conflictions with original widgets sets from GTK+.  Therefore,
 * ALL PUBLICLY AVAILABLE NAMES ARE RENAMED.
 *
 * $Id: mod_sequence.h,v 1.1.2.1 2005/02/18 17:30:24 fuyu Exp $
 */

#ifndef __MOD_SEQUENCE_H__
#define __MOD_SEQUENCE_H__

#include <glib.h>


/* Warning
 *
 * Do not use this API. It is here, internal to gtk+, for 2.6 only.
 * In 2.8 the plan is to add a similar data structure to GLib. 
 */

typedef struct _ModSequence      ModSequence;
typedef struct _ModSequenceNode *ModSequencePtr;

/* ModSequence */
ModSequence *  _mod_sequence_new              (GDestroyNotify     data_destroy);
void           _mod_sequence_free             (ModSequence       *seq);
void           _mod_sequence_sort             (ModSequence       *seq,
					       GCompareDataFunc   cmp_func,
					       gpointer           cmp_data);
void           _mod_sequence_append           (ModSequence       *seq,
					       gpointer           data);
void           _mod_sequence_prepend          (ModSequence       *seq,
					       gpointer           data);
ModSequencePtr _mod_sequence_insert           (ModSequencePtr     ptr,
					       gpointer           data);
void           _mod_sequence_remove           (ModSequencePtr     ptr);
void	       _mod_sequence_move             (ModSequencePtr     ptr,
					       ModSequencePtr	  pos);
void	       _mod_sequence_swap             (ModSequencePtr     a,
					       ModSequencePtr	  b);
ModSequencePtr _mod_sequence_insert_sorted    (ModSequence       *seq,
					       gpointer           data,
					       GCompareDataFunc   cmp_func,
					       gpointer           cmp_data);
void	       _mod_sequence_set	      (ModSequencePtr	  ptr,
					       gpointer		  data);
void           _mod_sequence_insert_sequence  (ModSequencePtr     ptr,
					       ModSequence       *other_seq);
void           _mod_sequence_concatenate      (ModSequence       *seq1,
					       ModSequence       *seq);
void           _mod_sequence_remove_range     (ModSequencePtr     begin,
					       ModSequencePtr     end,
					       ModSequence      **removed);
gint           _mod_sequence_get_length       (ModSequence       *seq);
ModSequencePtr _mod_sequence_get_end_ptr      (ModSequence       *seq);
ModSequencePtr _mod_sequence_get_begin_ptr    (ModSequence       *seq);
ModSequencePtr _mod_sequence_get_ptr_at_pos   (ModSequence       *seq,
					       gint               pos);
void           _mod_sequence_sort_changed     (ModSequencePtr     ptr,
					       GCompareDataFunc   cmp_func,
					       gpointer           cmp_data);
void	       _mod_sequence_foreach	      (ModSequence	 *seq,
					       GFunc		  func,
					       gpointer		  data);

/* ModSequencePtr */
gboolean       _mod_sequence_ptr_is_end       (ModSequencePtr     ptr);
gboolean       _mod_sequence_ptr_is_begin     (ModSequencePtr     ptr);
gint           _mod_sequence_ptr_get_position (ModSequencePtr     ptr);
ModSequencePtr _mod_sequence_ptr_next         (ModSequencePtr     ptr);
ModSequencePtr _mod_sequence_ptr_prev         (ModSequencePtr     ptr);
ModSequencePtr _mod_sequence_ptr_move         (ModSequencePtr     ptr,
					       guint              leap);
gpointer       _mod_sequence_ptr_get_data     (ModSequencePtr     ptr);
ModSequence   *_mod_sequence_ptr_get_sequence (ModSequencePtr	  ptr);

/* search */

/* return TRUE if you want to be called again with two
 * smaller segments
 */
typedef gboolean (* ModSequenceSearchFunc) (ModSequencePtr begin,
					     ModSequencePtr end,
					     gpointer     data);

void         _mod_sequence_search             (ModSequence               *seq,
					       ModSequenceSearchFunc      f,
					       gpointer                 data);

/* debug */
gint         _mod_sequence_calc_tree_height   (ModSequence               *seq);

#endif /* __MOD_SEQUENCE_H__ */
