/*
 * Copyright (C) 2004 Robert Hogan <robert at roberthogan dot net>
 */

#include "klamav.h"
#include "freshklam.h"
#include "klamd.h"
#include "sigtool.h"
#include "klamscan.h"
#include "kuarantine.h"
#include "aboutklamav.h"
#include "dbviewer.h"
#include "activityviewer.h"
#include "version.h"
#include "firstrunwizard.h"
#include "collectiondb.h"
#include "configdialog.h"
#include "klamavconfig.h"

#include <klocale.h>


#include <kaction.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <ksystemtray.h>
#include <kpopupmenu.h>
#include <kdebug.h>
#include <kmessagebox.h>
#include <kurl.h>

#include <qdir.h>
#include <qfile.h>

Klamav *kmain = 0L;



Klamav::Klamav()
    : KMainWindow( 0, "KlamAV " )
{

	downloadDBForWizard = false;
	downloadClamAVForWizard = false;

	kmain = this;
	QVBoxLayout *top = new QVBoxLayout(this,10,10);
	tab = new QTabWidget(this);
	
  	_tray = new KSystemTray(kmain, "klamav tray");
	_tray->setPixmap(KSystemTray::loadIcon("klamavbw"));
	connect(_tray,SIGNAL(quitSelected()),SLOT(shuttingDown()));
	
	KPopupMenu *conf_menu = _tray->contextMenu();
        EnableKlamd = new KAction(i18n("&Enable Auto-Scan"), "klamav", 0,this, SLOT(contextEnable()),actionCollection(),"klamd_enable");
        DisableKlamd = new KAction(i18n("&Disable Auto-Scan"),"klamavbw", 0,this, SLOT(contextDisable()),actionCollection(),"klamd_disable");
        
	EnableFreshklam = new KAction(i18n("&Enable Auto-Updates"), "klamavbwdl", 0,this, SLOT(contextEnableFK()),actionCollection(),"fk_enable");
        DisableFreshklam = new KAction(i18n("&Disable Auto-Updates"),"klamavbw", 0,this, SLOT(contextDisableFK()),actionCollection(),"fk_disable");

	EnableFreshklam->plug(conf_menu);
	DisableFreshklam->plug(conf_menu);
	EnableKlamd->plug(conf_menu);
	DisableKlamd->plug(conf_menu);
	
	QToolTip::add( _tray, i18n( "KlamAV - Virus Protection for KDE" ) );
	_tray->show();
	
	DisableFreshklam->setEnabled(FALSE);
	EnableFreshklam->setEnabled(TRUE);
	DisableKlamd->setEnabled(FALSE);
	EnableKlamd->setEnabled(TRUE);

        KConfig* config = KGlobal::config();
        config->setGroup("Freshklam");
        QStringList DatabasePaths = config->readListEntry("lastDownloadPaths");

        config->setGroup("Kuarantine");
        QStringList QuarantinePaths = config->readListEntry("KuarantineLocations");

	if ((DatabasePaths.isEmpty()) && (QuarantinePaths.isEmpty())){

            firstRunWizard();
        }

	activityviewer = new Activityviewer(this);

	klamscan = new Klamscan(this);
	tab->addTab(klamscan, i18n("&Scan"));

	klamd = new Klamd(this);
	tab->addTab(klamd, i18n("&Auto-Scan"));

	connect(klamd->search_button,SIGNAL(clicked()),SLOT(contextEnable()));
	connect(klamd->cancel_button,SIGNAL(clicked()),SLOT(contextDisable()));

		
	freshklam = new Freshklam(this);
	tab->addTab(freshklam, i18n("&Update"));

	connect(freshklam->search_button,SIGNAL(clicked()),SLOT(contextUpdateFK()));
	connect(freshklam->cancel_button,SIGNAL(clicked()),SLOT(contextDisableFK()));
	
	sigtool = new Sigtool(this);
	tab->addTab(sigtool, i18n("&E-Mail Protection"));
	
	
	kuarantine = new Kuarantine(this);
	tab->addTab(kuarantine, i18n("&Quarantine"));

	klamdb = new KlamDB(this);
	tab->addTab(klamdb, i18n("Virus Browser"));

	tab->addTab(activityviewer, i18n("Events"));
	
	aboutklamav = new Aboutklamav(this);
	tab->addTab(aboutklamav, i18n("Abou&t"));
	
  


	top->addWidget(tab);
	
	
	connect(tab,SIGNAL(currentChanged ( QWidget * ) ),klamdb,SLOT(shouldIShow(QWidget *)));

	KStdAction::quit(this, SLOT(shuttingDown()), actionCollection());
  
  	if (KApplication::kApplication()->isRestored()){
/*		config = KGlobal::config();
		config->setGroup("Klamd");
		QString RunKlamd = config->readEntry("Enabled");
		
		if (RunKlamd == "Yes"){
			_tray->setPixmap(KSystemTray::loadIcon("klamav"));
			DisableKlamd->setEnabled(TRUE);
			EnableKlamd->setEnabled(FALSE);

		}
*/
		hide();
	}else{
		show();
   	}

	
	if ((firstDownload) || (downloadDBForWizard)){
		kdDebug() << "firstdownload" << firstDownload << endl;
		kdDebug() << "downloadDBForWizard" << downloadDBForWizard << endl;
		tab->setCurrentPage(2);
		freshklam->slotSearch();
	}
        if (downloadClamAVForWizard)
            freshklam->checkForNewClamAVNow();
	//klamdb->shouldIShow();

	CollectionDB::instance()->insertEvent("Launch","KlamAV Launched");

    setCaption(QString("KlamAV %1 (Using ClamAV %2)").arg(KLAMAV_VERSION).arg(KlamavConfig::clamAVVersion()));
}
	
Klamav::~Klamav()
{
    KlamavConfig::writeConfig();
	kapp->quit();
}

void  Klamav::shuttingDown(){

	this->topLevelWidget()->hide();

}

bool Klamav::queryClose() {
	if ((klamd->isKlamdAlive()) || (freshklam->isFreshklamAlive())){
        KMessageBox::information (this,i18n("<p>KlamAV will stay open in the system tray. <br><br>"
        " <b>Remember</b> - you can't close KlamAV while <br> auto-scanning "
        " and/or auto-updating are still running!</p>"),"KlamAV","dontshow");
		hide();
		return false;

	}
	return true;
}


void Klamav::contextEnable() {
	
	klamd->startKlamd();
	//if (klamd->startKlamd()){
			//_tray->setPixmap(KSystemTray::loadIcon("klamav"));
			//EnableKlamd->setEnabled(FALSE);
			//DisableKlamd->setEnabled(TRUE);
	//}
}

void Klamav::clamdStopped() {
	if (freshklam->isFreshklamAlive())
		_tray->setPixmap(KSystemTray::loadIcon("klamavbwdl"));
	else
		_tray->setPixmap(KSystemTray::loadIcon("klamavbw"));
	DisableKlamd->setEnabled(FALSE);
	EnableKlamd->setEnabled(TRUE);
}

void Klamav::contextDisable() {
	klamd->slotCancel();
    resetAutoScan();
}

void Klamav::resetAutoScan() {
	if (freshklam->isFreshklamAlive())
		_tray->setPixmap(KSystemTray::loadIcon("klamavbwdl"));
	else
		_tray->setPixmap(KSystemTray::loadIcon("klamavbw"));
	DisableKlamd->setEnabled(FALSE);
	EnableKlamd->setEnabled(TRUE);
}


void Klamav::contextUpdateFK() {

    freshklam->slotSearch();
}

void Klamav::contextEnableFK() {

    freshklam->enableAutoUpdates();
}

void Klamav::contextDisableFK() {
	
	freshklam->slotCancel();
// 	DisableFreshklam->setEnabled(FALSE);
// 	EnableFreshklam->setEnabled(TRUE);

}
void Klamav::showVirusBrowser() {
	tab->setCurrentPage(5);
}

void Klamav::firstRunWizard() {

        FirstRunWizard wizard;
        wizard.setCaption( i18n( "First-Run Wizard" ));
        
        QString homepath = getenv("HOME");
        QString defaultdb = homepath + "/.klamav/database";
        QString defaultquar = homepath + "/.klamav/quarantine";
        if( wizard.exec() != QDialog::Rejected ){
    
            KConfig* config = KGlobal::config();

            config->setGroup("Freshklam");
            
            QString wizardDBPath = wizard.databasePath().path(-1);
            QString wizardQRPath = wizard.quarantinePath().path(-1);
/*            kdDebug() << wizard.databasePath() << endl;
            kdDebug() << wizard.defaultDatabasePath() << endl;*/
            //Configure Database Path
            QStringList lastDownloadPaths;
            if ((wizardDBPath != "") && (QDir::cleanDirPath(wizardDBPath) != defaultdb)){
                lastDownloadPaths.prepend( QString("%1").arg(wizardDBPath));
                checkDir(wizardDBPath);
            }else{
                lastDownloadPaths.prepend( QString("%1").arg(wizard.defaultDatabasePath()));
                createDefaultKlamAVDir("database");
            }
            config->writeEntry("lastDownloadPaths", lastDownloadPaths);
            config->sync();
            //Configure Quarantine Path
            QStringList lastQuarLocations;
        
            config->setGroup("Kuarantine");
            
/*            kdDebug() << wizard.quarantinePath() << endl;
            kdDebug() << wizard.defaultQuarantinePath() << endl;
            kdDebug() << defaultquar << endl;*/
            if ((wizardQRPath != "") && (QDir::cleanDirPath(wizardQRPath) != defaultquar)){
                lastQuarLocations.prepend( QString("%1").arg(wizardQRPath));
                checkDir(wizardQRPath);
            }else{
                lastQuarLocations.prepend( QString("%1").arg(wizard.defaultQuarantinePath()));
                createDefaultKlamAVDir("quarantine");
            }
            config->writeEntry("KuarantineLocations", lastQuarLocations);
            config->sync();

            if (wizard.downloadDatabase()){
                kdDebug() << "downloading database" << endl;
                downloadDBForWizard = true;
            }
            if (wizard.downloadClamAV()){
                kdDebug() << "downloading clamav" << endl;
                downloadClamAVForWizard = true;
            }

        }

}

void  Klamav::createDefaultKlamAVDir(QString type){

    QString path = getenv("HOME");
    bool ok = true;
    // directory exist?
    path += "/.klamav";
    QDir klamavdir(path);
    if (!klamavdir.exists() && !klamavdir.mkdir(path))
        ok = false;

    path += "/" + type;
    if (ok)
    {
        QDir klamavqdir(path);
        if (!klamavqdir.exists() && !klamavqdir.mkdir(path))
            ok = false;
        else
            chmod((const char *)path,0700);
    }

}

void  Klamav::checkDir(QString path){

    QDir klamavdir(path);
    QFile f1( path );
    if ((!klamavdir.exists()) || (f1.open( IO_ReadWrite )))
        KMessageBox::information(this, i18n("Either the directory %1 does not exist or you are not able to write to it. Either way, you will have to change it as it cannot be used. Sorry!").arg(path));
    f1.close(); 

}

void Klamav::slotConfigKlamav( const QCString& page )
{

    KlamavConfigDialog* dialog = (KlamavConfigDialog*) KConfigDialog::exists( "settings" );

    if( !dialog )
    {
        //KConfigDialog didn't find an instance of this dialog, so lets create it :
        dialog = new KlamavConfigDialog( this, "settings", KlamavConfig::self() );
        //connect( dialog, SIGNAL(settingsChanged()), SLOT(applySettings()) );
    }

    //FIXME it seems that if the dialog is on a different desktop it gets lost
    //      what do to? detect and move it?

    dialog->show();
    dialog->raise();
    dialog->setActiveWindow();

    //so that if the engine page is needed to be shown it works

    if ( !page.isNull() ) dialog->showPage( page );
}


#include "klamav.moc"
