//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QMetaObject;
import org.kde.qt.QtSupport;
import org.kde.qt.QObject;
import org.kde.qt.QPopupMenu;
import org.kde.qt.QEvent;
import org.kde.qt.QWidget;
import org.kde.qt.QDomElement;
import org.kde.qt.QObject;

/**

 The manager that knows all dockwidgets and handles the dock process (and member of the dockwidget class set).
 More or less a helper class for the KDockWidget class set but of interest for some functionality
 that can be called within a KDockMainWindow or a KDockWidget .
 An important feature is the ability to read or save the current state of all things concerning to
 dockwidgets to KConfig .
 The dockmanager is also often used when a certain dockwidget or a child of such dockwidget must be found.
 See {@link KDockManagerSignals} for signals emitted by KDockManager
		@author Max Judin (documentation: Falk Brettschneider).
 
		@short    The manager that knows all dockwidgets and handles the dock process (and member of the dockwidget class set).

*/
public class KDockManager extends QObject  {
	protected KDockManager(Class dummy){super((Class) null);}
	public static final int Unknown = 0;
	public static final int WrapExistingWidgetsOnly = 1;
	public static final int RestoreAllDockwidgets = 2;

	public native QMetaObject metaObject();
	public native String className();
	/**	
		 Constructs a dockmanager. Some initialization happen:
		
			<li>
			It installs an event filter for the main window,
			</li>
			
			<li>
			a control list for dock objects
			</li>
			
			<li>
			a control list for menu items concerning to menus provided by the dockmanager
			</li>
			
			<li>
			Some state variables are set
			</li>
				@param mainWindow the main window controlled by this
			@param name the internal QOject name
		   		@short    Constructs a dockmanager.
	*/
	public KDockManager(QWidget mainWindow, String name) {
		super((Class) null);
		newKDockManager(mainWindow,name);
	}
	private native void newKDockManager(QWidget mainWindow, String name);
	public KDockManager(QWidget mainWindow) {
		super((Class) null);
		newKDockManager(mainWindow);
	}
	private native void newKDockManager(QWidget mainWindow);
	public native void dumpDockWidgets();
	/**	
		 Saves the current state of the dockmanager and of all controlled widgets.
		 State means here to save the geometry, visibility, parents, internal object names, orientation,
		 separator positions, dockwidget-group information, tab widget states (if it is a tab group) and
		 last but not least some necessary things for recovering the dockmainwindow state.
			@param c the KDE configuration saver
			@param group the name of the section in KConfig
		   		@short    Saves the current state of the dockmanager and of all controlled widgets.
	*/
	public native void writeConfig(KConfig c, String group);
	public native void writeConfig(KConfig c);
	public native void writeConfig();
	/**	
		 Like writeConfig but reads the whole stuff in.
			 In order to restore a window configuration
		 from a config file, it looks up widgets by name
		 (QObject.name) in the childDock variable of
		 KDockManager. This list in turn contains all
		 KDockWidgets (according to the KDockWidget constructor).
		 So in principle, in order to restore a window layout,
		 one must first construct all widgets, put each of them in a
		 KDockWidget and then call readConfig(). And for all that
		 to work, each widget must have a unique name.
			@param c the KDE configuration saver
			@param group the name of the section in KConfig
		   		@short    Like writeConfig but reads the whole stuff in.
	*/
	public native void readConfig(KConfig c, String group);
	public native void readConfig(KConfig c);
	public native void readConfig();
	public native void setMainDockWidget2(KDockWidget arg1);
	/**	
		 Saves the current dock window layout into a DOM tree below the given element.
		   		@short    Saves the current dock window layout into a DOM tree below the given element.
	*/
	public native void writeConfig(QDomElement base);
	/**	
		 Reads the current dock window layout from a DOM tree below the given element.
		   		@short    Reads the current dock window layout from a DOM tree below the given element.
	*/
	public native void readConfig(QDomElement base);
	/**	
		 Shows all encapsulated widgets of all controlled dockwidgets and shows all dockwidgets which are
		 parent of a dockwidget tab group.
		   		@short    Shows all encapsulated widgets of all controlled dockwidgets and shows all dockwidgets which are  parent of a dockwidget tab group.
	*/
	public native void activate();
	/**	
		 It's more or less a method that catches several events which are interesting for the dockmanager.
		 Mainly mouse events during the drag process of a dockwidgets are of interest here.
			@param object the object that sends the event
			@param event the event
				@return the return value of the method call of the base class method
   
		@short    It's more or less a method that catches several events which are interesting for the dockmanager.
	*/
	public native boolean eventFilter(QObject object, QEvent event);
	/**	
		 This method finds out what a widgets' dockwidget is. That means the dockmanager has a look at all
		 dockwidgets it knows and tells you when one of those dockwidgets covers the given widget.
			@param w any widget that is supposed to be encapsulated by one of the controlled dockwidgets
				@return the dockwidget that encapsulates that widget, otherwise 0
   
		@short    This method finds out what a widgets' dockwidget is.
	*/
	public native KDockWidget findWidgetParentDock(QWidget w);
	/**	
		 Works like makeDockVisible() but can be called for widgets that covered by a dockwidget.
			@param w the widget that is encapsulated by a dockwidget that turns to visible.
		   		@short    Works like makeDockVisible() but can be called for widgets that covered by a dockwidget.
	*/
	public native void makeWidgetDockVisible(QWidget w);
	/**	
				@return the popupmenu for showing/hiding dockwidgets
   
		@short
	*/
	public native QPopupMenu dockHideShowMenu();
	/**	
			@param dockName an internal QObject name
				@return the dockwidget that has got that internal QObject name
   
		@short
	*/
	public native KDockWidget getDockWidgetFromName(String dockName);
	/**	
		 Enables opaque resizing. Opaque resizing defaults to KGlobalSettings.opaqueResize().
		 Call this method before you create any dock widgets!
		   		@short    Enables opaque resizing.
	*/
	public native void setSplitterOpaqueResize(boolean b);
	public native void setSplitterOpaqueResize();
	/**	
		 Returns true if opaque resizing is enabled, false otherwise.
		   		@short    Returns true if opaque resizing is enabled, false otherwise.
	*/
	public native boolean splitterOpaqueResize();
	/**	
		 Try to preserve the widget's size. Works like KeepSize resize mode
		 of QSplitter. Off by default.
		 Call this method before you create any dock widgets!
		   		@short    Try to preserve the widget's size.
	*/
	public native void setSplitterKeepSize(boolean b);
	public native void setSplitterKeepSize();
	/**	
		 Returns true if the KeepSize is enabled, false otherwise.
		   		@short    Returns true if the KeepSize is enabled, false otherwise.
	*/
	public native boolean splitterKeepSize();
	/**	
		 Operate the splitter with a higher resolution. Off by default.
		 Call this method before you create any dock widgets!
		 If high resolution is used all splitter position parameters
		 are percent*100 instead of percent.
		 @note Since KDE 3.5 this is ignored. Internally the splitter always
		       calcualtes in high resolution values. For KDE 4, this will be removed.
		   		@short    Operate the splitter with a higher resolution.
	*/
	public native void setSplitterHighResolution(boolean b);
	public native void setSplitterHighResolution();
	/**	
		 Returns true if the splitter uses the high resolution, false otherwise.
		   		@short    Returns true if the splitter uses the high resolution, false otherwise.
	*/
	public native boolean splitterHighResolution();
	/**	
				@short
	*/
	public native void setSpecialLeftDockContainer(KDockWidget container);
	public native void setSpecialTopDockContainer(KDockWidget container);
	public native void setSpecialRightDockContainer(KDockWidget container);
	public native void setSpecialBottomDockContainer(KDockWidget container);
	public native void removeFromAutoCreateList(KDockWidget pDockWidget);
	public native void finishReadDockConfig();
	public native void setReadDockConfigMode(int mode);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
