/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.ComponentModel;
import java.awt.Rectangle;
import java.lang.ref.WeakReference;
import jep.AppletFrame;
import jep.AppletHandlerFactory;
import sun.java2d.SunGraphics2D;

public class GraphicsClipper {
    protected static boolean showDebugInfo = false;
    protected WeakReference graphics = null;
    protected AppletFrame ancestor = null;
    protected ComponentModel peer = null;
    protected Object devClipLock = new Object();

    public static GraphicsClipper createNew(SunGraphics2D graphics, AppletFrame ancestor, ComponentModel peer) {
        return new GraphicsClipper(graphics, ancestor, peer);
    }

    public GraphicsClipper(SunGraphics2D graphics, AppletFrame ancestor, ComponentModel peer) {
        this.graphics = new WeakReference<SunGraphics2D>(graphics);
        this.ancestor = ancestor;
        this.peer = peer;
        ancestor.addClipper(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle clipToApplet(int x, int y, int width, int height) {
        Object object = this.devClipLock;
        synchronized (object) {
            if (this.ancestor.destroying || this.peer.fTarget == null || this.graphics.get() == null) {
                return new Rectangle();
            }
            if (!AppletHandlerFactory.isAppletViewDisplayable(this.ancestor.getCocoaParentViewLong())) {
                if (showDebugInfo) {
                    System.err.println("GraphicsClipper.clipToApplet(): Zero-clipping because applet invisible");
                }
                return new Rectangle();
            }
            if (this.ancestor.updatesOff || this.ancestor.asyncUpdatesOff) {
                if (showDebugInfo) {
                    System.err.println("GraphicsClipper.clipToApplet(): Zero-clipping because updates off");
                }
                return new Rectangle();
            }
            Rectangle appletClip = null;
            Rectangle bounds = new Rectangle(x, y, width, height);
            try {
                appletClip = this.ancestor.translateCurrentClip(this.peer.fTarget).intersection(bounds);
                if (appletClip.isEmpty()) {
                    appletClip.height = 0;
                    appletClip.width = 0;
                    appletClip.y = 0;
                    appletClip.x = 0;
                }
            }
            catch (Throwable e) {
                appletClip = new Rectangle();
            }
            if (showDebugInfo) {
                System.err.println("GraphicsClipper.clipToApplet(): Clipping from " + bounds.toString() + " to " + appletClip.toString());
            }
            return appletClip;
        }
    }

    public Rectangle clipToApplet(Rectangle r) {
        return this.clipToApplet(r.x, r.y, r.width, r.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateDevClip() {
        Object object = this.devClipLock;
        synchronized (object) {
            if (this.ancestor.destroying || this.peer.fTarget == null) {
                this.zeroDevClip();
                return;
            }
            SunGraphics2D g = (SunGraphics2D)this.graphics.get();
            if (g == null) {
                return;
            }
            Rectangle bounds = null;
            try {
                bounds = g.getSurfaceData().getBounds();
            }
            catch (NullPointerException e) {
                this.zeroDevClip();
                return;
            }
            Rectangle newDevClip = this.clipToApplet(bounds);
            if (!AppletHandlerFactory.isJava142()) {
                g.setDevClip(newDevClip);
                return;
            }
            Rectangle oldDevClip = this.getDevClip();
            if (oldDevClip.x != newDevClip.x || oldDevClip.y != newDevClip.y || oldDevClip.width != newDevClip.width || oldDevClip.height != newDevClip.height) {
                g.setDevClip(newDevClip);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zeroDevClip() {
        Object object = this.devClipLock;
        synchronized (object) {
            SunGraphics2D g = (SunGraphics2D)this.graphics.get();
            if (g == null) {
                return;
            }
            g.setDevClip(new Rectangle());
        }
    }

    public Rectangle getDevClip() {
        return null;
    }

    public SunGraphics2D getGraphics() {
        return (SunGraphics2D)this.graphics.get();
    }

    public String toString() {
        return this.getClass().getName() + " (jep)";
    }

    static {
        if ("true".equalsIgnoreCase(System.getProperty("jep.debuginfo", "false"))) {
            showDebugInfo = true;
        }
    }
}

