/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef _SNAP_OPTIONS_H
#define _SNAP_OPTIONS_H

#include <compiz-common.h>

COMPIZ_BEGIN_DECLS

CompPluginVTable * getCompPluginInfo (void);

typedef enum
{
    SnapDisplayOptionAvoidSnap,
    SnapDisplayOptionNum
} SnapDisplayOptions;

typedef void (*snapDisplayOptionChangeNotifyProc) (CompDisplay *display, CompOption *opt, SnapDisplayOptions num);

CompOption *snapGetDisplayOption (CompDisplay *d, SnapDisplayOptions num);

typedef enum
{
    SnapScreenOptionSnapType,
    SnapScreenOptionEdgesCategories,
    SnapScreenOptionResistanceDistance,
    SnapScreenOptionAttractionDistance,
    SnapScreenOptionNum
} SnapScreenOptions;

typedef void (*snapScreenOptionChangeNotifyProc) (CompScreen *screen, CompOption *opt, SnapScreenOptions num);

CompOption *snapGetScreenOption (CompScreen *s, SnapScreenOptions num);

typedef enum
{
    AvoidSnapShift = 0,
    AvoidSnapAlt = 1,
    AvoidSnapControl = 2,
    AvoidSnapMeta = 3,
} SnapAvoidSnapEnum;

typedef enum
{
    SnapTypeEdgeResistance = 0,
    SnapTypeEdgeAttraction = 1,
} SnapSnapTypeEnum;

typedef enum
{
    EdgesCategoriesScreenEdges = 0,
    EdgesCategoriesWindowEdges = 1,
} SnapEdgesCategoriesEnum;

#define AvoidSnapShiftMask (1 << 0)
#define AvoidSnapAltMask (1 << 1)
#define AvoidSnapControlMask (1 << 2)
#define AvoidSnapMetaMask (1 << 3)


#define SnapTypeEdgeResistanceMask (1 << 0)
#define SnapTypeEdgeAttractionMask (1 << 1)


#define EdgesCategoriesScreenEdgesMask (1 << 0)
#define EdgesCategoriesWindowEdgesMask (1 << 1)


CompListValue *  snapGetAvoidSnap (CompDisplay *d);
unsigned int     snapGetAvoidSnapMask (CompDisplay *d);
CompOption *     snapGetAvoidSnapOption (CompDisplay *d);
void             snapSetAvoidSnapNotify (CompDisplay *d, snapDisplayOptionChangeNotifyProc notify);

CompListValue *  snapGetSnapType (CompScreen *s);
unsigned int     snapGetSnapTypeMask (CompScreen *s);
CompOption *     snapGetSnapTypeOption (CompScreen *s);
void             snapSetSnapTypeNotify (CompScreen *s, snapScreenOptionChangeNotifyProc notify);

CompListValue *  snapGetEdgesCategories (CompScreen *s);
unsigned int     snapGetEdgesCategoriesMask (CompScreen *s);
CompOption *     snapGetEdgesCategoriesOption (CompScreen *s);
void             snapSetEdgesCategoriesNotify (CompScreen *s, snapScreenOptionChangeNotifyProc notify);

int              snapGetResistanceDistance (CompScreen *s);
CompOption *     snapGetResistanceDistanceOption (CompScreen *s);
void             snapSetResistanceDistanceNotify (CompScreen *s, snapScreenOptionChangeNotifyProc notify);

int              snapGetAttractionDistance (CompScreen *s);
CompOption *     snapGetAttractionDistanceOption (CompScreen *s);
void             snapSetAttractionDistanceNotify (CompScreen *s, snapScreenOptionChangeNotifyProc notify);

#ifndef GENERIC_PRIVATE_DEFINES
#define GENERIC_PRIVATE_DEFINES

#define GET_PLUGIN_CORE(object, plugin) \
    ((plugin##Core *) (object)->base.privates[plugin##CorePrivateIndex].ptr)
#define PLUGIN_CORE(object, plugin, prefix) \
    plugin##Core * prefix##c = GET_PLUGIN_CORE (object, plugin)

#define GET_PLUGIN_DISPLAY(object, plugin) \
    ((plugin##Display *) \
	(object)->base.privates[plugin##DisplayPrivateIndex].ptr)
#define PLUGIN_DISPLAY(object, plugin, prefix) \
    plugin##Display * prefix##d = GET_PLUGIN_DISPLAY (object, plugin)

#define GET_PLUGIN_SCREEN(object, parent, plugin) \
    ((plugin##Screen *) \
	(object)->base.privates[(parent)->screenPrivateIndex].ptr)
#define PLUGIN_SCREEN(object, plugin, prefix) \
    plugin##Screen * prefix##s = \
	GET_PLUGIN_SCREEN (object, \
	GET_PLUGIN_DISPLAY ((object)->display, plugin), plugin)

#define GET_PLUGIN_WINDOW(object, parent, plugin) \
    ((plugin##Window *) \
	(object)->base.privates[(parent)->windowPrivateIndex].ptr)
#define PLUGIN_WINDOW(object, plugin, prefix) \
    plugin##Window * prefix##w = \
	GET_PLUGIN_WINDOW  (object, \
	GET_PLUGIN_SCREEN  ((object)->screen, \
	GET_PLUGIN_DISPLAY ((object)->screen->display, plugin), plugin), plugin)

#endif

COMPIZ_END_DECLS

#endif
