/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "crashhandler_options.h"

static int CrashhandlerOptionsDisplayPrivateIndex;

static CompMetadata crashhandlerOptionsMetadata;

static CompPluginVTable *crashhandlerPluginVTable = NULL;
CompPluginVTable crashhandlerOptionsVTable;

#define CRASHHANDLER_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, CrashhandlerOptions, o)
#define CRASHHANDLER_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, CrashhandlerOptions, o)

typedef struct _CrashhandlerOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[CrashhandlerDisplayOptionNum];
    crashhandlerDisplayOptionChangeNotifyProc notify[CrashhandlerDisplayOptionNum];
} CrashhandlerOptionsDisplay;

typedef struct _CrashhandlerOptionsScreen
{
} CrashhandlerOptionsScreen;

Bool crashhandlerGetEnabled (CompDisplay *d)
{
    CRASHHANDLER_OPTIONS_DISPLAY(d);
    return od->opt[CrashhandlerDisplayOptionEnabled].value.b;
}

CompOption * crashhandlerGetEnabledOption (CompDisplay *d)
{
    CRASHHANDLER_OPTIONS_DISPLAY(d);
    return &od->opt[CrashhandlerDisplayOptionEnabled];
}

void crashhandlerSetEnabledNotify (CompDisplay *d, crashhandlerDisplayOptionChangeNotifyProc notify)
{
    CRASHHANDLER_OPTIONS_DISPLAY(d);
    od->notify[CrashhandlerDisplayOptionEnabled] = notify;
}

char * crashhandlerGetDirectory (CompDisplay *d)
{
    CRASHHANDLER_OPTIONS_DISPLAY(d);
    return od->opt[CrashhandlerDisplayOptionDirectory].value.s;
}

CompOption * crashhandlerGetDirectoryOption (CompDisplay *d)
{
    CRASHHANDLER_OPTIONS_DISPLAY(d);
    return &od->opt[CrashhandlerDisplayOptionDirectory];
}

void crashhandlerSetDirectoryNotify (CompDisplay *d, crashhandlerDisplayOptionChangeNotifyProc notify)
{
    CRASHHANDLER_OPTIONS_DISPLAY(d);
    od->notify[CrashhandlerDisplayOptionDirectory] = notify;
}

Bool crashhandlerGetStartWm (CompDisplay *d)
{
    CRASHHANDLER_OPTIONS_DISPLAY(d);
    return od->opt[CrashhandlerDisplayOptionStartWm].value.b;
}

CompOption * crashhandlerGetStartWmOption (CompDisplay *d)
{
    CRASHHANDLER_OPTIONS_DISPLAY(d);
    return &od->opt[CrashhandlerDisplayOptionStartWm];
}

void crashhandlerSetStartWmNotify (CompDisplay *d, crashhandlerDisplayOptionChangeNotifyProc notify)
{
    CRASHHANDLER_OPTIONS_DISPLAY(d);
    od->notify[CrashhandlerDisplayOptionStartWm] = notify;
}

char * crashhandlerGetWmCmd (CompDisplay *d)
{
    CRASHHANDLER_OPTIONS_DISPLAY(d);
    return od->opt[CrashhandlerDisplayOptionWmCmd].value.s;
}

CompOption * crashhandlerGetWmCmdOption (CompDisplay *d)
{
    CRASHHANDLER_OPTIONS_DISPLAY(d);
    return &od->opt[CrashhandlerDisplayOptionWmCmd];
}

void crashhandlerSetWmCmdNotify (CompDisplay *d, crashhandlerDisplayOptionChangeNotifyProc notify)
{
    CRASHHANDLER_OPTIONS_DISPLAY(d);
    od->notify[CrashhandlerDisplayOptionWmCmd] = notify;
}

CompOption * crashhandlerGetDisplayOption (CompDisplay *d, CrashhandlerDisplayOptions num)
{
    CRASHHANDLER_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

static const CompMetadataOptionInfo crashhandlerOptionsDisplayOptionInfo[] = {
    { "enabled", "bool", 0, 0, 0 },
    { "directory", "string", 0, 0, 0 },
    { "start_wm", "bool", 0, 0, 0 },
    { "wm_cmd", "string", 0, 0, 0 },
};

static Bool crashhandlerOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, const char *name, CompOptionValue *value)
{
    CRASHHANDLER_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, CrashhandlerDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case CrashhandlerDisplayOptionEnabled:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[CrashhandlerDisplayOptionEnabled])
                (*od->notify[CrashhandlerDisplayOptionEnabled]) (d, o, CrashhandlerDisplayOptionEnabled);
            return TRUE;
        }
        break;
     case CrashhandlerDisplayOptionDirectory:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[CrashhandlerDisplayOptionDirectory])
                (*od->notify[CrashhandlerDisplayOptionDirectory]) (d, o, CrashhandlerDisplayOptionDirectory);
            return TRUE;
        }
        break;
     case CrashhandlerDisplayOptionStartWm:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[CrashhandlerDisplayOptionStartWm])
                (*od->notify[CrashhandlerDisplayOptionStartWm]) (d, o, CrashhandlerDisplayOptionStartWm);
            return TRUE;
        }
        break;
     case CrashhandlerDisplayOptionWmCmd:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[CrashhandlerDisplayOptionWmCmd])
                (*od->notify[CrashhandlerDisplayOptionWmCmd]) (d, o, CrashhandlerDisplayOptionWmCmd);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * crashhandlerOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    CRASHHANDLER_OPTIONS_DISPLAY(d);
    *count = CrashhandlerDisplayOptionNum;
    return od->opt;
}

static Bool crashhandlerOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    CrashhandlerOptionsScreen *os;
    
    CRASHHANDLER_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(CrashhandlerOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    
    return TRUE;
}

static void crashhandlerOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    CRASHHANDLER_OPTIONS_SCREEN (s);

    free (os);
}

static Bool crashhandlerOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    CrashhandlerOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(CrashhandlerOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[CrashhandlerOptionsDisplayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &crashhandlerOptionsMetadata, crashhandlerOptionsDisplayOptionInfo, od->opt, CrashhandlerDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }

    return TRUE;
}

static void crashhandlerOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    CRASHHANDLER_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, CrashhandlerDisplayOptionNum);

    free (od);
}

static Bool crashhandlerOptionsInit (CompPlugin *p)
{
    CrashhandlerOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (CrashhandlerOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&crashhandlerOptionsMetadata, "crashhandler",crashhandlerOptionsDisplayOptionInfo, CrashhandlerDisplayOptionNum, 0, 0))
        return FALSE;

    compAddMetadataFromFile (&crashhandlerOptionsMetadata, "crashhandler");
    if (crashhandlerPluginVTable && crashhandlerPluginVTable->init)
        return crashhandlerPluginVTable->init (p);
    return TRUE;
}

static void crashhandlerOptionsFini (CompPlugin *p)
{
    if (crashhandlerPluginVTable && crashhandlerPluginVTable->fini)
        crashhandlerPluginVTable->fini (p);

    if (CrashhandlerOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (CrashhandlerOptionsDisplayPrivateIndex);

    compFiniMetadata (&crashhandlerOptionsMetadata);
}

static CompBool crashhandlerOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) crashhandlerOptionsInitDisplay,
        (InitPluginObjectProc) crashhandlerOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void crashhandlerOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) crashhandlerOptionsFiniDisplay,
        (FiniPluginObjectProc) crashhandlerOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool crashhandlerOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = crashhandlerOptionsInitObject (p, o);
    if (crashhandlerPluginVTable->initObject)
        rv &= crashhandlerPluginVTable->initObject (p, o);
    return rv;
}

static void crashhandlerOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (crashhandlerPluginVTable->finiObject)
        crashhandlerPluginVTable->finiObject (p, o);
    crashhandlerOptionsFiniObject (p, o);
}

static CompOption * crashhandlerOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) crashhandlerOptionsGetDisplayOptions,
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool crashhandlerOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) crashhandlerOptionsSetDisplayOption,
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
crashhandlerOptionsGetMetadata (CompPlugin *plugin)
{
    return &crashhandlerOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!crashhandlerPluginVTable)
    {
        crashhandlerPluginVTable = getCompPluginInfo ();
        memcpy(&crashhandlerOptionsVTable, crashhandlerPluginVTable, sizeof(CompPluginVTable));
        crashhandlerOptionsVTable.getMetadata = crashhandlerOptionsGetMetadata;
        crashhandlerOptionsVTable.init = crashhandlerOptionsInit;
        crashhandlerOptionsVTable.fini = crashhandlerOptionsFini;
        crashhandlerOptionsVTable.initObject = crashhandlerOptionsInitObjectWrapper;
        crashhandlerOptionsVTable.finiObject = crashhandlerOptionsFiniObjectWrapper;
        crashhandlerOptionsVTable.getObjectOptions = crashhandlerOptionsGetObjectOptions;
	crashhandlerOptionsVTable.setObjectOption = crashhandlerOptionsSetObjectOption;
	
    }
    return &crashhandlerOptionsVTable;
}

