/*
 * Copyright (c) 2003-2004 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: ochusha_thread_jbbs.h,v 1.2.2.1 2004/06/11 12:00:48 fuyu Exp $
 */

#ifndef _OCHUSHA_THREAD_JBBS_H_
#define _OCHUSHA_THREAD_JBBS_H_

#include "ochusha_thread_2ch.h"
#include "ochusha_board_jbbs.h"

#include <glib-object.h>
#include <glib.h>


#ifdef __cplusplus
extern "C" {
#endif

#define OCHUSHA_TYPE_THREAD_JBBS		(ochusha_thread_jbbs_get_type())
#define OCHUSHA_THREAD_JBBS(obj)		(G_TYPE_CHECK_INSTANCE_CAST((obj), OCHUSHA_TYPE_THREAD_JBBS, OchushaThreadJBBS))
#define OCHUSHA_THREAD_JBBS_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), OCHUSHA_TYPE_THREAD_JBBS, OchushaThreadJBBSClass))
#define OCHUSHA_IS_THREAD_JBBS(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), OCHUSHA_TYPE_THREAD_JBBS))
#define OCHUSHA_IS_THREAD_JBBS_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), OCHUSHA_TYPE_THREAD_JBBS))
#define OCHUSHA_THREAD_JBBS_GET_CLASS(obj) 	(G_TYPE_INSTANCE_GET_CLASS((obj), OCHUSHA_TYPE_THREAD_JBBS, OchushaThreadJBBSClass))


typedef struct _OchushaThreadJBBS OchushaThreadJBBS;
typedef struct _OchushaThreadJBBSClass OchushaThreadJBBSClass;


struct _OchushaThreadJBBS
{
  OchushaThread2ch parent_object;
};


struct _OchushaThreadJBBSClass
{
  OchushaThread2chClass parent_class;
};


GType ochusha_thread_jbbs_get_type(void) G_GNUC_CONST;
OchushaBBSThread *ochusha_thread_jbbs_new(OchushaBoardJBBS *board,
					  const char *thread_id,
					  const gchar *title);
#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _OCHUSHA_THREAD_JBBS_H_ */
