/*
 * Copyright (c) 2003-2004 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: ochusha_bbs_thread.h,v 1.25.2.2 2005/08/15 17:15:07 fuyu Exp $
 */

#ifndef _OCHUSHA_BBS_THREAD_H_
#define _OCHUSHA_BBS_THREAD_H_

#include "ochusha_bulletin_board.h"
#include "ochusha_network_broker.h"

#include "utils.h"

#include <glib-object.h>
#include <glib.h>

#include <time.h>


#ifdef __cplusplus
extern "C" {
#endif

#define OCHUSHA_TYPE_BBS_THREAD			(ochusha_bbs_thread_get_type())
#define OCHUSHA_BBS_THREAD(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), OCHUSHA_TYPE_BBS_THREAD, OchushaBBSThread))
#define OCHUSHA_BBS_THREAD_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), OCHUSHA_TYPE_BBS_THREAD, OchushaBBSThreadClass))
#define OCHUSHA_IS_BBS_THREAD(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), OCHUSHA_TYPE_BBS_THREAD))
#define OCHUSHA_IS_BBS_THREAD_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), OCHUSHA_TYPE_BBS_THREAD))
#define OCHUSHA_BBS_THREAD_GET_CLASS(obj) 	(G_TYPE_INSTANCE_GET_CLASS((obj), OCHUSHA_TYPE_BBS_THREAD, OchushaBBSThreadClass))


#if 0	/* 餷ġ */
typedef struct _OchushaBBSThread OchushaBBSThread;
typedef struct _OchushaBBSThreadClass OchushaBBSThreadClass;
#endif


struct _OchushaBBSThread
{
  GObject parent_object;

  OchushaBulletinBoard *board;

  char *id;	      /* 㤨DATե̾"NNNN.dat""NNNN" */
  gchar *title;       /* "顪 GTK+ȤäLinuxǤ塼" */

  /* оΥ쥹(㤨subject.txt) */
  int number_of_responses_on_server;

  /* ɥ쥹(ɤ߹쥹) */
  int number_of_responses_read;

  /* Ĥ˴ؤäȤ(OchushaBBSThreadStateORȤä) */
  int flags;

  /* 񤭹ߥե饰(BeȤɤʤ) */
  int post_mode;
};


struct _OchushaBBSThreadClass
{
  GObjectClass parent_class;

  /* signals */
  void (*read_threadlist_element)(OchushaBBSThread *thread,
				  GHashTable *thread_attributes);
  void (*write_threadlist_element)(OchushaBBSThread *thread,
				   gzFile threadlist_xml);


  /* postξܤˤ륷ʥ */
  gboolean (*check_cookie)(OchushaBBSThread *thread);
  gboolean (*too_match_clouded)(OchushaBBSThread *thread);


  /* virtual function table */
  OchushaBulletinBoard *(*get_board)(OchushaBBSThread *thread);
  int (*get_number_of_responses_on_server)(OchushaBBSThread *thread);
  int (*get_number_of_responses_read)(OchushaBBSThread *thread);
  void (*set_number_of_responses_read)(OchushaBBSThread *thread, int number);
  int (*get_flags)(OchushaBBSThread *thread);
  void (*set_flags)(OchushaBBSThread *thread, int flags);
  OchushaAsyncBuffer *(*get_responses_source)(OchushaBBSThread *thread,
					OchushaNetworkBroker *broker,
					OchushaAsyncBuffer *buffer,
					OchushaNetworkBrokerCacheMode mode);
  gboolean (*parse_responses)(OchushaBBSThread *thread,
			      OchushaAsyncBuffer *buffer,
			      int start, int number, gboolean no_wait,
			      StartThreadCallback *start_thread_callback,
			      EachResponseCallback *each_response_callback,
			      BrokenResponseCallback *broken_response_callback,
			      EndThreadCallback *end_thread_callback,
			      StartParsingCallback *start_parsing_callback,
			      BeforeWaitCallback *before_wait_callback,
			      AfterWaitCallback *after_wait_callback,
			      EndParsingCallback *end_parsing_callback,
			      gpointer callback_data);
  time_t (*get_last_modified_utc)(OchushaBBSThread *thread);
  const char *(*get_url)(OchushaBBSThread *thread);
  char *(*get_url_for_response)(OchushaBBSThread *thread, int from, int to);
  const char *(*get_url_to_post)(OchushaBBSThread *thread);
  gboolean (*check_url)(OchushaBBSThread *thread, const char *url,
			unsigned int *from_p, unsigned int *to_p);
  void (*remove_cache)(OchushaBBSThread *thread, OchushaConfig *config);

  gboolean (*preview_response)(OchushaBBSThread *thread,
			       const OchushaBBSResponse *response,
			       StartThreadCallback *start_cb,
			       EachResponseCallback *response_cb,
			       EndThreadCallback *end_cb,
			       gpointer callback_data);
  gboolean (*post_supported)(OchushaBBSThread *thread);
  gboolean (*post_response)(OchushaBBSThread *thread,
			    OchushaNetworkBroker *broker,
			    const OchushaBBSResponse *response);
};


typedef enum
{
  OCHUSHA_BBS_THREAD_DAT_DROPPED = 1 << 0,
  OCHUSHA_BBS_THREAD_STOPPED = 1 << 1,
  OCHUSHA_BBS_THREAD_KAKO = 1 << 2,
  OCHUSHA_BBS_THREAD_DAT_OYSTER = 1 << 3,
} OchushaBBSThreadState;


GType ochusha_bbs_thread_get_type(void) G_GNUC_CONST;
OchushaBBSThread *ochusha_bbs_thread_new(OchushaBulletinBoard *board,
					 const char *thread_id,
					 const gchar *title);

void ochusha_bbs_thread_set_board(OchushaBBSThread *thread,
				  OchushaBulletinBoard *board);
OchushaBulletinBoard *ochusha_bbs_thread_get_board(OchushaBBSThread *thread);

void ochusha_bbs_thread_set_id(OchushaBBSThread *thread, const char *id);
const char *ochusha_bbs_thread_get_id(OchushaBBSThread *thread);

void ochusha_bbs_thread_set_title(OchushaBBSThread *thread,
				  const gchar *title);
const gchar *ochusha_bbs_thread_get_title(OchushaBBSThread *thread);

int ochusha_bbs_thread_get_number_of_responses_on_server(OchushaBBSThread *thread);
int ochusha_bbs_thread_get_number_of_responses_read(OchushaBBSThread *thread);
void ochusha_bbs_thread_set_number_of_responses_read(OchushaBBSThread *thread,
						     int number);
int ochusha_bbs_thread_get_flags(OchushaBBSThread *thread);
void ochusha_bbs_thread_set_flags(OchushaBBSThread *thread, int flags);

time_t ochusha_bbs_thread_get_last_modified_utc(OchushaBBSThread *thread);

const char *ochusha_bbs_thread_get_url(OchushaBBSThread *thread);
char *ochusha_bbs_thread_get_url_for_response(OchushaBBSThread *thread,
					      int from, int to);

gboolean ochusha_bbs_thread_is_preview_supported(OchushaBBSThread *thread);
gboolean ochusha_bbs_thread_is_post_supported(OchushaBBSThread *thread);
const char *ochusha_bbs_thread_get_url_to_post_response(
						OchushaBBSThread *thread);

gboolean ochusha_bbs_thread_check_url(OchushaBBSThread *thread,
				      const char *url, unsigned int *from_p,
				      unsigned int *end_p);

OchushaAsyncBuffer *ochusha_bbs_thread_get_responses_source(
					OchushaBBSThread *thread,
					OchushaNetworkBroker *broker,
					OchushaAsyncBuffer *buffer,
					OchushaNetworkBrokerCacheMode mode);
const char *ochusha_bbs_thread_get_response_character_encoding(
						OchushaBBSThread *thread);
iconv_helper *ochusha_bbs_thread_get_response_iconv_helper(
						OchushaBBSThread *thread);
gboolean ochusha_bbs_thread_parse_responses(OchushaBBSThread *thread,
					    OchushaAsyncBuffer *buffer,
					    int start, int number,
					    gboolean no_wait,
					    StartThreadCallback *start_cb,
					    EachResponseCallback *response_cb,
					    BrokenResponseCallback *broken_cb,
					    EndThreadCallback *end_cb,
					    StartParsingCallback *start_parsing_callback,
					    BeforeWaitCallback *before_wait_callback,
					    AfterWaitCallback *after_wait_callback,
					    EndParsingCallback *end_parsing_callback,
					    gpointer callback_data);
void ochusha_bbs_thread_remove_cache(OchushaBBSThread *thread,
				     OchushaConfig *config);

gboolean ochusha_bbs_thread_preview_response(OchushaBBSThread *thread,
					const OchushaBBSResponse *response,
					StartThreadCallback *start_cb,
					EachResponseCallback *response_cb,
					EndThreadCallback *end_cb,
					gpointer callback_data);

gboolean ochusha_bbs_thread_post_response(OchushaBBSThread *thread,
					  OchushaNetworkBroker *broker,
					  const OchushaBBSResponse *response);

gboolean ochusha_bbs_thread_get_post_use_2ch_be(OchushaBBSThread *thread,
						const OchushaConfig *config);
void ochusha_bbs_thread_set_post_use_2ch_be(OchushaBBSThread *thread,
					    gboolean use_2ch_be);
gboolean ochusha_bbs_thread_get_post_use_2ch_viewer(OchushaBBSThread *thread,
						const OchushaConfig *config);
void ochusha_bbs_thread_set_post_use_2ch_viewer(OchushaBBSThread *thread,
						gboolean use_2ch_viewer);


#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _OCHUSHA_BBS_THREAD_H_ */
