/*
    Copyright (c) 2006-2008 by amdfanatyk <amdfanatyk@o2.pl>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef QMMAINWINDOW_H
#define QMMAINWINDOW_H

#include <qmainwindow.h>

class QMMainWindow : public QMainWindow
{
	Q_OBJECT

	public:
		QMMainWindow(QWidget * parent = 0, const char * name = 0);
		~QMMainWindow();

	signals:
		void mouseButtonReleased(const QPoint &);
		void keyPressed(QKeyEvent * e);
		void rightMouseButtonClicked(const QPoint &);
		void clicked();
		void doubleClicked();

	protected:
		void mouseDoubleClickEvent(QMouseEvent * e);
		void mousePressEvent(QMouseEvent * e);
		void mouseReleaseEvent(QMouseEvent * e);
		void mouseMoveEvent(QMouseEvent * e);
		void keyPressEvent(QKeyEvent * e);
};

#endif
