/*
    Copyright (c) 2006-2008 by amdfanatyk <amdfanatyk@o2.pl>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef KMLISTVIEW_H
#define KMLISTVIEW_H

#include <qdragobject.h>

#include <klistview.h>

class KMListView : public KListView
{
	Q_OBJECT

	public:
		KMListView(QWidget * parent = 0, const char * name = 0);
		~KMListView();

		void setSelected(QListViewItem * item, bool selected);
		void clearSelection();
		QListViewItem * selectedItem() const;

	public slots:
		void selectAll();

	signals:
		void mouseButtonReleased(const QPoint &);
		void keyPressed(QKeyEvent * e);
		void rightMouseButtonClicked(const QPoint &);
		void dragging();

	protected:
		bool acceptDrag(QDropEvent * event) const;
		void contentsMousePressEvent(QMouseEvent * e);
		void contentsMouseReleaseEvent(QMouseEvent * e);
		void contentsMouseMoveEvent(QMouseEvent * e);
		void keyPressEvent(QKeyEvent * e);

	private:
		bool dndPerm;
};

#endif
