/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef _SHOWDESKTOP_OPTIONS_H
#define _SHOWDESKTOP_OPTIONS_H

#include <compiz-common.h>

COMPIZ_BEGIN_DECLS

CompPluginVTable * getCompPluginInfo (void);

typedef enum
{
    ShowdesktopDisplayOptionNum
} ShowdesktopDisplayOptions;

typedef void (*showdesktopDisplayOptionChangeNotifyProc) (CompDisplay *display, CompOption *opt, ShowdesktopDisplayOptions num);

CompOption *showdesktopGetDisplayOption (CompDisplay *d, ShowdesktopDisplayOptions num);

typedef enum
{
    ShowdesktopScreenOptionSpeed,
    ShowdesktopScreenOptionTimestep,
    ShowdesktopScreenOptionDirection,
    ShowdesktopScreenOptionWindowMatch,
    ShowdesktopScreenOptionWindowOpacity,
    ShowdesktopScreenOptionWindowPartSize,
    ShowdesktopScreenOptionNum
} ShowdesktopScreenOptions;

typedef void (*showdesktopScreenOptionChangeNotifyProc) (CompScreen *screen, CompOption *opt, ShowdesktopScreenOptions num);

CompOption *showdesktopGetScreenOption (CompScreen *s, ShowdesktopScreenOptions num);

typedef enum
{
    DirectionUp = 0,
    DirectionDown = 1,
    DirectionLeft = 2,
    DirectionRight = 3,
    DirectionUpDown = 4,
    DirectionLeftRight = 5,
    DirectionToCorners = 6,
} ShowdesktopDirectionEnum;

float            showdesktopGetSpeed (CompScreen *s);
CompOption *     showdesktopGetSpeedOption (CompScreen *s);
void             showdesktopSetSpeedNotify (CompScreen *s, showdesktopScreenOptionChangeNotifyProc notify);

float            showdesktopGetTimestep (CompScreen *s);
CompOption *     showdesktopGetTimestepOption (CompScreen *s);
void             showdesktopSetTimestepNotify (CompScreen *s, showdesktopScreenOptionChangeNotifyProc notify);

int              showdesktopGetDirection (CompScreen *s);
CompOption *     showdesktopGetDirectionOption (CompScreen *s);
void             showdesktopSetDirectionNotify (CompScreen *s, showdesktopScreenOptionChangeNotifyProc notify);

CompMatch *      showdesktopGetWindowMatch (CompScreen *s);
CompOption *     showdesktopGetWindowMatchOption (CompScreen *s);
void             showdesktopSetWindowMatchNotify (CompScreen *s, showdesktopScreenOptionChangeNotifyProc notify);

float            showdesktopGetWindowOpacity (CompScreen *s);
CompOption *     showdesktopGetWindowOpacityOption (CompScreen *s);
void             showdesktopSetWindowOpacityNotify (CompScreen *s, showdesktopScreenOptionChangeNotifyProc notify);

int              showdesktopGetWindowPartSize (CompScreen *s);
CompOption *     showdesktopGetWindowPartSizeOption (CompScreen *s);
void             showdesktopSetWindowPartSizeNotify (CompScreen *s, showdesktopScreenOptionChangeNotifyProc notify);

#ifndef GENERIC_PRIVATE_DEFINES
#define GENERIC_PRIVATE_DEFINES

#define GET_PLUGIN_CORE(object, plugin) \
    ((plugin##Core *) (object)->base.privates[plugin##CorePrivateIndex].ptr)
#define PLUGIN_CORE(object, plugin, prefix) \
    plugin##Core * prefix##c = GET_PLUGIN_CORE (object, plugin)

#define GET_PLUGIN_DISPLAY(object, plugin) \
    ((plugin##Display *) \
	(object)->base.privates[plugin##DisplayPrivateIndex].ptr)
#define PLUGIN_DISPLAY(object, plugin, prefix) \
    plugin##Display * prefix##d = GET_PLUGIN_DISPLAY (object, plugin)

#define GET_PLUGIN_SCREEN(object, parent, plugin) \
    ((plugin##Screen *) \
	(object)->base.privates[(parent)->screenPrivateIndex].ptr)
#define PLUGIN_SCREEN(object, plugin, prefix) \
    plugin##Screen * prefix##s = \
	GET_PLUGIN_SCREEN (object, \
	GET_PLUGIN_DISPLAY ((object)->display, plugin), plugin)

#define GET_PLUGIN_WINDOW(object, parent, plugin) \
    ((plugin##Window *) \
	(object)->base.privates[(parent)->windowPrivateIndex].ptr)
#define PLUGIN_WINDOW(object, plugin, prefix) \
    plugin##Window * prefix##w = \
	GET_PLUGIN_WINDOW  (object, \
	GET_PLUGIN_SCREEN  ((object)->screen, \
	GET_PLUGIN_DISPLAY ((object)->screen->display, plugin), plugin), plugin)

#endif

COMPIZ_END_DECLS

#endif
