/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz-core.h>

#include "cubereflex_options.h"

static int CubereflexOptionsDisplayPrivateIndex;

static CompMetadata cubereflexOptionsMetadata;

static CompPluginVTable *cubereflexPluginVTable = NULL;
CompPluginVTable cubereflexOptionsVTable;

#define CUBEREFLEX_OPTIONS_DISPLAY(d) PLUGIN_DISPLAY(d, CubereflexOptions, o)
#define CUBEREFLEX_OPTIONS_SCREEN(s) PLUGIN_SCREEN(s, CubereflexOptions, o)

typedef struct _CubereflexOptionsDisplay
{
    int screenPrivateIndex;

} CubereflexOptionsDisplay;

typedef struct _CubereflexOptionsScreen
{
    CompOption opt[CubereflexScreenOptionNum];
    cubereflexScreenOptionChangeNotifyProc notify[CubereflexScreenOptionNum];
} CubereflexOptionsScreen;

unsigned short * cubereflexGetGroundColor1 (CompScreen *s)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    return os->opt[CubereflexScreenOptionGroundColor1].value.c;
}

unsigned short cubereflexGetGroundColor1Red (CompScreen *s)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    return os->opt[CubereflexScreenOptionGroundColor1].value.c[0];
}

unsigned short cubereflexGetGroundColor1Green (CompScreen *s)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    return os->opt[CubereflexScreenOptionGroundColor1].value.c[1];
}

unsigned short cubereflexGetGroundColor1Blue (CompScreen *s)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    return os->opt[CubereflexScreenOptionGroundColor1].value.c[2];
}

unsigned short cubereflexGetGroundColor1Alpha (CompScreen *s)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    return os->opt[CubereflexScreenOptionGroundColor1].value.c[3];
}

CompOption * cubereflexGetGroundColor1Option (CompScreen *s)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    return &os->opt[CubereflexScreenOptionGroundColor1];
}

void cubereflexSetGroundColor1Notify (CompScreen *s, cubereflexScreenOptionChangeNotifyProc notify)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    os->notify[CubereflexScreenOptionGroundColor1] = notify;
}

unsigned short * cubereflexGetGroundColor2 (CompScreen *s)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    return os->opt[CubereflexScreenOptionGroundColor2].value.c;
}

unsigned short cubereflexGetGroundColor2Red (CompScreen *s)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    return os->opt[CubereflexScreenOptionGroundColor2].value.c[0];
}

unsigned short cubereflexGetGroundColor2Green (CompScreen *s)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    return os->opt[CubereflexScreenOptionGroundColor2].value.c[1];
}

unsigned short cubereflexGetGroundColor2Blue (CompScreen *s)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    return os->opt[CubereflexScreenOptionGroundColor2].value.c[2];
}

unsigned short cubereflexGetGroundColor2Alpha (CompScreen *s)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    return os->opt[CubereflexScreenOptionGroundColor2].value.c[3];
}

CompOption * cubereflexGetGroundColor2Option (CompScreen *s)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    return &os->opt[CubereflexScreenOptionGroundColor2];
}

void cubereflexSetGroundColor2Notify (CompScreen *s, cubereflexScreenOptionChangeNotifyProc notify)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    os->notify[CubereflexScreenOptionGroundColor2] = notify;
}

float cubereflexGetGroundSize (CompScreen *s)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    return os->opt[CubereflexScreenOptionGroundSize].value.f;
}

CompOption * cubereflexGetGroundSizeOption (CompScreen *s)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    return &os->opt[CubereflexScreenOptionGroundSize];
}

void cubereflexSetGroundSizeNotify (CompScreen *s, cubereflexScreenOptionChangeNotifyProc notify)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    os->notify[CubereflexScreenOptionGroundSize] = notify;
}

float cubereflexGetIntensity (CompScreen *s)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    return os->opt[CubereflexScreenOptionIntensity].value.f;
}

CompOption * cubereflexGetIntensityOption (CompScreen *s)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    return &os->opt[CubereflexScreenOptionIntensity];
}

void cubereflexSetIntensityNotify (CompScreen *s, cubereflexScreenOptionChangeNotifyProc notify)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    os->notify[CubereflexScreenOptionIntensity] = notify;
}

Bool cubereflexGetAutoZoom (CompScreen *s)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    return os->opt[CubereflexScreenOptionAutoZoom].value.b;
}

CompOption * cubereflexGetAutoZoomOption (CompScreen *s)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    return &os->opt[CubereflexScreenOptionAutoZoom];
}

void cubereflexSetAutoZoomNotify (CompScreen *s, cubereflexScreenOptionChangeNotifyProc notify)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    os->notify[CubereflexScreenOptionAutoZoom] = notify;
}

Bool cubereflexGetZoomManualOnly (CompScreen *s)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    return os->opt[CubereflexScreenOptionZoomManualOnly].value.b;
}

CompOption * cubereflexGetZoomManualOnlyOption (CompScreen *s)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    return &os->opt[CubereflexScreenOptionZoomManualOnly];
}

void cubereflexSetZoomManualOnlyNotify (CompScreen *s, cubereflexScreenOptionChangeNotifyProc notify)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    os->notify[CubereflexScreenOptionZoomManualOnly] = notify;
}

int cubereflexGetMode (CompScreen *s)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    return os->opt[CubereflexScreenOptionMode].value.i;
}

CompOption * cubereflexGetModeOption (CompScreen *s)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    return &os->opt[CubereflexScreenOptionMode];
}

void cubereflexSetModeNotify (CompScreen *s, cubereflexScreenOptionChangeNotifyProc notify)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    os->notify[CubereflexScreenOptionMode] = notify;
}

CompOption * cubereflexGetScreenOption (CompScreen *s, CubereflexScreenOptions num)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo cubereflexOptionsScreenOptionInfo[] = {
    { "ground_color1", "color", 0, 0, 0 },
    { "ground_color2", "color", 0, 0, 0 },
    { "ground_size", "float", "<min>0.0</min><max>1.0</max>", 0, 0 },
    { "intensity", "float", "<min>0.0</min><max>1.0</max>", 0, 0 },
    { "auto_zoom", "bool", 0, 0, 0 },
    { "zoom_manual_only", "bool", 0, 0, 0 },
    { "mode", "int", "<min>0</min><max>3</max>", 0, 0 },
};

static Bool cubereflexOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, const char *name, CompOptionValue *value)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, CubereflexScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case CubereflexScreenOptionGroundColor1:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubereflexScreenOptionGroundColor1])
                (*os->notify[CubereflexScreenOptionGroundColor1]) (s, o, CubereflexScreenOptionGroundColor1);
            return TRUE;
        }
        break;
     case CubereflexScreenOptionGroundColor2:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubereflexScreenOptionGroundColor2])
                (*os->notify[CubereflexScreenOptionGroundColor2]) (s, o, CubereflexScreenOptionGroundColor2);
            return TRUE;
        }
        break;
     case CubereflexScreenOptionGroundSize:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubereflexScreenOptionGroundSize])
                (*os->notify[CubereflexScreenOptionGroundSize]) (s, o, CubereflexScreenOptionGroundSize);
            return TRUE;
        }
        break;
     case CubereflexScreenOptionIntensity:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubereflexScreenOptionIntensity])
                (*os->notify[CubereflexScreenOptionIntensity]) (s, o, CubereflexScreenOptionIntensity);
            return TRUE;
        }
        break;
     case CubereflexScreenOptionAutoZoom:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubereflexScreenOptionAutoZoom])
                (*os->notify[CubereflexScreenOptionAutoZoom]) (s, o, CubereflexScreenOptionAutoZoom);
            return TRUE;
        }
        break;
     case CubereflexScreenOptionZoomManualOnly:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubereflexScreenOptionZoomManualOnly])
                (*os->notify[CubereflexScreenOptionZoomManualOnly]) (s, o, CubereflexScreenOptionZoomManualOnly);
            return TRUE;
        }
        break;
     case CubereflexScreenOptionMode:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[CubereflexScreenOptionMode])
                (*os->notify[CubereflexScreenOptionMode]) (s, o, CubereflexScreenOptionMode);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * cubereflexOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    CUBEREFLEX_OPTIONS_SCREEN(s);
    *count = CubereflexScreenOptionNum;
    return os->opt;
}

static Bool cubereflexOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    CubereflexOptionsScreen *os;
    
    CUBEREFLEX_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(CubereflexOptionsScreen));
    if (!os)
        return FALSE;

    s->base.privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &cubereflexOptionsMetadata, cubereflexOptionsScreenOptionInfo, os->opt, CubereflexScreenOptionNum))
    {
        free (os);
        return FALSE;
    }

    return TRUE;
}

static void cubereflexOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    CUBEREFLEX_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, CubereflexScreenOptionNum);

    free (os);
}

static Bool cubereflexOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    CubereflexOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(CubereflexOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->base.privates[CubereflexOptionsDisplayPrivateIndex].ptr = od;

    
    return TRUE;
}

static void cubereflexOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    CUBEREFLEX_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);
    free (od);
}

static Bool cubereflexOptionsInit (CompPlugin *p)
{
    CubereflexOptionsDisplayPrivateIndex = allocateDisplayPrivateIndex();
    if (CubereflexOptionsDisplayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&cubereflexOptionsMetadata, "cubereflex",0, 0, cubereflexOptionsScreenOptionInfo, CubereflexScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&cubereflexOptionsMetadata, "cubereflex");
    if (cubereflexPluginVTable && cubereflexPluginVTable->init)
        return cubereflexPluginVTable->init (p);
    return TRUE;
}

static void cubereflexOptionsFini (CompPlugin *p)
{
    if (cubereflexPluginVTable && cubereflexPluginVTable->fini)
        cubereflexPluginVTable->fini (p);

    if (CubereflexOptionsDisplayPrivateIndex >= 0)
        freeDisplayPrivateIndex (CubereflexOptionsDisplayPrivateIndex);

    compFiniMetadata (&cubereflexOptionsMetadata);
}

static CompBool cubereflexOptionsInitObject (CompPlugin *p, CompObject *o)
{
    static InitPluginObjectProc dispTab[] = {
        (InitPluginObjectProc) 0,
        (InitPluginObjectProc) cubereflexOptionsInitDisplay,
        (InitPluginObjectProc) cubereflexOptionsInitScreen
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), TRUE, (p, o));
}

static void cubereflexOptionsFiniObject (CompPlugin *p, CompObject *o)
{
    static FiniPluginObjectProc dispTab[] = {
        (FiniPluginObjectProc) 0,
        (FiniPluginObjectProc) cubereflexOptionsFiniDisplay,
        (FiniPluginObjectProc) cubereflexOptionsFiniScreen
    };

    DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), (p, o));
}

static CompBool cubereflexOptionsInitObjectWrapper (CompPlugin *p, CompObject *o)
{
    CompBool rv = TRUE;
    rv = cubereflexOptionsInitObject (p, o);
    if (cubereflexPluginVTable->initObject)
        rv &= cubereflexPluginVTable->initObject (p, o);
    return rv;
}

static void cubereflexOptionsFiniObjectWrapper (CompPlugin *p, CompObject *o)
{
    if (cubereflexPluginVTable->finiObject)
        cubereflexPluginVTable->finiObject (p, o);
    cubereflexOptionsFiniObject (p, o);
}

static CompOption * cubereflexOptionsGetObjectOptions (CompPlugin *p, CompObject *o, int *count)
{
    static GetPluginObjectOptionsProc dispTab[] = {
        (GetPluginObjectOptionsProc) 0,
            (GetPluginObjectOptionsProc) 0,
        (GetPluginObjectOptionsProc) cubereflexOptionsGetScreenOptions
    };

    *count = 0;
    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab),
		     NULL, (p, o, count));
}

static CompBool cubereflexOptionsSetObjectOption (CompPlugin *p, CompObject *o, const char *name, CompOptionValue *value)
{
    static SetPluginObjectOptionProc dispTab[] = {
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) 0,
        (SetPluginObjectOptionProc) cubereflexOptionsSetScreenOption
    };

    RETURN_DISPATCH (o, dispTab, ARRAY_SIZE (dispTab), FALSE,
		     (p, o, name, value));
}

static CompMetadata *
cubereflexOptionsGetMetadata (CompPlugin *plugin)
{
    return &cubereflexOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo20070830 (void)
{
    if (!cubereflexPluginVTable)
    {
        cubereflexPluginVTable = getCompPluginInfo ();
        memcpy(&cubereflexOptionsVTable, cubereflexPluginVTable, sizeof(CompPluginVTable));
        cubereflexOptionsVTable.getMetadata = cubereflexOptionsGetMetadata;
        cubereflexOptionsVTable.init = cubereflexOptionsInit;
        cubereflexOptionsVTable.fini = cubereflexOptionsFini;
        cubereflexOptionsVTable.initObject = cubereflexOptionsInitObjectWrapper;
        cubereflexOptionsVTable.finiObject = cubereflexOptionsFiniObjectWrapper;
        cubereflexOptionsVTable.getObjectOptions = cubereflexOptionsGetObjectOptions;
	cubereflexOptionsVTable.setObjectOption = cubereflexOptionsSetObjectOption;
	
    }
    return &cubereflexOptionsVTable;
}

