/*
 * Decompiled with CFR 0.152.
 */
package netscape.oji;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.Security;
import java.util.Date;
import java.util.Properties;

public class MRJSession {
    private static PrintStream out = null;
    private static PrintStream err = null;
    private static PrintStream console = null;
    private static Properties props = null;
    private static String pluginHome = "";

    private static Properties loadProperties() {
        Properties props = new Properties();
        try {
            FileInputStream propsStream = new FileInputStream(pluginHome + "/MRJPlugin.properties");
            props.load(propsStream);
            ((InputStream)propsStream).close();
        }
        catch (IOException ex) {
            System.out.println("MRJSession.loadProperties(): Exception " + ex.getMessage());
            ex.printStackTrace();
            throw new InternalError();
        }
        return props;
    }

    private static void giveOurselvesAllPermissions() {
        try {
            int n = 1;
            while (Security.getProperty("policy.url." + n) != null) {
                ++n;
            }
            String ourPolicyProperty = "policy.url." + n;
            Security.setProperty(ourPolicyProperty, "file:" + pluginHome + "/MRJPlugin.policy");
        }
        catch (Exception ex) {
            System.out.println("MRJSession.giveOurselvesAllPermissions(): Exception " + ex.getMessage());
            ex.printStackTrace();
            throw new InternalError();
        }
    }

    private static void restrictPackageAccess() {
        try {
            String packageAccess = Security.getProperty("package.access");
            packageAccess = packageAccess + ",netscape.oji.";
            Security.setProperty("package.access", packageAccess);
        }
        catch (Exception ex) {
            System.out.println("MRJSession.restrictPackageAccess(): Exception " + ex.getMessage());
            ex.printStackTrace();
            throw new InternalError();
        }
    }

    public static void open(String consolePath) throws IOException {
        pluginHome = System.getProperty("netscape.oji.plugin.home");
        props = MRJSession.loadProperties();
        boolean append = Boolean.valueOf(props.getProperty("netscape.oji.plugin.console.append"));
        File consoleFile = new File(consolePath);
        File parentFile = consoleFile.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        out = System.out;
        err = System.err;
        console = new PrintStream(new FileOutputStream(consolePath, append));
        System.setOut(console);
        System.setErr(console);
    }

    public static void initSecurity() {
        Date date = new Date();
        String version = props.getProperty("netscape.oji.plugin.version");
        System.out.println("MRJ Plugin for Mac OS X v" + version);
        System.out.println("[starting up Java Applet Security @ " + date + "]");
        MRJSession.giveOurselvesAllPermissions();
        MRJSession.restrictPackageAccess();
        if (System.getProperty("java.version").compareTo("1.4") >= 0) {
            return;
        }
        if (System.getSecurityManager() == null) {
            try {
                String name = props.getProperty("netscape.oji.plugin.security");
                SecurityManager securityManager = (SecurityManager)Class.forName(name).newInstance();
                System.setSecurityManager(securityManager);
            }
            catch (Exception ex) {
                System.err.println("MRJ Plugin: Exception while setting Java 1.3.1 security manager: " + ex.getMessage());
                ex.printStackTrace();
                throw new InternalError();
            }
        }
    }

    public static void close() throws IOException {
        System.setOut(out);
        System.setErr(err);
        console.close();
    }
}

