/***************************************************************************
 *   Copyright (C) 2007 by Francesco Cecconi                               *
 *   francesco.cecconi@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License.        *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "../mainwin.h"
#include "../preference/profilemain.h"

void nmapClass::about()
{
	QMessageBox::about(this,tr("About NmapSI4-0.1 Svn"),
			   tr("NmapSI4-0.1 SVN is a qt4 interface for nmap scanner\n\n\n"
					   "NmapSI4 is published under the terms of the GPL v2\n\n"
					   "For technical support, send mail to brand80@users.sourceforge.net\n"
					   "or visit: http://nmapsi4.netsons.org\n"));
}

void nmapClass::about_qt()
{
	QMessageBox::aboutQt(this,"Qt Version");
}

void nmapClass::show_browser(QLineEdit *location)
{
	QString FileName;

	FileName = QFileDialog::getOpenFileName(this, QApplication::translate("nmapClass", "Select the file",
			0, QApplication::UnicodeUTF8), "/home", "");

	location->setText(FileName);
}

void nmapClass::show_log_browser(QLineEdit *location)
{
	QString FileName;

	FileName = QFileDialog::getExistingDirectory(this, "Open Directory",
					"/home", QFileDialog::ShowDirsOnly | QFileDialog::DontResolveSymlinks);

	location->setText(FileName);
}

void nmapClass::input_browser() // call browser for input file
{
	this->show_browser(lineInputFile);
}

void nmapClass::exit()
{
	if(proc)
		proc->terminate();

	if((checkLog) && (PFile)) { 
		PFile->close();
		this->isEmptyLog();
	} else
		if((!checkLog) && (PFile)) { // if log check is disable but the file exit
			PFile->close();
			PFile->remove();
		}

	this->close();
}

void nmapClass::stop_scan()
{
	if(proc) {

		QString tmp_line = hostEdit->text();
 		tmp_line.append(" (Stopped)"); // update hostEdit with stopped string (don't traslate)
		hostEdit->setText(tmp_line);

  		proc->terminate();

		progressScan->setValue(0); // clear UI element
		stopButton->setEnabled(FALSE);
		buttonClearHistory->setEnabled(TRUE);
	}
}

QFile* nmapClass::create_logFile(QString Path) {

	QFile *Pfile = new QFile();
	QDir::setCurrent(Path);
	Pfile->setFileName(FileName);
	return Pfile;
}

void nmapClass::isEmptyLog() {

	qint64 tmp = PFile->size();

	if(!tmp) {
		QDir::setCurrent(logPath);
		PFile->setFileName(FileName);
		PFile->remove();
	}
	else {

		if(firstPath != logPath) {
			QString pathTmp = logPath;
			pathTmp.append("/");
			pathTmp.append(FileName);

			if(!PFile->copy(FileName,pathTmp))
				QMessageBox::critical(this, "NmapSI4",
					tr("Save File permission Error (Log stored in /tmp)\n"),tr("Close"));
			else
				PFile->remove();
		}
	}
}


void nmapClass::fileSession() { // slot

	if(!PFile) {
		FileName = QDate::currentDate().toString("[dd-MM-yyyy]");
		FileName.append( QTime::currentTime().toString("[h-m-s]"));
		FileName.append("-nmapsi4.log");
		firstPath = logPath;
		PFile = create_logFile(logPath);
		PFile->open(QIODevice::WriteOnly | QIODevice::Text);
	}
}

void nmapClass::startProfile_ui() { // start preference UI
	mainProfile *dialog = new mainProfile();
	dialog->show();
 	connect( dialog, SIGNAL( accepted() ), this, SLOT( readProfile() ) );
}
