 /* 
 
        The wireless menus are derived from parts of KNetworkmanager by
        Timo Hoenig        <thoenig@suse.de>, <thoenig@nouse.net>
        Will Stephenson    <wstephenson@suse.de>, <wstephenson@kde.org>
        Valentine Sinitsyn <e_val@inbox.ru>
        
        (c) 2006 by Thomas Michel <tom.michel@arcor.de>

        Kwlan is free software; you can redistribute it and/or modify
        it under the terms of the GNU Library General Public License as
        published by the Free Software Foundation; either version 2 of
        the License, or (at your option) any later version.

        Kwlan is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU Library General Public License for more details.

        You should have received a copy of the GNU Library General Public License
        along with this library; see the file COPYING.LIB.  If not, write to
        the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
        Boston, MA 02110-1301, USA.
 */
#include "kwlantraywin.h"
#include "kwlaninterface.h"
#include "kdialup.h"
#include "kstartsupplicantdlg.h"
#include "kwlansettingsdlg.h"
#include "globals.h"
#include "kwlnetworklist.h"
#include "kprofileconfigdlg.h"
#include "dialup.h"

#include <kstdaction.h>
#include <kpopupmenu.h>
#include <kaction.h>
#include <qtooltip.h>
#include <kiconloader.h>
#include <qpixmap.h>
#include <klocale.h>
#include <kdebug.h>
#include <kpassivepopup.h>
#include <qpixmap.h>
#include <qprogressbar.h>
#include <qpainter.h>
#include <qstyle.h>


void KWirelessMenu::paint (QPainter *p, const QColorGroup &/*cg*/, bool highlighted, bool /*enabled*/, int x, int y, int w, int h)
{
    int spacer = 0;
    m_strengthGraph->setTotalSteps (100);
    m_strengthGraph->setSizePolicy (QSizePolicy ((QSizePolicy::SizeType) 0, (QSizePolicy::SizeType) 0, 0, 0, m_strengthGraph->sizePolicy ().hasHeightForWidth ()));
    m_strengthGraph->setFixedHeight (m_height - 2);
    m_strengthGraph->setProgress (m_strength);
    m_strengthGraph->setPercentageVisible (false);

    if (highlighted) {
        p->setPen(m_parent->palette ().active ().highlightedText ());
        m_strengthGraph->setBackgroundMode( Qt::PaletteHighlight, Qt::PaletteHighlight );
    } else {
        p->setPen(m_parent->palette ().active ().text ());
    }
    p->drawText   (x, y, w, h, AlignLeft | AlignVCenter | DontClip | ShowPrefix, m_ssid);
    QPixmap pmLock;
    if (m_isEncrypted) {
        pmLock = SmallIcon ("encrypted", QIconSet::Automatic);
    }
    else pmLock = SmallIcon ("decrypted", QIconSet::Automatic);
    p->drawPixmap (m_parent->sizeHint ().width () - m_strengthGraph->width () - m_space - pmLock.size ().width () - 6, y + m_border, pmLock);
    spacer = pmLock.size ().width () + 4;
    if (!m_isConfigured) {
        QPixmap pmNew = SmallIcon ("bookmark", QIconSet::Automatic);
        p->drawPixmap (m_parent->sizeHint ().width () - m_strengthGraph->width () - m_space - pmNew.size ().width () - spacer - 6, y + m_border, pmNew);
        spacer = pmNew.size ().width () + 4;
    } 

    if (m_adhoc) {
        QPixmap pmAdHoc = SmallIcon ("system", QIconSet::Automatic);
        p->drawPixmap (m_parent->sizeHint ().width () - m_strengthGraph->width () - m_space - pmAdHoc.size ().width () - spacer - 6, y + m_border, pmAdHoc);
    } 
    p->drawPixmap (m_parent->sizeHint ().width () - m_strengthGraph->width () - m_space, y +m_border, QPixmap::grabWidget (m_strengthGraph));
}

QSize KWirelessMenu::sizeHint ()
{
    return QSize (m_width, m_height);
}

KWirelessMenu::KWirelessMenu (QWidget* p, const kwlNetwork &prof, bool /*active*/)
    : QCustomMenuItem ()
{
    m_parent       = p;
    m_ssid       = prof.m_ssid;
    m_adhoc = prof.m_adhoc;
    m_isConfigured = prof.m_isConfigured;
    if (prof.m_flags.isEmpty()) m_isEncrypted = FALSE;
    else m_isEncrypted = TRUE;
    // Some drivers don't return a value for signal or quality
    // if signal is nat set, use quality as strength level; 
    int qual = prof.m_quality.toInt();
    int sig = prof.m_signal.toInt();
    if (sig == 0) m_strength = qual;
    else m_strength = sig;
    //_encrypted   = encrypted;
    m_strengthGraph = new QProgressBar (this->m_parent, "strengthGraph");
    m_strengthGraph->hide();
	// TODO make all this neat or at least static
    /* px between pmLock and pbarStrength */
    m_space     = 5;

    /* the following code should not be used as teaching material in any kind */
	// set the widget height to that of a small icon
    m_widgetHeight = SmallIcon (NULL, QIconSet::Automatic).height ();
	// figure out the height of the text
    m_textHeight = kapp->fontMetrics ().size (AlignLeft | AlignVCenter | DontClip | ShowPrefix, m_ssid).height ();
	// the item is height of the text plus the default frame width
    m_height = m_textHeight + kapp->style ().pixelMetric (QStyle::PM_DefaultFrameWidth);
    /* _height needs to be at least the height of a SmallIcon plus a border of one px (top & bottom)*/
    if (m_height < m_widgetHeight) {
        m_height = m_widgetHeight + 2;
    }

    /* border required for pmLock and pbarStrength */
    m_border = 1;
    if (m_border == kapp->style ().pixelMetric (QStyle::PM_DefaultFrameWidth))
        m_border += 2 * kapp->style ().pixelMetric (QStyle::PM_DefaultFrameWidth);
    if (m_border == 0)
        m_border ++;

    m_width =  kapp->fontMetrics().size(AlignLeft | AlignVCenter | DontClip | ShowPrefix, m_ssid).width(); /* essid */
    m_width += SmallIcon (NULL, QIconSet::Automatic).width ();                                             /* pmLock */
    m_width += m_space;                                                                                     /* pmLock <-> pbarStrength */
    m_width += 100;                                                                                        /* pbarStrength */
    m_width += m_space;                                                                                     /* pbarStrength -> contextMenu */
}

KWirelessMenu::~KWirelessMenu ()
{
}



KwlanTrayWin::KwlanTrayWin(QWidget *parent, const char *name)
    : KSystemTray(parent, name)
{
    m_interface = 0L;
    m_ifname="";
    //m_interfaceUp = FALSE;
    //actionCollection()->remove( actionCollection()->action( "quit" ) );
    m_quit = KStdAction::quit( this, SIGNAL( quitSelected() ), actionCollection() );
    m_about = KStdAction::aboutApp( this, SIGNAL( aboutSelected() ), actionCollection() );
    m_interfaceEnableMenu = new KAction(this,"interfaceEnable");
    connect (m_interfaceEnableMenu,SIGNAL(activated()),this, SLOT(interfaceEnable()));

    setPixmap(loadIcon("kwlan"));
    m_tooltip = new KwlanToolTip(this);
    //m_profiles.setAutoDelete(TRUE);
    m_profileMenu = new KPopupMenu();
    connect (m_profileMenu, SIGNAL(activated(int )),SLOT(selectProfile(int )));
    m_dialupMenu = new KPopupMenu();
    connect (m_dialupMenu, SIGNAL(activated(int )),SLOT(slotHandleDialupMenu(int )));
    m_wpaMenu = new KPopupMenu();
    m_wpaMenu->insertItem(i18n("Start WPA Supplicant"),WPASTARTID);
    m_wpaMenu->setItemParameter(WPASTARTID,WPASTARTID);
    m_wpaMenu->insertItem(i18n("Stop WPA Supplicant"),WPASTOPID);
    m_wpaMenu->setItemParameter(WPASTOPID,WPASTOPID);
    m_wpaMenu->insertItem(i18n("Log Viewer"),WPALOGID);
    m_wpaMenu->setItemParameter(WPALOGID,WPALOGID);
    m_wpaMenu->insertItem(i18n("Settings"),WPASETTINGSID);
    m_wpaMenu->setItemParameter(WPASETTINGSID,WPASETTINGSID);
    connect (m_wpaMenu,SIGNAL(activated(int )), this, SLOT(handleWpaMenuEvent(int )));
    m_wpaMenu->setItemEnabled(WPASTOPID,FALSE);
    m_interfacesMenu = new KPopupMenu();
    connect (m_interfacesMenu, SIGNAL(activated(int )),SLOT(slotHandleInterfacesMenu( int )));
    m_configureInterfacesMenu = new KPopupMenu();
    connect (m_configureInterfacesMenu, SIGNAL(activated(int )),SLOT(slotHandleConfigureInterfacesMenu( int )));
    m_timer = new QTimer(this);
    if (m_timer){
        connect (m_timer, SIGNAL(timeout()),SLOT(updateIcon()));
        m_timer->start(100,FALSE);
    }
    m_configuration = 0L;
}

KwlanTrayWin::~KwlanTrayWin() {
    if (m_timer){
        m_timer->stop();
        delete (m_timer);
    } 
    delete m_tooltip;
    m_tooltip = 0;
}

void KwlanTrayWin::setInterface(KwlanInterface *interface)
{
    if (!interface) return;
    m_interface = interface;
    //connect (m_interface, SIGNAL(interfaceUp( bool )), this, SLOT (setInterfaceEnableMenu( bool )));
    connect (this, SIGNAL(interfaceEnable( bool )), m_interface, SLOT (enableInterface(bool)));
    connect (m_interface, SIGNAL(interfaceGone(KwlanInterface*)), this, SLOT (slotInterfaceGone(KwlanInterface* )));
    connect (this, SIGNAL(viewLog()),m_interface,SLOT(logViewer()));
    //connect (this, SIGNAL(editProfiles()), m_interface,SLOT(editProfiles()));
    connect (this, SIGNAL(scan()), m_interface, SLOT(slotScan()));
    connect (this, SIGNAL(profileChanged(QString)), m_interface, SLOT(profileActivate(QString)));
    connect (m_interface, SIGNAL(wpaStatusChanged(bool)), this, SLOT(enableStartWpaMenu(bool)));
    connect (m_interface,SIGNAL(sigMessage( QString )),this,SLOT(say( QString )));
    m_confFile = QString("kwlanrc.") + interface->getInterfaceName();
    m_configuration = new Configuration(m_confFile);
    enableStartWpaMenu( interface->getWpaStarted());
    updateNetworks();

}

 
void KwlanTrayWin::contextMenuAboutToShow( KPopupMenu *r ) {
    
    QString  curProf;
    updateNetworks();
    if (! m_interface) 
    {
        kdDebug() << "Context menu cannot be shown: No interface found!!!" << endl;
        return;
    }

    curProf = m_interface->getCurrentProfile();
    int id;
    r->clear();
    r->insertTitle(SmallIcon ("kwlan"), "Kwlan - KDE Connection Manager");
    
    m_configureInterfacesMenu->clear();
    m_interfacesMenu->clear();
    id = 1;

    if (m_interface->getConfigureInterface())
    {
        // Now fill in the profiles into profile menu
        if (m_interface->getType()!=KwlanInterface::PPP)
        {
            if (!(m_interface->getMainWin())) return;
            QStringList interfaces = ((m_interface->getMainWin())->getInterfaces());
            for (QStringList::iterator it = interfaces.begin(); it !=interfaces.end();it++)
            {
                m_interfacesMenu->insertItem(*it,id);
                m_interfacesMenu->setItemParameter(id,id);
                m_interfacesMenu->setItemChecked(id, mainConfiguration().readMonitorInterface( *it));
                m_configureInterfacesMenu->insertItem(*it,id);
                m_configureInterfacesMenu->setItemParameter(id,id);
                m_configureInterfacesMenu->setItemChecked(id, mainConfiguration().readConfigureInterface( *it));
                id++;
            }
            r->insertItem(i18n("Monitor interfaces"),m_interfacesMenu);
            r->insertItem(i18n("Configure interfaces"),m_configureInterfacesMenu);
            id = 1;
            m_profileMenu->clear();
            kwlNetworkList::iterator prof; 
            for (prof = m_profiles.begin(); prof != m_profiles.end(); prof++)
            {
                QString text;
                text = (*prof).m_ssid;
                if (m_interface->getInterfaceData().wirelessDevice)
                {
                    KWirelessMenu *netMenu = new KWirelessMenu(r,*prof,FALSE);
                    m_profileMenu->insertItem(netMenu,id);
                    m_profileMenu->setItemParameter(id,id);
                }
                else {
                    m_profileMenu->insertItem(text,id);
                }
                m_networkMap[id]=*prof;
                if ((*prof).m_ssid == curProf)
                    m_profileMenu->setItemChecked(id, TRUE);
                else 
                    m_profileMenu->setItemChecked(id, FALSE);
                id++;
            }
            r->insertItem(i18n("Activate Profile"),m_profileMenu);
            r->insertItem(i18n("Wpa"),m_wpaMenu);
            r->insertSeparator();
        }
    }
    // Now show dialup Menu
    if (m_interface->getType()!=KwlanInterface::PPP)
    {
        QStringList dialupNetworks = listDialupNetworks();
        id = 1;
        m_dialupMenu->clear();
        for (QStringList::iterator it = dialupNetworks.begin(); it !=dialupNetworks.end();it++)
        {
            m_dialupMenu->insertItem(*it,id);
            m_dialupMenu->setItemParameter(id,id);
            id++;
        }
        r->insertItem(i18n("Connect Dialup"),m_dialupMenu);
        r->insertSeparator();
    }
    //now set the interface enable / disable menu
    if (m_interface->getConfigureInterface() || (m_interface->getType() == KwlanInterface::PPP))
    {
        QString enableMenu;
        if (m_interface->getInterfaceData().up) enableMenu = i18n("Disable");
        else enableMenu = i18n("Enable");
        m_interfaceEnableMenu->setText(enableMenu);
        m_interfaceEnableMenu->plug(r);
        r->insertSeparator();
    }
    if (m_interface->getType() != KwlanInterface::PPP) 
    {
        m_about->plug( r );
        m_quit->plug( r );
    }
    
}
void KwlanTrayWin::slotHandleInterfacesMenu( int id)
{
    if (::debugOutput) kdDebug()<< "Monitor interface " <<m_interfacesMenu->text(id) << endl;
    mainConfiguration().writeMonitorInterface( m_interfacesMenu->text(id), !m_interfacesMenu->isItemChecked(id));
    emit sigMonitorInterface( m_interfacesMenu->text(id),!m_interfacesMenu->isItemChecked(id));
}

void KwlanTrayWin::slotHandleConfigureInterfacesMenu( int id)
{
    if (::debugOutput) kdDebug()<< "Configure interface " <<m_configureInterfacesMenu->text(id) << endl;
    mainConfiguration().writeConfigureInterface( m_configureInterfacesMenu->text(id), !m_configureInterfacesMenu->isItemChecked(id));
    emit sigConfigureInterface( m_configureInterfacesMenu->text(id),!m_configureInterfacesMenu->isItemChecked(id));
}

void KwlanTrayWin::slotHandleDialupMenu(int id)
{
    //if (::debugOutput) 
        kdDebug()<< "Connect dialup:  " << m_dialupMenu->text(id) << endl;
    // get network
    KDialup *dialup = new KDialup();
    QString sel= m_dialupMenu->text(id);
    dialup->connectNetwork(sel);

}
void KwlanTrayWin::updateNetworks()
{
    kwlNetworkList networks;
    m_profiles.clear();
    //clearProfiles();
    if (!m_interface) return;
    //networks= m_interface->listProfiles();
    if (mainConfiguration().readShowAvailableOnly())
        networks = m_interface->getAvailableProfiles();
    else {
        QStringList tmpNetworks = m_interface->listProfiles();
        for (QStringList::Iterator it = tmpNetworks.begin(); it != tmpNetworks.end();it++)
            networks.append(kwlNetwork(*it));
    } 
    for (kwlNetworkList::Iterator it=networks.begin();it != networks.end();it++){
        //if ((*it).m_isConfigured)
            m_profiles.append(*it);
    }
}

/*
void KwlanTrayWin::setInterfaceEnableMenu( bool up)
{
    if (!m_interface) return;
    //m_interfaceUp = up;

}
*/
            
void KwlanTrayWin::interfaceEnable()
{
    if (!m_interface) return;
    emit (interfaceEnable(!m_interface->getInterfaceData().up));
}
const QString & KwlanTrayWin::getInterfaceName() const {
    return m_ifname;
}
        
void KwlanTrayWin::slotSettings()
{
    if (!m_interface) return;
    KwlanSettingsDlg *settings = new KwlanSettingsDlg();
    Configuration *configuration = m_interface->getConfiguration();
    settings->setConfiguraton( configuration);

    if (!settings) return;
    settings->setCaption(QString(i18n("Settings for %1")).arg(m_ifname));
    settings->show();
    settings->exec();
}


void KwlanTrayWin::updateIcon()
{
    //QPixmap trayIcon;
    // Do we have a wireless interface?
    if (!m_interface ) return;
    interfaceData data = m_interface->getInterfaceData();
    QString statusIcon = getIcon();
    if (data.connected)
    {
        if (data.prevTxBytes == data.txBytes)
        {
            if (data.prevRxBytes == data.rxBytes) statusIcon +=QString("-none");
            else statusIcon +=QString("-rx");
        }
        else if (data.prevRxBytes == data.rxBytes) statusIcon +=QString("-tx");
        else  statusIcon += QString("-both");
    }
    else statusIcon += QString("-disconnected") ;
    setPixmap(loadIcon(statusIcon));
}


void KwlanTrayWin::setInterfaceName(const QString &ifname)
{
    m_ifname = ifname;
}

void KwlanTrayWin::setIpAddress(const QString &ipaddress){
    m_ipaddress = ipaddress;
}


void KwlanTrayWin::selectProfile(int id)
{
    kdDebug() <<"select Profile " << m_networkMap[id].m_ssid << endl;
    emit profileChanged(m_networkMap[id].m_ssid);
    /*
    if (m_networkMap[id].m_isConfigured)
    else {
        KProfileConfigDlg *nc = new KProfileConfigDlg();
        if (nc == NULL)
            return;
        nc->setInterface(m_interface);
        nc->paramsFromScanResults(m_networkMap[id]);
        nc->show();
        nc->exec();
    }
    */
}

void KwlanTrayWin::wpaStart()
{
    QString driver;
    if (!m_interface) return;
    if (m_interface->getInterfaceData().wirelessDevice)
    {
        KStartSupplicantDlg *startSupplicant = new KStartSupplicantDlg();
        if (!startSupplicant) return;
        if (!m_configuration) return;
        m_configuration->readDriver(driver);
        QString iface = m_interface->getInterfaceName();
        startSupplicant->setData( & iface ,& driver);
        startSupplicant->show();
        startSupplicant->exec();
        if (startSupplicant->m_start){
            m_interface->startWpa(startSupplicant->getDriver());
        }
    }

    else {
        //wired device, so drvier is wired
        m_interface->startWpa(QString("wired"));
    }
}

void KwlanTrayWin::wpaStop()
{
    if (!m_interface) return;
    m_interface->stopWpa();
}
void KwlanTrayWin::handleWpaMenuEvent(int menu)
{
    switch (menu)
    {
        case WPASTARTID:
            wpaStart();
            break;
        case WPASTOPID:
            wpaStop();
            break;
        case WPALOGID:
            emit (viewLog());
            break;
        case WPASETTINGSID:
            slotSettings();
            break;
    }
}

void KwlanTrayWin::enableStartWpaMenu(bool enable)
{
    m_wpaMenu->setItemEnabled(WPASTARTID,!enable);
    m_wpaMenu->setItemEnabled(WPASTOPID,enable);
    m_wpaMenu->setItemEnabled(WPALOGID,enable);
}

void KwlanTrayWin::slotInterfaceGone(KwlanInterface *interface)
{
    if (::debugOutput) kdDebug() << "Closing traywin..." << endl;
    m_interface=0L;
    m_timer->stop();
    close();
    deleteLater();
}

void KwlanTrayWin::slotShowTrayWin(QString interface, bool showWin)
{
    if (interface != m_ifname) return;
    if (showWin) show();
    else hide();
}


void KwlanTrayWin::mousePressEvent ( QMouseEvent * event )
{
    if (debugOutput) kdDebug() << "Tray Win clicked" << endl;
    if ( rect().contains( event->pos() ) )
        emit sigTrayWinClicked(m_ifname);
    //slotClicked(event);
   KSystemTray::mousePressEvent(event);
}

QString KwlanTrayWin::getIcon()
{
    QString statusIcon = QString("");
    wirelessData wData = m_interface->getWirelessData();
    if (m_interface->getType() == KwlanInterface::PPP)
        statusIcon = "kwlan/dialup";
    else if (!m_interface->getInterfaceData().wirelessDevice)
        statusIcon = "kwlan/wired";
    else {
        if (m_interface->getInterfaceData().connected)
        {
            int index = wData.linkQualityNum;
            if (index > 66)
                statusIcon = QString("kwlan/wireless3");
            else if (index > 33)
                statusIcon = QString("kwlan/wireless2");
            else
                statusIcon = QString("kwlan/wireless1");
        }
        else statusIcon = QString("kwlan/wireless");
    }
    return statusIcon;
}

void KwlanTrayWin::say(QString message)
{
    if (this->isVisible())
        KPassivePopup::message("Kwlan", message, kapp->miniIcon(), this);
}
    
KwlanToolTip::KwlanToolTip(QWidget *parent): QToolTip(parent) {
}
    
KwlanToolTip::~KwlanToolTip() {
    
}
        
void KwlanToolTip::maybeTip(const QPoint &p) {
    QString tooltip;
    KwlanTrayWin *parent = (KwlanTrayWin *)parentWidget();
        
    // We can't show tooltip if no interface was specified
    if (!parent->getInterface())
    {
        kdDebug() << "No interface for tooltip found" << endl;
        return;
    }
    const QString &ifname = parent->getInterfaceName();
    interfaceData data = parent->getInterface()->getInterfaceData();
    wirelessData wData;
    if (data.wirelessDevice)
         wData = parent->getInterface()->getWirelessData();
    //QString network = parent->getProfile();
    QString network = parent->getInterface()->getCurrentProfile();
    // Get the URLs of the icons
    QString dialup,wireless_connected,wireless_disconnected,wired_connected,wired_disconnected;
    KIconLoader *kIcon = new KIconLoader();
    dialup = kIcon->iconPath("kwlan/dialup",KIcon::Desktop);
    wireless_connected = kIcon->iconPath(parent->getIcon()+QString("-none"),KIcon::Desktop);
    wireless_disconnected = kIcon->iconPath("kwlan/wireless-disconnected",KIcon::Desktop);
    wired_connected = kIcon->iconPath("kwlan/wired-none",KIcon::Desktop);
    wired_disconnected = kIcon->iconPath("kwlan/wired-disconnected",KIcon::Desktop);
    //if (data.connected) {
    if (parent->getInterface()->getState()==KwlanInterface::CONFIGURED) {
        if (parent->getInterface()->getType() == KwlanInterface::PPP)
        {
            tooltip = QString("<center><img align=center src=%1></center>").arg(dialup);
        }
        if (data.wirelessDevice) {
            tooltip = QString("<center><img align=center src=%1></center>").arg(wireless_connected);
        }
        else {
            tooltip = QString("<center><img align=center src=%1></center>").arg(wired_connected);
        }
        tooltip += QString("<center><table border=0 bgcolor=#000000 cellspacing=1 cellpadding=1>");
        if (network.isEmpty())
            tooltip += QString(i18n("<tr><td colspan=2 bgcolor=#04CC1A><center><b>Interface:</b> [ %1 ]</center></td>")).arg(ifname);
        else
            tooltip += QString(i18n("<tr><td colspan=2 bgcolor=#04CC1A><center><b>Interface:</b> [ %1 ]<br>Connected to %2</b></center></td>")).arg(ifname,network);        
        if (data.wirelessDevice) {
            if (wData.essid.isEmpty())
                tooltip += QString(i18n("<tr><td bgcolor=#CCCCCC><b>Connected to:</b></td><td bgcolor=#CCCCCC><center>Hidden</center></td></tr>"));
            else
            tooltip += QString(i18n("<tr><td bgcolor=#CCCCCC><b>Connected to:</b></td><td bgcolor=#CCCCCC><center>%1</center></td></tr>")).arg(wData.essid);
            
            if (!wData.bitRate.isEmpty())
                tooltip += QString(i18n("<tr><td bgcolor=#EEEEEE><b>Bitrate:</b></td><td bgcolor=#EEEEEE><center>%1 Mbit/s</center></td></tr>")).arg(wData.bitRate);
            if (!wData.linkQuality.isEmpty())
                tooltip += QString(i18n("<tr><td bgcolor=#CCCCCC><b>Link quality:</b></td><td bgcolor=#CCCCCC><center>%1</center></td></tr>")).arg(wData.linkQuality);
            if (!wData.signal.isEmpty())
                tooltip += QString(i18n("<tr><td bgcolor=#EEEEEE><b>Signal Level:</b></td><td bgcolor=#EEEEEE><center>%1</center></td></tr>")).arg(wData.signal);
            if (!wData.frequency.isEmpty())
                tooltip += QString(i18n("<tr><td bgcolor=#CCCCCC><b>Frequency:</b></td><td bgcolor=#CCCCCC><center>%1</center></td></tr>")).arg(wData.frequency);
            if (!wData.channel.isEmpty())
                tooltip += QString(i18n("<tr><td bgcolor=#EEEEEE><b>Channel:</b></td><td bgcolor=#EEEEEE><center>%1</center></td></tr>")).arg(wData.channel);
        }
        tooltip += QString(i18n("<tr><tr><td bgcolor=#CCCCCC><b>IP address:</b></td><td bgcolor=#CCCCCC><center>%1</center></td></tr>")).arg(data.ipAddress);
        tooltip += QString(i18n("<tr><td bgcolor=#EEEEEE><b>Netmask:</b></td><td bgcolor=#EEEEEE><center>%1</center></td></tr>")).arg(data.subnetMask);
        tooltip += QString(i18n("<tr><tr><td bgcolor=#CCCCCC><b>Broadcast address:</b></td><td bgcolor=#CCCCCC><center>%1</center></td></tr>")).arg(data.broadcastAddress);
        tooltip += QString(i18n("<tr><td bgcolor=#EEEEEE><b>Bytes received:</b></td><td bgcolor=#EEEEEE><center>%1</center></td></tr>")).arg(data.rxString);
        tooltip += QString(i18n("<tr><tr><td bgcolor=#CCCCCC><b>Bytes sent:</b></td><td bgcolor=#CCCCCC><center>%1</center></td></tr>")).arg(data.txString);
        tooltip += QString(i18n("<tr><td bgcolor=#EEEEEE><b>Packets received:</b></td><td bgcolor=#EEEEEE><center>%1</center></td></tr>")).arg(data.rxPackets);
        tooltip += QString(i18n("<tr><tr><td bgcolor=#CCCCCC><b>Packets sent:</b></td><td bgcolor=#CCCCCC><center>%1</center></td></tr>")).arg(data.txPackets);
        tooltip += QString("</table></center>");
    }
    else {
        if (data.wirelessDevice) {
            tooltip = QString("<center><img align=center src=%1></center>").arg(wireless_disconnected);
        }
        else {
            tooltip = QString("<center><img align=center src=%1></center>").arg(wired_disconnected);
        }
        tooltip += QString("<center><table border=0 bgcolor=#000000 cellspacing=1 cellpadding=1>");
        switch (parent->getInterface()->getState())
        {
            case KwlanInterface::DISABLED:
                tooltip += QString(i18n("<tr><td bgcolor=#DD0500><center>[ %1 ] <b>is disabled</b></center></td></tr>")).arg(ifname);
                if (data.wirelessDevice && wData.radioOff) {
                    tooltip += QString(i18n("<tr><td bgcolor=#CCCCCC><center>The radio is off</center></td></tr>"));
                }
                break;
            case KwlanInterface::CONNECTED:
                tooltip += QString(i18n("<tr><td bgcolor=#DD0500><center>[ %1 ] <b> is requesting ip address</b></center></td></tr>")).arg(ifname);
                break;
            case KwlanInterface::NOTCONNECTED:
                tooltip += QString(i18n("<tr><td bgcolor=#DD0500><center>[ %1 ] <b>is not connected</b></center></td></tr>")).arg(ifname);
        }
        tooltip += QString("</table></center>");
    }
                 
    tip(parent->rect(), tooltip);
}

