/***************************************************************************
 *   Copyright (C) 2006 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "cpuinfofreqsrc.h"
#include <qtextstream.h> 
#include <qfile.h>
#include <klocale.h>

CpuinfoFreqSrc::CpuinfoFreqSrc(QWidget* inParent, const QFile& inSourceFile):
		LabelSource(inParent),
		mSourceFile(inSourceFile.name()),
		mTrigger(this){
	mID = "proc";
	mName = mID;
	mDescription = i18n("This source is provided by the Linux kernel proc vfs interface.");
}

CpuinfoFreqSrc::~CpuinfoFreqSrc(){
}

std::list<Source*>CpuinfoFreqSrc::createInstances(QWidget* inParent){
	std::list<Source*> list;
	QFile cpuinfoFreqFile( "/proc/cpuinfo" );
	if(cpuinfoFreqFile.open(IO_ReadOnly))
		list.push_back(new CpuinfoFreqSrc(inParent, cpuinfoFreqFile));
	return list;
}

QString CpuinfoFreqSrc::fetchValue(){
	QString s = "n/a";
	if(mSourceFile.open(IO_ReadOnly)){
		while( mSourceFile.readLine( s, 64 ) != -1 )
			if( s.startsWith( "cpu MHz") )
				break;
		s = s.section( ':', 1, 1 ).stripWhiteSpace();
		s = KHzinHumanReadable(uint(s.toDouble() * 1000));
		mSourceFile.close();
	}
	return s;
}
