// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Implements the register_k3d_plugins entry-point required of all K-3D modules
		\author Romain Behar (romainbehar@yahoo.com)
*/

#include <k3dsdk/module.h>

/// Namespace reserved for the POV plugin module, to protect public symbols from name clashes with other modules
namespace libk3dpov
{

extern k3d::iplugin_factory& render_engine_factory();

} // namespace libk3dpov

K3D_MODULE_START(libk3dpov, k3d::uuid(0x153d0e65, 0xf22a48c3, 0xa34853a3, 0xb7decb2b), Registry)
	Registry.register_factory(libk3dpov::render_engine_factory());
K3D_MODULE_END


