#ifndef K3DSDK_IBITMAP_READ_FORMAT_H
#define K3DSDK_IBITMAP_READ_FORMAT_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares k3d::ibitmap_read_format, an abstract interface for objects capable of deserializing files into k3dIBitmap objects
		\author Tim Shead (tshead@k-3d.com)
*/

#include "bitmap.h"
#include "iunknown.h"

// Forward declarations
namespace boost { namespace filesystem { class path; } }

namespace k3d
{

/// Abstract interface for objects capable of loading bitmaps from a filesystem
class ibitmap_read_format :
	public virtual iunknown
{
public:
	virtual bool read_file(const boost::filesystem::path& File, bitmap& Bitmap) = 0;

protected:
	ibitmap_read_format() {}
	ibitmap_read_format(const ibitmap_read_format& RHS) {}
	ibitmap_read_format& operator=(const ibitmap_read_format& RHS) { return *this; }
	virtual ~ibitmap_read_format() {}
};

} // namespace k3d

#endif // K3DSDK_IBITMAP_READ_FORMAT_H


