#ifndef PLAYER_H
#include "player.h"

#include <kurl.h>

Player::Player()
{
	xine = xine_new();

	if (!xine)
		return;

	xine_init(xine);
	ao_port = xine_open_audio_driver(xine, NULL, NULL);

	term = true;
	pos = 0;
	stream = 0;

	int ma, mi, su;
	xine_get_version(&ma, &mi, &su);
	xineVer = QString::number(ma) + "." + QString::number(mi) + "." + QString::number(su);
}

Player::~Player()
{
	xine_close_audio_driver(xine, ao_port);
	xine_exit(xine);
}

void Player::setTrack(const QString & t)
{
	track = t;
}

QString Player::getTrack() const
{
	return track;
}

QStringList Player::getAudioCDContents(const QString & device) const
{
	QStringList urls;
	char ** url;
	int num;

	if (!device.isNull())
	{
        	xine_cfg_entry_t config;
        	xine_config_lookup_entry(xine, "input.cdda_device", &config);
        	config.str_value = (char *)device.latin1();
        	xine_config_update_entry(xine, &config);
	}
	else
		return urls;

	url = xine_get_autoplay_mrls(xine, "CD", &num);

	if (url)
	{
		for (int i = 0 ; i != num ; i++)
		{
			if (url[i])
				urls << KURL::decode_string(url[i]);
		}
	}

	return urls;
}

const xine_t * Player::getXineHandle() const
{
	return xine;
}

const xine_stream_t * Player::getXineStreamHandle() const
{
	return stream;
}

QString Player::getXineVer() const
{
	return xineVer;
}
/*
int64_t Player::getCurrentVpts() const
{
	if ((!term) && (pos) && (xine_get_status(stream) == XINE_STATUS_PLAY))
		return xine_get_current_vpts(stream);
	else
		return 0;
}
*/
void Player::setVolume(const int & vol)
{
	volume = vol;
}

int Player::getLength() const
{
	return length;
}

int Player::getVolume() const
{
	return volume;
}

int Player::getPos() const
{
	return pos;
}

void Player::setPos(const int & p)
{
	pos = p;
}

void Player::setEqualizer(const int & amp, const int freq[])
{
	if (!stream)
		return;

	xine_set_param(stream, XINE_PARAM_AUDIO_AMP_LEVEL, amp);

	xine_set_param(stream, XINE_PARAM_EQ_30HZ, freq[0]);
	xine_set_param(stream, XINE_PARAM_EQ_60HZ, freq[1]);
	xine_set_param(stream, XINE_PARAM_EQ_125HZ, freq[2]);
	xine_set_param(stream, XINE_PARAM_EQ_250HZ, freq[3]);
	xine_set_param(stream, XINE_PARAM_EQ_500HZ, freq[4]);
	xine_set_param(stream, XINE_PARAM_EQ_1000HZ, freq[5]);
	xine_set_param(stream, XINE_PARAM_EQ_2000HZ, freq[6]);
	xine_set_param(stream, XINE_PARAM_EQ_4000HZ, freq[7]);
	xine_set_param(stream, XINE_PARAM_EQ_8000HZ, freq[8]);
	xine_set_param(stream, XINE_PARAM_EQ_16000HZ, freq[9]);
}

void Player::setSoundSystem(const QString & system)
{
	xine_close_audio_driver(xine, ao_port);
	ao_port = xine_open_audio_driver(xine, system.latin1(), NULL);
}

void Player::termThread()
{
	term = true;
}

void Player::wakeThread()
{
	term = false;
}

void Player::run()
{
	if (!xine)
	{
		qDebug("Couldn't init xine!");
		return;
	}

	stream = xine_stream_new(xine, ao_port, NULL);

	if (!xine_open(stream, (const char *)track.local8Bit()) || !xine_play(stream, 0, pos))
		goto cleanup;

	while ((xine_get_status(stream) == XINE_STATUS_PLAY) && (!term))
	{
		xine_set_param(stream, XINE_PARAM_AUDIO_VOLUME, volume);
		xine_get_pos_length(stream, NULL, &pos, &length);
	
		QThread::msleep(250);
	}

cleanup:

	xine_close(stream);
	xine_dispose(stream);

	stream = 0;
	pos = 0;
	track = QString::null;
}

#endif
