#!/bin/ksh

# Set search path for commands
export PATH=/usr/xpg4/bin:/usr/sbin:/usr/bin:/usr/ccs/bin:/usr/dt/bin:/usr/openwin/bin

#XPRINTDIR=/usr/openwin/server/etc/XpConfig/
#XBINDIR=/usr/openwin/bin

case "$1" in
    'GISWxprintglue')
        PKG_NAME="GISWxprintglue"
        ;;
    'GISWxprint')
        PKG_NAME="GISWxprint"
        ;;
    *)
        echo "## Error illegal target"
        exit 1
        ;;
esac


PKG_FILES=/tmp/tmp_${PKG_NAME}


if [ "${XPRINTDIR}" = "" ] ; then
    echo "$0: Error: XPRINTDIR not set"
    exit 1
fi

if [ "${XBINDIR}" = "" ] ; then
    echo "$0: Error: XBINDIR not set"
    exit 1
fi
 

# Do not edit
# REL_* vars are paths relative to '/'
# Thanks to the "wonders" of some /bin/sh I cannot use ...
# REL_XPRINTDIR=${XPRINTDIR#*/}
# REL_XBINDIR=${XBINDIR#*/}
# ... ;-(
REL_XPRINTDIR="`echo ${XPRINTDIR} | sed 's/\///'`"
REL_XBINDIR="`echo ${XBINDIR} | sed 's/\///'`"

createpkgproto()
{
    pkgproto | 
    while read i1 i2 i3 i4 i5 ; do       
        if [ "${i1}" = "f" ] ; then
            if [ ! -r "${i3}" ] ; then
                echo "${0}: \"${i3}\" not found." >&2
                exit 1
            fi
        fi
    
        if [ "${i1}" = "d" -o -x "${i3}" ] ; then
            echo "$i1 $i2 $i3 0755"
        else
            echo "$i1 $i2 $i3"
        fi  
    done
}

#### Main

# Create and test tarball of files which should be in the final RPM...
if true ; then
echo "###### Fetching files from build dir..."
(
  # Go to xc/packager/tarball
  cd ../../tarball
  # ${XPDESTTARFILE} is used by "make make_xprint_tarball"
  export XPDESTTARFILE="/tmp/xprint_pkg_`date +%y%m%d%H%M%S`.tar.gz"
  make make_xprint_tarball

  # Check if the temp. tarball was being build
  if [ ! -f "${XPDESTTARFILE}" ] ; then
      echo "# temp. tarball missing."
      exit 1
  fi

  # ... and then unpack the temp. tarball in the ${PKG_FILES} dir
  [ -d "${PKG_FILES}" ] && rm -Rf "${PKG_FILES}"
  mkdir "${PKG_FILES}"
  cd "${PKG_FILES}"
  gunzip -c ${XPDESTTARFILE} | tar -xf -
  rm -f ${XPDESTTARFILE}
  
  cd xprint/install
   
  # Remove old ReadMe
  rm -f ${REL_XPRINTDIR}/README
  
  if [ "${PKG_NAME}" = "GISWxprintglue" ] ; then
    # Remove our own Xprt binary, Solaris has it's own working version
    # under /usr/openwin/bin/Xprt and the GISWxprintglue will use that
    # (only the "GISWxprint" package will ship it's own version of Xprt)
    rm -f ${REL_XBINDIR}/Xprt
  fi
)
fi

echo "###### Building pkgproto file..."

rm -f pkgproto.tmp
(
  OLD_PWD="${PWD}"
  cd "${PKG_FILES}/xprint/install"

  # Add files in /etc but skip any dirs (they are part of SUNWcsr)
  # (and treat them all as executable)
  echo '!default 755 root bin'
  find etc '!' -type d -print | createpkgproto

  # Add entry for package base dir ("/opt/GISWxprintglue" or "/opt/GISWxprint")
  echo "opt/${PKG_NAME}" | createpkgproto

  # Add files in opt/${PKG_NAME}/bin (executables)
  echo '!default 755 root bin'
  find opt/${PKG_NAME}/bin -print | createpkgproto

  # Add CDE/1.x glue
  find usr/dt/config/Xsession.d '!' -type d -print | createpkgproto

  # Add config files in opt/${PKG_NAME}/server (all non-executable)
  echo '!default 644 root bin'
  find opt/${PKG_NAME}/server -print | createpkgproto

  # Add Xfree86 encoding files for GISWxprint
  # (GISWxprintglue uses Solaris Xprt which uses the Solaris encoding/ttmap files)
  if [ "${PKG_NAME}" = "GISWxprint" ] ; then
    find opt/${PKG_NAME}/lib/X11/fonts/encodings -print | createpkgproto
  fi

  # Add files in opt/${PKG_NAME}/man (manual pages)
  if [ -d opt/${PKG_NAME}/man ] ; then 
    echo '!default 644 root bin'
    find opt/${PKG_NAME}/man -print | createpkgproto
  fi

  # Add FAQ, README etc.
  echo '!default 644 root bin'
  [ ! -d "opt/${PKG_NAME}/docs" ] && mkdirhier "opt/${PKG_NAME}/docs"
  cp "${OLD_PWD}/../../../doc/hardcopy/XPRINT/Xprint_FAQ.txt" opt/${PKG_NAME}/docs/.
  cp "${OLD_PWD}/README" opt/${PKG_NAME}/docs/.
  find opt/${PKG_NAME}/docs -print | createpkgproto
  
  # List package info files
  echo "# packaging files"
  echo "i pkginfo"
  echo "i depend"
  echo "i preinstall=./preinstall"
  echo "i postinstall=./postinstall"
) >pkgproto.tmp
ls -l pkgproto.tmp

echo "###### Making package..."
[ -d "/tmp/${PKG_NAME}" ] && rm -R "/tmp/${PKG_NAME}"

echo "#### pkgmk..."
pkgmk -f pkgproto.tmp -d /tmp -o -r "${PKG_FILES}/xprint/install" ${PKG_NAME}

echo "#### pkgtrans..."
pwd
rm -f "./${PKG_NAME}.pkg"
pkgtrans /tmp "${PWD}/${PKG_NAME}.pkg" ${PKG_NAME}

echo "#### compressing..."
rm -f "${PKG_NAME}.tar.gz"
tar -cvf - "${PKG_NAME}.pkg" README | gzip --best --stdout >"${PKG_NAME}.tar.gz"
rm -f "${PKG_NAME}.pkg"

echo "###### Cleaning up..."
rm -rf "${PKG_FILES}"
rm -R "/tmp/${PKG_NAME}"
#rm -f pkgproto.tmp

echo "###### Package done:"
ls -lad "${PKG_NAME}.tar.gz"

echo "###### Done."
exit 0
#
