/*
 * newfs.h - NILFS tool newfs (mkfs.nilfs), declares
 *
 * Copyright (C) 2005, 2006 Nippon Telegraph and Telephone Corporation.
 *
 * This file is part of NILFS.
 *
 * NILFS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * NILFS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with NILFS; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * newfs.h,v 1.3 2006/02/08 02:01:33 amagai Exp
 *
 * Written by Hisashi Hifumi
 *            Amagai Yoshiji
 */

#include <linux/types.h>

#ifndef __bitwise  /* Tricky workaround; should be replaced */
typedef __u64 __le64;
typedef __u32 __le32;
typedef __u16 __le16;
#endif
typedef __le64 nilfs_btree_key_t;
typedef __le64 nilfs_btree_ptr_t;

typedef unsigned char uchar;

#include "../fs/nilfs_fs.h"

/* B-Tree node on disk */
struct nilfs_btree_node {
	__le16 bn_level;		/* level of node */
	__le16 bn_nkeys;		/* number of keys and ptrs in node */
	__le32 bn_reserved[3];		/* reserved */
};

extern __u32 crc32c_le(__u32, unsigned char const *, size_t);

/* get device size through ioctl */
#ifndef BLKGETSIZE64
#define BLKGETSIZE64 	_IOR(0x12, 114, size_t)
#endif

#define min(x, y)	 ((x) < (y) ? (x) : (y))

/*
 * borrowed from linux/include/linux/byteswap/swab.h,
 *		 linux/include/linux/byteswap/big_endian.h,
 *	     and linux/include/linux/byteswap/little_endian.h.
 */
/*
 * linux/byteorder/swab.h
 * Byte-swapping, independently from CPU endianness
 *	swabXX[ps]?(foo)
 *
 * Francois-Rene Rideau <fare@tunes.org> 19971205
 *    separated swab functions from cpu_to_XX,
 *    to clean up support for bizarre-endian architectures.
 *
 * See asm-i386/byteorder.h and suches for examples of how to provide
 * architecture-dependent optimized versions
 *
 */

#if __BYTE_ORDER == __LITTLE_ENDIAN
#define __cpu_to_le16(x)	(x)
#define __cpu_to_le32(x)	(x)
#define __cpu_to_le64(x)	(x)
#define __le16_to_cpu(x)	(x)
#define __le32_to_cpu(x)	(x)
#define __le64_to_cpu(x)	(x)
#define CPU_TO_LE16(x)
#define CPU_TO_LE32(x)
#define CPU_TO_LE64(x)
#define LE16_TO_CPU(x)
#define LE32_TO_CPU(x)
#define LE64_TO_CPU(x)
#else
#define __le16_to_cpu(x) __cpu_to_le16(x)
#define __le32_to_cpu(x) __cpu_to_le32(x)
#define __le64_to_cpu(x) __cpu_to_le64(x)
#define __cpu_to_le16(x) \
({ \
	__u16 __x = (x); \
	((__u16)( \
	(((__u16)(__x) & (__u16)0x00ffU) << 8) | \
	(((__u16)(__x) & (__u16)0xff00U) >> 8) )); \
})
#define __cpu_to_le32(x) \
({ \
	__u32 __x = (x); \
	((__u32)( \
	(((__u32)(__x) & (__u32)0x000000ffUL) << 24) | \
	(((__u32)(__x) & (__u32)0x0000ff00UL) <<  8) | \
	(((__u32)(__x) & (__u32)0x00ff0000UL) >>  8) | \
	(((__u32)(__x) & (__u32)0xff000000UL) >> 24) )); \
})

#define __cpu_to_le64(x) \
({ \
	__u64 __x = (x); \
	((__u64)( \
	(__u64)(((__u64)(__x) & (__u64)0x00000000000000ffULL) << 56) | \
	(__u64)(((__u64)(__x) & (__u64)0x000000000000ff00ULL) << 40) | \
	(__u64)(((__u64)(__x) & (__u64)0x0000000000ff0000ULL) << 24) | \
	(__u64)(((__u64)(__x) & (__u64)0x00000000ff000000ULL) <<  8) | \
	(__u64)(((__u64)(__x) & (__u64)0x000000ff00000000ULL) >>  8) | \
	(__u64)(((__u64)(__x) & (__u64)0x0000ff0000000000ULL) >> 24) | \
	(__u64)(((__u64)(__x) & (__u64)0x00ff000000000000ULL) >> 40) | \
	(__u64)(((__u64)(__x) & (__u64)0xff00000000000000ULL) >> 56) )); \
})
#define CPU_TO_LE16(x)	(x)=__cpu_to_le16(x)
#define CPU_TO_LE32(x)	(x)=__cpu_to_le32(x)
#define CPU_TO_LE64(x)	(x)=__cpu_to_le64(x)
#define LE16_TO_CPU(x)	(x)=__le16_to_cpu(x)
#define LE32_TO_CPU(x)	(x)=__le32_to_cpu(x)
#define LE64_TO_CPU(x)	(x)=__le64_to_cpu(x)
#endif

/**************** borrowings end ****************/

/* Local Variables:	*/
/* eval: (c-set-style "linux")	*/
/* End:			*/
