#!/bin/sh
#
# updatecp - checkpoint list updater
#
# Copyright (C) 2006 Nippon Telegraph and Telephone Corporation.
# This file is part of NILFS and is licensed under the GPL.
#
# updatecp.sh,v 1.3 2006/02/14 06:17:10 moriai Exp
#
# Written by Satoshi Moriai <moriai@osrg.net>
#

PATH=/usr/bin:/bin:/sbin:/usr/sbin; export PATH

case "$#" in
3)	;;
*)	echo "Usage: updatecp nilfsdir remotedir interval"
	exit 1
	;;
esac

cd /

NILFSDIR="$1"
REMOTEDIR="$2"
INTERVAL="$3"

ls -a $NILFSDIR >/dev/null || exit 1

NILFSDEV=`awk '$2 == "'"$NILFSDIR"'" {print $1}' /proc/mounts`

[ -n "$NILFSDEV" ] || { echo "$NILFSDIR isn't a mount point." 1>&2; exit 1; }

DESTDIR=/var/run/nilfs/`echo "$NILFSDIR" | sed 's!/!_!g'`

[ -d "$DESTDIR" ] || mkdir "$DESTDIR" || exit 1

[ -r "$DESTDIR/index.html" ] || cat <<"EOF" >"$DESTDIR/index.html" || exit 1
<HTML>
<HEAD>
    <TITLE>NILFS snapshot list</TITLE>
</HEAD>
<FRAMESET COLS="30%,70%">
    <FRAME SRC="navi.html" NAME="Navi">
    <FRAME SRC="" NAME="Content">
<BODY>
</BODY>
</FRAMESET>
</HTML>

EOF

echo $$ >"$DESTDIR.pid"

while [ -d $NILFSDIR ]; do
	if seekcp -x "$REMOTEDIR" "$NILFSDEV" >$DESTDIR/navi-new.html; then
		mv $DESTDIR/navi-new.html $DESTDIR/navi.html
		sleep $INTERVAL
	else
		echo "updatecp: Can't update checkpoint list." >&2
		exit 1
	fi
done

exit 0
