#!/bin/sh
#
# landmark - select representatives in clusters of checkpoints
# Copyright (C) 2006 Nippon Telegraph and Telephone Corporation.
# This file is part of NILFS and is licensed under the GPL.
#
# landmark.sh,v 1.3 2006/03/20 12:27:17 ryusuke Exp
#
# Written by Ryusuke Konishi <ryusuke@osrg.net>
#

cintval=20     # cluster interval in minutes (20 minutes)
cspan=3600     # maximum span of cluster in minutes (1 hour)

subst=0
conc=0
while getopts hi:S:cs o; do
    case $o in
	i)
	    cintval="$OPTARG" ;;
	S)
	    cspan="$OPTARG" ;;
	c)
	    conc=1 ;; # concatinate sketch data between selected checkpoints
	s)
	    subst=1 ;; # substitute the latest valid sketch data if the
	               # selected checkpoint has no sketch data.
	h)
	    exit 0 ;;
	*)
	    exit 1 ;;
    esac
done
shift `expr $OPTIND - 1`

srcdev=$1
ci=`expr $cintval \* 60`
cs=`expr $cspan \* 60`

function time_after() { expr \( $2 \) - \( $1 \) \< 0 > /dev/null; }

function save_sketch() {
    test $2 -gt 0 || return
    if [ $conc -ne 0 ]; then
	inspect -s $1 -o "sketch.$1" $srcdev 1>&2
	if [ $bws -gt 0 -a -f "sketch.$bws" ]; then
	    cat sketch.$1 >> sketch.$bws
	    mv sketch.$bws sketch.$1
	fi
    fi
    bws=$1
}

function write_sketch() {
    if [ $conc -ne 0 ]; then
	if [ $bws -gt 0 -a $bws -ne $1 ]; then
	    mv sketch.$bws sketch.$1
	fi
    elif [ $subst -ne 0 -a $bws -gt 0 ]; then
	inspect -s $bws -o "sketch.$1" $srcdev 1>&2
    fi
    bws=0
}

bws=0
if read b c t f s; then
    save_sketch $b $s
    bp=$b cp=$c tp=$t op="$f $s"
    ts=$t
    while read b c t f s; do
	if time_after $t "$tp + $ci" || time_after $t "$ts + $cs"; then
	    write_sketch $bp
	    echo $bp $cp $tp $op
	    ts=$t
	fi
	save_sketch $b $s
	bp=$b cp=$c tp=$t op="$f $s"
    done
    write_sketch $bp
    echo $bp $cp $tp $op
fi


