/*
 * Copyright (c) 2003-2004 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: ugly_gtk2utils.c,v 1.13 2004/04/07 19:22:21 fuyu Exp $
 */

#include "config.h"

#include "ochusha_private.h"
#include "ochusha_ui.h"

#include "ugly_gtk2utils.h"

#include <glib.h>
#include <gtk/gtk.h>

#include <stdio.h>


static gboolean
delayed_g_object_unref_real(gpointer data)
{
#if DEBUG_REF_COUNT
  GtkWidget *child;
#endif
  g_return_val_if_fail(G_IS_OBJECT(data), FALSE);
#if DEBUG_GUI
  fprintf(stderr, "delayed_g_object_unref_real: data=%p data->ref_count=%d\n",
	  data, G_OBJECT(data)->ref_count);
#endif
  if (((GObject *)data)->ref_count > 1)
    {
#if DEBUG_REF_COUNT
      fprintf(stderr, "delayed_g_object_unref_real: data=%p is still alive\n",
	      data);
#endif
      return TRUE;
    }

#if DEBUG_REF_COUNT
  if (GTK_IS_BIN(data))
    {
      child = gtk_bin_get_child(GTK_BIN(data));
      fprintf(stderr, "delayed_g_object_unref_real: child(%p)->ref_count=%d\n",
	      child, G_OBJECT(child)->ref_count);
    }
  else
    child = NULL;
#endif

  /* OCHU_THREADS_ENTER(); */
  gdk_threads_enter();

  OCHU_OBJECT_UNREF(data);

  gdk_threads_leave();
  /* OCHU_THREADS_LEAVE(); */

#if DEBUG_REF_COUNT
  if (child != NULL)
    {
      fprintf(stderr, "delayed_g_object_unref_real: child(%p)->ref_count=%d\n",
	      child, ((GObject *)child)->ref_count);
    }
#endif

#if DEBUG_GUI
  fprintf(stderr, "delayed_g_object_unref_real:  data=%p data->ref_count=%d\n",
	  data, ((GObject *)data)->ref_count);
#endif
  return FALSE;
}


/*
 * GtkTreeViewGtkTextFiewʤGTK+ǡidleؿϿƤ륦
 * åȤξ硢idleؿƤ֤˥åȤ
 * GTK+롣кΤᡢΥץ饤ƥϿ
 * idleؿưޤǥ֥ȤƤȤǡ
 * ʲǽʸ¤˲򤹤롣
 */
void
delayed_g_object_unref(GObject *object)
{
  g_return_if_fail(G_IS_OBJECT(object));

  g_idle_add_full(G_PRIORITY_LOW, delayed_g_object_unref_real, object, NULL);
}


#if GTK_MINOR_VERSION > 2
/*
 * GTK+-2.4ǤGtkItemFactorydeprecateƤޤä
 * GtkUIManagerѤAPIǤϥݥåץåץ˥塼ɽΤ
 * ݤˤʤäƤ롣
 * ʤΤǡgtk_item_factory_popup_with_dataؿȤ
 */
static GQuark popup_menu_target_id;
static GQuark popup_menu_position_id;


typedef struct _MenuPos
{
  guint x;
  guint y;
} MenuPos;


static void
popup_menu_pos(GtkMenu *menu, gint *x, gint *y, gboolean *unused,
		      gpointer data)
{
  MenuPos *mpos = data;
  *x = mpos->x;
  *y = mpos->y;
}


static void
popup_delete_data(GObject *object, GtkUIManager *manager)
{
  g_signal_handlers_disconnect_by_func(object,
				       popup_delete_data,
				       manager);
  g_object_set_qdata(G_OBJECT(manager), popup_menu_target_id, NULL);
}


void
ochusha_ui_manager_popup_with_data(GtkUIManager *ui_manager,
				   const char *menu_path,
				   gpointer popup_data,
				   GtkDestroyNotify destroy,
				   guint x, guint y, guint button,
				   guint32 event_time)
{
  static gboolean initialized = FALSE;
  GtkWidget *tmp_widget;
  GtkMenu *menu;
  MenuPos *mpos;

  if (!initialized)
    {
      popup_menu_target_id
	= g_quark_from_static_string("UglyGTK2Utils::PopupMenuTarget");
      popup_menu_position_id
	= g_quark_from_static_string("UglyGTK2Utils::PopupMenuPosition");
      
      initialized = TRUE;
    }

  tmp_widget = gtk_ui_manager_get_widget(ui_manager, menu_path);
  g_return_if_fail(GTK_IS_MENU(tmp_widget));

  menu = GTK_MENU(tmp_widget);
  mpos = g_object_get_qdata(G_OBJECT(menu), popup_menu_position_id);

  if (mpos == NULL)
    {
      mpos = g_new0(MenuPos, 1);
      g_object_set_qdata_full(G_OBJECT(menu), popup_menu_position_id,
			      mpos, g_free);
    }

  mpos->x = x;
  mpos->y = y;

  g_object_set_qdata_full(G_OBJECT(ui_manager), popup_menu_target_id,
			  popup_data, destroy);
  g_signal_connect(G_OBJECT(menu), "selection-done",
		   G_CALLBACK(popup_delete_data), ui_manager);
  gtk_menu_popup(menu, NULL, NULL, popup_menu_pos, mpos, button, event_time);
}


gpointer
ochusha_ui_manager_get_popup_data(GtkUIManager *ui_manager)
{
  return g_object_get_qdata(G_OBJECT(ui_manager), popup_menu_target_id);
}
				   

#endif
