/*****************************************************************

Copyright (c) 2001 Matthias Elter <elter@kde.org>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <kiconloader.h>
#include <klocale.h>
#include <kglobal.h>
#include <kdebug.h>

#include "pluginmanager.h"
#include "panelbutton.h"
#include "containerarea.h"
#include "container_base.h"
#include "container_button.h"

#include "panelmenuiteminfo.h"
#include "removespecialbutton_mnu.h"
#include "removespecialbutton_mnu.moc"

PanelRemoveSpecialButtonMenu::PanelRemoveSpecialButtonMenu(ContainerArea *cArea,
                                                           QWidget *parent,
                                                           const char *name)
    : QPopupMenu(parent, name),
      m_containerArea(cArea)
{
    connect( this, SIGNAL( activated( int ) ), SLOT( slotExec( int ) ) );
    connect( this, SIGNAL( aboutToShow() ), SLOT( slotAboutToShow() ) );

    m_containers.setAutoDelete( false );
}

void PanelRemoveSpecialButtonMenu::slotAboutToShow()
{
    int id = 0;

    clear();
    m_containers.clear();
    m_containers = m_containerArea->containers("Special Button");
    QValueList<PanelMenuItemInfo> items;

    for (QPtrListIterator<BaseContainer> it(m_containers); it.current() ; ++it)
    {
        if ((*it)->isImmutable())
        {
            continue;
        }

        items.append(PanelMenuItemInfo((*it)->icon(), (*it)->visibleName(), id ));
        id++;
    }

    qHeapSort(items);
    QValueList<PanelMenuItemInfo>::iterator it = items.begin();
    for (; it != items.end(); ++it)
    {
        (*it).plug(this);
    }

    if (m_containers.count() > 1)
    {
        insertSeparator();
        insertItem(i18n("All"), this, SLOT(slotRemoveAll()));
    }
}

void PanelRemoveSpecialButtonMenu::slotExec( int id )
{
    if (m_containers.at(id))
    {
        m_containerArea->removeContainer(m_containers.at(id));
    }
}

PanelRemoveSpecialButtonMenu::~PanelRemoveSpecialButtonMenu()
{
}

void PanelRemoveSpecialButtonMenu::slotRemoveAll()
{
    for (QPtrListIterator<BaseContainer> it(m_containers); it.current() ; ++it)
    {
        m_containerArea->removeContainer(it.current());
    }
}
