/*****************************************************************

Copyright (c) 2001 Matthias Elter <elter@kde.org>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <klocale.h>
#include <kglobal.h>
#include <kdebug.h>

#include "addcontainer_mnu.h"
#include "addcontainer_mnu.moc"

#include "addapplet_mnu.h"
#include "addbutton_mnu.h"
#include "addextension_mnu.h"
#include "addspecialbutton_mnu.h"
#include "pluginmanager.h"

AddContainerMenu::AddContainerMenu(ContainerArea* containerArea, bool showExtensions,
                                   QWidget *parent, const char *name)
    : QPopupMenu(parent, name),
      m_appletId(-1),
      m_extensionId(-1),
      m_buttonId(-1),
      m_specialId(-1)
{
    m_appletId = insertItem(i18n("&Applet"),
                            new PanelAddAppletMenu(containerArea, this));
    m_buttonId = insertItem(i18n("Appli&cation"),
                            new PanelAddButtonMenu(containerArea, this));

    if (showExtensions)
    {
        m_extensionId = insertItem(i18n("&Panel"),
                                   new PanelAddExtensionMenu(this));
    }

    m_specialId = insertItem(i18n("&Special Button"),
                             new PanelAddSpecialButtonMenu(containerArea,
                                                           this));
    adjustSize();

    connect(this, SIGNAL(aboutToShow()), SLOT(slotAboutToShow()));
}

AddContainerMenu::~AddContainerMenu()
{

}

void AddContainerMenu::slotAboutToShow()
{
    setItemEnabled(m_appletId, PluginManager::applets().count() > 0);
    setItemEnabled(m_extensionId, PluginManager::extensions().count() > 0);
}

