/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: minisurf.h,v 1.8.4.1 2004/07/09 01:58:56 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _MINISURF_H_
#define _MINISURF_H_

#include "hxvsurf.h"
#include "minifmt.h"
#include "baseobj.h"
#include "hxcolor.h"


class CMiniBaseSite;


class CMiniBaseSurface : public IHXVideoSurface,
                         public CHXBaseCountingObject

{
public:
    // Creation...
    static CMiniBaseSurface* Create(IUnknown* pContext, CMiniBaseSite* pSite);

    // IUnknown methods
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, void** ppvObj);
    STDMETHOD_(ULONG32,AddRef)(THIS);
    STDMETHOD_(ULONG32,Release)(THIS);

    // IHXVideoSurface methods usually called by renderers to Draw on
    // the surface
    STDMETHOD(BeginOptimizedBlt)(THIS_ HXBitmapInfoHeader* pBitmapInfo);
    
    STDMETHOD(Blt)(THIS_
                   UCHAR*               pImageData,
                   HXBitmapInfoHeader* pBitmapInfo,
                   REF(HXxRect)         rDestRect,
                   REF(HXxRect)         rSrcRect);
    
    STDMETHOD(OptimizedBlt)     (THIS_
                                 UCHAR*      pImageBits,
                                 REF(HXxRect) rDestRect,
                                 REF(HXxRect) rSrcRect);

    STDMETHOD(EndOptimizedBlt)  (THIS);
    STDMETHOD(GetOptimizedFormat)(THIS_ REF(HX_COMPRESSION_TYPE) /*OUT*/ ulType);
    STDMETHOD(GetPreferredFormat)(THIS_ REF(HX_COMPRESSION_TYPE) /*OUT*/ ulType);

    // Virtual Functions which must me implemented by each OS.
    virtual HX_RESULT   _CreateDestBuffer(int cidIn,
                                          int nWidth, int nHeight,
                                          int& nCount) = 0; 

    virtual HX_RESULT   _LockDestBuffer(UCHAR** ppDestPtr,
                                        LONG32* pnDestPitch,
                                        int& cid,
                                        REF(HXxSize) dstSize,
                                        int nIndex=0) = 0;

    virtual HX_RESULT   _TransferToDestBuffer(UCHAR* pSrcBuffer,
                                              HXBitmapInfoHeader* pBitmapInfo,
                                              HXxRect* prSrcRect,
                                              HXxRect* prDstRect,
                                              UCHAR* pDstBuffer,
                                              LONG32 nDstPitch);
    
    virtual HX_RESULT   _UnlockDestBuffer(UCHAR* pSurfPtr, int nIndex=0) = 0;
    
    virtual HX_RESULT   _RenderDestBuffer(HXxRect* prSrcRect,
                                          HXxRect* prDstRect,
                                          int nIndex=0) = 0;

    virtual HX_RESULT   _DestroyDestBuffer(int cid, int nCount=1) = 0; 

    
protected:

    //A method called from Blt() to give the devices a chance to keep
    //their screen from going into power saving mode or to keep a
    //screen saver from firing. This is called each Blt() so it is up
    //to the platform specific code to only do the minimal work
    //needed.
    virtual void _KeepScreenAlive() {};
    
    CMiniBaseSurface(IUnknown* pContext, CMiniBaseSite* pSite);
    virtual ~CMiniBaseSurface();
    PRIVATE_DESTRUCTORS_ARE_NOT_A_CRIME

    virtual int             GetDstCID(int nIndex=0)=0;
    virtual BOOL            ScaleDuringRender(int nCID);

    HX_RESULT               AllocateDestBuffers(int nWidth,
                                                int nHeight,
                                                int nCount=1);

    HX_RESULT               DestroyDestBuffers(int nCount);

    LONG32                  m_lRefCount;
    IUnknown*               m_pContext;

    CMiniBaseSite*          m_pSite;
    HXBitmapInfoHeader*     m_pOptimizedFormat;
    int                     m_nSrcCID;
    int                     m_nSrcPitch;

#if defined(HELIX_CONFIG_NOSTATICS)    
    LPHXCOLORCONVERTERNOSTATIC m_fpColorConverter;
    virtual color_data_t*   GetColorData() = 0;
#else
    LPHXCOLORCONVERTER      m_fpColorConverter;
#endif
    int                     m_nDstBuffers;
    HXxSize                 m_dstBufSize;

    CFmtObj*                m_pImageHelper;
};

#endif //_MINISURF_H_
