/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: xutils.cpp,v 1.9.2.3 2004/07/09 01:48:55 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "winutils.h"

#include <string.h>

#include <gdk/gdkx.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>

static void
wmspec_change_state (gboolean   add,
                     GdkWindow *window,
                     GdkAtom    state)
{
    // Freedesktop.org
#define _NET_WM_STATE_REMOVE    0
#define _NET_WM_STATE_ADD       1
#define _NET_WM_STATE_TOGGLE    2

    XEvent xev;

    xev.xclient.type = ClientMessage;
    xev.xclient.serial = 0;
    xev.xclient.send_event = True;
    xev.xclient.display = GDK_DISPLAY();
    xev.xclient.window = GDK_WINDOW_XID(window);
    xev.xclient.message_type = gdk_x11_get_xatom_by_name ("_NET_WM_STATE");
    xev.xclient.format = 32;
    xev.xclient.data.l[0] = add ? _NET_WM_STATE_ADD : _NET_WM_STATE_REMOVE;
    xev.xclient.data.l[1] = gdk_x11_atom_to_xatom (state);
    xev.xclient.data.l[2] = 0;

    XSendEvent(GDK_DISPLAY(), GDK_ROOT_WINDOW(), False,
	       SubstructureNotifyMask, (XEvent *) &xev);
}

/* fullscreen support */
void winutils_screen_get_size(GdkWindow* window, gint* width, gint* height)
{
//     The following code is for gtk2.2:
    
//     GdkScreen *screen;
//     gint monitor;
//     GdkRectangle rect;
	    
//     screen = gdk_screen_get_default();
//     monitor = gdk_screen_get_monitor_at_window(screen, window);
	    
//     gdk_screen_get_monitor_geometry(screen, monitor, &rect);

//     *width = rect.width;
//     *height = rect.height;


    *width = DisplayWidth(GDK_DISPLAY(), gdk_x11_get_default_screen ());
    *height = DisplayHeight(GDK_DISPLAY(), gdk_x11_get_default_screen ());
    (void)window;
}

void
winutils_window_fullscreen(GtkWindow* window,
                           gboolean*  used_net_wm)
{
    GdkAtom fullscreen_atom;
    *used_net_wm = FALSE;
    
    fullscreen_atom = gdk_atom_intern("_NET_WM_STATE_FULLSCREEN",
                                      FALSE);
    
    if(gdk_net_wm_supports(fullscreen_atom))
    {
        /* Use freedesktop.org to fullscreen us */

        // This is a gtk2.2 function
        // gtk_window_fullscreen (window);

        wmspec_change_state (TRUE,
                             GTK_WIDGET(window)->window,
                             fullscreen_atom);

        *used_net_wm = TRUE;
    }
    else
    {
        gint old_width, old_height;
        gint old_x,     old_y;
        gint new_width, new_height;
        gint root_origin_x, root_origin_y;
        gint origin_x, origin_y;

        /* The orign code here gives us the dimensions of our window decorations */
        gdk_window_get_root_origin(GTK_WIDGET(window)->window, &root_origin_x, &root_origin_y);
        gdk_window_get_origin(GTK_WIDGET(window)->window, &origin_x, &origin_y);

        winutils_screen_get_size(GTK_WIDGET(window)->window, &new_width, &new_height);
        gtk_window_get_size(window, &old_width, &old_height);
        gtk_window_get_position(window, &old_x, &old_y);
        
        g_object_set_data(G_OBJECT(window), "old_x", (gpointer)old_x);
        g_object_set_data(G_OBJECT(window), "old_y", (gpointer)old_y);
        g_object_set_data(G_OBJECT(window), "old_width",  (gpointer)old_width);
        g_object_set_data(G_OBJECT(window), "old_height", (gpointer)old_height);

        gtk_window_move(window, root_origin_x - origin_x, root_origin_y - origin_y);
        gtk_window_resize(window, new_width, new_height);
    }
}

void
winutils_window_unfullscreen(GtkWindow* window,
                             gboolean*  used_net_wm)
{
    GdkAtom fullscreen_atom;
    *used_net_wm = FALSE;

    fullscreen_atom = gdk_atom_intern("_NET_WM_STATE_FULLSCREEN",
                                      FALSE);

    if(gdk_net_wm_supports(fullscreen_atom))
    {
        /* Use freedesktop.org to unfullscreen us */

        // This is a gtk2.2 function
        // gtk_window_unfullscreen (GTK_WINDOW(window));
    
        wmspec_change_state (FALSE,
                             GTK_WIDGET(window)->window,
                             fullscreen_atom);    
        *used_net_wm = TRUE;
    }
    else
    {
        /* No freedesktop.org support. Resize manually */
        gint new_width, new_height;
        gint new_x, new_y;
        
        new_x      = (gint)g_object_get_data(G_OBJECT(window), "old_x");
        new_y      = (gint)g_object_get_data(G_OBJECT(window), "old_y");
        new_width  = (gint)g_object_get_data(G_OBJECT(window), "old_width");
        new_height = (gint)g_object_get_data(G_OBJECT(window), "old_height");

        if(new_width > 0 && new_height > 0)
        {
            gtk_window_resize(window, new_width, new_height);
            gtk_window_move(window, new_x, new_y);
        }
    }
}

/* Always on top support */
void
winutils_window_on_top(GtkWindow* window,
                       gboolean   on_top,
                       gboolean*  used_net_wm)
{
    // XXXRGG: Get rid of this when we move to gtk-2.2+ (set_above)
    // Hints for older WM's
#define WIN_LAYER_DESKTOP     0
#define WIN_LAYER_BELOW       2
#define WIN_LAYER_NORMAL      4
#define WIN_LAYER_ONTOP       6
#define WIN_LAYER_DOCK	      8
#define WIN_LAYER_ABOVE_DOCK  10

    XEvent xev;
    GdkWindow* win;
    GdkAtom above_atom;
    GdkAtom stays_on_top_atom;

    *used_net_wm = FALSE;
    
    win = GTK_WIDGET(window)->window;

    above_atom = gdk_atom_intern("_NET_WM_STATE_ABOVE", FALSE);
    stays_on_top_atom = gdk_atom_intern("_NET_WM_STATE_STAYS_ON_TOP", FALSE);
    
    if(gdk_net_wm_supports(above_atom))
    {
        // The new way
        // http://www.freedesktop.org/standards/wm-spec/1.2-html/ar01s05.html
        wmspec_change_state(on_top,
                            win,
                            above_atom);

        *used_net_wm = TRUE;
    }
    else if(gdk_net_wm_supports(stays_on_top_atom))
    {
        // Some versions of kde did it this way.
        // This can eventually be removed.
        wmspec_change_state(on_top,
                            win,
                            stays_on_top_atom);

        *used_net_wm = TRUE;
    }   
    else
    { 
        // The old way, for non-freedesktop.org WM's
        memset(&xev, sizeof(xev), 0);

        xev.type = ClientMessage;
        xev.xclient.type = ClientMessage;
        xev.xclient.window = GDK_WINDOW_XWINDOW(win);
        xev.xclient.message_type = gdk_x11_get_xatom_by_name("_WIN_LAYER");
        xev.xclient.format = 32;
        xev.xclient.data.l[0] = (on_top)? WIN_LAYER_ONTOP: WIN_LAYER_NORMAL;
                                        
        XSendEvent(GDK_DISPLAY(), GDK_ROOT_WINDOW(), False,
                   SubstructureNotifyMask, (XEvent *) & xev);

        gdk_window_raise(win);
        gtk_window_set_decorated(GTK_WINDOW(window), FALSE);
    }
}

/* screensaver support */
static struct {
    gboolean enabled;
    int timeout;
    int interval;
    int prefer_blanking;
    int allow_exposures;
} g_screensaver;

void
winutils_screensaver_init(void)
{
    memset(&g_screensaver, 0, sizeof(g_screensaver));

    g_screensaver.enabled = TRUE;
}

gboolean
winutils_screensaver_is_enabled(void)
{
    return g_screensaver.enabled;
}

void
winutils_screensaver_enable(void)
{
    if(!g_screensaver.enabled)
    {
	XSetScreenSaver (GDK_DISPLAY(),
			 g_screensaver.timeout,
			 g_screensaver.interval,
			 g_screensaver.prefer_blanking,
			 g_screensaver.allow_exposures);

        g_screensaver.enabled = TRUE;
    } 
}

void
winutils_screensaver_disable(void)
{
    if(g_screensaver.enabled)
    {
	XGetScreenSaver(GDK_DISPLAY(),
			&g_screensaver.timeout,
                        &g_screensaver.interval,
                        &g_screensaver.prefer_blanking,
                        &g_screensaver.allow_exposures);

	XSetScreenSaver(GDK_DISPLAY(),
			0,
			0,
                        DontPreferBlanking,
			DontAllowExposures);

        g_screensaver.enabled = FALSE;
    }    
}
