/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: minisite.h,v 1.9.4.4 2004/07/09 01:58:56 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _MINISITE_H_
#define _MINISITE_H_

#include "hxcom.h"
#include "hxtypes.h"
#include "hxwintyp.h"
#include "hxwin.h"
#include "hxsite2.h"
#include "hxevent.h"
#include "hxccf.h"
#include "chxpckts.h"
#include "hxslist.h"
#include "baseobj.h"

#ifdef HELIX_FEATURE_SMIL_SITE
#include "region.h"
#endif

#include "hxengin.h"

/****************************************************************************
 * 
 *  Class:
 *
 *      NonDelegatingUnknown
 *
 *  Purpose:
 *
 *      Same signature as IUnknown, allows an object to implement 
 *      aggregation.
 *
 */
class CHXHeader;
class CMiniBaseSurface;


class CMiniBaseSite : public IHXSite,
#if defined (HELIX_FEATURE_SMIL_SITE)                      
                      public IHXSite2,
                      public IHXCallback,
                      public IHXSiteControl,
#endif //HELIX_FEATURE_SMIL_SITE
                      public IHXSiteWindowed,
                      public CHXBaseCountingObject
{
public:
    static CMiniBaseSite* CreateSite(IUnknown* pContext,
                                     IUnknown* pUnkOuter = NULL,
                                     INT32 lZorder = 0);


    /*
     * IUnknown
     */
    STDMETHOD(QueryInterface) (THIS_ REFIID riid, void** ppvObj);
    STDMETHOD_(ULONG32,AddRef) (THIS);
    STDMETHOD_(ULONG32,Release) (THIS);

    /*
     * IHXSiteWindowed
     */

    STDMETHOD(AttachWindow) (THIS_ HXxWindow* /*IN*/ pWindow);
    STDMETHOD(DetachWindow) (THIS);
    STDMETHOD(Create) (THIS_ void* ParentWindow, UINT32 style);
    STDMETHOD(Destroy) (THIS);
    STDMETHOD_(HXxWindow*,GetWindow)(THIS);

    /*
     * IHXSite methods
     */

    STDMETHOD(AttachUser) (THIS_ IHXSiteUser*   /*IN*/  pUser);
    STDMETHOD(DetachUser) (THIS);
    STDMETHOD(GetUser) (THIS_ REF(IHXSiteUser*) /*OUT*/ pUser);
    STDMETHOD(CreateChild) (THIS_ REF(IHXSite*)  /*OUT*/ pChildSite);
    STDMETHOD(DestroyChild) (THIS_ IHXSite*       /*IN*/  pChildSite);
    STDMETHOD(AttachWatcher) (THIS_ IHXSiteWatcher* /*IN*/ pWatcher);
    STDMETHOD(DetachWatcher) (THIS);
    STDMETHOD(SetPosition) (THIS_ HXxPoint position);
    STDMETHOD(GetPosition) (THIS_ REF(HXxPoint) position);
    STDMETHOD(SetSize) (THIS_ HXxSize size);
    STDMETHOD(GetSize) (THIS_ REF(HXxSize) size);
    STDMETHOD(DamageRect) (THIS_ HXxRect rect);
    STDMETHOD(DamageRegion) (THIS_ HXxRegion region);
    STDMETHOD(ForceRedraw) (THIS);


#if defined (HELIX_FEATURE_SMIL_SITE)

    /*
     * IHXSiteControl
     */
    STDMETHOD(ForceRedrawAll) (THIS_ );


    /*
     * IHXSite2 methods
     */
    STDMETHOD(UpdateSiteWindow) (THIS_ HXxWindow* /*IN*/ pWindow);
    STDMETHOD(ShowSite) (THIS_ BOOL    bShow);
    STDMETHOD_(BOOL, IsSiteVisible) (THIS);
    STDMETHOD(MoveSiteToTop) (THIS);
    STDMETHOD(GetVideoSurface) (THIS_ REF(IHXVideoSurface*) pSurface);
    STDMETHOD(AddPassiveSiteWatcher) (THIS_ IHXPassiveSiteWatcher* pWatcher);
    STDMETHOD(RemovePassiveSiteWatcher) (THIS_ IHXPassiveSiteWatcher* pWatcher);
    STDMETHOD(SetCursor) (THIS_ HXxCursor cursor, REF(HXxCursor) oldCursor);


    inline void SetTopLevelSite(CMiniBaseSite* pTop)
    {
        m_pTopLevelSite = pTop;
    }
    inline void SetOrigin(HXxPoint* pOrigin)
    {
        memcpy(&m_topleft, pOrigin, sizeof(HXxPoint));  /* Flawfinder: ignore */
    }
    inline HXxPoint* GetOrigin()
    {
        return &m_topleft;
    }
    inline void SetParentSite(CMiniBaseSite* pParent)
    {
        m_pParentSite = pParent;
    }
    inline void SetParentWindow(HXxWindow* pWindow)
    {
        memcpy(&m_TopLevelWindow, pWindow, sizeof(HXxWindow) );  /* Flawfinder: ignore */
    }
    inline STDMETHOD_(UINT32,GetNumberOfChildSites) (THIS)
    {
        return (UINT32)m_ChildrenInZOrder.GetCount();
    }
    inline void SetInternalZOrder(INT32 lZOrder)
    {
        m_lZOrder = lZOrder;
    }
    inline HXREGION* GetRegion()
    {
        return m_Region;
    }
    

    inline STDMETHOD(GetZOrder)(THIS_ REF(INT32) lZOrder )
    {
        lZOrder = m_lZOrder;
        return HXR_OK;
    }
    STDMETHOD(SetZOrder) (THIS_ INT32 lZOrder);

#endif //HELIX_FEATURE_SMIL_SITE
    
    /*
     * Internal methods
     */

    CMiniBaseSite(IUnknown* pContext,
                  IUnknown* pUnkOuter = NULL,
                  INT32 lZorder = 0);
    
    virtual ~CMiniBaseSite();

protected:

    BOOL _CheckForVisibleChild();

#ifdef HELIX_FEATURE_SMIL_SITE
    typedef enum _callback_type
    {
        REPAINT    = 1<<0,
        CLIP       = 1<<1,
        MOUSE      = 1<<2,  
        REDRAW_ALL = 1<<3,
        MOVE       = 1<<4
    } CALLBACK_TYPE;
    
    void BuildParnetClipping( HXREGION* hClip, CMiniBaseSite* pChild );
    void UpdateZOrder( CMiniBaseSite* pUpdatedChildSite, INT32 lNewZOrder);
    void RecomputeClip();
    BOOL ComputeSubRects();
    void ScheduleCallback( CALLBACK_TYPE  nWhichCallback,
                           INT32 nMilliseconds );
    void _ForceRedrawAll();
    STDMETHOD(Func)(THIS_ void);
    void ResetOrigin();
    void GetAbsoluteCords(REF(HXxPoint) point);

#endif
    
    /*
     *  OS Specific Functions
     */

    virtual void*       _Create(void* ParentWindow, UINT32 style) = 0;
    virtual void        _Destroy(HXxWindow* pWindow) = 0;
    virtual void        _SetSize(HXxSize size) = 0;
    virtual void        _ChildCreated(void) {};
    virtual void        _SetPosition(HXxPoint position) = 0;

    //Give the platforms a chance to do OS specific setup.
    virtual void        _AttachWindow(){};
    virtual void        _DetachWindow(){};

    //This returns the OS specific window handle, as void*, that the
    //pointer is currently in.
    virtual BOOL        _MoveWindow(void* ,
                                    INT32 X, INT32 Y,
                                    INT32 nWidth, INT32 nHeight,
                                    BOOL bRepaint) = 0;
    
    IUnknown*                   m_pContext;
    IHXCommonClassFactory*      m_pCCF;
    IHXSiteUser*                m_pUser;
    IHXSiteWatcher*             m_pWatcher;
    IHXValues*                  m_pValues;
    CMiniBaseSurface*           m_pVideoSurface;

    HXxWindow*                  m_pWindow;
    HXxSize                     m_size;
    HXxPoint                    m_position;

    LONG32                      m_lRefCount;
    INT32                       m_lZOrder;

    

#if defined (HELIX_FEATURE_SMIL_SITE)    
    CMiniBaseSite* m_pTopLevelSite;
    CHXSimpleList  m_ChildrenInZOrder;
    HXxPoint       m_topleft;
    CMiniBaseSite* m_pParentSite;
    HXxWindow      m_TopLevelWindow;
    HXREGION*      m_Region;
    HXREGION*      m_RegionWithoutChildren;
    BOOL           m_bIsVisible;
    CallbackHandle m_CallbackHandle;
    IHXScheduler*  m_pScheduler;
    UINT32         m_bfCallBacks;
    UINT32         m_ulCallbackTime;

    CHXSimpleList  m_PassiveSiteWatchers;
#endif
    BOOL m_bWindowCreatedByCreate;

};

#endif //_MINISITE_H_

