/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: HXErrorCodeStrings.c,v 1.4.2.3 2004/07/09 01:49:47 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "HXErrorCodeStrings.h"

#include "enter_hx_headers.h"
#include "hxresult.h"
#include "exit_hx_headers.h"

typedef struct MapHXCodeToKeyRecord
{
	UINT32 ulHXCode;
	char* pKeyString;
} MapHXCodeToKeyRecord;

static MapHXCodeToKeyRecord const HXCodeToKeyMap[] =
{
	{ HXR_NOTIMPL, "HXR_NOTIMPL" }, // 80004001
	{ HXR_OUTOFMEMORY, "HXR_OUTOFMEMORY" }, // 8007000e
	{ HXR_INVALID_PARAMETER, "HXR_INVALID_PARAMETER" }, // 80070057
	{ HXR_NOINTERFACE, "HXR_NOINTERFACE" }, // 80004002
	{ HXR_POINTER, "HXR_POINTER" }, // 80004003
	{ HXR_HANDLE, "HXR_HANDLE" }, // 80070006
	{ HXR_ABORT, "HXR_ABORT" }, // 80004004
	{ HXR_FAIL, "HXR_FAIL" }, // 80004005
	{ HXR_ACCESSDENIED, "HXR_ACCESSDENIED" }, // 80070005
	{ HXR_IGNORE, "HXR_IGNORE" }, // 80000006

	{ HXR_INVALID_OPERATION, "HXR_INVALID_OPERATION" }, // 80040004
	{ HXR_INVALID_VERSION, "HXR_INVALID_VERSION" }, // 80040005
	{ HXR_INVALID_REVISION, "HXR_INVALID_REVISION" }, // 80040006
	{ HXR_NOT_INITIALIZED, "HXR_NOT_INITIALIZED" }, // 80040007
	{ HXR_DOC_MISSING, "HXR_DOC_MISSING" }, // 80040008
	{ HXR_UNEXPECTED, "HXR_UNEXPECTED" }, // 80040009
	{ HXR_INCOMPLETE, "HXR_INCOMPLETE" }, // 8004000c
	{ HXR_BUFFERTOOSMALL, "HXR_BUFFERTOOSMALL" }, // 8004000d
	{ HXR_UNSUPPORTED_VIDEO, "HXR_UNSUPPORTED_VIDEO" }, // 8004000e
	{ HXR_UNSUPPORTED_AUDIO, "HXR_UNSUPPORTED_AUDIO" }, // 8004000f
	{ HXR_INVALID_BANDWIDTH, "HXR_INVALID_BANDWIDTH" }, // 80040010
	{ HXR_NO_RENDERER, "HXR_NO_RENDERER" }, // 80040011
	{ HXR_NO_FILEFORMAT, "HXR_NO_FILEFORMAT" }, // 80040011
	{ HXR_MISSING_COMPONENTS, "HXR_MISSING_COMPONENTS" }, // 80040011
	{ HXR_ELEMENT_NOT_FOUND, "HXR_ELEMENT_NOT_FOUND" }, // 00040012
	{ HXR_NOCLASS, "HXR_NOCLASS" }, // 00040013
	{ HXR_CLASS_NOAGGREGATION, "HXR_CLASS_NOAGGREGATION" }, // 00040014
	{ HXR_NOT_LICENSED, "HXR_NOT_LICENSED" }, // 80040015
	{ HXR_NO_FILESYSTEM, "HXR_NO_FILESYSTEM" }, // 80040016
	{ HXR_REQUEST_UPGRADE, "HXR_REQUEST_UPGRADE" }, // 80040017

	{ HXR_CHECK_RIGHTS, "HXR_CHECK_RIGHTS" }, // 80040018
	{ HXR_RESTORE_SERVER_DENIED, "HXR_RESTORE_SERVER_DENIED" }, // 80040019
	{ HXR_DEBUGGER_DETECTED, "HXR_DEBUGGER_DETECTED" }, // 8004001a
	{ HXR_RESTORE_SERVER_CONNECT, "HXR_RESTORE_SERVER_CONNECT" }, // 8004005c
	{ HXR_RESTORE_SERVER_TIMEOUT, "HXR_RESTORE_SERVER_TIMEOUT" }, // 8004005d
	{ HXR_REVOKE_SERVER_CONNECT, "HXR_REVOKE_SERVER_CONNECT" }, // 8004005e
	{ HXR_REVOKE_SERVER_TIMEOUT, "HXR_REVOKE_SERVER_TIMEOUT" }, // 8004005f
	{ HXR_VIEW_RIGHTS_NODRM, "HXR_VIEW_RIGHTS_NODRM" }, // 800401cd
	{ HXR_VSRC_NODRM, "HXR_VSRC_NODRM" }, // 800401d3

	{ HXR_AWAITING_LICENSE, "HXR_AWAITING_LICENSE" }, // 8004001f
	{ HXR_ALREADY_INITIALIZED, "HXR_ALREADY_INITIALIZED" }, // 80040020
	{ HXR_NOT_SUPPORTED, "HXR_NOT_SUPPORTED" }, // 80040021
	{ HXR_S_FALSE, "HXR_S_FALSE" }, // 00040022
	{ PNR_WARNING, "PNR_WARNING" }, // 00040023

	{ HXR_BUFFERING, "HXR_BUFFERING" }, // 00040040
	{ HXR_PAUSED, "HXR_PAUSED" }, // 00040041
	{ HXR_NO_DATA, "HXR_NO_DATA" }, // 00040042
	{ HXR_STREAM_DONE, "HXR_STREAM_DONE" }, // 00040043
	{ HXR_NET_SOCKET_INVALID, "HXR_NET_SOCKET_INVALID" }, // 80040043
	{ HXR_NET_CONNECT, "HXR_NET_CONNECT" }, // 80040044
	{ HXR_BIND, "HXR_BIND" }, // 80040045
	{ HXR_SOCKET_CREATE, "HXR_SOCKET_CREATE" }, // 80040046
	{ HXR_INVALID_HOST, "HXR_INVALID_HOST" }, // 80040047
	{ HXR_NET_READ, "HXR_NET_READ" }, // 80040048
	{ HXR_NET_WRITE, "HXR_NET_WRITE" }, // 80040049
	{ HXR_NET_UDP, "HXR_NET_UDP" }, // 8004004a
	{ HXR_RETRY, "HXR_RETRY" }, // 8004004b
	{ HXR_SERVER_TIMEOUT, "HXR_SERVER_TIMEOUT" }, // 8004004c
	{ HXR_SERVER_DISCONNECTED, "HXR_SERVER_DISCONNECTED" }, // 8004004d
	{ HXR_WOULD_BLOCK, "HXR_WOULD_BLOCK" }, // 8004004e
	{ HXR_GENERAL_NONET, "HXR_GENERAL_NONET" }, // 8004004f
	{ HXR_BLOCK_CANCELED, "HXR_BLOCK_CANCELED" }, // 80040050
	{ HXR_MULTICAST_JOIN, "HXR_MULTICAST_JOIN" }, // 80040051
	{ HXR_GENERAL_MULTICAST, "HXR_GENERAL_MULTICAST" }, // 80040052
	{ HXR_MULTICAST_UDP, "HXR_MULTICAST_UDP" }, // 80040053
	{ HXR_AT_INTERRUPT, "HXR_AT_INTERRUPT" }, // 80040054
	{ HXR_MSG_TOOLARGE, "HXR_MSG_TOOLARGE" }, // 80040055
	{ HXR_NET_TCP, "HXR_NET_TCP" }, // 80040056
	{ HXR_TRY_AUTOCONFIG, "HXR_TRY_AUTOCONFIG" }, // 80040057
	{ HXR_NOTENOUGH_BANDWIDTH, "HXR_NOTENOUGH_BANDWIDTH" }, // 80040058
	{ HXR_HTTP_CONNECT, "HXR_HTTP_CONNECT" }, // 80040059
	{ HXR_PORT_IN_USE, "HXR_PORT_IN_USE" }, // 8004005a
	{ HXR_LOADTEST_NOT_SUPPORTED, "HXR_LOADTEST_NOT_SUPPORTED" }, // 8004005b
	{ HXR_TCP_CONNECT, "HXR_TCP_CONNECT" }, // 00040060
	{ HXR_TCP_RECONNECT, "HXR_TCP_RECONNECT" }, // 00040061
	{ HXR_TCP_FAILED, "HXR_TCP_FAILED" }, // 80040062
	{ HXR_AUTH_SOCKET_CREATE_FAILURE, "HXR_AUTH_SOCKET_CREATE_FAILURE" }, // 80040063
	{ HXR_AUTH_TCP_CONNECT_FAILURE, "HXR_AUTH_TCP_CONNECT_FAILURE" }, // 80040064
	{ HXR_AUTH_TCP_CONNECT_TIMEOUT, "HXR_AUTH_TCP_CONNECT_TIMEOUT" }, // 80040065
	{ HXR_AUTH_FAILURE, "HXR_AUTH_FAILURE" }, // 80040066
	{ HXR_AUTH_REQ_PARAMETER_MISSING, "HXR_AUTH_REQ_PARAMETER_MISSING" }, // 80040067
	{ HXR_DNS_RESOLVE_FAILURE, "HXR_DNS_RESOLVE_FAILURE" }, // 80040068
	{ HXR_AUTH_SUCCEEDED, "HXR_AUTH_SUCCEEDED" }, // 00040068
	{ HXR_PULL_AUTHENTICATION_FAILED, "HXR_PULL_AUTHENTICATION_FAILED" }, // 80040069
	{ HXR_BIND_ERROR, "HXR_BIND_ERROR" }, // 8004006a
	{ HXR_PULL_PING_TIMEOUT, "HXR_PULL_PING_TIMEOUT" }, // 8004006b
	{ HXR_AUTH_TCP_FAILED, "HXR_AUTH_TCP_FAILED" }, // 8004006c
	{ HXR_UNEXPECTED_STREAM_END, "HXR_UNEXPECTED_STREAM_END" }, // 8004006d
	{ HXR_AUTH_READ_TIMEOUT, "HXR_AUTH_READ_TIMEOUT" }, // 8004006e
	{ HXR_AUTH_CONNECTION_FAILURE, "HXR_AUTH_CONNECTION_FAILURE" }, // 8004006f
	{ HXR_BLOCKED, "HXR_BLOCKED" }, // 80040070
	{ HXR_NOTENOUGH_PREDECBUF, "HXR_NOTENOUGH_PREDECBUF" }, // 80040071

	{ HXR_AT_END, "HXR_AT_END" }, // 00040080
	{ HXR_INVALID_FILE, "HXR_INVALID_FILE" }, // 80040081
	{ HXR_INVALID_PATH, "HXR_INVALID_PATH" }, // 80040082
	{ HXR_RECORD, "HXR_RECORD" }, // 80040083
	{ HXR_RECORD_WRITE, "HXR_RECORD_WRITE" }, // 80040084
	{ HXR_TEMP_FILE, "HXR_TEMP_FILE" }, // 80040085
	{ HXR_ALREADY_OPEN, "HXR_ALREADY_OPEN" }, // 80040086
	{ HXR_SEEK_PENDING, "HXR_SEEK_PENDING" }, // 80040087
	{ HXR_CANCELLED, "HXR_CANCELLED" }, // 80040088
	{ HXR_FILE_NOT_FOUND, "HXR_FILE_NOT_FOUND" }, // 80040089
	{ HXR_WRITE_ERROR, "HXR_WRITE_ERROR" }, // 8004008a
	{ HXR_FILE_EXISTS, "HXR_FILE_EXISTS" }, // 8004008b
	{ HXR_FILE_NOT_OPEN, "HXR_FILE_NOT_OPEN" }, // 8004008c
	{ HXR_ADVISE_PREFER_LINEAR, "HXR_ADVISE_PREFER_LINEAR" }, // 0004008d
	{ HXR_PARSE_ERROR, "HXR_PARSE_ERROR" }, // 8004008e
	{ HXR_ADVISE_NOASYNC_SEEK, "HXR_ADVISE_NOASYNC_SEEK" }, // 0004008f
	{ HXR_HEADER_PARSE_ERROR, "HXR_HEADER_PARSE_ERROR" }, // 80040090
	{ HXR_CORRUPT_FILE		, "HXR_CORRUPT_FILE		" }, // 80040091

	{ HXR_BAD_SERVER, "HXR_BAD_SERVER" }, // 800400c0
	{ HXR_ADVANCED_SERVER, "HXR_ADVANCED_SERVER" }, // 800400c1
	{ HXR_OLD_SERVER, "HXR_OLD_SERVER" }, // 800400c2
	{ HXR_REDIRECTION, "HXR_REDIRECTION" }, // 000400c3
	{ HXR_SERVER_ALERT, "HXR_SERVER_ALERT" }, // 800400c4
	{ HXR_PROXY, "HXR_PROXY" }, // 800400c5
	{ HXR_PROXY_RESPONSE, "HXR_PROXY_RESPONSE" }, // 800400c6
	{ HXR_ADVANCED_PROXY, "HXR_ADVANCED_PROXY" }, // 800400c7
	{ HXR_OLD_PROXY, "HXR_OLD_PROXY" }, // 800400c8
	{ HXR_INVALID_PROTOCOL, "HXR_INVALID_PROTOCOL" }, // 800400c9
	{ HXR_INVALID_URL_OPTION, "HXR_INVALID_URL_OPTION" }, // 800400ca
	{ HXR_INVALID_URL_HOST, "HXR_INVALID_URL_HOST" }, // 800400cb
	{ HXR_INVALID_URL_PATH, "HXR_INVALID_URL_PATH" }, // 800400cc
	{ HXR_HTTP_CONTENT_NOT_FOUND, "HXR_HTTP_CONTENT_NOT_FOUND" }, // 800400cd
	{ HXR_NOT_AUTHORIZED, "HXR_NOT_AUTHORIZED" }, // 800400ce
	{ HXR_UNEXPECTED_MSG, "HXR_UNEXPECTED_MSG" }, // 800400cf
	{ HXR_BAD_TRANSPORT, "HXR_BAD_TRANSPORT" }, // 800400d0
	{ HXR_NO_SESSION_ID, "HXR_NO_SESSION_ID" }, // 800400d1
	{ HXR_PROXY_DNR, "HXR_PROXY_DNR" }, // 800400d2
	{ HXR_PROXY_NET_CONNECT, "HXR_PROXY_NET_CONNECT" }, // 800400d3
	{ HXR_AGGREGATE_OP_NOT_ALLOWED, "HXR_AGGREGATE_OP_NOT_ALLOWED" }, // 800400d4
	{ HXR_RIGHTS_EXPIRED, "HXR_RIGHTS_EXPIRED" }, // 800400d5
	{ HXR_NOT_MODIFIED, "HXR_NOT_MODIFIED" }, // 800400d6
	{ HXR_FORBIDDEN, "HXR_FORBIDDEN" }, // 800400d7

	{ HXR_AUDIO_DRIVER, "HXR_AUDIO_DRIVER" }, // 80040100
	{ HXR_LATE_PACKET, "HXR_LATE_PACKET" }, // 80040101
	{ HXR_OVERLAPPED_PACKET, "HXR_OVERLAPPED_PACKET" }, // 80040102
	{ HXR_OUTOFORDER_PACKET, "HXR_OUTOFORDER_PACKET" }, // 80040103
	{ HXR_NONCONTIGUOUS_PACKET, "HXR_NONCONTIGUOUS_PACKET" }, // 80040104

	{ HXR_OPEN_NOT_PROCESSED, "HXR_OPEN_NOT_PROCESSED" }, // 80040140
	{ HXR_WINDRAW_EXCEPTION, "HXR_WINDRAW_EXCEPTION" }, // 80040141

	{ HXR_EXPIRED, "HXR_EXPIRED" }, // 80040180

	{ HXR_INVALID_INTERLEAVER, "HXR_INVALID_INTERLEAVER" }, // 80040fc0
	{ HXR_BAD_FORMAT, "HXR_BAD_FORMAT" }, // 80040fc1
	{ HXR_CHUNK_MISSING, "HXR_CHUNK_MISSING" }, // 80040fc2
	{ HXR_INVALID_STREAM, "HXR_INVALID_STREAM" }, // 80040fc3
	{ HXR_DNR, "HXR_DNR" }, // 80040fc4
	{ HXR_OPEN_DRIVER, "HXR_OPEN_DRIVER" }, // 80040fc5
	{ HXR_UPGRADE, "HXR_UPGRADE" }, // 80040fc6
	{ HXR_NOTIFICATION, "HXR_NOTIFICATION" }, // 80040fc7
	{ HXR_NOT_NOTIFIED, "HXR_NOT_NOTIFIED" }, // 80040fc8
	{ HXR_STOPPED, "HXR_STOPPED" }, // 80040fc9
	{ HXR_CLOSED, "HXR_CLOSED" }, // 80040fca
	{ HXR_INVALID_WAV_FILE, "HXR_INVALID_WAV_FILE" }, // 80040fcb
	{ HXR_NO_SEEK, "HXR_NO_SEEK" }, // 80040fcc

	{ HXR_DEC_INITED, "HXR_DEC_INITED" }, // 80040200
	{ HXR_DEC_NOT_FOUND, "HXR_DEC_NOT_FOUND" }, // 80040201
	{ HXR_DEC_INVALID, "HXR_DEC_INVALID" }, // 80040202
	{ HXR_DEC_TYPE_MISMATCH, "HXR_DEC_TYPE_MISMATCH" }, // 80040203
	{ HXR_DEC_INIT_FAILED, "HXR_DEC_INIT_FAILED" }, // 80040204
	{ HXR_DEC_NOT_INITED, "HXR_DEC_NOT_INITED" }, // 80040205
	{ HXR_DEC_DECOMPRESS, "HXR_DEC_DECOMPRESS" }, // 80040206
	{ HXR_OBSOLETE_VERSION, "HXR_OBSOLETE_VERSION" }, // 80040207

	{ HXR_ENC_FILE_TOO_SMALL, "HXR_ENC_FILE_TOO_SMALL" }, // 80040240
	{ HXR_ENC_UNKNOWN_FILE, "HXR_ENC_UNKNOWN_FILE" }, // 80040241
	{ HXR_ENC_BAD_CHANNELS, "HXR_ENC_BAD_CHANNELS" }, // 80040242
	{ HXR_ENC_BAD_SAMPSIZE, "HXR_ENC_BAD_SAMPSIZE" }, // 80040243
	{ HXR_ENC_BAD_SAMPRATE, "HXR_ENC_BAD_SAMPRATE" }, // 80040244
	{ HXR_ENC_INVALID, "HXR_ENC_INVALID" }, // 80040245
	{ HXR_ENC_NO_OUTPUT_FILE, "HXR_ENC_NO_OUTPUT_FILE" }, // 80040246
	{ HXR_ENC_NO_INPUT_FILE, "HXR_ENC_NO_INPUT_FILE" }, // 80040247
	{ HXR_ENC_NO_OUTPUT_PERMISSIONS, "HXR_ENC_NO_OUTPUT_PERMISSIONS" }, // 80040248
	{ HXR_ENC_BAD_FILETYPE, "HXR_ENC_BAD_FILETYPE" }, // 80040249
	{ HXR_ENC_INVALID_VIDEO, "HXR_ENC_INVALID_VIDEO" }, // 8004024a
	{ HXR_ENC_INVALID_AUDIO, "HXR_ENC_INVALID_AUDIO" }, // 8004024b
	{ HXR_ENC_NO_VIDEO_CAPTURE, "HXR_ENC_NO_VIDEO_CAPTURE" }, // 8004024c
	{ HXR_ENC_INVALID_VIDEO_CAPTURE, "HXR_ENC_INVALID_VIDEO_CAPTURE" }, // 8004024d
	{ HXR_ENC_NO_AUDIO_CAPTURE, "HXR_ENC_NO_AUDIO_CAPTURE" }, // 8004024e
	{ HXR_ENC_INVALID_AUDIO_CAPTURE, "HXR_ENC_INVALID_AUDIO_CAPTURE" }, // 8004024f
	{ HXR_ENC_TOO_SLOW_FOR_LIVE, "HXR_ENC_TOO_SLOW_FOR_LIVE" }, // 80040250
	{ HXR_ENC_ENGINE_NOT_INITIALIZED, "HXR_ENC_ENGINE_NOT_INITIALIZED" }, // 80040251
	{ HXR_ENC_CODEC_NOT_FOUND, "HXR_ENC_CODEC_NOT_FOUND" }, // 80040252
	{ HXR_ENC_CODEC_NOT_INITIALIZED, "HXR_ENC_CODEC_NOT_INITIALIZED" }, // 80040253
	{ HXR_ENC_INVALID_INPUT_DIMENSIONS, "HXR_ENC_INVALID_INPUT_DIMENSIONS" }, // 80040254
	{ HXR_ENC_MESSAGE_IGNORED, "HXR_ENC_MESSAGE_IGNORED" }, // 80040255
	{ HXR_ENC_NO_SETTINGS, "HXR_ENC_NO_SETTINGS" }, // 80040256
	{ HXR_ENC_NO_OUTPUT_TYPES, "HXR_ENC_NO_OUTPUT_TYPES" }, // 80040257
	{ HXR_ENC_IMPROPER_STATE, "HXR_ENC_IMPROPER_STATE" }, // 80040258
	{ HXR_ENC_INVALID_SERVER, "HXR_ENC_INVALID_SERVER" }, // 80040259
	{ HXR_ENC_INVALID_TEMP_PATH, "HXR_ENC_INVALID_TEMP_PATH" }, // 8004025a
	{ HXR_ENC_MERGE_FAIL, "HXR_ENC_MERGE_FAIL" }, // 8004025b
	{ HXR_BIN_DATA_NOT_FOUND, "HXR_BIN_DATA_NOT_FOUND" }, // 0004025c
	{ HXR_BIN_END_OF_DATA, "HXR_BIN_END_OF_DATA" }, // 0004025d
	{ HXR_BIN_DATA_PURGED, "HXR_BIN_DATA_PURGED" }, // 8004025e
	{ HXR_BIN_FULL, "HXR_BIN_FULL" }, // 8004025f
	{ HXR_BIN_OFFSET_PAST_END, "HXR_BIN_OFFSET_PAST_END" }, // 80040260
	{ HXR_ENC_NO_ENCODED_DATA, "HXR_ENC_NO_ENCODED_DATA" }, // 80040261
	{ HXR_ENC_INVALID_DLL, "HXR_ENC_INVALID_DLL" }, // 80040262
	{ HXR_NOT_INDEXABLE, "HXR_NOT_INDEXABLE" }, // 80040263
	{ HXR_ENC_NO_BROWSER, "HXR_ENC_NO_BROWSER" }, // 80040264
	{ HXR_ENC_NO_FILE_TO_SERVER, "HXR_ENC_NO_FILE_TO_SERVER" }, // 80040265
	{ HXR_ENC_INSUFFICIENT_DISK_SPACE, "HXR_ENC_INSUFFICIENT_DISK_SPACE" }, // 80040266
	{ HXR_ENC_SAMPLE_DISCARDED, "HXR_ENC_SAMPLE_DISCARDED" }, // 00040267
	{ HXR_ENC_RV10_FRAME_TOO_LARGE, "HXR_ENC_RV10_FRAME_TOO_LARGE" }, // 80040268
	{ HXR_S_NOT_HANDLED, "HXR_S_NOT_HANDLED" }, // 00040269
	{ HXR_S_END_OF_STREAM, "HXR_S_END_OF_STREAM" }, // 0004026a

	{ HXR_S_JOBFILE_INCOMPLETE, "HXR_S_JOBFILE_INCOMPLETE" }, // 
	{ HXR_S_NOTHING_TO_SERIALIZE, "HXR_S_NOTHING_TO_SERIALIZE" }, // 
	{ HXR_SIZENOTSET, "HXR_SIZENOTSET" }, // 
	{ HXR_ALREADY_COMMITTED, "HXR_ALREADY_COMMITTED" }, // 
	{ HXR_BUFFERS_OUTSTANDING, "HXR_BUFFERS_OUTSTANDING" }, // 
	{ HXR_NOT_COMMITTED, "HXR_NOT_COMMITTED" }, // 
	{ HXR_SAMPLE_TIME_NOT_SET, "HXR_SAMPLE_TIME_NOT_SET" }, // 
	{ HXR_TIMEOUT, "HXR_TIMEOUT" }, // 
	{ HXR_WRONGSTATE, "HXR_WRONGSTATE" }, // 

	{ HXR_RMT_USAGE_ERROR, "HXR_RMT_USAGE_ERROR" }, // 800403c1
	{ HXR_RMT_INVALID_ENDTIME, "HXR_RMT_INVALID_ENDTIME" }, // 800403c2
	{ HXR_RMT_MISSING_INPUT_FILE, "HXR_RMT_MISSING_INPUT_FILE" }, // 800403c3
	{ HXR_RMT_MISSING_OUTPUT_FILE, "HXR_RMT_MISSING_OUTPUT_FILE" }, // 800403c4
	{ HXR_RMT_INPUT_EQUALS_OUTPUT_FILE, "HXR_RMT_INPUT_EQUALS_OUTPUT_FILE" }, // 800403c5
	{ HXR_RMT_UNSUPPORTED_AUDIO_VERSION, "HXR_RMT_UNSUPPORTED_AUDIO_VERSION" }, // 800403c6
	{ HXR_RMT_DIFFERENT_AUDIO, "HXR_RMT_DIFFERENT_AUDIO" }, // 800403c7
	{ HXR_RMT_DIFFERENT_VIDEO, "HXR_RMT_DIFFERENT_VIDEO" }, // 800403c8
	{ HXR_RMT_PASTE_MISSING_STREAM, "HXR_RMT_PASTE_MISSING_STREAM" }, // 800403c9
	{ HXR_RMT_END_OF_STREAM, "HXR_RMT_END_OF_STREAM" }, // 800403ca
	{ HXR_RMT_IMAGE_MAP_PARSE_ERROR, "HXR_RMT_IMAGE_MAP_PARSE_ERROR" }, // 800403cb
	{ HXR_RMT_INVALID_IMAGEMAP_FILE, "HXR_RMT_INVALID_IMAGEMAP_FILE" }, // 800403cc
	{ HXR_RMT_EVENT_PARSE_ERROR, "HXR_RMT_EVENT_PARSE_ERROR" }, // 800403cd
	{ HXR_RMT_INVALID_EVENT_FILE, "HXR_RMT_INVALID_EVENT_FILE" }, // 800403ce
	{ HXR_RMT_INVALID_OUTPUT_FILE, "HXR_RMT_INVALID_OUTPUT_FILE" }, // 800403cf
	{ HXR_RMT_INVALID_DURATION, "HXR_RMT_INVALID_DURATION" }, // 800403d0
	{ HXR_RMT_NO_DUMP_FILES, "HXR_RMT_NO_DUMP_FILES" }, // 800403d1
	{ HXR_RMT_NO_EVENT_DUMP_FILE, "HXR_RMT_NO_EVENT_DUMP_FILE" }, // 800403d2
	{ HXR_RMT_NO_IMAP_DUMP_FILE, "HXR_RMT_NO_IMAP_DUMP_FILE" }, // 800403d3
	{ HXR_RMT_NO_DATA, "HXR_RMT_NO_DATA" }, // 800403d4
	{ HXR_RMT_EMPTY_STREAM, "HXR_RMT_EMPTY_STREAM" }, // 800403d5
	{ HXR_RMT_READ_ONLY_FILE, "HXR_RMT_READ_ONLY_FILE" }, // 800403d6
	{ HXR_RMT_PASTE_MISSING_AUDIO_STREAM, "HXR_RMT_PASTE_MISSING_AUDIO_STREAM" }, // 800403d7
	{ HXR_RMT_PASTE_MISSING_VIDEO_STREAM, "HXR_RMT_PASTE_MISSING_VIDEO_STREAM" }, // 800403d8
	{ HXR_RMT_ENCRYPTED_CONTENT, "HXR_RMT_ENCRYPTED_CONTENT" }, // 800403d9

	{ HXR_PROP_NOT_FOUND, "HXR_PROP_NOT_FOUND" }, // 80040281
	{ HXR_PROP_NOT_COMPOSITE, "HXR_PROP_NOT_COMPOSITE" }, // 80040282
	{ HXR_PROP_DUPLICATE, "HXR_PROP_DUPLICATE" }, // 80040283
	{ HXR_PROP_TYPE_MISMATCH, "HXR_PROP_TYPE_MISMATCH" }, // 80040284
	{ HXR_PROP_ACTIVE, "HXR_PROP_ACTIVE" }, // 80040285
	{ HXR_PROP_INACTIVE, "HXR_PROP_INACTIVE" }, // 80040286
	{ HXR_PROP_VAL_UNDERFLOW, "HXR_PROP_VAL_UNDERFLOW" }, // 80040287
	{ HXR_PROP_VAL_OVERFLOW, "HXR_PROP_VAL_OVERFLOW" }, // 80040288
	{ HXR_PROP_VAL_LT_LBOUND, "HXR_PROP_VAL_LT_LBOUND" }, // 80040289
	{ HXR_PROP_VAL_GT_UBOUND, "HXR_PROP_VAL_GT_UBOUND" }, // 8004028a
	{ HXR_PROP_DELETE_PENDING, "HXR_PROP_DELETE_PENDING" }, // 0004028b

	{ HXR_COULDNOTINITCORE, "HXR_COULDNOTINITCORE" }, // 800401c1
	{ HXR_PERFECTPLAY_NOT_SUPPORTED, "HXR_PERFECTPLAY_NOT_SUPPORTED" }, // 800401c2
	{ HXR_NO_LIVE_PERFECTPLAY, "HXR_NO_LIVE_PERFECTPLAY" }, // 800401c3
	{ HXR_PERFECTPLAY_NOT_ALLOWED, "HXR_PERFECTPLAY_NOT_ALLOWED" }, // 800401c4
	{ HXR_NO_CODECS, "HXR_NO_CODECS" }, // 800401c5
	{ HXR_SLOW_MACHINE, "HXR_SLOW_MACHINE" }, // 800401c6
	{ HXR_FORCE_PERFECTPLAY, "HXR_FORCE_PERFECTPLAY" }, // 800401c7
	{ HXR_INVALID_HTTP_PROXY_HOST, "HXR_INVALID_HTTP_PROXY_HOST" }, // 800401c8
	{ HXR_INVALID_METAFILE, "HXR_INVALID_METAFILE" }, // 800401c9
	{ HXR_BROWSER_LAUNCH, "HXR_BROWSER_LAUNCH" }, // 800401ca
	{ HXR_VIEW_SOURCE_NOCLIP, "HXR_VIEW_SOURCE_NOCLIP" }, // 800401cb
	{ HXR_VIEW_SOURCE_DISSABLED, "HXR_VIEW_SOURCE_DISSABLED" }, // 800401cc
	{ HXR_TIMELINE_SUSPENDED, "HXR_TIMELINE_SUSPENDED" }, // 800401ce
	{ HXR_BUFFER_NOT_AVAILABLE, "HXR_BUFFER_NOT_AVAILABLE" }, // 800401cf
	{ HXR_COULD_NOT_DISPLAY, "HXR_COULD_NOT_DISPLAY" }, // 800401d0
	{ HXR_VSRC_DISABLED, "HXR_VSRC_DISABLED" }, // 800401d1
	{ HXR_VSRC_NOCLIP, "HXR_VSRC_NOCLIP" }, // 800401d2

	{ HXR_RESOURCE_NOT_CACHED, "HXR_RESOURCE_NOT_CACHED" }, // 80040301
	{ HXR_RESOURCE_NOT_FOUND, "HXR_RESOURCE_NOT_FOUND" }, // 80040302
	{ HXR_RESOURCE_CLOSE_FILE_FIRST, "HXR_RESOURCE_CLOSE_FILE_FIRST" }, // 80040303
	{ HXR_RESOURCE_NODATA, "HXR_RESOURCE_NODATA" }, // 80040304
	{ HXR_RESOURCE_BADFILE, "HXR_RESOURCE_BADFILE" }, // 80040305
	{ HXR_RESOURCE_PARTIALCOPY, "HXR_RESOURCE_PARTIALCOPY" }, // 80040306

	{ HXR_PPV_NO_USER, "HXR_PPV_NO_USER" }, // 800402c0
	{ HXR_PPV_GUID_READ_ONLY, "HXR_PPV_GUID_READ_ONLY" }, // 800402c1
	{ HXR_PPV_GUID_COLLISION, "HXR_PPV_GUID_COLLISION" }, // 800402c2
	{ HXR_REGISTER_GUID_EXISTS, "HXR_REGISTER_GUID_EXISTS" }, // 800402c3
	{ HXR_PPV_AUTHORIZATION_FAILED, "HXR_PPV_AUTHORIZATION_FAILED" }, // 800402c4
	{ HXR_PPV_OLD_PLAYER, "HXR_PPV_OLD_PLAYER" }, // 800402c5
	{ HXR_PPV_ACCOUNT_LOCKED, "HXR_PPV_ACCOUNT_LOCKED" }, // 800402c6
	{ HXR_PPV_DBACCESS_ERROR, "HXR_PPV_DBACCESS_ERROR" }, // 800402c8
	{ HXR_PPV_USER_ALREADY_EXISTS, "HXR_PPV_USER_ALREADY_EXISTS" }, // 800402c9

	{ HXR_UPG_AUTH_FAILED, "HXR_UPG_AUTH_FAILED" }, // 80040340
	{ HXR_UPG_CERT_AUTH_FAILED, "HXR_UPG_CERT_AUTH_FAILED" }, // 80040341
	{ HXR_UPG_CERT_EXPIRED, "HXR_UPG_CERT_EXPIRED" }, // 80040342
	{ HXR_UPG_CERT_REVOKED, "HXR_UPG_CERT_REVOKED" }, // 80040343
	{ HXR_UPG_RUP_BAD, "HXR_UPG_RUP_BAD" }, // 80040344
	{ HXR_UPG_SYSTEM_BUSY, "HXR_UPG_SYSTEM_BUSY" }, // 80040345

	{ HXR_AUTOCFG_SUCCESS, "HXR_AUTOCFG_SUCCESS" }, // 80040345
	{ HXR_AUTOCFG_FAILED, "HXR_AUTOCFG_FAILED" }, // 80040345
	{ HXR_AUTOCFG_ABORT, "HXR_AUTOCFG_ABORT" }, // 80040345
	
	{ HXR_UNKNOWN_IMAGE, "HXR_UNKNOWN_IMAGE" }, // 80040345
	{ HXR_UNKNOWN_EFFECT, "HXR_UNKNOWN_EFFECT" }, // 80040345
	{ HXR_SENDIMAGE_ABORTED, "HXR_SENDIMAGE_ABORTED" }, // 80040345
	{ HXR_SENDEFFECT_ABORTED, "HXR_SENDEFFECT_ABORTED" }, // 80040345

	{ HXR_SE_MIN_VALUE, "HXR_SE_MIN_VALUE" }, // 80041800
	{ HXR_SE_NO_ERROR, "HXR_SE_NO_ERROR" }, // 80041901
	{ HXR_SE_INVALID_VERSION, "HXR_SE_INVALID_VERSION" }, // 80041902
	{ HXR_SE_INVALID_FORMAT, "HXR_SE_INVALID_FORMAT" }, // 80041903
	{ HXR_SE_INVALID_BANDWIDTH, "HXR_SE_INVALID_BANDWIDTH" }, // 80041904
	{ HXR_SE_INVALID_PATH, "HXR_SE_INVALID_PATH" }, // 80041905
	{ HXR_SE_UNKNOWN_PATH, "HXR_SE_UNKNOWN_PATH" }, // 80041906
	{ HXR_SE_INVALID_PROTOCOL, "HXR_SE_INVALID_PROTOCOL" }, // 80041907
	{ HXR_SE_INVALID_PLAYER_ADDR, "HXR_SE_INVALID_PLAYER_ADDR" }, // 80041908
	{ HXR_SE_LOCAL_STREAMS_PROHIBITED, "HXR_SE_LOCAL_STREAMS_PROHIBITED" }, // 80041909
	{ HXR_SE_SERVER_FULL, "HXR_SE_SERVER_FULL" }, // 8004190a
	{ HXR_SE_REMOTE_STREAMS_PROHIBITED, "HXR_SE_REMOTE_STREAMS_PROHIBITED" }, // 8004190b
	{ HXR_SE_EVENT_STREAMS_PROHIBITED, "HXR_SE_EVENT_STREAMS_PROHIBITED" }, // 8004190c
	{ HXR_SE_INVALID_HOST, "HXR_SE_INVALID_HOST" }, // 8004190d
	{ HXR_SE_NO_CODEC, "HXR_SE_NO_CODEC" }, // 8004190e
	{ HXR_SE_LIVEFILE_INVALID_BWN, "HXR_SE_LIVEFILE_INVALID_BWN" }, // 8004190f
	{ HXR_SE_UNABLE_TO_FULFILL, "HXR_SE_UNABLE_TO_FULFILL" }, // 80041910
	{ HXR_SE_MULTICAST_DELIVERY_ONLY, "HXR_SE_MULTICAST_DELIVERY_ONLY" }, // 80041911
	{ HXR_SE_LICENSE_EXCEEDED, "HXR_SE_LICENSE_EXCEEDED" }, // 80041912
	{ HXR_SE_LICENSE_UNAVAILABLE, "HXR_SE_LICENSE_UNAVAILABLE" }, // 80041913
	{ HXR_SE_INVALID_LOSS_CORRECTION, "HXR_SE_INVALID_LOSS_CORRECTION" }, // 80041914
	{ HXR_SE_PROTOCOL_FAILURE, "HXR_SE_PROTOCOL_FAILURE" }, // 80041915
	{ HXR_SE_REALVIDEO_STREAMS_PROHIBITED, "HXR_SE_REALVIDEO_STREAMS_PROHIBITED" }, // 80041916
	{ HXR_SE_REALAUDIO_STREAMS_PROHIBITED, "HXR_SE_REALAUDIO_STREAMS_PROHIBITED" }, // 80041917
	{ HXR_SE_DATATYPE_UNSUPPORTED, "HXR_SE_DATATYPE_UNSUPPORTED" }, // 80041918
	{ HXR_SE_DATATYPE_UNLICENSED, "HXR_SE_DATATYPE_UNLICENSED" }, // 80041919
	{ HXR_SE_RESTRICTED_PLAYER, "HXR_SE_RESTRICTED_PLAYER" }, // 8004191a
	{ HXR_SE_STREAM_INITIALIZING, "HXR_SE_STREAM_INITIALIZING" }, // 8004191b
	{ HXR_SE_INVALID_PLAYER, "HXR_SE_INVALID_PLAYER" }, // 8004191c
	{ HXR_SE_PLAYER_PLUS_ONLY, "HXR_SE_PLAYER_PLUS_ONLY" }, // 8004191d
	{ HXR_SE_NO_EMBEDDED_PLAYERS, "HXR_SE_NO_EMBEDDED_PLAYERS" }, // 8004191e
	{ HXR_SE_PNA_PROHIBITED, "HXR_SE_PNA_PROHIBITED" }, // 8004191f
	{ HXR_SE_AUTHENTICATION_UNSUPPORTED, "HXR_SE_AUTHENTICATION_UNSUPPORTED" }, // 80041920
	{ HXR_SE_MAX_FAILED_AUTHENTICATIONS, "HXR_SE_MAX_FAILED_AUTHENTICATIONS" }, // 80041921
	{ HXR_SE_AUTH_ACCESS_DENIED, "HXR_SE_AUTH_ACCESS_DENIED" }, // 80041922
	{ HXR_SE_AUTH_UUID_READ_ONLY, "HXR_SE_AUTH_UUID_READ_ONLY" }, // 80041923
	{ HXR_SE_AUTH_UUID_NOT_UNIQUE, "HXR_SE_AUTH_UUID_NOT_UNIQUE" }, // 80041924
	{ HXR_SE_AUTH_NO_SUCH_USER, "HXR_SE_AUTH_NO_SUCH_USER" }, // 80041925
	{ HXR_SE_AUTH_REGISTRATION_SUCCEEDED, "HXR_SE_AUTH_REGISTRATION_SUCCEEDED" }, // 80041926
	{ HXR_SE_AUTH_REGISTRATION_FAILED, "HXR_SE_AUTH_REGISTRATION_FAILED" }, // 80041927
	{ HXR_SE_AUTH_REGISTRATION_GUID_REQUIRED, "HXR_SE_AUTH_REGISTRATION_GUID_REQUIRED" }, // 80041928
	{ HXR_SE_AUTH_UNREGISTERED_PLAYER, "HXR_SE_AUTH_UNREGISTERED_PLAYER" }, // 80041929
	{ HXR_SE_AUTH_TIME_EXPIRED, "HXR_SE_AUTH_TIME_EXPIRED" }, // 8004192a
	{ HXR_SE_AUTH_NO_TIME_LEFT, "HXR_SE_AUTH_NO_TIME_LEFT" }, // 8004192b
	{ HXR_SE_AUTH_ACCOUNT_LOCKED, "HXR_SE_AUTH_ACCOUNT_LOCKED" }, // 8004192c
	{ HXR_SE_AUTH_INVALID_SERVER_CFG, "HXR_SE_AUTH_INVALID_SERVER_CFG" }, // 8004192d
	{ HXR_SE_NO_MOBILE_DOWNLOAD, "HXR_SE_NO_MOBILE_DOWNLOAD" }, // 8004192e
	{ HXR_SE_NO_MORE_MULTI_ADDR, "HXR_SE_NO_MORE_MULTI_ADDR" }, // 8004192f
	{ HXR_PE_PROXY_MAX_CONNECTIONS, "HXR_PE_PROXY_MAX_CONNECTIONS" }, // 80041930
	{ HXR_PE_PROXY_MAX_GW_BANDWIDTH, "HXR_PE_PROXY_MAX_GW_BANDWIDTH" }, // 80041931
	{ HXR_PE_PROXY_MAX_BANDWIDTH, "HXR_PE_PROXY_MAX_BANDWIDTH" }, // 80041932
	{ HXR_SE_BAD_LOADTEST_PASSWORD, "HXR_SE_BAD_LOADTEST_PASSWORD" }, // 80041933
	{ HXR_SE_PNA_NOT_SUPPORTED, "HXR_SE_PNA_NOT_SUPPORTED" }, // 80041934
	{ HXR_PE_PROXY_ORIGIN_DISCONNECTED, "HXR_PE_PROXY_ORIGIN_DISCONNECTED" }, // 80041935
	{ HXR_SE_INTERNAL_ERROR, "HXR_SE_INTERNAL_ERROR" }, // 80041936
	{ HXR_SE_MAX_VALUE, "HXR_SE_MAX_VALUE" }, // 80041937
    { 0, 0 }
};

const char*
HXErrorCodeToString( UInt32 ulHXCode )
{
	int index;
    for ( index = 0; HXCodeToKeyMap[ index ].ulHXCode != 0; ++index )
    {
		if ( HXCodeToKeyMap[index].ulHXCode == ulHXCode )
		{
			return HXCodeToKeyMap[ index ].pKeyString;
		}
    }
	return NULL;
}
