/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: hxstatus.h,v 1.5.2.4 2004/07/09 01:48:55 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _HXSTATUS_DISPLAY_H_
#define _HXSTATUS_DISPLAY_H_

#include <gdk/gdk.h>
#include <gtk/gtkvbox.h>


#include "commonapp.h"

G_BEGIN_DECLS
    
#define HX_TYPE_STATUS_DISPLAY            (hxstatus_display_get_type ())
#define HX_STATUS_DISPLAY(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), HX_TYPE_STATUS_DISPLAY, HXStatusDisplay))
#define HX_STATUS_DISPLAY_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), HX_TYPE_STATUS_DISPLAY, HXStatusDisplayClass))
#define HX_IS_STATUS_DISPLAY(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HX_TYPE_STATUS_DISPLAY))
#define HX_IS_STATUS_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), HX_TYPE_STATUS_DISPLAY))
#define HX_STATUS_DISPLAY_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), HX_TYPE_STATUS_DISPLAY, HXStatusDisplayClass))

typedef struct _HXStatusDisplay      HXStatusDisplay;
typedef struct _HXStatusDisplayClass HXStatusDisplayClass;
typedef struct _HXStatusDisplayTop   HXStatusDisplayTop;

    
struct _HXStatusDisplay
{
    GtkVBox display;

    HXPlayer* player;
    gchar* title_override;
    gchar* author_override;
    gchar* copyright_override;

    guint timer_id;
    gboolean timer_is_running;
    guint timer_interval;
    GtkFunction timer_function;
    gpointer timer_data;

    // The timer will be disabled when the widget is hidden.
    // It can also be disable while the widget is not playing.
    gboolean timer_disable_while_not_playing;

    // Also fire the timer on state changes (useful if this is updating ui);
    gboolean timer_fire_on_state_changes;    

    GArray *player_status_signal_handlers_array;
    guint player_status_signal_handlers_array_len;
};

struct _HXStatusDisplayClass
{
    GtkVBoxClass parent_class;

    void        (*set_player)   (HXStatusDisplay* status,
                                 HXPlayer*     player);
};

GType      hxstatus_display_get_type  (void) G_GNUC_CONST;
void       hxstatus_display_set_player(HXStatusDisplay* status,
                                       HXPlayer* player);
void       hxstatus_display_set_timer (HXStatusDisplay* status,
                                       guint            interval,
                                       GtkFunction      function,
                                       gpointer         data,
                                       gboolean         disable_while_not_playing,
                                       gboolean         fire_on_state_changes);

void hxstatus_display_start_timer          (HXStatusDisplay* status);
void hxstatus_display_stop_timer           (HXStatusDisplay* status);
void hxstatus_display_change_timer_interval(HXStatusDisplay* status,
                                            guint            interval);


/* StatusDisplay is uninstantiable -- use one of the derived classes */
/* GtkWidget* hxstatus_display_new      (void); */

G_END_DECLS

#endif
