/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: oggutil.cpp,v 1.1.4.3 2004/11/24 18:02:52 acolwell Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */
#include "oggutil.h"
#include "hlxclib/memory.h"

ogg_page* OggUtil::CopyPage(ogg_page* pA)
{
    ogg_page* pRet = new ogg_page;

    if (pRet)
    {
        // copy page fields
        *pRet = *pA;

        // allocate new header and body buffers
        pRet->header = new unsigned char [pA->header_len];
        pRet->body = new unsigned char [pA->body_len];

        if (pRet->header && pRet->body)
        {
            memcpy(pRet->header, pA->header, pA->header_len);
            memcpy(pRet->body, pA->body, pA->body_len);
        }
        else
        {
            DestroyPage(pRet);
            pRet = 0;
        }
    }

    return pRet;
}

void OggUtil::DestroyPage(ogg_page* pA)
{
    if (pA)
    {
        delete [] pA->header;
        delete [] pA->body;
        delete pA;
    }
}

bool OggUtil::ComparePages(ogg_page* pA, ogg_page* pB)
{
    return (pA && pB && pA->body && pB->body && pA->header && pA->header &&
            (pA->body_len == pB->body_len) && 
            (pA->header_len == pB->header_len) &&
            (!memcmp(pA->body, pB->body, pB->body_len)) &&
            (!memcmp(pA->header, pB->header, pB->header_len)));
}

ogg_packet* 
OggUtil::CopyPacket(ogg_packet* pA)
{
    ogg_packet* pRet = 0;

    if (pA)
    {
        pRet = new ogg_packet;

        if (pRet)
        {
            // copy ogg_packet fields
            *pRet = *pA;

            pRet->packet = new unsigned char[pRet->bytes];

            if (pRet->packet)
            {
                memcpy(pRet->packet, pA->packet, pRet->bytes);
            }
            else
            {
                delete pRet;
                pRet = 0;
            }
        }
    }

    return pRet;
}

void OggUtil::DestroyPacket(ogg_packet* pA)
{
    if (pA)
    {
        delete [] pA->packet;
        delete pA;
    }
}
