/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: player_version_data.h,v 1.2.6.3 2004/07/09 01:48:48 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _PLAYER_VERSION_DATA_H_
#define _PLAYER_VERSION_DATA_H_


#include "platform.h"
#include "hxplayer.ver"


#define PLAYER_ULONG32_VERSION	TARVER_ULONG32_VERSION
#define PLAYER_LIST_VERSION	TARVER_LIST_VERSION
#define PLAYER_MAJOR_VERSION	TARVER_MAJOR_VERSION
#define PLAYER_MINOR_VERSION	TARVER_MINOR_VERSION
#define PLAYER_STRING_VERSION	TARVER_STRING_VERSION
#define PLAYER_STR_BUILD_NAME	TARVER_STR_BUILD_NAME
#define PLAYER_STR_PLATFORM	TARVER_STR_PLATFORM

/* XXXDC: Uses the funky '#' stringitizing operator to create a 
 * string like "x.y".
 */
#define _VERSION_STRINGIFY(x) #x
#define PLAYER_MAJOR_STRING _VERSION_STRINGIFY(TARVER_MAJOR_VERSION)
#define PLAYER_MINOR_STRING _VERSION_STRINGIFY(TARVER_MINOR_VERSION)
#define PLAYER_MAJOR_MINOR_STRING PLAYER_MAJOR_STRING "." PLAYER_MINOR_STRING

#ifdef HELIX_FEATURE_REAL_BRANDING

#ifndef PLAYER_PRODUCT_NAME
#define PLAYER_PRODUCT_NAME "RealPlayer"
#endif

#ifndef PLAYER_RELEASE_NAME
#define PLAYER_RELEASE_NAME "0.3"
#endif

#ifndef PLAYER_PRODUCT_NAME_FULL
#define PLAYER_PRODUCT_NAME_FULL PLAYER_PRODUCT_NAME " " PLAYER_RELEASE_NAME
#endif

#ifndef PLAYER_STR_EXECUTABLE_NAME
#define PLAYER_STR_EXECUTABLE_NAME "realplay"
#endif

#else // HELIX_FEATURE_REAL_BRANDING

#ifndef PLAYER_PRODUCT_NAME
#define PLAYER_PRODUCT_NAME "Helix Player"
#endif

#ifndef PLAYER_RELEASE_NAME
#define PLAYER_RELEASE_NAME "0.3"
#endif

#ifndef PLAYER_PRODUCT_NAME_FULL
#define PLAYER_PRODUCT_NAME_FULL PLAYER_PRODUCT_NAME " " PLAYER_RELEASE_NAME
#endif

#ifndef PLAYER_STR_EXECUTABLE_NAME
#define PLAYER_STR_EXECUTABLE_NAME "hxplay"
#endif

#endif // HELIX_FEATURE_REAL_BRANDING

#endif //_PLAYER_VERSION_DATA_H_
