/*
 * terminal.h
 * Thomas Nemeth, le 15.10.2003
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef TERMINAL_H
#define TERMINAL_H

#include <ncurses.h>


/* Structure used for color sets */
typedef enum {
        NoColor = -1,
        Black,
        Red,
        Green,
        Yellow,
        Blue,
        Magenta,
        Cyan,
        White
} ColorVal;


/* Structure used to set colors */
typedef struct {
        int    fg;  /* Foreground color from ColorVal */
        int    bg;  /* Background color from ColorVal */
        int    hl;  /* Highlight if 1                 */
        char * str; /* String from config file        */
} ColorDefinitions;


/* Structure used for commands list */
typedef struct Cmdslst {
        int    key;     /* Key to hit to launch function             */
        int  (*fct)();  /* Function to launch when key 'key' is hit  */
} Cmdslst;


#define YES    1
#define NO     2
#define CANCEL 3

#define CONT   1
#define STOP   2
#define QUIT   3


#define NORMALCOLOR 0
#define BORDERCOLOR 1
#define TITLECOLOR  2



/**
 * Initialize the curses library.
 */
void init_curses(int usecolors, int nbcolors, ColorDefinitions *coldefs);


/**
 * Convert colors from configuration file to usable data (str -> fg/bg/hl)
 */
void convert_colors();


/**
 * Set output color
 */
void set_color(WINDOW *win, int color, int switch_hl);


/**
 * Wait for a command
 */
int command_loop(Cmdslst *cmds);


/**
 * Creates a new window
 */
WINDOW *create_newwin(const char *title,
        int height, int width,
        int starty, int startx);


/**
 * Creates a dialog window
 */
WINDOW *create_dialog(const char *title, int height);


/**
 * Destroy a window
 */
void destroy_win(WINDOW *local_win);


/**
 * "yes or no" dialog box
 */
int yes_or_no(const char *title, const char *reason, int def);


/**
 * Yes/no/cancel dialog box
 */
int yes_no_cancel(const char *title, const char *reason, int def);


#endif

