/*
 * mp3_mod.c
 * Thomas Nemeth, le 15.10.2003
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include "defines.h"
#include <ncurses.h>
#include "tmms.h"
#include "modules.h"

static int parse_mp3(const char *datas, int *frame,
                     int *mins, int *secs, int *rms, int *rss, int *br);

static Module MP3 = {
        .ext     = ".mp3",
        .cmd     = "mpg123",
        .pos     = "-k",
        .dev     = "-o",
        .opt     = "-v",
        .postype = FRAMES,
        .parse   = &parse_mp3,
        .infos   = NULL
};


void register_mp3()
{
        register_module(&MP3);
}


static int parse_mp3(const char *datas, int *frame,
                     int *mins, int *secs, int *rms, int *rss, int *br)
{
        int r = 0, nbr = -1;
        char *t = strstr(datas, "Frame#");

        if (t)
        {
                int rf, sc, rcs, n;
                nbr = 9;
                r = sscanf(datas,
                        "Frame# %d [%d], Time: %d:%d.%d [%d:%d.%d], [%d]",
                        frame, &rf, mins, secs, &sc, rms, rss, &rcs, &n);
        }
        else
        {
                char *i = strstr(datas, "Bitrate:");
                if (i)
                {
                        int e;
                        nbr = 2;
                        r = sscanf(datas,
                                "Bitrate: %d Kbits/s, Extension value: %d",
                                br, &e);
                }
        }

        return (r == nbr);
}

