/***************************************************************************
 *   Copyleft (C) 2004 by Cocophotos                                       *
 *   cocophotos@hotmail.com                                                *
 *   Sous licence GPL v2 ou plus                                           *
 ***************************************************************************/

#include <QtCore>
#include <QtGui>
#include <QtNetwork>
#include "scythia.h"
#include "choose_prog.h"


scythia *mw;
QTranslator *translator;

QString CheminConf, CheminTrad, Language;

int main(int argc, char **argv)
{
	CheminConf = QFileInfo(argv[0]).absolutePath() + "/scythia-files/";

	if (QDir(CheminConf).exists() == false)
	{
		QDir::home().mkdir(".scythia-conf");
		CheminConf = QDir::homePath() + "/.scythia-conf/";
		CheminTrad = "/usr/share/scythia/lang/";
	}

	else
		CheminTrad = CheminConf;
	QApplication a(argc, argv);
	translator = new QTranslator(0);

	// On sélectionne la langue
	bool defautLang = false;
	QFile langConf(CheminConf + "scythia-lang");
	if (langConf.open(QIODevice::ReadOnly))
	{
		Language = langConf.readAll();
		if (Language != QObject::trUtf8("français"))
		{
			// On charge et installe le fichier pour la traduction.
			translator->load(Language, CheminTrad);
			a.installTranslator(translator);
			defautLang = true;
		}
	}

	// On crée la classe principale
	mw = new scythia();

	if (!defautLang)
		mw->slotSelectLang();

	// On affiche la fenêtre principale en plein écran
	mw->showMaximized();
	// On affiche les fichiers locaux
	// IMPORTANT : à mettre dans le main APRES le show
	mw->slotChangeLocalPath("");

	// Exécution du programme
	a.setQuitOnLastWindowClosed(FALSE);
	int i = a.exec();

	// On écrase le fichier des signets
	// IMPORTANT : a mettre dans le main JUSTE AVANT le return
	mw->list.CreerFichier();

	return i;
}
