/****************************************************************************
** Liste des signets FTP pour Scythia
** Créé par Anacr0x : anacr0x@free.fr
**
** Sous licence GPL v2 ou plus
****************************************************************************/

#ifndef LISTE_SIGNET_H
#define LISTE_SIGNET_H

#include <QtCore>
#include <QtGui>
#include <QtNetwork>

#define NB_PARAM 8

/*************************************************************************/
//! Classe qui permet d'enregistrer les signets

/*! Cette classe gère l'enregistrement des signets dans le fichier :
   "Scythia-signets" ainsi que leur modifications et suppression\n
   Elle possède un petit algo de cryptage des mots de passe pour plus de sécurité. */
/*************************************************************************/

class ListeSignet
{
private:

	/*! Liste qui enregistre les informations sur les signets et les stocke dans le
	   fichiers à chaque fermeture du programme */
	QString list;

	/*! Trouve le début de l'item dans list */
	int DebutItem(int nb);

	/*! Crypte la chaîne passé en param. Le code correspond au nombre de décalage dans
	   la chaîne ascii */
	QString Crypte(const QString &str, int code);

public:
	/*! Le constructeur : lit le fichier et rempli la liste */
	ListeSignet();

	/*! Crée le fichier (à mettre 1 fois avant le return du main)\n
	   Valeur(s) de retour :\n
	   true == succès\n
	   false == erreur */
	bool CreerFichier();

	/*! Donne le nombre d'identifiant qu'il y a dans la liste */
	int NbItem();

	/*! Donne le numéro d'item de l'identifiant\n
	   Valeur(s) de retour :\n
	   -1 == erreur */
	int IdentifiantToItem(const QString &Identifiant);

	/*! Retourne l'identifiant de l'item nb\n
	   \warning 0 est le 1er item et (NbItem()-1) le dernier */
	QString RecupIdentifiant(int nb);

	/*! Retourne le login de l'item nb\n
	   \warning 0 est le 1er item et (NbItem()-1) le dernier */
	inline QString RecupLogin(int nb)
	{
		return list.section('\n', NB_PARAM * nb + 1, NB_PARAM * nb + 1);
	}

	/*! Retourne l'hôte de l'item nb\n
	   \warning 0 est le 1er item et (NbItem()-1) le dernier */
	inline QString RecupHote(int nb)
	{
		return list.section('\n', NB_PARAM * nb + 2, NB_PARAM * nb + 2);
	}

	/*! Retourne le mot de passe (crypté) de l'item nb\n
	   \warning 0 est le 1er item et (NbItem()-1) le dernier */
	inline QString RecupMotDePasse(int nb)
	{
		return Crypte(list.section('\n', NB_PARAM * nb + 3, NB_PARAM * nb + 3), -1);
	}

	/*! Retourne le port de l'item nb\n
	   \warning 0 est le 1er item et (NbItem()-1) le dernier */
	inline int RecupPort(int nb)
	{
		return list.section('\n', NB_PARAM * nb + 4, NB_PARAM * nb + 4).toInt();
	}

	/*! Retourne le mode de transfert de l'item nb\n
	   \warning 0 est le 1er item et (NbItem()-1) le dernier */
	inline QString RecupTransferMode(int nb)
	{
		return list.section('\n', NB_PARAM * nb + 5, NB_PARAM * nb + 5);
	}

	/*! Retourne le nom du proxy de l'item nb\n
	   \warning 0 est le 1er item et (NbItem()-1) le dernier */
	inline QString RecupProxyName(int nb)
	{
		return list.section('\n', NB_PARAM * nb + 6, NB_PARAM * nb + 6);
	}

	/*! Retourne le port du proxy de l'item nb\n
	   \warning 0 est le 1er item et (NbItem()-1) le dernier */
	inline int RecupProxyPort(int nb)
	{
		return list.section('\n', NB_PARAM * nb + 7, NB_PARAM * nb + 7).toInt();
	}

	/*! Ajoute un item dans la liste */
	void Ajouter(const QString &Identifiant, const QString &Login,
	             const QString &MotDePasse, const QString &Hote, int Port,
	             const QString &TransferMode, const QString &ProxyName,
	             int ProxyPort );

	/*! Supprime un item de la liste */
	void Supprimer(int nb);

	/*! Modifie un item de la liste */
	void ModifItem(int nb, const QString &Identifiant, const QString &Login,
	               const QString &MotDePasse, const QString &Hote, int Port,
	               const QString &TransferMode, const QString &ProxyName,
	               int ProxyPort );
};

#endif
