/***************************************************************************
 *   Copyleft (C) 2004 by Cocophotos                                       *
 *   cocophotos@hotmail.com                                                *
 *   Sous licence GPL v2 ou plus                                           *
 ***************************************************************************/

#ifndef SIGNET_H
#define SIGNET_H

#include "ui_ftpsignet.h"

/*************************************************************************/
//! Gère le dialog de gestion des signets

/*! Permet d'afficher un dialog de gestion des signets capable de d'ajouter,
   supprimer et modifier les paramètres inscrits dans les signets */
/*************************************************************************/

class ftpSignet:public QDialog, public Ui::ftpSignet
{
Q_OBJECT public:
	/*! Constructeur : ajoute dans la ListView les items déjà existants */
	ftpSignet(QWidget * parent = 0);

	/*! Stock en mémoire le numéro de l'item en cour d'utilisation */
	int itemSignet;

public slots:
	/*! Permet de modifier un signet déjà existant */
	virtual void slotModifSignet();
	/*! Permet d'afficher les données quand on clique sur un signet */
	virtual void slotClickedIdentifiant();
	/*! Permet de supprimer un signet déjà existant */
	virtual void slotDeleteSignet();
	/*! Permet d'ajouter un signet */
	virtual void slotSSave();
	/*! Permet de gérer les boutons à afficher en fonction des données inscrites */
	virtual void slotSDataChanged(const QString &);
};

#endif
