/***************************************************************************
 *   Copyleft (C) 2004 by Cocophotos                                       *
 *   cocophotos@hotmail.com                                                *
 *   Sous licence GPL v2 ou plus                                           *
 ***************************************************************************/


#include "ftpconnect.h"
#include "scythia.h"

extern scythia *mw;		// Pointeur qui permet de récupérer l'objet
// principal de la classe ListeSignet

ftpConnect::ftpConnect(QWidget * parent):QDialog(parent)
{
	setupUi(this);
	connect(identifiant, SIGNAL(textChanged(const QString &)), this,
	        SLOT(slotSDataChanged(const QString &)));
	connect(password, SIGNAL(textChanged(const QString &)), this,
	        SLOT(slotSDataChanged(const QString &)));
	connect(username, SIGNAL(textChanged(const QString &)), this,
	        SLOT(slotSDataChanged(const QString &)));
	connect(signetList, SIGNAL(itemClicked(QListWidgetItem *)), this,
	        SLOT(slotClickedIdentifiant()));
	connect(signetList, SIGNAL(itemDoubleClicked(QListWidgetItem *)),
	        this, SLOT(slotConnectRapid()));
	connect(anonymous, SIGNAL(stateChanged(int)), this,
	        SLOT(slotAnonymousChanged(int)));
	connect(ftpUrlBtn, SIGNAL(clicked()), this, SLOT(slotFtpUrl()));

	// Récupère les noms d'identifiant enregistrer dans Scythia-signets et les
	// place dans la liste
	int max = mw->list.NbItem();
	for (int i = 0; i < max; i++)
		signetList->addItem(mw->list.RecupIdentifiant(i));

	// On arrange un peu le splitter en diminuant la taille de la partie de gauche
	splitter->setStretchFactor(1, 2);
}

void ftpConnect::slotFtpUrl()
{
	if (ftpUrl->text() == "")
		return;

	QString url = ftpUrl->text().section("//", -1, -1);
	QString mdp = url.section("@", 0, 0).section(":", -1, -1);
	identifiant->setText(url.section(":", 0, 0));
	username->setText(url.section(":", 0, 0));
	password->setText(mdp);
	host->setEditText(url.section("@", 1, 1));
}

/***************Slot pour ce connecter*******************/
void ftpConnect::slotConnectRapid()
{
	if (password->text() == "")
	{
		// Mesage d'erreur si password est vide
		QMessageBox::warning(this, tr("Erreur Mot de passe"),
		                     trUtf8("Entrez un mot de passe s'il vous plaît"));
	}
	else
		accept();
}

/*************Slot pour récupérer le texte du fichier Scythia-signets lorsque l'on clique dans la liste**********/
void ftpConnect::slotClickedIdentifiant()
{
	if ((itemConnect = signetList->currentRow()) == -1)
		return;

	// Récupération et affichage des données
	identifiant->setText(mw->list.RecupIdentifiant(itemConnect));
	username->setText(mw->list.RecupLogin(itemConnect));
	password->setText(mw->list.RecupMotDePasse(itemConnect));
	host->setEditText(mw->list.RecupHote(itemConnect));
	port->setValue(mw->list.RecupPort(itemConnect));
	if (mw->list.RecupTransferMode(itemConnect) == "Passif")
		transferMode->setCurrentIndex(0);
	else
		transferMode->setCurrentIndex(1);
	proxyName->setText(mw->list.RecupProxyName(itemConnect));
	proxyPort->setValue(mw->list.RecupProxyPort(itemConnect));
}

/*******Slot pour le changement des LineEdit ==> Si tt les LineEdit ne sont pas rempli, les bouttons sont incliquables******/
void ftpConnect::slotSDataChanged(const QString &)
{
	if (!host->currentText().isEmpty() && !username->text().isEmpty()
	        && !host->currentText().isEmpty() && !password->text().isEmpty()
	        && !username->text().isEmpty() && !transferMode->currentText().isEmpty())
		connectButton->setEnabled(TRUE);
	else
		connectButton->setEnabled(FALSE);
}

/*******Slot pour le changement des LineEdit ==> Si tt les LineEdit ne sont pas rempli, les bouttons sont incliquables******/
void ftpConnect::slotAnonymousChanged(int state)
{
	if (state == Qt::Checked)
	{
		// On ajoute les données spécifiques à une connexion anonyme
		username->setText("anonymous");
		password->setText("scythia@buggynet.org");

		identifiant->setEnabled(FALSE);
		username->setEnabled(FALSE);
		password->setEnabled(FALSE);
		ftpUrl->setEnabled(FALSE);
		ftpUrlBtn->setEnabled(FALSE);
	}
	else
	{
		identifiant->setEnabled(TRUE);
		username->setEnabled(TRUE);
		password->setEnabled(TRUE);
		ftpUrl->setEnabled(TRUE);
		ftpUrlBtn->setEnabled(TRUE);
	}
}
