/****************************************************************************
** Créé par Anacr0x et Cocophotos :
**          anacr0x@free.fr
**          cocophotos@hotmail.com
**
** Sous licence GPL v2 ou plus
****************************************************************************/

#ifndef CHOOSE_PROG_H
#define CHOOSE_PROG_H

#include <QtCore>
#include <QtGui>
#include <QtNetwork>
#include "ui_choose_prog.h"
#include "scythia.h"

/*************************************************************************/
//! Classe qui gère la sélection des programmes de visualisation des fichiers

/*! Cette classe affiche un dialog permettant de choisir les programmes à associer à différents type de
   fichiers pour la visualisation.\n
   Elle gère également l'enregistrement du fichiers "Scythia-progs" pour les aperçus des fichiers (musiques,
   vidéos, documents, etc...). */
/*************************************************************************/

class chooseProg:public QDialog, public Ui::chooseProg
{
	Q_OBJECT
public:
	/*! Le constructeur : ouvre le fichier et récupère les données */
	chooseProg(QWidget * parent = 0);

public slots:
	/*! QFileDialog pour chercher le chemin de l'éxécutable associer aux images et affiche le chemin */
	void slotImages();
	/*! QFileDialog pour chercher le chemin de l'éxécutable associer aux fichiers video et affiche le chemin */
	void slotVideo();
	/*! QFileDialog pour chercher le chemin de l'éxécutable associer aux fichiers audio et affiche le chemin */
	void slotAudio();
	/*! QFileDialog pour chercher le chemin de l'éxécutable associer aux archives et affiche le chemin */
	void slotArchives();
	/*! QFileDialog pour chercher le chemin de l'éxécutable associer aux fichiers textes et affiche le chemin */
	void slotTxts();
	/*! QFileDialog pour chercher le chemin de l'éxécutable associer aux documents type Word et affiche le chemin */
	void slotDocs();

	/*! Sauvegarde les données et ferme le dialog */
	void OK();
};

#endif
