/****************************************************************************
** Créé par Anacr0x et Cocophotos :
**          anacr0x@free.fr
**          cocophotos@hotmail.com
**
** Sous licence GPL v2 ou plus
****************************************************************************/

#include "choose_prog.h"

extern scythia *mw;		// Pointeur qui permet de récupérer l'objet
// principal de la classe ListeSignet
extern QString CheminConf;

chooseProg::chooseProg(QWidget * parent):QDialog(parent)
{
	setupUi(this);
	connect(okChooseProg, SIGNAL(clicked()), this, SLOT(OK()));
	connect(cancelChooseProg, SIGNAL(clicked()), this, SLOT(Annuler()));
	connect(browseArchives, SIGNAL(clicked()), this, SLOT(slotArchives()));
	connect(browseTxts, SIGNAL(clicked()), this, SLOT(slotDocs()));
	connect(browseImages, SIGNAL(clicked()), this, SLOT(slotImages()));
	connect(browseVideo, SIGNAL(clicked()), this, SLOT(slotVideo()));
	connect(browseAudio, SIGNAL(clicked()), this, SLOT(slotAudio()));

	// Ouvre le fichier en lecture seule
	QFile conf(CheminConf + "scythia-progs");
	if (conf.open(QIODevice::ReadOnly))
	{
		// Lit tout le fichier et le met dans la liste
		mw->listProgs = QString(conf.readAll());
		conf.close();
	}
	// On inscrit les paramètres
	images->setText(mw->listProgs.section('\n', 0, 0));
	video->setText(mw->listProgs.section('\n', 1, 1));
	audio->setText(mw->listProgs.section('\n', 2, 2));
	archives->setText(mw->listProgs.section('\n', 3, 3));
	txts->setText(mw->listProgs.section('\n', 4, 4));
	docs->setText(mw->listProgs.section('\n', 5, 5));
}

void chooseProg::slotImages()
{
	QString CheminImages = QFileDialog::getOpenFileName(0,
	                       tr
	                       ("Choisir le programme pour les images"),
	                       "",
	                       tr
	                       ("Tous les fichiers (*.*)"));
	images->setText(CheminImages);
}

void chooseProg::slotVideo()
{
	QString CheminVideo = QFileDialog::getOpenFileName(0,
	                      tr
	                      ("Choisir le programme pour fichiers video"),
	                      "",
	                      tr
	                      ("Tous les fichiers (*.*)"));
	video->setText(CheminVideo);
}

void chooseProg::slotAudio()
{
	QString CheminAudio = QFileDialog::getOpenFileName(0,
	                      tr
	                      ("Choisir le programme pour fichiers audio"),
	                      "",
	                      tr
	                      ("Tous les fichiers (*.*)"));
	audio->setText(CheminAudio);
}

void chooseProg::slotArchives()
{
	QString CheminArchives = QFileDialog::getOpenFileName(0,
	                         tr
	                         ("Choisir le programme pour les images"),
	                         "",
	                         tr
	                         ("Tous les fichiers (*.*)"));
	archives->setText(CheminArchives);
}

void chooseProg::slotTxts()
{
	QString CheminTxts = QFileDialog::getOpenFileName(0,
	                     tr
	                     ("Choisir le programme pour les fichiers textes"),
	                     "",
	                     tr("Tous les fichiers (*.*)"));
	docs->setText(CheminTxts);
}

void chooseProg::slotDocs()
{
	QString CheminDocs = QFileDialog::getOpenFileName(0,
	                     tr
	                     ("Choisir le programme pour les documents"),
	                     "",
	                     tr("Tous les fichiers (*.*)"));
	docs->setText(CheminDocs);
}

void chooseProg::OK()
{
	// Ouvre le fichier en écriture seule
	QFile conf(CheminConf + "scythia-progs");
	if (conf.open(QIODevice::WriteOnly))
	{
		// Récupère les paramètres
		mw->listProgs = images->text();
		mw->listProgs.append('\n');
		mw->listProgs.append(video->text());
		mw->listProgs.append('\n');
		mw->listProgs.append(audio->text());
		mw->listProgs.append('\n');
		mw->listProgs.append(archives->text());
		mw->listProgs.append('\n');
		mw->listProgs.append(txts->text());
		mw->listProgs.append('\n');
		mw->listProgs.append(docs->text());
		mw->listProgs.append('\n');

		// Ecrit toute la liste dans le fichier et ferme
		conf.write(mw->listProgs.toAscii(), mw->listProgs.size());
		conf.close();
	}
	accept();
}
