/****************************************************************************
** Simplification et complétion de la classe QDir
** Créé par Anacr0x et Cocophotos :
**          anacr0x@free.fr
**          cocophotos@hotmail.com
**
** Sous licence GPL v2 ou plus
****************************************************************************/

#ifndef MYDD_H
#define MYDD_H

#include <QtCore>
#include <QtGui>
#include <QtNetwork>

#include "mytreewidget.h"

/*************************************************************************/
//! S'occupe de la gestion du disque dur

/*! MyDD est une classe d'amélioration et de complétion de QDir.\n\n
Son objectif est surtout de simplifier la gestion de l'affichage avec
les MyTreeWidgetItem.\n
Elle permet également de gérer la suppression de dossier non vide par
exemple. */
/*************************************************************************/

class MyFtp;

class MyDD : public QDir
{
private:
	/*! Permet de savoir si les fichiers cachés sont affichés */
	bool hidden;

	/*! Stock tous les fichiers trouvés par scanDir() */
	QString ScanDirList;

	/*! Utilisé pour sauvegarder la réponse de scanDir() */
	QString reply;

public:
	/*! Pointeur sur le MyTreeWidget utilisé pour l'affichage des fichiers locaux */
	MyTreeWidget *lvLocal;

	/*! Pointeur sur le QLineEdit utilisé pour l'affichage du chemin */
	QLineEdit *leDirPath;

	/*! Constructeur :\n
	path = pointeur sur le lineEdit utilisé pour afficher le chemin */
	MyDD (MyTreeWidget *local, QLineEdit *path = NULL);

	/*! Entre dans le dossier selectionné et affiche les fichiers.\n
	Retourne false si le dossier n'est pas authoriser à la lecture. */
	bool changePath ();

	/*! Change le chemin du disque dur avec celui passé en paramètre.\n
	Retourne false si le dossier n'est pas authoriser à la lecture. */
	bool changePath (const QString &LocalPath);

	/*! Rafraichi la liste et affiche les fichiers dans list */
	inline void refreshList ()
	{
		changePath (".");
	}

	/*! Permet de donné la liste complète des sous-dossiers et fichiers */
	QString scanDir (const QString &LocalPath);

	/*! Trouve un fichier dans la liste locale et précise s'il existe */
	bool isFileExist (const QString &file);

	/*! Supprime du dd le fichier/dossier (même non vide) sélectionné dans la listbox */
	void delSelection ();

	/*! Suprime un dossier (vide ou non) */
	void delDir (const QString &dir);

	/*! Renomme le dossier/fichier sélectionné dans la listbox en newName.\n
	Si restoreExt==true l'extension est remise */
	void renameSelection (QString newName, bool restoreExt = true);

	/*! Permet d'afficher ou de cacher les fichiers cachés.\n
	Par défaut, les fichiers cachés ne sont pas affichés */
	void showHiddenFiles (bool show);

	/*! Permet de savoir si les fichiers cachés sont affichés */
	inline bool showHiddenFiles ()
	{
		return hidden;
	}
};

#endif
