/***************************************************************************
 *   Copyleft (C) 2004 by Cocophotos                                       *
 *   cocophotos@hotmail.com                                                *
 *   Sous licence GPL v2 ou plus                                           *
 ***************************************************************************/

#ifndef SCYTHIA_H
#define SCYTHIA_H

#include <QtCore>
#include <QtGui>
#include <QtNetwork>
#include "liste_signet.h"
#include "MyFtp/myftp.h"
#include "ui_scythia.h"
#include "transfers.h"

/*************************************************************************/
//! La classe principale du programme

/*! Regroupe toute la gestion de l'interface graphique \n
   En effet il regroupe les principales fonctionnalités graphiques du programme. */
/*************************************************************************/
class scythia:public QMainWindow, public Ui::scythia
{
	Q_OBJECT
public:
	/*!Le constructeur : règle certains détails graphiques et connecte les signaux utilisés. */
	scythia(QWidget * parent = 0);
	/*!Le destructeur : libère la mémoire. */
	~scythia();

	/*!Objet de la classe MyFtp. \n
	   Il permet de gérer :
	   - L'affichage de la liste ftp et locale (fichiers et dossiers)
	   - Renommer un fichier ou dossier par ftp ou en local
	   - Supprimer un fichier ou dossier par ftp ou en local
	   - Créer un nouveau dossier par ftp ou en local. */
	MyFtp *ftp;
	/*!Objet de la classe transfers. \n
	   Permet de gérer les transferts en cours.*/
	transfers *transfersWidget;
	/*!Permet de stocker et de manipuler facilement les signets. */
	ListeSignet list;
	/*!Stock la liste de tout les programmes utilisé pour les aperçus des fichiers locaux. */
	QString listProgs;
	/*!Stock le chemin courant du ftp. */
	QString currentFtpDir;
	/*!Stock le nom du serveur distant. */
	QString Host;
	/*!Stock le login. */
	QString UserName;
	/*!Stock le password. */
	QString Password;
	/*!Stock le numéro du port utilsé. */
	int Port;
	/*!Stock le numéro de l'item sélectionné. */
	int itemSelected;
	/*!Les différentes listes de fichiers possible. */
	enum ListSelected
	{ Nothing, LocalList, FtpList, TransfersList };
	/*!Stock le type de liste actuellement sélectionné. */
	ListSelected listSelected;
	/*!Utiliser pour afficher l'état de la connexion. */
	QLabel *stateLabel;
	/*!Utiliser pour afficher l'icone d'attente en bas à droite. */
	QLabel *waitLabel;
	/*!Utiliser pour afficher l'icone de connexion en bas à droite. */
	QLabel *connectLabel;
	/*!Utiliser pour gérer le trayicon. */
	QSystemTrayIcon *trayIcon;
	/*!Utiliser pour afficher le munu du trayicon. */
	QMenu *menu;
	/*!Utiliser pour savoir si on doit demander avan de mettre dans le system tray. */
	bool systemTray;
	/*!QProcess qui permet de lancer les aperçus. */
	QProcess progs;

public slots:
	/*************************************************************
	Gestion des connexions/déconnexions
	*************************************************************/
	/*!Cette fonction gère la connection rapide au FTP. \n
	   Elle permet d'ouvrir la boîte de dialogue "Connection rapide */
	void slotConnect();
	/*!Cette fonction gère la déconnection au FTP. \n
	   Elle permet de fermer la connection, mais pas de déconnecter complétement */
	void slotDisconnect();
	/*!Cette fonction gère le changement d'état du FTP. \n
	   On trouve :
	   - Déconnecter ==> Lorsque l'on ouvre le programme
	   - Connection ==> Lorsqu'on lance une connexion
	   - Recherche d'Hôte ==> Lorsqu'on est en cours de connexion
	   - Connecté ==> Lorsque l'hôte est trouvé
	   - Reconnu ==> Lorsqu'on peut accéder aux ressources FTP
	   - Fermé ==> Lorsque la connexion au FTP est close \n
	   Elle permet d'afficher les états cités précédemment. */
	void slotStateChanged(int state);
	/*!Cette fonction gère toutes les erreurs FTP. \n
	   Par exemple :
	   - Hôte inconnu
	   - Impossible de se connecter au serveur
	   - Mot de passe incorrect
	   - Login incorrect
	   - etc. \n
	   Elle renvoit un QMessageBox contenant l'erreur */
	void slotDetailledError(const QString & error);

	/*************************************************************
	Gestion des différents changements de dossiers
	*************************************************************/
	/*!Cette fonction permet la remise à jour de la liste FTP. */
	void slotReloadFtpList();
	/*!Cette fonction permet la remise à jour de la liste locale. */
	void slotReloadLocalList();
	/*!Cette fonction permet la remise à jour de la liste courante. */
	void slotReloadList();
	/*!Cette fonction renvoie le nouveau chemin au LineEdit locale. */
	void slotLocalPathChanged();
	/*!Cette fonction renvoie le nouveau chemin au LineEdit du FTP. */
	void slotFtpPathChanged();
	/*!Cette fonction gère l'affichage de la liste locale. \n
	   Elle permet aussi de lancer les logiciels pour l'aperçus des fichiers. */
	void slotChangeLocalPath(QTreeWidgetItem *);
	/*!Cette fonction gère le stockage du chemin dans un QString. \n
	   Elle permet aussi de réactualiser la liste */
	void slotChangeLocalPath(const QString &);
	/*!Cette fonction gère l'affichage de la liste locale. \n
	   Elle permet aussi de lancer les logiciels pour l'aperçus des fichiers. */
	void slotChangeLocalPath();
	/*!Cette fonction gère le stockage du chemin dans un QString. \n
	   Elle renvoie aussi l'affichage dans la liste du FTP grâce à changePath() (cf myftp.h) */
	void slotChangeFtpPath(QTreeWidgetItem *);
	/*!Cette fonction gère le stockage du chemin dans un QString. \n
	   Elle renvoie aussi l'affichage dans la liste du FTP grâce à changePath() (cf myftp.h) */
	void slotChangeFtpPath();
	/*! Permet d'afficher ou de cacher les fichiers cachés. */
	void slotHiddenFiles();

	/*************************************************************
	Actions directs sur les fichiers
	*************************************************************/
	/*!Cette fonction gère l'éxécution d'un fichier local par un programme tiers.  */
	void slotOpenFile();
	/*!Cette fonction gère la suppression de fichier ou dossier (vide). \n
	   Elle est adaptée aux deux listes. */
	void slotRemoveFile();
	/*!Cette fonction gère la création d'un nouveau dossier. \n
	   Elle est adaptée aux deux listes. */
	void slotNewFolder();
	/*!Cette fonction permet de renommer un fichier ou dossier. \n
	   Elle est adaptée aux deux listes." */
	void slotRenameFile();
	/*!Cette fonction gère les downloads de fichiers.\n
	   destDir correspond au sous dossier dans lequel on inclu le fichier. */
	void slotDownload(const QString & destDir = NULL);
	inline void slot_download()
	{
		slotDownload();
	}
	/*!Cette fonction gère les uploads de fichiers.\n
	   destDir correspond au sous dossier dans lequel on inclu le fichier. */
	void slotUpload(const QString & destDir = NULL);
	inline void slot_upload()
	{
		slotUpload();
	}
	/*!Cette fonction affiche le temps restant, la vitesse de téléchargement (ou d'upload), les Ko Restants, et le pourcentage.
	   Pour la vitesse et le temps restant voir aussi slotTmpVit() */
	//void slotDataTransferProgress(qint64 done, qint64 total);
	/*! Cette fonction permet de savoir quand un download est terminé et renvoi le nom du dossier où le transfert s'est terminé */
	void slotDownloadFinished(const QString &destPath, int id, bool error);
	/*! Cette fonction permet de savoir quand un upload est terminé et renvoi le nom du dossier où le transfert s'est terminé */
	void slotUploadFinished(const QString &destPath, int id, bool error);
	/*!Cette fonction lance la boîte de dialogue qui montre les logiciels choisis pour les aperçus */
	void slotExecProg();

	/*************************************************************
	Autres actions...
	*************************************************************/
	/*!Cette fonction permet d'envoyer manuellement une commande ftp */
	void slotCommand();
	/*!Cette fonction lance le dialogue des signets */
	void slotAddSignet();
	/*!Cette fonction permet de choisir la langue du programme */
	void slotSelectLang();

	/*************************************************************
	Gestion de l'affichage
	*************************************************************/
	/*!Cette fonction permet de sélectionner tous les fichiers. */
	void slotSelectAll();
	/*!Cette fonction affiche la barre de menu qui gère les fichiers/dossiers (suppression, renommer, nouveau dossier). */
	void slotAffichToolbarFile();
	/*!Cette fonction affiche la barre de menu qui gère la connection/déconnection au FTP. */
	void slotAffichToolbarConnect();
	/*!Cette fonction affiche la barre de menu qui gère les options de tranfert. */
	void slotAffichToolbarTransfert();
	/*!Cette fonction cache la barre de menu qui gère les fichiers/dossiers (suppression, renommer, nouveau dossier). */
	void slotHideToolbarFile();
	/*!Cette fonction cache la barre de menu qui gère la connection/déconnection au FTP. */
	void slotHideToolbarConnect();
	/*!Cette fonction cache la barre de menu qui gère les options de tranfert. */
	void slotHideToolbarTransfert();
	/*!Cette fonction indique que la liste locale est sélectionnée ==> Pour savoir s'il faut supprimer un fichier en
	      locale ou non, renommer un fichier en locale ou non, etc. */
	void slotLocalSelection(QTreeWidgetItem * = NULL);
	/*!Cette fonction indique que la liste FTP est sélectionnée ==> Pour savoir s'il faut supprimer un fichier en
	      locale ou non, renommer un fichier en locale ou non, etc. */
	void slotFtpSelection(QTreeWidgetItem * = NULL);
	/*!Cette fonction indique que la liste des transferts est sélectionnée. */
	void slotTransferSelection(QTreeWidgetItem * = NULL);
	/*!Cette fonction affiche lors du clic droit les fonctions en locale. */
	void slotPopupLocal(QTreeWidgetItem * item, const QPoint pos);
	/*!Cette fonction affiche lors du clic droit les fonctions sur le FTP. */
	void slotPopupFtp(QTreeWidgetItem * item, const QPoint pos);
	/*!Cette fonction affiche le dialogue pour l'aide. */
	void slotHelp();
	/*!Cette fonction permet d'afficher un message d'attente lorsqu'une action est en cours. */
	void slotCurrentActionChanged(MyFtp::FtpCurrentAction action);
	/*!Cette fonction permet d'afficher la fenêtre principale quand elle est cachée et inversement. */
	void showOrHide();
	/*!Cette fonction permet d'afficher un message lors de la fermeture de la fenêtre principale. */
	void closeEvent (QCloseEvent*);
	/*!Cette fonction permet d'afficher/cacher la fenêtre lors d'un clic sur le trayicon. */
	void trayIconActivated(QSystemTrayIcon::ActivationReason reason);
};

#endif
