/****************************************************************************
** Créé par Anacr0x : anacr0x@free.fr
**
** Sous licence GPL v2 ou plus
****************************************************************************/

#include "basicdialog.h"
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QPushButton>
#include <QLabel>
#include <QFileDialog>

// ////////////////////////////////////////////////////////////////
//
// BasicDialog
//
// ////////////////////////////////////////////////////////////////

void BasicDialog::createInterface(const QString & icon, const QString & title,
                                  const QString & firstLine, QWidget * widget,
                                  const QString & secondLine, bool SelectFileButton,
                                  bool SelectDirButton, bool JustOneButton)
{
	setWindowIcon(QIcon(icon));
	setWindowTitle(title);

	QLabel *firstLabel = new QLabel(firstLine);
	QLabel *secondLabel = NULL;
	if (secondLine != "")
		secondLabel = new QLabel(secondLine);

	QPushButton *okButton = new QPushButton(QIcon(":/images/button_ok.png"), "");
	QPushButton *cancelButton =
	    new QPushButton(QIcon(":/images/button_cancel.png"), "");

	QHBoxLayout *buttonsLayout = new QHBoxLayout;
	buttonsLayout->addWidget(okButton);
	if (!JustOneButton)
		buttonsLayout->addWidget(cancelButton);

	QVBoxLayout *mainLayout = new QVBoxLayout;
	mainLayout->addWidget(firstLabel);

	if (SelectFileButton || SelectDirButton)
	{
		QHBoxLayout *choiceLayout = new QHBoxLayout;
		choiceLayout->addWidget(widget);
		QPushButton *selectButton = new QPushButton("...");
		selectButton->setFixedSize(24, 20);
		choiceLayout->addWidget(selectButton);

		if (SelectFileButton)
			connect(selectButton, SIGNAL(clicked()), this, SLOT(selectFile()));
		else
			connect(selectButton, SIGNAL(clicked()), this, SLOT(selectDir()));

		mainLayout->addLayout(choiceLayout);
	}
	else
		mainLayout->addWidget(widget);


	if (secondLine != "")
		mainLayout->addWidget(secondLabel);
	mainLayout->addLayout(buttonsLayout);
	setLayout(mainLayout);

	connect(okButton, SIGNAL(clicked()), this, SLOT(accept()));
	connect(cancelButton, SIGNAL(clicked()), this, SLOT(reject()));
}

void BasicDialog::selectFile()
{
	QString path = QFileDialog::getOpenFileName(this,
	               "Choose a file",
	               "",
	               "All (*)");

	emit pathSelected(path);
}

void BasicDialog::selectDir()
{
	QString path = QFileDialog::getExistingDirectory(this,
	               "Choose a directory",
	               "",
	               QFileDialog::
	               ShowDirsOnly | QFileDialog::
	               DontResolveSymlinks);

	emit pathSelected(path);
}

BasicLineDialog::BasicLineDialog(const QString & icon, const QString & title,
                                 const QString & firstLine,
                                 const QString & secondLine, QWidget * parent,
                                 bool SelectFileButton,
                                 bool SelectDirButton):BasicDialog(parent)
{
	le = new QLineEdit(this);
	connect(le, SIGNAL(returnPressed()), this, SLOT(accept()));
	createInterface(icon, title, firstLine, le, secondLine, SelectFileButton,
	                SelectDirButton);

	if (SelectFileButton || SelectDirButton)
		connect(this, SIGNAL(pathSelected(const QString &)), this,
		        SLOT(changeEdit(const QString &)));
}

void BasicLineDialog::changeEdit(const QString & path)
{
	le->setText(path);
}

BasicComboDialog::BasicComboDialog(const QString & icon, const QString & title,
                                   const QString & firstLine,
                                   const QString & secondLine,
                                   QWidget * parent):BasicDialog(parent)
{
	cb = new QComboBox(this);
	createInterface(icon, title, firstLine, cb, secondLine);
}

BasicListDialog::BasicListDialog(const QString & icon, const QString & title,
                                 const QString & firstLine,
                                 const QStringList & choices,
                                 const QString & secondLine,
                                 QWidget * parent):BasicDialog(parent)
{
	lw = new QListWidget(this);
	lw->setSelectionMode(QAbstractItemView::SingleSelection);
	lw->addItems(choices);
	lw->setItemSelected(lw->item(0), true);
	connect(lw, SIGNAL(itemDoubleClicked(QListWidgetItem *)), this, SLOT(accept()));
	createInterface(icon, title, firstLine, lw, secondLine);
}

BasicCheckBoxDialog::BasicCheckBoxDialog(const QString & icon, const QString & title,
        const QString & firstLine,
        const QString & checkBoxLine,
        QWidget * parent):BasicDialog(parent)
{
	cb = new QCheckBox(checkBoxLine, this);
	createInterface(icon, title, firstLine, cb, "", false, false, true);
}
