/* rygel-media-export-harvester.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-media-export-harvester.vala, do not modify */

/*
 * Copyright (C) 2010 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-server.h>
#include <rygel-core.h>
#include <glib/gi18n-lib.h>


#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTER (rygel_media_export_harvester_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester))
#define RYGEL_MEDIA_EXPORT_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_HARVESTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))

typedef struct _RygelMediaExportHarvester RygelMediaExportHarvester;
typedef struct _RygelMediaExportHarvesterClass RygelMediaExportHarvesterClass;
typedef struct _RygelMediaExportHarvesterPrivate RygelMediaExportHarvesterPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK (rygel_media_export_harvesting_task_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTask))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))

typedef struct _RygelMediaExportHarvestingTask RygelMediaExportHarvestingTask;
typedef struct _RygelMediaExportHarvestingTaskClass RygelMediaExportHarvestingTaskClass;

#define RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR (rygel_media_export_recursive_file_monitor_get_type ())
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitor))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))

typedef struct _RygelMediaExportRecursiveFileMonitor RygelMediaExportRecursiveFileMonitor;
typedef struct _RygelMediaExportRecursiveFileMonitorClass RygelMediaExportRecursiveFileMonitorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelMediaExportHarvestingTaskPrivate RygelMediaExportHarvestingTaskPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;

#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER (rygel_media_export_trackable_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_TRACKABLE_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainer))
#define RYGEL_MEDIA_EXPORT_TRACKABLE_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_TRACKABLE_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_TRACKABLE_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_TRACKABLE_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainerClass))

typedef struct _RygelMediaExportTrackableDbContainer RygelMediaExportTrackableDbContainer;
typedef struct _RygelMediaExportTrackableDbContainerClass RygelMediaExportTrackableDbContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER (rygel_media_export_writable_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_WRITABLE_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER, RygelMediaExportWritableDbContainer))
#define RYGEL_MEDIA_EXPORT_WRITABLE_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER, RygelMediaExportWritableDbContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_WRITABLE_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_WRITABLE_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_WRITABLE_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER, RygelMediaExportWritableDbContainerClass))

typedef struct _RygelMediaExportWritableDbContainer RygelMediaExportWritableDbContainer;
typedef struct _RygelMediaExportWritableDbContainerClass RygelMediaExportWritableDbContainerClass;
typedef struct _Block5Data Block5Data;

struct _RygelMediaExportHarvester {
	GObject parent_instance;
	RygelMediaExportHarvesterPrivate * priv;
};

struct _RygelMediaExportHarvesterClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportHarvesterPrivate {
	GeeHashMap* tasks;
	GeeHashMap* extraction_grace_timers;
	RygelMediaExportRecursiveFileMonitor* monitor;
	GCancellable* cancellable;
	GeeArrayList* _locations;
};

struct _RygelMediaExportHarvestingTask {
	GObject parent_instance;
	RygelMediaExportHarvestingTaskPrivate * priv;
	GFile* origin;
};

struct _RygelMediaExportHarvestingTaskClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
struct _Block5Data {
	int _ref_count_;
	RygelMediaExportHarvester* self;
	GFile* file;
};


static gpointer rygel_media_export_harvester_parent_class = NULL;

GType rygel_media_export_harvester_get_type (void) G_GNUC_CONST;
GType rygel_media_export_harvesting_task_get_type (void) G_GNUC_CONST;
GType rygel_media_export_recursive_file_monitor_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_HARVESTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_HARVESTER_DUMMY_PROPERTY,
	RYGEL_MEDIA_EXPORT_HARVESTER_LOCATIONS
};
#define RYGEL_MEDIA_EXPORT_HARVESTER_FILE_CHANGE_DEFAULT_GRACE_PERIOD ((guint) 5)
RygelMediaExportHarvester* rygel_media_export_harvester_new (GCancellable* cancellable, GeeArrayList* locations);
RygelMediaExportHarvester* rygel_media_export_harvester_construct (GType object_type, GCancellable* cancellable, GeeArrayList* locations);
static void rygel_media_export_harvester_set_locations (RygelMediaExportHarvester* self, GeeArrayList* value);
GeeArrayList* rygel_media_export_harvester_get_locations (RygelMediaExportHarvester* self);
RygelMediaExportRecursiveFileMonitor* rygel_media_export_recursive_file_monitor_new (GCancellable* cancellable);
RygelMediaExportRecursiveFileMonitor* rygel_media_export_recursive_file_monitor_construct (GType object_type, GCancellable* cancellable);
static void rygel_media_export_harvester_on_file_changed (RygelMediaExportHarvester* self, GFile* file, GFile* other, GFileMonitorEvent event);
static void _rygel_media_export_harvester_on_file_changed_rygel_media_export_recursive_file_monitor_changed (RygelMediaExportRecursiveFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
gboolean rygel_media_export_harvester_is_eligible (GFileInfo* info);
void rygel_media_export_harvester_schedule_locations (RygelMediaExportHarvester* self, RygelMediaContainer* parent);
void rygel_media_export_harvester_schedule (RygelMediaExportHarvester* self, GFile* file, RygelMediaContainer* parent);
void rygel_media_export_harvester_cancel (RygelMediaExportHarvester* self, GFile* file);
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_new (RygelMediaExportRecursiveFileMonitor* monitor, GFile* file, RygelMediaContainer* parent);
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_construct (GType object_type, RygelMediaExportRecursiveFileMonitor* monitor, GFile* file, RygelMediaContainer* parent);
static void rygel_media_export_harvester_on_file_harvested (RygelMediaExportHarvester* self, RygelStateMachine* state_machine);
static void _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
void rygel_media_export_harvesting_task_cancel (RygelMediaExportHarvestingTask* self);
static void rygel_media_export_harvester_on_changes_done (RygelMediaExportHarvester* self, GFile* file, GError** error);
static void rygel_media_export_harvester_on_file_removed (RygelMediaExportHarvester* self, GFile* file);
static void rygel_media_export_harvester_on_file_added (RygelMediaExportHarvester* self, GFile* file);
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (void);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
GQuark rygel_media_export_database_error_quark (void);
RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const gchar* object_id, GError** error);
GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_trackable_db_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_writable_db_container_get_type (void) G_GNUC_CONST;
void rygel_media_export_writable_db_container_remove_tracked (RygelMediaExportWritableDbContainer* self, RygelMediaObject* object, GError** error);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean __lambda6_ (Block5Data* _data5_);
static gboolean ___lambda6__gsource_func (gpointer self);
static void rygel_media_export_harvester_finalize (GObject* obj);
static void _vala_rygel_media_export_harvester_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_export_harvester_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Create a new instance of the meta-data extraction manager.
     */
static gpointer _g_object_ref0 (gpointer self) {
#line 44 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	return self ? g_object_ref (self) : NULL;
#line 206 "rygel-media-export-harvester.c"
}


static void _rygel_media_export_harvester_on_file_changed_rygel_media_export_recursive_file_monitor_changed (RygelMediaExportRecursiveFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_media_export_harvester_on_file_changed ((RygelMediaExportHarvester*) self, file, other_file, event_type);
#line 213 "rygel-media-export-harvester.c"
}


RygelMediaExportHarvester* rygel_media_export_harvester_construct (GType object_type, GCancellable* cancellable, GeeArrayList* locations) {
	RygelMediaExportHarvester * self = NULL;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	GCancellable* _tmp19_ = NULL;
	RygelMediaExportRecursiveFileMonitor* _tmp20_ = NULL;
	RygelMediaExportRecursiveFileMonitor* _tmp21_ = NULL;
	GeeHashMap* _tmp22_ = NULL;
	GeeHashMap* _tmp23_ = NULL;
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_val_if_fail (cancellable != NULL, NULL);
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_val_if_fail (locations != NULL, NULL);
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self = (RygelMediaExportHarvester*) g_object_new (object_type, NULL);
#line 44 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = cancellable;
#line 44 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 44 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 44 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self->priv->cancellable = _tmp1_;
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp2_ = gee_array_list_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeEqualDataFunc) g_file_equal, NULL, NULL);
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp3_ = _tmp2_;
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_media_export_harvester_set_locations (self, _tmp3_);
#line 45 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (_tmp3_);
#line 250 "rygel-media-export-harvester.c"
	{
		GeeArrayList* _file_list = NULL;
		GeeArrayList* _tmp4_ = NULL;
		GeeArrayList* _tmp5_ = NULL;
		gint _file_size = 0;
		GeeArrayList* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _file_index = 0;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp4_ = locations;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_file_list = _tmp5_;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp6_ = _file_list;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp8_ = _tmp7_;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_file_size = _tmp8_;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_file_index = -1;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		while (TRUE) {
#line 278 "rygel-media-export-harvester.c"
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			GFile* file = NULL;
			GeeArrayList* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gpointer _tmp14_ = NULL;
			GFile* _tmp15_ = NULL;
			gboolean _tmp16_ = FALSE;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp9_ = _file_index;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_file_index = _tmp9_ + 1;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp10_ = _file_index;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp11_ = _file_size;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			if (!(_tmp10_ < _tmp11_)) {
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				break;
#line 300 "rygel-media-export-harvester.c"
			}
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp12_ = _file_list;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp13_ = _file_index;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			file = (GFile*) _tmp14_;
#line 47 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp15_ = file;
#line 47 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp16_ = g_file_query_exists (_tmp15_, NULL);
#line 47 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			if (_tmp16_) {
#line 316 "rygel-media-export-harvester.c"
				GeeArrayList* _tmp17_ = NULL;
				GFile* _tmp18_ = NULL;
#line 48 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp17_ = self->priv->_locations;
#line 48 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp18_ = file;
#line 48 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp18_);
#line 325 "rygel-media-export-harvester.c"
			}
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_object_unref0 (file);
#line 329 "rygel-media-export-harvester.c"
		}
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (_file_list);
#line 333 "rygel-media-export-harvester.c"
	}
#line 52 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp19_ = cancellable;
#line 52 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp20_ = rygel_media_export_recursive_file_monitor_new (_tmp19_);
#line 52 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->monitor);
#line 52 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self->priv->monitor = _tmp20_;
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp21_ = self->priv->monitor;
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_signal_connect_object (_tmp21_, "changed", (GCallback) _rygel_media_export_harvester_on_file_changed_rygel_media_export_recursive_file_monitor_changed, self, 0);
#line 55 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp22_ = gee_hash_map_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeHashDataFunc) g_file_hash, NULL, NULL, (GeeEqualDataFunc) g_file_equal, NULL, NULL, NULL, NULL, NULL);
#line 55 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->tasks);
#line 55 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self->priv->tasks = _tmp22_;
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp23_ = gee_hash_map_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, G_TYPE_UINT, NULL, NULL, (GeeHashDataFunc) g_file_hash, NULL, NULL, (GeeEqualDataFunc) g_file_equal, NULL, NULL, NULL, NULL, NULL);
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->extraction_grace_timers);
#line 58 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self->priv->extraction_grace_timers = _tmp23_;
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	return self;
#line 361 "rygel-media-export-harvester.c"
}


RygelMediaExportHarvester* rygel_media_export_harvester_new (GCancellable* cancellable, GeeArrayList* locations) {
#line 42 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	return rygel_media_export_harvester_construct (RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, cancellable, locations);
#line 368 "rygel-media-export-harvester.c"
}


/**
     * Check if a FileInfo is considered for extraction
     *
     * @param info a FileInfo
     * @return true if file should be extracted, false otherwise
     */
gboolean rygel_media_export_harvester_is_eligible (GFileInfo* info) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GFileInfo* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
#line 69 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_val_if_fail (info != NULL, FALSE);
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp6_ = info;
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp7_ = g_file_info_get_content_type (_tmp6_);
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp8_ = g_str_has_prefix (_tmp7_, "image/");
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp8_) {
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp5_ = TRUE;
#line 401 "rygel-media-export-harvester.c"
	} else {
		GFileInfo* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp9_ = info;
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp10_ = g_file_info_get_content_type (_tmp9_);
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp11_ = g_str_has_prefix (_tmp10_, "video/");
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp5_ = _tmp11_;
#line 414 "rygel-media-export-harvester.c"
	}
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp5_) {
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp4_ = TRUE;
#line 420 "rygel-media-export-harvester.c"
	} else {
		GFileInfo* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp12_ = info;
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp13_ = g_file_info_get_content_type (_tmp12_);
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp14_ = g_str_has_prefix (_tmp13_, "audio/");
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp4_ = _tmp14_;
#line 433 "rygel-media-export-harvester.c"
	}
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp4_) {
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp3_ = TRUE;
#line 439 "rygel-media-export-harvester.c"
	} else {
		GFileInfo* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
#line 73 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp15_ = info;
#line 73 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp16_ = g_file_info_get_content_type (_tmp15_);
#line 73 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp3_ = g_strcmp0 (_tmp16_, "application/ogg") == 0;
#line 449 "rygel-media-export-harvester.c"
	}
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp3_) {
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp2_ = TRUE;
#line 455 "rygel-media-export-harvester.c"
	} else {
		GFileInfo* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp17_ = info;
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp18_ = g_file_info_get_content_type (_tmp17_);
#line 74 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp2_ = g_strcmp0 (_tmp18_, "application/xml") == 0;
#line 465 "rygel-media-export-harvester.c"
	}
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp2_) {
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp1_ = TRUE;
#line 471 "rygel-media-export-harvester.c"
	} else {
		GFileInfo* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp19_ = info;
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp20_ = g_file_info_get_content_type (_tmp19_);
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp1_ = g_strcmp0 (_tmp20_, "text/xml") == 0;
#line 481 "rygel-media-export-harvester.c"
	}
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp1_) {
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp0_ = TRUE;
#line 487 "rygel-media-export-harvester.c"
	} else {
		GFileInfo* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp21_ = info;
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp22_ = g_file_info_get_content_type (_tmp21_);
#line 76 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp0_ = g_strcmp0 (_tmp22_, "text/plain") == 0;
#line 497 "rygel-media-export-harvester.c"
	}
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	result = _tmp0_;
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	return result;
#line 503 "rygel-media-export-harvester.c"
}


/**
     * Schedule rescan of all top-level locations known to the harvester.
     *
     * @param parent top-level container of the files
     */
void rygel_media_export_harvester_schedule_locations (RygelMediaExportHarvester* self, RygelMediaContainer* parent) {
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 84 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (parent != NULL);
#line 517 "rygel-media-export-harvester.c"
	{
		GeeArrayList* _file_list = NULL;
		GeeArrayList* _tmp0_ = NULL;
		GeeArrayList* _tmp1_ = NULL;
		gint _file_size = 0;
		GeeArrayList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _file_index = 0;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp0_ = self->priv->_locations;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_file_list = _tmp1_;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp2_ = _file_list;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp4_ = _tmp3_;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_file_size = _tmp4_;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_file_index = -1;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		while (TRUE) {
#line 545 "rygel-media-export-harvester.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			GFile* file = NULL;
			GeeArrayList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			GFile* _tmp11_ = NULL;
			RygelMediaContainer* _tmp12_ = NULL;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp5_ = _file_index;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_file_index = _tmp5_ + 1;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp6_ = _file_index;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp7_ = _file_size;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				break;
#line 567 "rygel-media-export-harvester.c"
			}
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp8_ = _file_list;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp9_ = _file_index;
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			file = (GFile*) _tmp10_;
#line 86 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp11_ = file;
#line 86 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp12_ = parent;
#line 86 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			rygel_media_export_harvester_schedule (self, _tmp11_, _tmp12_);
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_object_unref0 (file);
#line 585 "rygel-media-export-harvester.c"
		}
#line 85 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (_file_list);
#line 589 "rygel-media-export-harvester.c"
	}
}


/**
     * Put a file on queue for meta-data extraction
     *
     * @param file the file to investigate
     * @param parent container of the filer to be harvested
     */
static void _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_media_export_harvester_on_file_harvested ((RygelMediaExportHarvester*) self, _sender);
#line 603 "rygel-media-export-harvester.c"
}


void rygel_media_export_harvester_schedule (RygelMediaExportHarvester* self, GFile* file, RygelMediaContainer* parent) {
	GeeHashMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	RygelMediaExportHarvestingTask* task = NULL;
	RygelMediaExportRecursiveFileMonitor* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	RygelMediaContainer* _tmp5_ = NULL;
	RygelMediaExportHarvestingTask* _tmp6_ = NULL;
	GCancellable* _tmp7_ = NULL;
	GeeHashMap* _tmp8_ = NULL;
	GFile* _tmp9_ = NULL;
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (file != NULL);
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (parent != NULL);
#line 98 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = self->priv->extraction_grace_timers;
#line 98 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = file;
#line 98 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp0_, _tmp1_, NULL);
#line 101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp2_ = file;
#line 101 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_media_export_harvester_cancel (self, _tmp2_);
#line 103 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp3_ = self->priv->monitor;
#line 103 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp4_ = file;
#line 103 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp5_ = parent;
#line 103 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp6_ = rygel_media_export_harvesting_task_new (_tmp3_, _tmp4_, _tmp5_);
#line 103 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	task = _tmp6_;
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp7_ = self->priv->cancellable;
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) task, _tmp7_);
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_signal_connect_object ((RygelStateMachine*) task, "completed", (GCallback) _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed, self, 0);
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp8_ = self->priv->tasks;
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp9_ = file;
#line 108 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, _tmp9_, task);
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_state_machine_run ((RygelStateMachine*) task, NULL, NULL);
#line 96 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (task);
#line 661 "rygel-media-export-harvester.c"
}


/**
     * Cancel a running meta-data extraction run
     *
     * @param file file cancel the current run for
     */
void rygel_media_export_harvester_cancel (RygelMediaExportHarvester* self, GFile* file) {
	GeeHashMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 117 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 117 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (file != NULL);
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = self->priv->tasks;
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = file;
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp1_);
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp2_) {
#line 686 "rygel-media-export-harvester.c"
		RygelMediaExportHarvestingTask* task = NULL;
		GeeHashMap* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		RygelMediaExportHarvestingTask* _tmp6_ = NULL;
		guint _tmp7_ = 0U;
		GeeHashMap* _tmp8_ = NULL;
		GFile* _tmp9_ = NULL;
		RygelMediaExportHarvestingTask* _tmp10_ = NULL;
#line 119 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp3_ = self->priv->tasks;
#line 119 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp4_ = file;
#line 119 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp4_);
#line 119 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		task = (RygelMediaExportHarvestingTask*) _tmp5_;
#line 120 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp6_ = task;
#line 120 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_signal_parse_name ("completed", RYGEL_TYPE_STATE_MACHINE, &_tmp7_, NULL, FALSE);
#line 120 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_signal_handlers_disconnect_matched ((RygelStateMachine*) _tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed, self);
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp8_ = self->priv->tasks;
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp9_ = file;
#line 121 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp8_, _tmp9_, NULL);
#line 122 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp10_ = task;
#line 122 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		rygel_media_export_harvesting_task_cancel (_tmp10_);
#line 118 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (task);
#line 722 "rygel-media-export-harvester.c"
	}
}


/**
     * Callback for finished harvester.
     *
     * Updates book-keeping hash.
     * @param state_machine HarvestingTask sending the event
     */
static void rygel_media_export_harvester_on_file_harvested (RygelMediaExportHarvester* self, RygelStateMachine* state_machine) {
	RygelMediaExportHarvestingTask* task = NULL;
	RygelStateMachine* _tmp0_ = NULL;
	RygelMediaExportHarvestingTask* _tmp1_ = NULL;
	GFile* file = NULL;
	RygelMediaExportHarvestingTask* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GeeHashMap* _tmp9_ = NULL;
	GFile* _tmp10_ = NULL;
	GeeHashMap* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (state_machine != NULL);
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = state_machine;
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK) ? ((RygelMediaExportHarvestingTask*) _tmp0_) : NULL);
#line 133 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	task = _tmp1_;
#line 134 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp2_ = task;
#line 134 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp3_ = _tmp2_->origin;
#line 134 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 134 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	file = _tmp4_;
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp5_ = _ ("'%s' harvested");
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp6_ = file;
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp7_ = g_file_get_uri (_tmp6_);
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp8_ = _tmp7_;
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_message (_tmp5_, _tmp8_);
#line 135 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_free0 (_tmp8_);
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp9_ = self->priv->tasks;
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp10_ = file;
#line 137 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp9_, _tmp10_, NULL);
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp11_ = self->priv->tasks;
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp12_ = gee_map_get_is_empty ((GeeMap*) _tmp11_);
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp13_ = _tmp12_;
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp13_) {
#line 139 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_signal_emit_by_name (self, "done");
#line 796 "rygel-media-export-harvester.c"
	}
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (file);
#line 132 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (task);
#line 802 "rygel-media-export-harvester.c"
}


static void rygel_media_export_harvester_on_file_changed (RygelMediaExportHarvester* self, GFile* file, GFile* other, GFileMonitorEvent event) {
	GError * _inner_error_ = NULL;
#line 143 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 143 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (file != NULL);
#line 812 "rygel-media-export-harvester.c"
	{
		GFileMonitorEvent _tmp0_ = 0;
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp0_ = event;
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		switch (_tmp0_) {
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			case G_FILE_MONITOR_EVENT_CREATED:
#line 821 "rygel-media-export-harvester.c"
			{
				{
					GFileInfo* info = NULL;
					GFile* _tmp1_ = NULL;
					GCancellable* _tmp2_ = NULL;
					GFileInfo* _tmp3_ = NULL;
					GFileInfo* _tmp4_ = NULL;
					GFileType _tmp5_ = 0;
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					_tmp1_ = file;
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					_tmp2_ = self->priv->cancellable;
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					_tmp3_ = g_file_query_info (_tmp1_, G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_QUERY_INFO_NONE, _tmp2_, &_inner_error_);
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					info = _tmp3_;
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 840 "rygel-media-export-harvester.c"
						goto __catch59_g_error;
					}
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					_tmp4_ = info;
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					_tmp5_ = g_file_info_get_file_type (_tmp4_);
#line 153 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					if (_tmp5_ == G_FILE_TYPE_DIRECTORY) {
#line 849 "rygel-media-export-harvester.c"
						GFile* _tmp6_ = NULL;
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						_tmp6_ = file;
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						rygel_media_export_harvester_on_changes_done (self, _tmp6_, &_inner_error_);
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
							_g_object_unref0 (info);
#line 859 "rygel-media-export-harvester.c"
							goto __catch59_g_error;
						}
					}
#line 156 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					_g_object_unref0 (info);
#line 156 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					break;
#line 867 "rygel-media-export-harvester.c"
				}
			}
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			case G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT:
#line 872 "rygel-media-export-harvester.c"
			{
				GFile* _tmp7_ = NULL;
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp7_ = file;
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				rygel_media_export_harvester_on_changes_done (self, _tmp7_, &_inner_error_);
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 881 "rygel-media-export-harvester.c"
					goto __catch59_g_error;
				}
#line 160 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				break;
#line 886 "rygel-media-export-harvester.c"
			}
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			case G_FILE_MONITOR_EVENT_DELETED:
#line 890 "rygel-media-export-harvester.c"
			{
				GFile* _tmp8_ = NULL;
#line 162 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp8_ = file;
#line 162 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				rygel_media_export_harvester_on_file_removed (self, _tmp8_);
#line 163 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				break;
#line 899 "rygel-media-export-harvester.c"
			}
			default:
			{
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				break;
#line 905 "rygel-media-export-harvester.c"
			}
		}
	}
	goto __finally59;
	__catch59_g_error:
	{
		GError* _error_ = NULL;
		GFile* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		GError* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_error_ = _inner_error_;
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_inner_error_ = NULL;
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp9_ = file;
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp10_ = g_file_get_uri (_tmp9_);
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp11_ = _tmp10_;
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp12_ = _error_;
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp13_ = _tmp12_->message;
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_debug ("rygel-media-export-harvester.vala:168: Failed to query information for" \
" %s: %s", _tmp11_, _tmp13_);
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_free0 (_tmp11_);
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_error_free0 (_error_);
#line 938 "rygel-media-export-harvester.c"
	}
	__finally59:
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_clear_error (&_inner_error_);
#line 146 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		return;
#line 949 "rygel-media-export-harvester.c"
	}
}


static void rygel_media_export_harvester_on_file_added (RygelMediaExportHarvester* self, GFile* file) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (file != NULL);
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = file;
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = g_file_get_uri (_tmp0_);
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp2_ = _tmp1_;
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_debug ("rygel-media-export-harvester.vala:175: Filesystem events settled for %" \
"s, scheduling extraction…", _tmp2_);
#line 175 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_free0 (_tmp2_);
#line 973 "rygel-media-export-harvester.c"
	{
		RygelMediaExportMediaCache* cache = NULL;
		RygelMediaExportMediaCache* _tmp3_ = NULL;
		GFileInfo* info = NULL;
		GFile* _tmp4_ = NULL;
		GCancellable* _tmp5_ = NULL;
		GFileInfo* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		GFileType _tmp8_ = 0;
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp3_ = rygel_media_export_media_cache_get_default ();
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		cache = _tmp3_;
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp4_ = file;
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp5_ = self->priv->cancellable;
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp6_ = g_file_query_info (_tmp4_, G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, _tmp5_, &_inner_error_);
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		info = _tmp6_;
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_object_unref0 (cache);
#line 999 "rygel-media-export-harvester.c"
			goto __catch60_g_error;
		}
#line 183 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp8_ = g_file_info_get_file_type (info);
#line 183 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		if (_tmp8_ == G_FILE_TYPE_DIRECTORY) {
#line 183 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp7_ = TRUE;
#line 1008 "rygel-media-export-harvester.c"
		} else {
			gboolean _tmp9_ = FALSE;
#line 184 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp9_ = rygel_media_export_harvester_is_eligible (info);
#line 184 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp7_ = _tmp9_;
#line 1015 "rygel-media-export-harvester.c"
		}
#line 183 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		if (_tmp7_) {
#line 1019 "rygel-media-export-harvester.c"
			gchar* id = NULL;
			GFile* _tmp10_ = NULL;
			GFile* _tmp11_ = NULL;
			GFile* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
#line 185 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp10_ = file;
#line 185 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp11_ = g_file_get_parent (_tmp10_);
#line 185 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp12_ = _tmp11_;
#line 185 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp13_ = rygel_media_export_media_cache_get_id (_tmp12_);
#line 185 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp14_ = _tmp13_;
#line 185 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_object_unref0 (_tmp12_);
#line 185 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			id = _tmp14_;
#line 1040 "rygel-media-export-harvester.c"
			{
				RygelMediaObject* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				RygelMediaObject* _tmp17_ = NULL;
				RygelMediaContainer* parent_container = NULL;
				RygelMediaObject* _tmp18_ = NULL;
				RygelMediaContainer* _tmp19_ = NULL;
				GFile* _tmp20_ = NULL;
				RygelMediaContainer* _tmp21_ = NULL;
#line 187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp16_ = id;
#line 187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp17_ = rygel_media_export_media_cache_get_object (cache, _tmp16_, &_inner_error_);
#line 187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp15_ = _tmp17_;
#line 187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 1060 "rygel-media-export-harvester.c"
						goto __catch61_rygel_media_export_database_error;
					}
#line 187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					_g_free0 (id);
#line 187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					_g_object_unref0 (info);
#line 187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					_g_object_unref0 (cache);
#line 187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					g_clear_error (&_inner_error_);
#line 187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					return;
#line 1075 "rygel-media-export-harvester.c"
				}
#line 187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp18_ = _tmp15_;
#line 187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp15_ = NULL;
#line 187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp19_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp18_) : NULL;
#line 187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				if (_tmp19_ == NULL) {
#line 187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					_g_object_unref0 (_tmp18_);
#line 1087 "rygel-media-export-harvester.c"
				}
#line 187 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				parent_container = _tmp19_;
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp20_ = file;
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp21_ = parent_container;
#line 189 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				rygel_media_export_harvester_schedule (self, _tmp20_, _tmp21_);
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_object_unref0 (parent_container);
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_object_unref0 (_tmp15_);
#line 1101 "rygel-media-export-harvester.c"
			}
			goto __finally61;
			__catch61_rygel_media_export_database_error:
			{
				GError* _error_ = NULL;
				const gchar* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				GError* _tmp24_ = NULL;
				const gchar* _tmp25_ = NULL;
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_error_ = _inner_error_;
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_inner_error_ = NULL;
#line 191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp22_ = _ ("Error fetching object '%s' from database: %s");
#line 191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp23_ = id;
#line 191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp24_ = _error_;
#line 191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp25_ = _tmp24_->message;
#line 191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				g_warning (_tmp22_, _tmp23_, _tmp25_);
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_error_free0 (_error_);
#line 1127 "rygel-media-export-harvester.c"
			}
			__finally61:
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_free0 (id);
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_object_unref0 (info);
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_object_unref0 (cache);
#line 1138 "rygel-media-export-harvester.c"
				goto __catch60_g_error;
			}
#line 183 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_free0 (id);
#line 1143 "rygel-media-export-harvester.c"
		} else {
			GFile* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
#line 196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp26_ = file;
#line 196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp27_ = g_file_get_uri (_tmp26_);
#line 196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp28_ = _tmp27_;
#line 196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			g_debug ("rygel-media-export-harvester.vala:196: %s is not eligible for extracti" \
"on", _tmp28_);
#line 196 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_free0 (_tmp28_);
#line 1158 "rygel-media-export-harvester.c"
		}
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (info);
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (cache);
#line 1164 "rygel-media-export-harvester.c"
	}
	goto __finally60;
	__catch60_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp29_ = NULL;
		GFile* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		GError* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_error_ = _inner_error_;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_inner_error_ = NULL;
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp29_ = _ ("Failed to query info of a file %s: %s");
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp30_ = file;
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp31_ = g_file_get_uri (_tmp30_);
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp32_ = _tmp31_;
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp33_ = _error_;
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp34_ = _tmp33_->message;
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_warning (_tmp29_, _tmp32_, _tmp34_);
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_free0 (_tmp32_);
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_error_free0 (_error_);
#line 1198 "rygel-media-export-harvester.c"
	}
	__finally60:
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_clear_error (&_inner_error_);
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		return;
#line 1209 "rygel-media-export-harvester.c"
	}
}


static void rygel_media_export_harvester_on_file_removed (RygelMediaExportHarvester* self, GFile* file) {
	RygelMediaExportMediaCache* cache = NULL;
	RygelMediaExportMediaCache* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GFile* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
#line 205 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 205 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (file != NULL);
#line 206 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = rygel_media_export_media_cache_get_default ();
#line 206 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	cache = _tmp0_;
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = self->priv->extraction_grace_timers;
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp2_ = file;
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, _tmp2_);
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp3_) {
#line 1238 "rygel-media-export-harvester.c"
		GeeHashMap* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
		gpointer _tmp6_ = NULL;
		GeeHashMap* _tmp7_ = NULL;
		GFile* _tmp8_ = NULL;
#line 208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp4_ = self->priv->extraction_grace_timers;
#line 208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp5_ = file;
#line 208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
#line 208 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_source_remove ((guint) ((guintptr) _tmp6_));
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp7_ = self->priv->extraction_grace_timers;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp8_ = file;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp7_, _tmp8_, NULL);
#line 1258 "rygel-media-export-harvester.c"
	}
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp9_ = file;
#line 212 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_media_export_harvester_cancel (self, _tmp9_);
#line 1264 "rygel-media-export-harvester.c"
	{
		gchar* id = NULL;
		GFile* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		RygelMediaObject* object = NULL;
		RygelMediaExportMediaCache* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		RygelMediaObject* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		RygelMediaObject* _tmp16_ = NULL;
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp10_ = file;
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp11_ = rygel_media_export_media_cache_get_id (_tmp10_);
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		id = _tmp11_;
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp12_ = cache;
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp13_ = id;
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp14_ = rygel_media_export_media_cache_get_object (_tmp12_, _tmp13_, &_inner_error_);
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		object = _tmp14_;
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_free0 (id);
#line 1293 "rygel-media-export-harvester.c"
			goto __catch62_g_error;
		}
#line 220 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp16_ = object;
#line 220 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		if (_tmp16_ != NULL) {
#line 1300 "rygel-media-export-harvester.c"
			RygelMediaObject* _tmp17_ = NULL;
			RygelMediaContainer* _tmp18_ = NULL;
			RygelMediaContainer* _tmp19_ = NULL;
#line 220 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp17_ = object;
#line 220 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp18_ = rygel_media_object_get_parent (_tmp17_);
#line 220 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp19_ = _tmp18_;
#line 220 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp15_ = _tmp19_ != NULL;
#line 1312 "rygel-media-export-harvester.c"
		} else {
#line 220 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp15_ = FALSE;
#line 1316 "rygel-media-export-harvester.c"
		}
#line 220 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		if (_tmp15_) {
#line 1320 "rygel-media-export-harvester.c"
			RygelMediaContainer* parent = NULL;
			RygelMediaObject* _tmp20_ = NULL;
			RygelMediaContainer* _tmp21_ = NULL;
			RygelMediaContainer* _tmp22_ = NULL;
			RygelMediaContainer* _tmp23_ = NULL;
			RygelMediaContainer* _tmp24_ = NULL;
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp20_ = object;
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp21_ = rygel_media_object_get_parent (_tmp20_);
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp22_ = _tmp21_;
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp23_ = _g_object_ref0 (_tmp22_);
#line 221 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			parent = _tmp23_;
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp24_ = parent;
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER)) {
#line 1341 "rygel-media-export-harvester.c"
				RygelMediaExportWritableDbContainer* container = NULL;
				RygelMediaContainer* _tmp25_ = NULL;
				RygelMediaExportWritableDbContainer* _tmp26_ = NULL;
				RygelMediaExportWritableDbContainer* _tmp27_ = NULL;
				RygelMediaObject* _tmp28_ = NULL;
#line 224 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp25_ = parent;
#line 224 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER) ? ((RygelMediaExportWritableDbContainer*) _tmp25_) : NULL);
#line 224 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				container = _tmp26_;
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp27_ = container;
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp28_ = object;
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				rygel_media_export_writable_db_container_remove_tracked (_tmp27_, _tmp28_, &_inner_error_);
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					_g_object_unref0 (container);
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					_g_object_unref0 (parent);
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					_g_object_unref0 (object);
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					_g_free0 (id);
#line 1369 "rygel-media-export-harvester.c"
					goto __catch62_g_error;
				}
#line 223 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_g_object_unref0 (container);
#line 1374 "rygel-media-export-harvester.c"
			} else {
				RygelMediaContainer* _tmp29_ = NULL;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				_tmp29_ = parent;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER)) {
#line 1381 "rygel-media-export-harvester.c"
					RygelTrackableContainer* container = NULL;
					RygelMediaContainer* _tmp30_ = NULL;
					RygelTrackableContainer* _tmp31_ = NULL;
					RygelTrackableContainer* _tmp32_ = NULL;
					RygelMediaObject* _tmp33_ = NULL;
#line 229 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					_tmp30_ = parent;
#line 229 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, RYGEL_TYPE_TRACKABLE_CONTAINER) ? ((RygelTrackableContainer*) _tmp30_) : NULL);
#line 229 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					container = _tmp31_;
#line 231 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					_tmp32_ = container;
#line 231 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					_tmp33_ = object;
#line 231 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					rygel_trackable_container_remove_child_tracked (_tmp32_, _tmp33_, NULL, NULL);
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
					_g_object_unref0 (container);
#line 1401 "rygel-media-export-harvester.c"
				}
			}
#line 220 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_object_unref0 (parent);
#line 1406 "rygel-media-export-harvester.c"
		} else {
			const gchar* _tmp34_ = NULL;
			const gchar* _tmp35_ = NULL;
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp34_ = _ ("Could not find object %s or its parent. Database is inconsistent");
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp35_ = id;
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			g_warning (_tmp34_, _tmp35_);
#line 1416 "rygel-media-export-harvester.c"
		}
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (object);
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_free0 (id);
#line 1422 "rygel-media-export-harvester.c"
	}
	goto __finally62;
	__catch62_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp36_ = NULL;
		GError* _tmp37_ = NULL;
		const gchar* _tmp38_ = NULL;
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_error_ = _inner_error_;
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_inner_error_ = NULL;
#line 238 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp36_ = _ ("Error removing object from database: %s");
#line 238 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp37_ = _error_;
#line 238 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp38_ = _tmp37_->message;
#line 238 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_warning (_tmp36_, _tmp38_);
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_error_free0 (_error_);
#line 1445 "rygel-media-export-harvester.c"
	}
	__finally62:
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (cache);
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_clear_error (&_inner_error_);
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		return;
#line 1458 "rygel-media-export-harvester.c"
	}
#line 205 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (cache);
#line 1462 "rygel-media-export-harvester.c"
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	return _data5_;
#line 1471 "rygel-media-export-harvester.c"
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 1480 "rygel-media-export-harvester.c"
		RygelMediaExportHarvester* self;
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		self = _data5_->self;
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (_data5_->file);
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (self);
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_slice_free (Block5Data, _data5_);
#line 1490 "rygel-media-export-harvester.c"
	}
}


static gboolean __lambda6_ (Block5Data* _data5_) {
	RygelMediaExportHarvester* self;
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
#line 265 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self = _data5_->self;
#line 266 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = _data5_->file;
#line 266 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_media_export_harvester_on_file_added (self, _tmp0_);
#line 268 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	result = FALSE;
#line 268 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	return result;
#line 1509 "rygel-media-export-harvester.c"
}


static gboolean ___lambda6__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda6_ (self);
#line 265 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	return result;
#line 1518 "rygel-media-export-harvester.c"
}


static void rygel_media_export_harvester_on_changes_done (RygelMediaExportHarvester* self, GFile* file, GError** error) {
	Block5Data* _data5_;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	guint period = 0U;
	GeeHashMap* _tmp11_ = NULL;
	GFile* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	GSourceFunc callback = NULL;
	void* callback_target = NULL;
	GDestroyNotify callback_target_destroy_notify = NULL;
	guint _tmp21_ = 0U;
	GError * _inner_error_ = NULL;
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (file != NULL);
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_data5_ = g_slice_new0 (Block5Data);
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_data5_->_ref_count_ = 1;
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_data5_->self = g_object_ref (self);
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = file;
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (_data5_->file);
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_data5_->file = _tmp1_;
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp2_ = _data5_->file;
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp3_ = g_file_get_basename (_tmp2_);
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp4_ = _tmp3_;
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp5_ = g_str_has_prefix (_tmp4_, ".");
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp6_ = _tmp5_;
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_free0 (_tmp4_);
#line 244 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp6_) {
#line 245 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		block5_data_unref (_data5_);
#line 245 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_data5_ = NULL;
#line 245 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		return;
#line 1578 "rygel-media-export-harvester.c"
	}
#line 248 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	period = RYGEL_MEDIA_EXPORT_HARVESTER_FILE_CHANGE_DEFAULT_GRACE_PERIOD;
#line 1582 "rygel-media-export-harvester.c"
	{
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		RygelMetaConfig* _tmp9_ = NULL;
		gint _tmp10_ = 0;
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp7_ = rygel_meta_config_get_default ();
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		config = _tmp7_;
#line 251 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp9_ = config;
#line 251 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp10_ = rygel_configuration_get_int ((RygelConfiguration*) _tmp9_, "MediaExport", "monitor-grace-timeout", 0, 500, &_inner_error_);
#line 251 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp8_ = _tmp10_;
#line 251 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 251 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_object_unref0 (config);
#line 1603 "rygel-media-export-harvester.c"
			goto __catch63_g_error;
		}
#line 251 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		period = (guint) _tmp8_;
#line 249 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_object_unref0 (config);
#line 1610 "rygel-media-export-harvester.c"
	}
	goto __finally63;
	__catch63_g_error:
	{
		GError* _error_ = NULL;
#line 249 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_error_ = _inner_error_;
#line 249 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_inner_error_ = NULL;
#line 249 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_g_error_free0 (_error_);
#line 1622 "rygel-media-export-harvester.c"
	}
	__finally63:
#line 249 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 249 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_propagate_error (error, _inner_error_);
#line 249 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		block5_data_unref (_data5_);
#line 249 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_data5_ = NULL;
#line 249 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		return;
#line 1635 "rygel-media-export-harvester.c"
	}
#line 258 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp11_ = self->priv->extraction_grace_timers;
#line 258 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp12_ = _data5_->file;
#line 258 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp13_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp11_, _tmp12_);
#line 258 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp13_) {
#line 1645 "rygel-media-export-harvester.c"
		GeeHashMap* _tmp14_ = NULL;
		GFile* _tmp15_ = NULL;
		gpointer _tmp16_ = NULL;
#line 259 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp14_ = self->priv->extraction_grace_timers;
#line 259 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp15_ = _data5_->file;
#line 259 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp14_, _tmp15_);
#line 259 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_source_remove ((guint) ((guintptr) _tmp16_));
#line 1657 "rygel-media-export-harvester.c"
	} else {
		guint _tmp17_ = 0U;
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp17_ = period;
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		if (_tmp17_ > ((guint) 0)) {
#line 1664 "rygel-media-export-harvester.c"
			GFile* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp18_ = _data5_->file;
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp19_ = g_file_get_uri (_tmp18_);
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_tmp20_ = _tmp19_;
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			g_debug ("rygel-media-export-harvester.vala:261: Starting grace timer for harves" \
"ting %s…", _tmp20_);
#line 261 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
			_g_free0 (_tmp20_);
#line 1678 "rygel-media-export-harvester.c"
		}
	}
#line 265 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	callback = ___lambda6__gsource_func;
#line 265 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	callback_target = block5_data_ref (_data5_);
#line 265 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	callback_target_destroy_notify = block5_data_unref;
#line 271 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp21_ = period;
#line 271 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	if (_tmp21_ > ((guint) 0)) {
#line 1691 "rygel-media-export-harvester.c"
		guint timeout = 0U;
		GSourceFunc _tmp22_ = NULL;
		void* _tmp22__target = NULL;
		GDestroyNotify _tmp22__target_destroy_notify = NULL;
		guint _tmp23_ = 0U;
		GeeHashMap* _tmp24_ = NULL;
		GFile* _tmp25_ = NULL;
		guint _tmp26_ = 0U;
#line 272 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp22_ = callback;
#line 272 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp22__target = callback_target;
#line 272 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp22__target_destroy_notify = callback_target_destroy_notify;
#line 272 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		callback_target_destroy_notify = NULL;
#line 272 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp23_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, RYGEL_MEDIA_EXPORT_HARVESTER_FILE_CHANGE_DEFAULT_GRACE_PERIOD, _tmp22_, _tmp22__target, _tmp22__target_destroy_notify);
#line 272 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		timeout = _tmp23_;
#line 274 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp24_ = self->priv->extraction_grace_timers;
#line 274 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp25_ = _data5_->file;
#line 274 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp26_ = timeout;
#line 274 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp24_, _tmp25_, (gpointer) ((guintptr) _tmp26_));
#line 1720 "rygel-media-export-harvester.c"
	} else {
		GSourceFunc _tmp27_ = NULL;
		void* _tmp27__target = NULL;
		GDestroyNotify _tmp27__target_destroy_notify = NULL;
#line 276 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp27_ = callback;
#line 276 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp27__target = callback_target;
#line 276 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		_tmp27__target_destroy_notify = callback_target_destroy_notify;
#line 276 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		callback_target_destroy_notify = NULL;
#line 276 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp27_, _tmp27__target, _tmp27__target_destroy_notify);
#line 1735 "rygel-media-export-harvester.c"
	}
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	callback = NULL;
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	callback_target = NULL;
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	callback_target_destroy_notify = NULL;
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	block5_data_unref (_data5_);
#line 243 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_data5_ = NULL;
#line 1749 "rygel-media-export-harvester.c"
}


GeeArrayList* rygel_media_export_harvester_get_locations (RygelMediaExportHarvester* self) {
	GeeArrayList* result;
	GeeArrayList* _tmp0_ = NULL;
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = self->priv->_locations;
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	result = _tmp0_;
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	return result;
#line 1764 "rygel-media-export-harvester.c"
}


static void rygel_media_export_harvester_set_locations (RygelMediaExportHarvester* self, GeeArrayList* value) {
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_return_if_fail (self != NULL);
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp0_ = value;
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->_locations);
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self->priv->_locations = _tmp1_;
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_object_notify ((GObject *) self, "locations");
#line 1783 "rygel-media-export-harvester.c"
}


static void rygel_media_export_harvester_class_init (RygelMediaExportHarvesterClass * klass) {
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	rygel_media_export_harvester_parent_class = g_type_class_peek_parent (klass);
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaExportHarvesterPrivate));
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_export_harvester_get_property;
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_export_harvester_set_property;
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_harvester_finalize;
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_EXPORT_HARVESTER_LOCATIONS, g_param_spec_object ("locations", "locations", "locations", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	g_signal_new ("done", RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1802 "rygel-media-export-harvester.c"
}


static void rygel_media_export_harvester_instance_init (RygelMediaExportHarvester * self) {
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self->priv = RYGEL_MEDIA_EXPORT_HARVESTER_GET_PRIVATE (self);
#line 1809 "rygel-media-export-harvester.c"
}


static void rygel_media_export_harvester_finalize (GObject* obj) {
	RygelMediaExportHarvester * self;
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester);
#line 29 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->tasks);
#line 30 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->extraction_grace_timers);
#line 31 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->monitor);
#line 32 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 35 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	_g_object_unref0 (self->priv->_locations);
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	G_OBJECT_CLASS (rygel_media_export_harvester_parent_class)->finalize (obj);
#line 1829 "rygel-media-export-harvester.c"
}


/**
 * This class takes care of the book-keeping of running and finished
 * extraction tasks running within the media-export plugin
 */
GType rygel_media_export_harvester_get_type (void) {
	static volatile gsize rygel_media_export_harvester_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_harvester_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportHarvesterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_harvester_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportHarvester), 0, (GInstanceInitFunc) rygel_media_export_harvester_instance_init, NULL };
		GType rygel_media_export_harvester_type_id;
		rygel_media_export_harvester_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportHarvester", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_harvester_type_id__volatile, rygel_media_export_harvester_type_id);
	}
	return rygel_media_export_harvester_type_id__volatile;
}


static void _vala_rygel_media_export_harvester_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaExportHarvester * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester);
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	switch (property_id) {
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		case RYGEL_MEDIA_EXPORT_HARVESTER_LOCATIONS:
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		g_value_set_object (value, rygel_media_export_harvester_get_locations (self));
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		break;
#line 1860 "rygel-media-export-harvester.c"
		default:
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		break;
#line 1866 "rygel-media-export-harvester.c"
	}
}


static void _vala_rygel_media_export_harvester_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaExportHarvester * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester);
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
	switch (property_id) {
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		case RYGEL_MEDIA_EXPORT_HARVESTER_LOCATIONS:
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		rygel_media_export_harvester_set_locations (self, g_value_get_object (value));
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		break;
#line 1882 "rygel-media-export-harvester.c"
		default:
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvester.vala"
		break;
#line 1888 "rygel-media-export-harvester.c"
	}
}



