/* rygel-search.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-search.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_MEDIA_QUERY_ACTION (rygel_media_query_action_get_type ())
#define RYGEL_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction))
#define RYGEL_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))
#define RYGEL_IS_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_IS_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_MEDIA_QUERY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))

typedef struct _RygelMediaQueryAction RygelMediaQueryAction;
typedef struct _RygelMediaQueryActionClass RygelMediaQueryActionClass;
typedef struct _RygelMediaQueryActionPrivate RygelMediaQueryActionPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

#define RYGEL_TYPE_SEARCH (rygel_search_get_type ())
#define RYGEL_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH, RygelSearch))
#define RYGEL_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH, RygelSearchClass))
#define RYGEL_IS_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH))
#define RYGEL_IS_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH))
#define RYGEL_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH, RygelSearchClass))

typedef struct _RygelSearch RygelSearch;
typedef struct _RygelSearchClass RygelSearchClass;
typedef struct _RygelSearchPrivate RygelSearchPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
#define __vala_GUPnPServiceAction_free0(var) ((var == NULL) ? NULL : (var = (_vala_GUPnPServiceAction_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_SEARCH_CRITERIA_PARSER (rygel_search_criteria_parser_get_type ())
#define RYGEL_SEARCH_CRITERIA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParser))
#define RYGEL_SEARCH_CRITERIA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParserClass))
#define RYGEL_IS_SEARCH_CRITERIA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER))
#define RYGEL_IS_SEARCH_CRITERIA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_CRITERIA_PARSER))
#define RYGEL_SEARCH_CRITERIA_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParserClass))

typedef struct _RygelSearchCriteriaParser RygelSearchCriteriaParser;
typedef struct _RygelSearchCriteriaParserClass RygelSearchCriteriaParserClass;
typedef struct _RygelSearchCriteriaParserPrivate RygelSearchCriteriaParserPrivate;
typedef struct _RygelSearchFetchResultsData RygelSearchFetchResultsData;

struct _RygelMediaQueryAction {
	GObject parent_instance;
	RygelMediaQueryActionPrivate * priv;
	gchar* object_id;
	gchar* browse_flag;
	gchar* filter;
	guint index;
	guint requested_count;
	gchar* sort_criteria;
	guint number_returned;
	guint total_matches;
	guint update_id;
	RygelMediaContainer* root_container;
	RygelHTTPServer* http_server;
	guint32 system_update_id;
	GUPnPServiceAction* action;
	RygelSerializer* serializer;
	RygelClientHacks* hacks;
	gchar* object_id_arg;
};

struct _RygelMediaQueryActionClass {
	GObjectClass parent_class;
	void (*parse_args) (RygelMediaQueryAction* self, GError** error);
	void (*fetch_results) (RygelMediaQueryAction* self, RygelMediaObject* media_object, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*fetch_results_finish) (RygelMediaQueryAction* self, GAsyncResult* _res_, GError** error);
	void (*handle_error) (RygelMediaQueryAction* self, GError* _error_);
};

struct _RygelSearch {
	RygelMediaQueryAction parent_instance;
	RygelSearchPrivate * priv;
	gchar* search_criteria;
};

struct _RygelSearchClass {
	RygelMediaQueryActionClass parent_class;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_CURRENT_TAG_VALUE = 702,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE = 703,
	RYGEL_CONTENT_DIRECTORY_ERROR_REQUIRED_TAG = 704,
	RYGEL_CONTENT_DIRECTORY_ERROR_READ_ONLY_TAG = 705,
	RYGEL_CONTENT_DIRECTORY_ERROR_PARAMETER_MISMATCH = 706,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SEARCH_CRITERIA = 708,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_CONTAINER = 710,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_FILE_TRANSFER = 717,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_OUTDATED_OBJECT_METADATA = 728,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelSearchCriteriaParser {
	GObject parent_instance;
	RygelSearchCriteriaParserPrivate * priv;
	gchar* str;
	RygelSearchExpression* expression;
	GError* err;
};

struct _RygelSearchCriteriaParserClass {
	GObjectClass parent_class;
};

struct _RygelSearchFetchResultsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearch* self;
	RygelMediaObject* media_object;
	RygelMediaObjects* result;
	RygelMediaObject* _tmp0_;
	RygelMediaObjects* _tmp1_;
	RygelSearchableContainer* container;
	RygelMediaObject* _tmp2_;
	RygelSearchableContainer* _tmp3_;
	RygelSearchCriteriaParser* parser;
	const gchar* _tmp4_;
	RygelSearchCriteriaParser* _tmp5_;
	RygelSearchCriteriaParser* _tmp6_;
	RygelSearchCriteriaParser* _tmp7_;
	GError* _tmp8_;
	const gchar* _tmp9_;
	GError* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	RygelSearchableContainer* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* sort_criteria;
	gchar* _tmp16_;
	RygelClientHacks* _tmp17_;
	RygelMediaObjects* _tmp18_;
	RygelClientHacks* _tmp19_;
	RygelSearchableContainer* _tmp20_;
	RygelSearchCriteriaParser* _tmp21_;
	RygelSearchExpression* _tmp22_;
	guint _tmp23_;
	guint _tmp24_;
	const gchar* _tmp25_;
	GCancellable* _tmp26_;
	GCancellable* _tmp27_;
	guint _tmp28_;
	RygelMediaObjects* _tmp29_;
	RygelMediaObjects* _tmp30_;
	RygelMediaObjects* _tmp31_;
	RygelSearchableContainer* _tmp32_;
	RygelSearchCriteriaParser* _tmp33_;
	RygelSearchExpression* _tmp34_;
	guint _tmp35_;
	guint _tmp36_;
	const gchar* _tmp37_;
	GCancellable* _tmp38_;
	GCancellable* _tmp39_;
	guint _tmp40_;
	RygelMediaObjects* _tmp41_;
	RygelMediaObjects* _tmp42_;
	GError * _inner_error_;
};


static gpointer rygel_search_parent_class = NULL;

GType rygel_media_query_action_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_search_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_SEARCH_DUMMY_PROPERTY
};
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
RygelSearch* rygel_search_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelSearch* rygel_search_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
static GUPnPServiceAction* _vala_GUPnPServiceAction_copy (GUPnPServiceAction* self);
RygelMediaQueryAction* rygel_media_query_action_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self);
static void rygel_search_real_parse_args (RygelMediaQueryAction* base, GError** error);
void rygel_media_query_action_parse_args (RygelMediaQueryAction* self, GError** error);
GQuark rygel_content_directory_error_quark (void);
static void rygel_search_real_fetch_results_data_free (gpointer _data);
static void rygel_search_real_fetch_results (RygelMediaQueryAction* base, RygelMediaObject* media_object, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_search_real_fetch_results_co (RygelSearchFetchResultsData* _data_);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
RygelMediaObjects* rygel_media_objects_new (void);
RygelMediaObjects* rygel_media_objects_construct (GType object_type);
GType rygel_search_criteria_parser_get_type (void) G_GNUC_CONST;
RygelSearchCriteriaParser* rygel_search_criteria_parser_new (const gchar* str, GError** error);
RygelSearchCriteriaParser* rygel_search_criteria_parser_construct (GType object_type, const gchar* str, GError** error);
static void rygel_search_fetch_results_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
const gchar* rygel_media_container_get_sort_criteria (RygelMediaContainer* self);
void rygel_client_hacks_search (RygelClientHacks* self, RygelSearchableContainer* container, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_client_hacks_search_finish (RygelClientHacks* self, GAsyncResult* _res_, guint* total_matches, GError** error);
void rygel_searchable_container_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_search_real_handle_error (RygelMediaQueryAction* base, GError* _error_);
void rygel_media_query_action_handle_error (RygelMediaQueryAction* self, GError* _error_);
static void rygel_search_finalize (GObject* obj);


static GUPnPServiceAction* _vala_GUPnPServiceAction_copy (GUPnPServiceAction* self) {
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	return g_boxed_copy (gupnp_service_action_get_type (), self);
#line 353 "rygel-search.c"
}


static gpointer __vala_GUPnPServiceAction_copy0 (gpointer self) {
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	return self ? _vala_GUPnPServiceAction_copy (self) : NULL;
#line 360 "rygel-search.c"
}


static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self) {
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	g_boxed_free (gupnp_service_action_get_type (), self);
#line 367 "rygel-search.c"
}


RygelSearch* rygel_search_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	RygelSearch * self = NULL;
	RygelContentDirectory* _tmp0_ = NULL;
	GUPnPServiceAction* _tmp1_ = NULL;
	GUPnPServiceAction* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	g_return_val_if_fail (content_dir != NULL, NULL);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	g_return_val_if_fail (action != NULL, NULL);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_tmp0_ = content_dir;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_tmp1_ = action;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_tmp2_ = __vala_GUPnPServiceAction_copy0 (_tmp1_);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	self = (RygelSearch*) rygel_media_query_action_construct (object_type, _tmp0_, _tmp2_);
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_tmp3_ = g_strdup ("ContainerID");
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_g_free0 (((RygelMediaQueryAction*) self)->object_id_arg);
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	((RygelMediaQueryAction*) self)->object_id_arg = _tmp3_;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	__vala_GUPnPServiceAction_free0 (action);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	return self;
#line 399 "rygel-search.c"
}


RygelSearch* rygel_search_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	return rygel_search_construct (RYGEL_TYPE_SEARCH, content_dir, action);
#line 406 "rygel-search.c"
}


static void rygel_search_real_parse_args (RygelMediaQueryAction* base, GError** error) {
	RygelSearch * self;
	GUPnPServiceAction* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	self = (RygelSearch*) base;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	RYGEL_MEDIA_QUERY_ACTION_CLASS (rygel_search_parent_class)->parse_args (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction), &_inner_error_);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		g_propagate_error (error, _inner_error_);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		return;
#line 426 "rygel-search.c"
	}
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_tmp0_ = ((RygelMediaQueryAction*) self)->action;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	gupnp_service_action_get (_tmp0_, "SearchCriteria", G_TYPE_STRING, &self->search_criteria, NULL);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_tmp1_ = self->search_criteria;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	if (_tmp1_ == NULL) {
#line 436 "rygel-search.c"
		GError* _tmp2_ = NULL;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_tmp2_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, "No search criteria given");
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_inner_error_ = _tmp2_;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		g_propagate_error (error, _inner_error_);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		return;
#line 446 "rygel-search.c"
	}
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_tmp3_ = self->search_criteria;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	g_debug ("rygel-search.vala:54: Executing search request: %s", _tmp3_);
#line 452 "rygel-search.c"
}


static void rygel_search_real_fetch_results_data_free (gpointer _data) {
	RygelSearchFetchResultsData* _data_;
	_data_ = _data;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_g_object_unref0 (_data_->media_object);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_g_object_unref0 (_data_->result);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_g_object_unref0 (_data_->self);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	g_slice_free (RygelSearchFetchResultsData, _data_);
#line 467 "rygel-search.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	return self ? g_object_ref (self) : NULL;
#line 474 "rygel-search.c"
}


static void rygel_search_real_fetch_results (RygelMediaQueryAction* base, RygelMediaObject* media_object, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearch * self;
	RygelSearchFetchResultsData* _data_;
	RygelSearch* _tmp0_ = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	RygelMediaObject* _tmp2_ = NULL;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	self = (RygelSearch*) base;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_ = g_slice_new0 (RygelSearchFetchResultsData);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_search_real_fetch_results);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_search_real_fetch_results_data_free);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->self = _tmp0_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_tmp1_ = media_object;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_g_object_unref0 (_data_->media_object);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->media_object = _tmp2_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	rygel_search_real_fetch_results_co (_data_);
#line 506 "rygel-search.c"
}


static RygelMediaObjects* rygel_search_real_fetch_results_finish (RygelMediaQueryAction* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelSearchFetchResultsData* _data_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		return NULL;
#line 517 "rygel-search.c"
	}
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	result = _data_->result;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->result = NULL;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	return result;
#line 527 "rygel-search.c"
}


static void rygel_search_fetch_results_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchFetchResultsData* _data_;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_ = _user_data_;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->_source_object_ = source_object;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->_res_ = _res_;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	rygel_search_real_fetch_results_co (_data_);
#line 541 "rygel-search.c"
}


static gboolean rygel_search_real_fetch_results_co (RygelSearchFetchResultsData* _data_) {
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	switch (_data_->_state_) {
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		case 0:
#line 550 "rygel-search.c"
		goto _state_0;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		case 1:
#line 554 "rygel-search.c"
		goto _state_1;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		case 2:
#line 558 "rygel-search.c"
		goto _state_2;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		case 3:
#line 562 "rygel-search.c"
		goto _state_3;
		default:
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		g_assert_not_reached ();
#line 567 "rygel-search.c"
	}
	_state_0:
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->_tmp0_ = NULL;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->_tmp0_ = _data_->media_object;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp0_, RYGEL_TYPE_SEARCHABLE_CONTAINER)) {
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp1_ = NULL;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp1_ = rygel_media_objects_new ();
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->result = _data_->_tmp1_;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		if (_data_->_state_ == 0) {
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 586 "rygel-search.c"
		} else {
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 590 "rygel-search.c"
		}
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		g_object_unref (_data_->_async_result);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		return FALSE;
#line 596 "rygel-search.c"
	}
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->_tmp2_ = NULL;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->_tmp2_ = _data_->media_object;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->_tmp3_ = NULL;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp2_, RYGEL_TYPE_SEARCHABLE_CONTAINER) ? ((RygelSearchableContainer*) _data_->_tmp2_) : NULL);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->container = _data_->_tmp3_;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->_tmp4_ = NULL;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->_tmp4_ = _data_->self->search_criteria;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->_tmp5_ = NULL;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->_tmp5_ = rygel_search_criteria_parser_new (_data_->_tmp4_, &_data_->_inner_error_);
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->parser = _data_->_tmp5_;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		g_error_free (_data_->_inner_error_);
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_g_object_unref0 (_data_->container);
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		if (_data_->_state_ == 0) {
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 630 "rygel-search.c"
		} else {
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 634 "rygel-search.c"
		}
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		g_object_unref (_data_->_async_result);
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		return FALSE;
#line 640 "rygel-search.c"
	}
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->_tmp6_ = NULL;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->_tmp6_ = _data_->parser;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->_state_ = 1;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	rygel_state_machine_run ((RygelStateMachine*) _data_->_tmp6_, rygel_search_fetch_results_ready, _data_);
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	return FALSE;
#line 652 "rygel-search.c"
	_state_1:
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	rygel_state_machine_run_finish ((RygelStateMachine*) _data_->_tmp6_, _data_->_res_);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->_tmp7_ = NULL;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->_tmp7_ = _data_->parser;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->_tmp8_ = NULL;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->_tmp8_ = _data_->_tmp7_->err;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	if (_data_->_tmp8_ != NULL) {
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp9_ = NULL;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp9_ = _ ("Invalid search criteria given");
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp10_ = NULL;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp10_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SEARCH_CRITERIA, _data_->_tmp9_);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_inner_error_ = _data_->_tmp10_;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		g_error_free (_data_->_inner_error_);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_g_object_unref0 (_data_->parser);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_g_object_unref0 (_data_->container);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		if (_data_->_state_ == 0) {
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 688 "rygel-search.c"
		} else {
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 692 "rygel-search.c"
		}
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		g_object_unref (_data_->_async_result);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		return FALSE;
#line 698 "rygel-search.c"
	}
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->_tmp12_ = NULL;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->_tmp12_ = ((RygelMediaQueryAction*) _data_->self)->sort_criteria;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->_tmp11_ = _data_->_tmp12_;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	if (_data_->_tmp11_ == NULL) {
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp13_ = NULL;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp13_ = _data_->container;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp14_ = NULL;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp14_ = rygel_media_container_get_sort_criteria ((RygelMediaContainer*) _data_->_tmp13_);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp15_ = NULL;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp15_ = _data_->_tmp14_;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp11_ = _data_->_tmp15_;
#line 722 "rygel-search.c"
	}
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->_tmp16_ = NULL;
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->_tmp16_ = g_strdup (_data_->_tmp11_);
#line 73 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->sort_criteria = _data_->_tmp16_;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->_tmp17_ = NULL;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_data_->_tmp17_ = ((RygelMediaQueryAction*) _data_->self)->hacks;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	if (_data_->_tmp17_ != NULL) {
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp19_ = NULL;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp19_ = ((RygelMediaQueryAction*) _data_->self)->hacks;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp20_ = NULL;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp20_ = _data_->container;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp21_ = NULL;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp21_ = _data_->parser;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp22_ = NULL;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp22_ = _data_->_tmp21_->expression;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp23_ = 0U;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp23_ = ((RygelMediaQueryAction*) _data_->self)->index;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp24_ = 0U;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp24_ = ((RygelMediaQueryAction*) _data_->self)->requested_count;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp25_ = NULL;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp25_ = _data_->sort_criteria;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp26_ = NULL;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp26_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp27_ = NULL;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp27_ = _data_->_tmp26_;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp28_ = 0U;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_state_ = 2;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		rygel_client_hacks_search (_data_->_tmp19_, _data_->_tmp20_, _data_->_tmp22_, _data_->_tmp23_, _data_->_tmp24_, _data_->_tmp25_, _data_->_tmp27_, rygel_search_fetch_results_ready, _data_);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		return FALSE;
#line 780 "rygel-search.c"
		_state_2:
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp29_ = NULL;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp29_ = rygel_client_hacks_search_finish (_data_->_tmp19_, _data_->_res_, &_data_->_tmp28_, &_data_->_inner_error_);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		((RygelMediaQueryAction*) _data_->self)->total_matches = _data_->_tmp28_;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp18_ = _data_->_tmp29_;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
			g_error_free (_data_->_inner_error_);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
			_g_free0 (_data_->sort_criteria);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
			_g_object_unref0 (_data_->parser);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
			_g_object_unref0 (_data_->container);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
			if (_data_->_state_ == 0) {
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 806 "rygel-search.c"
			} else {
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 810 "rygel-search.c"
			}
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
			g_object_unref (_data_->_async_result);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
			return FALSE;
#line 816 "rygel-search.c"
		}
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp30_ = NULL;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp30_ = _data_->_tmp18_;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp18_ = NULL;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->result = _data_->_tmp30_;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_g_object_unref0 (_data_->_tmp18_);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_g_free0 (_data_->sort_criteria);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_g_object_unref0 (_data_->parser);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_g_object_unref0 (_data_->container);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		if (_data_->_state_ == 0) {
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 838 "rygel-search.c"
		} else {
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 842 "rygel-search.c"
		}
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		g_object_unref (_data_->_async_result);
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		return FALSE;
#line 848 "rygel-search.c"
	} else {
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp32_ = NULL;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp32_ = _data_->container;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp33_ = NULL;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp33_ = _data_->parser;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp34_ = NULL;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp34_ = _data_->_tmp33_->expression;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp35_ = 0U;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp35_ = ((RygelMediaQueryAction*) _data_->self)->index;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp36_ = 0U;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp36_ = ((RygelMediaQueryAction*) _data_->self)->requested_count;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp37_ = NULL;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp37_ = _data_->sort_criteria;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp38_ = NULL;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp38_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp39_ = NULL;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp39_ = _data_->_tmp38_;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp40_ = 0U;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_state_ = 3;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		rygel_searchable_container_search (_data_->_tmp32_, _data_->_tmp34_, _data_->_tmp35_, _data_->_tmp36_, _data_->_tmp37_, _data_->_tmp39_, rygel_search_fetch_results_ready, _data_);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		return FALSE;
#line 890 "rygel-search.c"
		_state_3:
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp41_ = NULL;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp41_ = rygel_searchable_container_search_finish (_data_->_tmp32_, _data_->_res_, &_data_->_tmp40_, &_data_->_inner_error_);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		((RygelMediaQueryAction*) _data_->self)->total_matches = _data_->_tmp40_;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp31_ = _data_->_tmp41_;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
			g_error_free (_data_->_inner_error_);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
			_g_free0 (_data_->sort_criteria);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
			_g_object_unref0 (_data_->parser);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
			_g_object_unref0 (_data_->container);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
			if (_data_->_state_ == 0) {
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 916 "rygel-search.c"
			} else {
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 920 "rygel-search.c"
			}
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
			g_object_unref (_data_->_async_result);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
			return FALSE;
#line 926 "rygel-search.c"
		}
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp42_ = NULL;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp42_ = _data_->_tmp31_;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->_tmp31_ = NULL;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_data_->result = _data_->_tmp42_;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_g_object_unref0 (_data_->_tmp31_);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_g_free0 (_data_->sort_criteria);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_g_object_unref0 (_data_->parser);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		_g_object_unref0 (_data_->container);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		if (_data_->_state_ == 0) {
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 948 "rygel-search.c"
		} else {
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 952 "rygel-search.c"
		}
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		g_object_unref (_data_->_async_result);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		return FALSE;
#line 958 "rygel-search.c"
	}
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_g_free0 (_data_->sort_criteria);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_g_object_unref0 (_data_->parser);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_g_object_unref0 (_data_->container);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	if (_data_->_state_ == 0) {
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 970 "rygel-search.c"
	} else {
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 974 "rygel-search.c"
	}
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	g_object_unref (_data_->_async_result);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	return FALSE;
#line 980 "rygel-search.c"
}


static void rygel_search_real_handle_error (RygelMediaQueryAction* base, GError* _error_) {
	RygelSearch * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GError* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GError* _tmp4_ = NULL;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	self = (RygelSearch*) base;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_tmp0_ = _ ("Failed to search in '%s': %s");
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_tmp1_ = ((RygelMediaQueryAction*) self)->object_id;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_tmp2_ = _error_;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_tmp3_ = _tmp2_->message;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	g_warning (_tmp0_, _tmp1_, _tmp3_);
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_tmp4_ = _error_;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	RYGEL_MEDIA_QUERY_ACTION_CLASS (rygel_search_parent_class)->handle_error (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction), _tmp4_);
#line 1007 "rygel-search.c"
}


static void rygel_search_class_init (RygelSearchClass * klass) {
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	rygel_search_parent_class = g_type_class_peek_parent (klass);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	((RygelMediaQueryActionClass *) klass)->parse_args = rygel_search_real_parse_args;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	((RygelMediaQueryActionClass *) klass)->fetch_results = rygel_search_real_fetch_results;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	((RygelMediaQueryActionClass *) klass)->fetch_results_finish = rygel_search_real_fetch_results_finish;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	((RygelMediaQueryActionClass *) klass)->handle_error = rygel_search_real_handle_error;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_search_finalize;
#line 1024 "rygel-search.c"
}


static void rygel_search_instance_init (RygelSearch * self) {
}


static void rygel_search_finalize (GObject* obj) {
	RygelSearch * self;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_SEARCH, RygelSearch);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	_g_free0 (self->search_criteria);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-search.vala"
	G_OBJECT_CLASS (rygel_search_parent_class)->finalize (obj);
#line 1040 "rygel-search.c"
}


/**
 * Search action implementation.
 */
GType rygel_search_get_type (void) {
	static volatile gsize rygel_search_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_search_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSearchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_search_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSearch), 0, (GInstanceInitFunc) rygel_search_instance_init, NULL };
		GType rygel_search_type_id;
		rygel_search_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_QUERY_ACTION, "RygelSearch", &g_define_type_info, 0);
		g_once_init_leave (&rygel_search_type_id__volatile, rygel_search_type_id);
	}
	return rygel_search_type_id__volatile;
}



