/* rygel-media-resource.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-media-resource.vala, do not modify */

/*
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL CABLE TELEVISION LABORATORIES
 * INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;
typedef struct _RygelMediaResourcePrivate RygelMediaResourcePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _RygelMediaResource {
	GObject parent_instance;
	RygelMediaResourcePrivate * priv;
	gchar** play_speeds;
	gint play_speeds_length1;
};

struct _RygelMediaResourceClass {
	GObjectClass parent_class;
};

struct _RygelMediaResourcePrivate {
	gchar* name;
	gchar* _uri;
	gchar* _import_uri;
	gchar* _extension;
	gint64 _size;
	gint64 _cleartext_size;
	glong _duration;
	gint _bitrate;
	gint _bits_per_sample;
	gint _color_depth;
	gint _width;
	gint _height;
	gint _audio_channels;
	gint _sample_freq;
	gchar* _protocol;
	gchar* _mime_type;
	gchar* _dlna_profile;
	gchar* _network;
	GUPnPDLNAConversion _dlna_conversion;
	GUPnPDLNAFlags _dlna_flags;
	GUPnPDLNAOperation _dlna_operation;
};


static gpointer rygel_media_resource_parent_class = NULL;

GType rygel_media_resource_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_RESOURCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourcePrivate))
enum  {
	RYGEL_MEDIA_RESOURCE_DUMMY_PROPERTY,
	RYGEL_MEDIA_RESOURCE_URI,
	RYGEL_MEDIA_RESOURCE_IMPORT_URI,
	RYGEL_MEDIA_RESOURCE_EXTENSION,
	RYGEL_MEDIA_RESOURCE_SIZE,
	RYGEL_MEDIA_RESOURCE_CLEARTEXT_SIZE,
	RYGEL_MEDIA_RESOURCE_DURATION,
	RYGEL_MEDIA_RESOURCE_BITRATE,
	RYGEL_MEDIA_RESOURCE_BITS_PER_SAMPLE,
	RYGEL_MEDIA_RESOURCE_COLOR_DEPTH,
	RYGEL_MEDIA_RESOURCE_WIDTH,
	RYGEL_MEDIA_RESOURCE_HEIGHT,
	RYGEL_MEDIA_RESOURCE_AUDIO_CHANNELS,
	RYGEL_MEDIA_RESOURCE_SAMPLE_FREQ,
	RYGEL_MEDIA_RESOURCE_PROTOCOL,
	RYGEL_MEDIA_RESOURCE_MIME_TYPE,
	RYGEL_MEDIA_RESOURCE_DLNA_PROFILE,
	RYGEL_MEDIA_RESOURCE_NETWORK,
	RYGEL_MEDIA_RESOURCE_DLNA_CONVERSION,
	RYGEL_MEDIA_RESOURCE_DLNA_FLAGS,
	RYGEL_MEDIA_RESOURCE_DLNA_OPERATION
};
RygelMediaResource* rygel_media_resource_new (const gchar* name);
RygelMediaResource* rygel_media_resource_construct (GType object_type, const gchar* name);
RygelMediaResource* rygel_media_resource_new_from_resource (const gchar* name, RygelMediaResource* that);
RygelMediaResource* rygel_media_resource_construct_from_resource (GType object_type, const gchar* name, RygelMediaResource* that);
const gchar* rygel_media_resource_get_uri (RygelMediaResource* self);
void rygel_media_resource_set_uri (RygelMediaResource* self, const gchar* value);
void rygel_media_resource_set_import_uri (RygelMediaResource* self, const gchar* value);
const gchar* rygel_media_resource_get_extension (RygelMediaResource* self);
void rygel_media_resource_set_extension (RygelMediaResource* self, const gchar* value);
gint64 rygel_media_resource_get_size (RygelMediaResource* self);
void rygel_media_resource_set_size (RygelMediaResource* self, gint64 value);
gint64 rygel_media_resource_get_cleartext_size (RygelMediaResource* self);
void rygel_media_resource_set_cleartext_size (RygelMediaResource* self, gint64 value);
glong rygel_media_resource_get_duration (RygelMediaResource* self);
void rygel_media_resource_set_duration (RygelMediaResource* self, glong value);
gint rygel_media_resource_get_bitrate (RygelMediaResource* self);
void rygel_media_resource_set_bitrate (RygelMediaResource* self, gint value);
gint rygel_media_resource_get_bits_per_sample (RygelMediaResource* self);
void rygel_media_resource_set_bits_per_sample (RygelMediaResource* self, gint value);
gint rygel_media_resource_get_color_depth (RygelMediaResource* self);
void rygel_media_resource_set_color_depth (RygelMediaResource* self, gint value);
gint rygel_media_resource_get_width (RygelMediaResource* self);
void rygel_media_resource_set_width (RygelMediaResource* self, gint value);
gint rygel_media_resource_get_height (RygelMediaResource* self);
void rygel_media_resource_set_height (RygelMediaResource* self, gint value);
gint rygel_media_resource_get_audio_channels (RygelMediaResource* self);
void rygel_media_resource_set_audio_channels (RygelMediaResource* self, gint value);
gint rygel_media_resource_get_sample_freq (RygelMediaResource* self);
void rygel_media_resource_set_sample_freq (RygelMediaResource* self, gint value);
const gchar* rygel_media_resource_get_protocol (RygelMediaResource* self);
void rygel_media_resource_set_protocol (RygelMediaResource* self, const gchar* value);
const gchar* rygel_media_resource_get_mime_type (RygelMediaResource* self);
void rygel_media_resource_set_mime_type (RygelMediaResource* self, const gchar* value);
const gchar* rygel_media_resource_get_dlna_profile (RygelMediaResource* self);
void rygel_media_resource_set_dlna_profile (RygelMediaResource* self, const gchar* value);
const gchar* rygel_media_resource_get_network (RygelMediaResource* self);
void rygel_media_resource_set_network (RygelMediaResource* self, const gchar* value);
gchar** rygel_media_resource_copy_speeds (gchar** src, int src_length1, int* result_length1);
GUPnPDLNAConversion rygel_media_resource_get_dlna_conversion (RygelMediaResource* self);
void rygel_media_resource_set_dlna_conversion (RygelMediaResource* self, GUPnPDLNAConversion value);
GUPnPDLNAFlags rygel_media_resource_get_dlna_flags (RygelMediaResource* self);
void rygel_media_resource_set_dlna_flags (RygelMediaResource* self, GUPnPDLNAFlags value);
GUPnPDLNAOperation rygel_media_resource_get_dlna_operation (RygelMediaResource* self);
void rygel_media_resource_set_dlna_operation (RygelMediaResource* self, GUPnPDLNAOperation value);
RygelMediaResource* rygel_media_resource_new_from_didl_lite_resource (const gchar* name, GUPnPDIDLLiteResource* didl_resource);
RygelMediaResource* rygel_media_resource_construct_from_didl_lite_resource (GType object_type, const gchar* name, GUPnPDIDLLiteResource* didl_resource);
RygelMediaResource* rygel_media_resource_dup (RygelMediaResource* self);
gchar* rygel_media_resource_get_name (RygelMediaResource* self);
GUPnPDIDLLiteResource* rygel_media_resource_serialize (RygelMediaResource* self, GUPnPDIDLLiteResource* didl_resource, GHashTable* replacements);
gchar* rygel_media_object_apply_replacements (GHashTable* replacement_pairs, const gchar* source_string);
GUPnPProtocolInfo* rygel_media_resource_get_protocol_info (RygelMediaResource* self, GHashTable* replacements);
void rygel_media_resource_set_protocol_info (RygelMediaResource* self, GUPnPProtocolInfo* pi);
gboolean rygel_media_resource_supports_arbitrary_byte_seek (RygelMediaResource* self);
gboolean rygel_media_resource_is_dlna_operation_mode_set (RygelMediaResource* self, glong flags);
gboolean rygel_media_resource_supports_arbitrary_time_seek (RygelMediaResource* self);
gboolean rygel_media_resource_supports_limited_byte_seek (RygelMediaResource* self);
gboolean rygel_media_resource_is_dlna_protocol_flag_set (RygelMediaResource* self, glong flags);
gboolean rygel_media_resource_supports_limited_time_seek (RygelMediaResource* self);
gboolean rygel_media_resource_supports_limited_cleartext_byte_seek (RygelMediaResource* self);
gboolean rygel_media_resource_supports_full_cleartext_byte_seek (RygelMediaResource* self);
gboolean rygel_media_resource_is_link_protection_enabled (RygelMediaResource* self);
gboolean rygel_media_resource_is_dlna_content (RygelMediaResource* self);
gchar* rygel_media_resource_get_default_transfer_mode (RygelMediaResource* self);
gboolean rygel_media_resource_supports_transfer_mode (RygelMediaResource* self, const gchar* transfer_mode);
gboolean rygel_media_resource_is_streamable (RygelMediaResource* self);
gboolean rygel_media_resource_is_cleartext_range_support_enabled (RygelMediaResource* self);
gboolean rygel_media_resource_supports_playspeed (RygelMediaResource* self);
gchar* rygel_media_resource_to_string (RygelMediaResource* self);
const gchar* rygel_media_resource_get_import_uri (RygelMediaResource* self);
static void rygel_media_resource_finalize (GObject* obj);
static void _vala_rygel_media_resource_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_resource_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


RygelMediaResource* rygel_media_resource_construct (GType object_type, const gchar* name) {
	RygelMediaResource * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self = (RygelMediaResource*) g_object_new (object_type, NULL);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = name;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_g_free0 (self->priv->name);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->name = _tmp1_;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return self;
#line 213 "rygel-media-resource.c"
}


RygelMediaResource* rygel_media_resource_new (const gchar* name) {
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return rygel_media_resource_construct (RYGEL_TYPE_MEDIA_RESOURCE, name);
#line 220 "rygel-media-resource.c"
}


/**
     * Copy constructor
     */
RygelMediaResource* rygel_media_resource_construct_from_resource (GType object_type, const gchar* name, RygelMediaResource* that) {
	RygelMediaResource * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	RygelMediaResource* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	RygelMediaResource* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	RygelMediaResource* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	RygelMediaResource* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	RygelMediaResource* _tmp10_ = NULL;
	gint64 _tmp11_ = 0LL;
	RygelMediaResource* _tmp12_ = NULL;
	glong _tmp13_ = 0L;
	RygelMediaResource* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	RygelMediaResource* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	RygelMediaResource* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	RygelMediaResource* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	RygelMediaResource* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	RygelMediaResource* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	RygelMediaResource* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	RygelMediaResource* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	RygelMediaResource* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	RygelMediaResource* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	RygelMediaResource* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	RygelMediaResource* _tmp36_ = NULL;
	gchar** _tmp37_ = NULL;
	gint _tmp37__length1 = 0;
	gint _tmp38_ = 0;
	gchar** _tmp39_ = NULL;
	RygelMediaResource* _tmp40_ = NULL;
	GUPnPDLNAConversion _tmp41_ = 0;
	RygelMediaResource* _tmp42_ = NULL;
	GUPnPDLNAFlags _tmp43_ = 0;
	RygelMediaResource* _tmp44_ = NULL;
	GUPnPDLNAOperation _tmp45_ = 0;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (that != NULL, NULL);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self = (RygelMediaResource*) g_object_new (object_type, NULL);
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = name;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_g_free0 (self->priv->name);
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->name = _tmp1_;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp2_ = that;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp3_ = _tmp2_->priv->_uri;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_uri (self, _tmp3_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp4_ = that;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp5_ = _tmp4_->priv->_uri;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_import_uri (self, _tmp5_);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp6_ = that;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp7_ = _tmp6_->priv->_extension;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_extension (self, _tmp7_);
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp8_ = that;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp9_ = _tmp8_->priv->_size;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_size (self, _tmp9_);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp10_ = that;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp11_ = _tmp10_->priv->_cleartext_size;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_cleartext_size (self, _tmp11_);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp12_ = that;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp13_ = _tmp12_->priv->_duration;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_duration (self, _tmp13_);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp14_ = that;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp15_ = _tmp14_->priv->_bitrate;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_bitrate (self, _tmp15_);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp16_ = that;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp17_ = _tmp16_->priv->_bits_per_sample;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_bits_per_sample (self, _tmp17_);
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp18_ = that;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp19_ = _tmp18_->priv->_color_depth;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_color_depth (self, _tmp19_);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp20_ = that;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp21_ = _tmp20_->priv->_width;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_width (self, _tmp21_);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp22_ = that;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp23_ = _tmp22_->priv->_height;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_height (self, _tmp23_);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp24_ = that;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp25_ = _tmp24_->priv->_audio_channels;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_audio_channels (self, _tmp25_);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp26_ = that;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp27_ = _tmp26_->priv->_sample_freq;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_sample_freq (self, _tmp27_);
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp28_ = that;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp29_ = _tmp28_->priv->_protocol;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_protocol (self, _tmp29_);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp30_ = that;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp31_ = _tmp30_->priv->_mime_type;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_mime_type (self, _tmp31_);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp32_ = that;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp33_ = _tmp32_->priv->_dlna_profile;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_dlna_profile (self, _tmp33_);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp34_ = that;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp35_ = _tmp34_->priv->_network;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_network (self, _tmp35_);
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp36_ = that;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp37_ = _tmp36_->play_speeds;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp37__length1 = _tmp36_->play_speeds_length1;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp39_ = rygel_media_resource_copy_speeds (_tmp37_, _tmp37__length1, &_tmp38_);
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->play_speeds = (_vala_array_free (self->play_speeds, self->play_speeds_length1, (GDestroyNotify) g_free), NULL);
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->play_speeds = _tmp39_;
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->play_speeds_length1 = _tmp38_;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp40_ = that;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp41_ = _tmp40_->priv->_dlna_conversion;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_dlna_conversion (self, _tmp41_);
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp42_ = that;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp43_ = _tmp42_->priv->_dlna_flags;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_dlna_flags (self, _tmp43_);
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp44_ = that;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp45_ = _tmp44_->priv->_dlna_operation;
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_dlna_operation (self, _tmp45_);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return self;
#line 426 "rygel-media-resource.c"
}


RygelMediaResource* rygel_media_resource_new_from_resource (const gchar* name, RygelMediaResource* that) {
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return rygel_media_resource_construct_from_resource (RYGEL_TYPE_MEDIA_RESOURCE, name, that);
#line 433 "rygel-media-resource.c"
}


RygelMediaResource* rygel_media_resource_construct_from_didl_lite_resource (GType object_type, const gchar* name, GUPnPDIDLLiteResource* didl_resource) {
	RygelMediaResource * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GUPnPDIDLLiteResource* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GUPnPDIDLLiteResource* _tmp5_ = NULL;
	gint64 _tmp6_ = 0LL;
	gint64 _tmp7_ = 0LL;
	GUPnPDIDLLiteResource* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	gint64 _tmp10_ = 0LL;
	GUPnPDIDLLiteResource* _tmp11_ = NULL;
	glong _tmp12_ = 0L;
	glong _tmp13_ = 0L;
	GUPnPDIDLLiteResource* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	GUPnPDIDLLiteResource* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	GUPnPDIDLLiteResource* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	GUPnPDIDLLiteResource* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	GUPnPDIDLLiteResource* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	GUPnPDIDLLiteResource* _tmp29_ = NULL;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	GUPnPDIDLLiteResource* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	GUPnPDIDLLiteResource* _tmp35_ = NULL;
	GUPnPProtocolInfo* _tmp36_ = NULL;
	GUPnPProtocolInfo* _tmp37_ = NULL;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (didl_resource != NULL, NULL);
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self = (RygelMediaResource*) g_object_new (object_type, NULL);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = name;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_g_free0 (self->priv->name);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->name = _tmp1_;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp2_ = didl_resource;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp3_ = gupnp_didl_lite_resource_get_uri (_tmp2_);
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp4_ = _tmp3_;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_uri (self, _tmp4_);
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp5_ = didl_resource;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp6_ = gupnp_didl_lite_resource_get_size64 (_tmp5_);
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp7_ = _tmp6_;
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_size (self, _tmp7_);
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp8_ = didl_resource;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp9_ = gupnp_didl_lite_resource_get_cleartext_size (_tmp8_);
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp10_ = _tmp9_;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_cleartext_size (self, _tmp10_);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp11_ = didl_resource;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp12_ = gupnp_didl_lite_resource_get_duration (_tmp11_);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp13_ = _tmp12_;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_duration (self, _tmp13_);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp14_ = didl_resource;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp15_ = gupnp_didl_lite_resource_get_bitrate (_tmp14_);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp16_ = _tmp15_;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_bitrate (self, _tmp16_);
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp17_ = didl_resource;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp18_ = gupnp_didl_lite_resource_get_bits_per_sample (_tmp17_);
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp19_ = _tmp18_;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_bits_per_sample (self, _tmp19_);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp20_ = didl_resource;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp21_ = gupnp_didl_lite_resource_get_color_depth (_tmp20_);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp22_ = _tmp21_;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_color_depth (self, _tmp22_);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp23_ = didl_resource;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp24_ = gupnp_didl_lite_resource_get_width (_tmp23_);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp25_ = _tmp24_;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_width (self, _tmp25_);
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp26_ = didl_resource;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp27_ = gupnp_didl_lite_resource_get_height (_tmp26_);
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp28_ = _tmp27_;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_height (self, _tmp28_);
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp29_ = didl_resource;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp30_ = gupnp_didl_lite_resource_get_audio_channels (_tmp29_);
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp31_ = _tmp30_;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_audio_channels (self, _tmp31_);
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp32_ = didl_resource;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp33_ = gupnp_didl_lite_resource_get_sample_freq (_tmp32_);
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp34_ = _tmp33_;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_sample_freq (self, _tmp34_);
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp35_ = didl_resource;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp36_ = gupnp_didl_lite_resource_get_protocol_info (_tmp35_);
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp37_ = _tmp36_;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp37_ != NULL) {
#line 587 "rygel-media-resource.c"
		GUPnPDIDLLiteResource* _tmp38_ = NULL;
		GUPnPProtocolInfo* _tmp39_ = NULL;
		GUPnPProtocolInfo* _tmp40_ = NULL;
		const gchar* _tmp41_ = NULL;
		const gchar* _tmp42_ = NULL;
		GUPnPDIDLLiteResource* _tmp43_ = NULL;
		GUPnPProtocolInfo* _tmp44_ = NULL;
		GUPnPProtocolInfo* _tmp45_ = NULL;
		const gchar* _tmp46_ = NULL;
		const gchar* _tmp47_ = NULL;
		GUPnPDIDLLiteResource* _tmp48_ = NULL;
		GUPnPProtocolInfo* _tmp49_ = NULL;
		GUPnPProtocolInfo* _tmp50_ = NULL;
		const gchar* _tmp51_ = NULL;
		const gchar* _tmp52_ = NULL;
		GUPnPDIDLLiteResource* _tmp53_ = NULL;
		GUPnPProtocolInfo* _tmp54_ = NULL;
		GUPnPProtocolInfo* _tmp55_ = NULL;
		const gchar* _tmp56_ = NULL;
		const gchar* _tmp57_ = NULL;
		GUPnPDIDLLiteResource* _tmp58_ = NULL;
		GUPnPProtocolInfo* _tmp59_ = NULL;
		GUPnPProtocolInfo* _tmp60_ = NULL;
		gchar** _tmp61_ = NULL;
		gint _tmp61__length1 = 0;
		gchar** _tmp62_ = NULL;
		gint _tmp62__length1 = 0;
		gint _tmp63_ = 0;
		gchar** _tmp64_ = NULL;
		GUPnPDIDLLiteResource* _tmp65_ = NULL;
		GUPnPProtocolInfo* _tmp66_ = NULL;
		GUPnPProtocolInfo* _tmp67_ = NULL;
		GUPnPDLNAConversion _tmp68_ = 0;
		GUPnPDLNAConversion _tmp69_ = 0;
		GUPnPDIDLLiteResource* _tmp70_ = NULL;
		GUPnPProtocolInfo* _tmp71_ = NULL;
		GUPnPProtocolInfo* _tmp72_ = NULL;
		GUPnPDLNAFlags _tmp73_ = 0;
		GUPnPDLNAFlags _tmp74_ = 0;
		GUPnPDIDLLiteResource* _tmp75_ = NULL;
		GUPnPProtocolInfo* _tmp76_ = NULL;
		GUPnPProtocolInfo* _tmp77_ = NULL;
		GUPnPDLNAOperation _tmp78_ = 0;
		GUPnPDLNAOperation _tmp79_ = 0;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp38_ = didl_resource;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp39_ = gupnp_didl_lite_resource_get_protocol_info (_tmp38_);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp40_ = _tmp39_;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp41_ = gupnp_protocol_info_get_protocol (_tmp40_);
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp42_ = _tmp41_;
#line 122 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		rygel_media_resource_set_protocol (self, _tmp42_);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp43_ = didl_resource;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp44_ = gupnp_didl_lite_resource_get_protocol_info (_tmp43_);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp45_ = _tmp44_;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp46_ = gupnp_protocol_info_get_mime_type (_tmp45_);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp47_ = _tmp46_;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		rygel_media_resource_set_mime_type (self, _tmp47_);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp48_ = didl_resource;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp49_ = gupnp_didl_lite_resource_get_protocol_info (_tmp48_);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp50_ = _tmp49_;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp51_ = gupnp_protocol_info_get_dlna_profile (_tmp50_);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp52_ = _tmp51_;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		rygel_media_resource_set_dlna_profile (self, _tmp52_);
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp53_ = didl_resource;
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp54_ = gupnp_didl_lite_resource_get_protocol_info (_tmp53_);
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp55_ = _tmp54_;
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp56_ = gupnp_protocol_info_get_network (_tmp55_);
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp57_ = _tmp56_;
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		rygel_media_resource_set_network (self, _tmp57_);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp58_ = didl_resource;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp59_ = gupnp_didl_lite_resource_get_protocol_info (_tmp58_);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp60_ = _tmp59_;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp61_ = gupnp_protocol_info_get_play_speeds (_tmp60_);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp61__length1 = _vala_array_length (_tmp61_);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp62_ = _tmp61_;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp62__length1 = _tmp61__length1;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp64_ = rygel_media_resource_copy_speeds (_tmp62_, _tmp62__length1, &_tmp63_);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		self->play_speeds = (_vala_array_free (self->play_speeds, self->play_speeds_length1, (GDestroyNotify) g_free), NULL);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		self->play_speeds = _tmp64_;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		self->play_speeds_length1 = _tmp63_;
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp65_ = didl_resource;
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp66_ = gupnp_didl_lite_resource_get_protocol_info (_tmp65_);
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp67_ = _tmp66_;
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp68_ = gupnp_protocol_info_get_dlna_conversion (_tmp67_);
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp69_ = _tmp68_;
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		rygel_media_resource_set_dlna_conversion (self, _tmp69_);
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp70_ = didl_resource;
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp71_ = gupnp_didl_lite_resource_get_protocol_info (_tmp70_);
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp72_ = _tmp71_;
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp73_ = gupnp_protocol_info_get_dlna_flags (_tmp72_);
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp74_ = _tmp73_;
#line 128 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		rygel_media_resource_set_dlna_flags (self, _tmp74_);
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp75_ = didl_resource;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp76_ = gupnp_didl_lite_resource_get_protocol_info (_tmp75_);
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp77_ = _tmp76_;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp78_ = gupnp_protocol_info_get_dlna_operation (_tmp77_);
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp79_ = _tmp78_;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		rygel_media_resource_set_dlna_operation (self, _tmp79_);
#line 738 "rygel-media-resource.c"
	}
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return self;
#line 742 "rygel-media-resource.c"
}


RygelMediaResource* rygel_media_resource_new_from_didl_lite_resource (const gchar* name, GUPnPDIDLLiteResource* didl_resource) {
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return rygel_media_resource_construct_from_didl_lite_resource (RYGEL_TYPE_MEDIA_RESOURCE, name, didl_resource);
#line 749 "rygel-media-resource.c"
}


RygelMediaResource* rygel_media_resource_dup (RygelMediaResource* self) {
	RygelMediaResource* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	RygelMediaResource* _tmp2_ = NULL;
	RygelMediaResource* _tmp3_ = NULL;
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = rygel_media_resource_get_name (self);
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp1_ = _tmp0_;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp2_ = rygel_media_resource_new_from_resource (_tmp1_, self);
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp3_ = _tmp2_;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_g_free0 (_tmp1_);
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp3_;
#line 134 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 775 "rygel-media-resource.c"
}


gchar** rygel_media_resource_copy_speeds (gchar** src, int src_length1, int* result_length1) {
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** new_speeds = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar** _tmp3_ = NULL;
	gint new_speeds_length1 = 0;
	gint _new_speeds_size_ = 0;
	gint speed_index = 0;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = src;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0__length1 = src_length1;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp0_ == NULL) {
#line 800 "rygel-media-resource.c"
		gchar** _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp1_ = NULL;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp1__length1 = 0;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		if (result_length1) {
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
			*result_length1 = _tmp1__length1;
#line 811 "rygel-media-resource.c"
		}
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		result = _tmp1_;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		return result;
#line 817 "rygel-media-resource.c"
	}
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp2_ = src;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp2__length1 = src_length1;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp3_ = g_new0 (gchar*, _tmp2__length1 + 1);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	new_speeds = _tmp3_;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	new_speeds_length1 = _tmp2__length1;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_new_speeds_size_ = new_speeds_length1;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	speed_index = 0;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp4_ = src;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp4__length1 = src_length1;
#line 837 "rygel-media-resource.c"
	{
		gchar** speed_collection = NULL;
		gint speed_collection_length1 = 0;
		gint _speed_collection_size_ = 0;
		gint speed_it = 0;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		speed_collection = _tmp4_;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		speed_collection_length1 = _tmp4__length1;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		for (speed_it = 0; speed_it < _tmp4__length1; speed_it = speed_it + 1) {
#line 849 "rygel-media-resource.c"
			gchar* _tmp5_ = NULL;
			gchar* speed = NULL;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
			_tmp5_ = g_strdup (speed_collection[speed_it]);
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
			speed = _tmp5_;
#line 856 "rygel-media-resource.c"
			{
				gchar** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp7_ = 0;
				const gchar* _tmp8_ = NULL;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_ = NULL;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
				_tmp6_ = new_speeds;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
				_tmp6__length1 = new_speeds_length1;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
				_tmp7_ = speed_index;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
				speed_index = _tmp7_ + 1;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
				_tmp8_ = speed;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
				_tmp9_ = g_strdup (_tmp8_);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
				_g_free0 (_tmp6_[_tmp7_]);
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
				_tmp6_[_tmp7_] = _tmp9_;
#line 144 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
				_tmp10_ = _tmp6_[_tmp7_];
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
				_g_free0 (speed);
#line 884 "rygel-media-resource.c"
			}
		}
	}
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp11_ = new_speeds;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp11__length1 = new_speeds_length1;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (result_length1) {
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		*result_length1 = _tmp11__length1;
#line 896 "rygel-media-resource.c"
	}
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp11_;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 902 "rygel-media-resource.c"
}


gchar* rygel_media_resource_get_name (RygelMediaResource* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 150 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = self->priv->name;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp1_;
#line 151 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 920 "rygel-media-resource.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return self ? g_object_ref (self) : NULL;
#line 927 "rygel-media-resource.c"
}


GUPnPDIDLLiteResource* rygel_media_resource_serialize (RygelMediaResource* self, GUPnPDIDLLiteResource* didl_resource, GHashTable* replacements) {
	GUPnPDIDLLiteResource* result = NULL;
	GHashTable* _tmp0_ = NULL;
	GUPnPDIDLLiteResource* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	GUPnPDIDLLiteResource* _tmp10_ = NULL;
	gint64 _tmp11_ = 0LL;
	GUPnPDIDLLiteResource* _tmp12_ = NULL;
	glong _tmp13_ = 0L;
	GUPnPDIDLLiteResource* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	GUPnPDIDLLiteResource* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	GUPnPDIDLLiteResource* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	GUPnPDIDLLiteResource* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	GUPnPDIDLLiteResource* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	GUPnPDIDLLiteResource* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	GUPnPDIDLLiteResource* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	GUPnPDIDLLiteResource* _tmp28_ = NULL;
	GUPnPProtocolInfo* _tmp29_ = NULL;
	GUPnPProtocolInfo* _tmp30_ = NULL;
	GUPnPDIDLLiteResource* _tmp31_ = NULL;
	GUPnPDIDLLiteResource* _tmp32_ = NULL;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (didl_resource != NULL, NULL);
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = replacements;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp0_ == NULL) {
#line 967 "rygel-media-resource.c"
		GUPnPDIDLLiteResource* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp1_ = didl_resource;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp2_ = self->priv->_uri;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		gupnp_didl_lite_resource_set_uri (_tmp1_, _tmp2_);
#line 976 "rygel-media-resource.c"
	} else {
		GUPnPDIDLLiteResource* _tmp3_ = NULL;
		GHashTable* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp3_ = didl_resource;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp4_ = replacements;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp5_ = self->priv->_uri;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp6_ = rygel_media_object_apply_replacements (_tmp4_, _tmp5_);
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp7_ = _tmp6_;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		gupnp_didl_lite_resource_set_uri (_tmp3_, _tmp7_);
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_g_free0 (_tmp7_);
#line 997 "rygel-media-resource.c"
	}
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp8_ = didl_resource;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp9_ = self->priv->_size;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	gupnp_didl_lite_resource_set_size64 (_tmp8_, _tmp9_);
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp10_ = didl_resource;
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp11_ = self->priv->_cleartext_size;
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	gupnp_didl_lite_resource_set_cleartext_size (_tmp10_, _tmp11_);
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp12_ = didl_resource;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp13_ = self->priv->_duration;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	gupnp_didl_lite_resource_set_duration (_tmp12_, _tmp13_);
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp14_ = didl_resource;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp15_ = self->priv->_bitrate;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	gupnp_didl_lite_resource_set_bitrate (_tmp14_, _tmp15_);
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp16_ = didl_resource;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp17_ = self->priv->_bits_per_sample;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	gupnp_didl_lite_resource_set_bits_per_sample (_tmp16_, _tmp17_);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp18_ = didl_resource;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp19_ = self->priv->_color_depth;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	gupnp_didl_lite_resource_set_color_depth (_tmp18_, _tmp19_);
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp20_ = didl_resource;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp21_ = self->priv->_width;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	gupnp_didl_lite_resource_set_width (_tmp20_, _tmp21_);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp22_ = didl_resource;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp23_ = self->priv->_height;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	gupnp_didl_lite_resource_set_height (_tmp22_, _tmp23_);
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp24_ = didl_resource;
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp25_ = self->priv->_audio_channels;
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	gupnp_didl_lite_resource_set_audio_channels (_tmp24_, _tmp25_);
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp26_ = didl_resource;
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp27_ = self->priv->_sample_freq;
#line 173 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	gupnp_didl_lite_resource_set_sample_freq (_tmp26_, _tmp27_);
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp28_ = didl_resource;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp29_ = rygel_media_resource_get_protocol_info (self, NULL);
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp30_ = _tmp29_;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	gupnp_didl_lite_resource_set_protocol_info (_tmp28_, _tmp30_);
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_g_object_unref0 (_tmp30_);
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp31_ = didl_resource;
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp32_ = _g_object_ref0 (_tmp31_);
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp32_;
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 1077 "rygel-media-resource.c"
}


void rygel_media_resource_set_protocol_info (RygelMediaResource* self, GUPnPProtocolInfo* pi) {
	GUPnPProtocolInfo* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GUPnPProtocolInfo* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GUPnPProtocolInfo* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GUPnPProtocolInfo* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GUPnPProtocolInfo* _tmp12_ = NULL;
	GUPnPDLNAConversion _tmp13_ = 0;
	GUPnPDLNAConversion _tmp14_ = 0;
	GUPnPProtocolInfo* _tmp15_ = NULL;
	GUPnPDLNAOperation _tmp16_ = 0;
	GUPnPDLNAOperation _tmp17_ = 0;
	GUPnPProtocolInfo* _tmp18_ = NULL;
	GUPnPDLNAFlags _tmp19_ = 0;
	GUPnPDLNAFlags _tmp20_ = 0;
	GUPnPProtocolInfo* _tmp21_ = NULL;
	gchar** _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	gchar** _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	gint _tmp24_ = 0;
	gchar** _tmp25_ = NULL;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_if_fail (self != NULL);
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_if_fail (pi != NULL);
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = pi;
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp1_ = gupnp_protocol_info_get_protocol (_tmp0_);
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp2_ = _tmp1_;
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_protocol (self, _tmp2_);
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp3_ = pi;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp4_ = gupnp_protocol_info_get_network (_tmp3_);
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp5_ = _tmp4_;
#line 181 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_network (self, _tmp5_);
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp6_ = pi;
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp7_ = gupnp_protocol_info_get_mime_type (_tmp6_);
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp8_ = _tmp7_;
#line 182 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_mime_type (self, _tmp8_);
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp9_ = pi;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp10_ = gupnp_protocol_info_get_dlna_profile (_tmp9_);
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp11_ = _tmp10_;
#line 183 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_dlna_profile (self, _tmp11_);
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp12_ = pi;
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp13_ = gupnp_protocol_info_get_dlna_conversion (_tmp12_);
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp14_ = _tmp13_;
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_dlna_conversion (self, _tmp14_);
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp15_ = pi;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp16_ = gupnp_protocol_info_get_dlna_operation (_tmp15_);
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp17_ = _tmp16_;
#line 185 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_dlna_operation (self, _tmp17_);
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp18_ = pi;
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp19_ = gupnp_protocol_info_get_dlna_flags (_tmp18_);
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp20_ = _tmp19_;
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_set_dlna_flags (self, _tmp20_);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp21_ = pi;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp22_ = gupnp_protocol_info_get_play_speeds (_tmp21_);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp22__length1 = _vala_array_length (_tmp22_);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp23_ = _tmp22_;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp23__length1 = _tmp22__length1;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp25_ = rygel_media_resource_copy_speeds (_tmp23_, _tmp23__length1, &_tmp24_);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->play_speeds = (_vala_array_free (self->play_speeds, self->play_speeds_length1, (GDestroyNotify) g_free), NULL);
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->play_speeds = _tmp25_;
#line 187 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->play_speeds_length1 = _tmp24_;
#line 1188 "rygel-media-resource.c"
}


GUPnPProtocolInfo* rygel_media_resource_get_protocol_info (RygelMediaResource* self, GHashTable* replacements) {
	GUPnPProtocolInfo* result = NULL;
	GUPnPProtocolInfo* new_pi = NULL;
	GUPnPProtocolInfo* _tmp0_ = NULL;
	GUPnPProtocolInfo* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GUPnPProtocolInfo* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	GUPnPProtocolInfo* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GUPnPProtocolInfo* _tmp15_ = NULL;
	GUPnPDLNAConversion _tmp16_ = 0;
	GUPnPProtocolInfo* _tmp17_ = NULL;
	GUPnPDLNAOperation _tmp18_ = 0;
	GUPnPProtocolInfo* _tmp19_ = NULL;
	GUPnPDLNAFlags _tmp20_ = 0;
	gchar** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = gupnp_protocol_info_new ();
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	new_pi = _tmp0_;
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp1_ = new_pi;
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp2_ = self->priv->_protocol;
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	gupnp_protocol_info_set_protocol (_tmp1_, _tmp2_);
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp3_ = new_pi;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp4_ = self->priv->_network;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	gupnp_protocol_info_set_network (_tmp3_, _tmp4_);
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp5_ = replacements;
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp5_ == NULL) {
#line 1233 "rygel-media-resource.c"
		GUPnPProtocolInfo* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp6_ = new_pi;
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp7_ = self->priv->_mime_type;
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		gupnp_protocol_info_set_mime_type (_tmp6_, _tmp7_);
#line 1242 "rygel-media-resource.c"
	} else {
		GUPnPProtocolInfo* _tmp8_ = NULL;
		GHashTable* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp8_ = new_pi;
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp9_ = replacements;
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp10_ = self->priv->_mime_type;
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp11_ = rygel_media_object_apply_replacements (_tmp9_, _tmp10_);
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp12_ = _tmp11_;
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		gupnp_protocol_info_set_mime_type (_tmp8_, _tmp12_);
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_g_free0 (_tmp12_);
#line 1263 "rygel-media-resource.c"
	}
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp13_ = new_pi;
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp14_ = self->priv->_dlna_profile;
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	gupnp_protocol_info_set_dlna_profile (_tmp13_, _tmp14_);
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp15_ = new_pi;
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp16_ = self->priv->_dlna_conversion;
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	gupnp_protocol_info_set_dlna_conversion (_tmp15_, _tmp16_);
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp17_ = new_pi;
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp18_ = self->priv->_dlna_operation;
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	gupnp_protocol_info_set_dlna_operation (_tmp17_, _tmp18_);
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp19_ = new_pi;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp20_ = self->priv->_dlna_flags;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	gupnp_protocol_info_set_dlna_flags (_tmp19_, _tmp20_);
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp21_ = self->play_speeds;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp21__length1 = self->play_speeds_length1;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp21_ != NULL) {
#line 1295 "rygel-media-resource.c"
		GUPnPProtocolInfo* _tmp22_ = NULL;
		gchar** _tmp23_ = NULL;
		gint _tmp23__length1 = 0;
		gint _tmp24_ = 0;
		gchar** _tmp25_ = NULL;
		gchar** _tmp26_ = NULL;
		gint _tmp26__length1 = 0;
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp22_ = new_pi;
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp23_ = self->play_speeds;
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp23__length1 = self->play_speeds_length1;
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp25_ = rygel_media_resource_copy_speeds (_tmp23_, _tmp23__length1, &_tmp24_);
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp26_ = _tmp25_;
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp26__length1 = _tmp24_;
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		gupnp_protocol_info_set_play_speeds (_tmp22_, _tmp26_);
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp26_ = (_vala_array_free (_tmp26_, _tmp26__length1, (GDestroyNotify) g_free), NULL);
#line 1319 "rygel-media-resource.c"
	}
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = new_pi;
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 1325 "rygel-media-resource.c"
}


gboolean rygel_media_resource_supports_arbitrary_byte_seek (RygelMediaResource* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 214 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = rygel_media_resource_is_dlna_operation_mode_set (self, (glong) GUPNP_DLNA_OPERATION_RANGE);
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0_;
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 1340 "rygel-media-resource.c"
}


gboolean rygel_media_resource_supports_arbitrary_time_seek (RygelMediaResource* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = rygel_media_resource_is_dlna_operation_mode_set (self, (glong) GUPNP_DLNA_OPERATION_TIMESEEK);
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0_;
#line 219 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 1355 "rygel-media-resource.c"
}


gboolean rygel_media_resource_supports_limited_byte_seek (RygelMediaResource* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 222 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 223 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_BYTE_BASED_SEEK);
#line 223 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0_;
#line 223 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 1370 "rygel-media-resource.c"
}


gboolean rygel_media_resource_supports_limited_time_seek (RygelMediaResource* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 227 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_TIME_BASED_SEEK);
#line 227 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0_;
#line 227 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 1385 "rygel-media-resource.c"
}


gboolean rygel_media_resource_supports_limited_cleartext_byte_seek (RygelMediaResource* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_LOP_CLEAR_TEXT_BYTE_SEEK);
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0_;
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 1400 "rygel-media-resource.c"
}


gboolean rygel_media_resource_supports_full_cleartext_byte_seek (RygelMediaResource* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 234 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_CLEAR_TEXT_BYTE_SEEK_FULL);
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0_;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 1415 "rygel-media-resource.c"
}


gboolean rygel_media_resource_is_link_protection_enabled (RygelMediaResource* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 238 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 239 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_LINK_PROTECTED_CONTENT);
#line 239 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0_;
#line 239 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 1430 "rygel-media-resource.c"
}


gboolean rygel_media_resource_is_dlna_content (RygelMediaResource* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 243 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = self->priv->_dlna_profile;
#line 243 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0_ != NULL;
#line 243 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 1445 "rygel-media-resource.c"
}


gchar* rygel_media_resource_get_default_transfer_mode (RygelMediaResource* self) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
#line 246 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 247 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE);
#line 247 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp0_) {
#line 1458 "rygel-media-resource.c"
		gchar* _tmp1_ = NULL;
#line 248 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp1_ = g_strdup ("Streaming");
#line 248 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		result = _tmp1_;
#line 248 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		return result;
#line 1466 "rygel-media-resource.c"
	} else {
		gchar* _tmp2_ = NULL;
#line 250 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp2_ = g_strdup ("Interactive");
#line 250 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		result = _tmp2_;
#line 250 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		return result;
#line 1475 "rygel-media-resource.c"
	}
}


gboolean rygel_media_resource_supports_transfer_mode (RygelMediaResource* self, const gchar* transfer_mode) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GQuark _tmp4_ = 0U;
#line 259 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	static GQuark _tmp3_label0 = 0;
#line 259 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	static GQuark _tmp3_label1 = 0;
#line 259 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	static GQuark _tmp3_label2 = 0;
#line 254 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 254 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (transfer_mode != NULL, FALSE);
#line 255 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = rygel_media_resource_is_dlna_content (self);
#line 255 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (!_tmp0_) {
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		result = TRUE;
#line 256 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		return result;
#line 1504 "rygel-media-resource.c"
	}
#line 259 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp1_ = transfer_mode;
#line 259 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp2_ = _tmp1_;
#line 259 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
#line 259 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("Streaming")))) {
#line 259 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		switch (0) {
#line 1516 "rygel-media-resource.c"
			default:
			{
				gboolean _tmp5_ = FALSE;
#line 261 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
				_tmp5_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE);
#line 261 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
				result = _tmp5_;
#line 261 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
				return result;
#line 1526 "rygel-media-resource.c"
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("Interactive")))) {
#line 259 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		switch (0) {
#line 1532 "rygel-media-resource.c"
			default:
			{
				gboolean _tmp6_ = FALSE;
#line 263 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
				_tmp6_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE);
#line 263 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
				result = _tmp6_;
#line 263 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
				return result;
#line 1542 "rygel-media-resource.c"
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("Background")))) {
#line 259 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		switch (0) {
#line 1548 "rygel-media-resource.c"
			default:
			{
				gboolean _tmp7_ = FALSE;
#line 265 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
				_tmp7_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE);
#line 265 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
				result = _tmp7_;
#line 265 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
				return result;
#line 1558 "rygel-media-resource.c"
			}
		}
	} else {
#line 259 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		switch (0) {
#line 1564 "rygel-media-resource.c"
			default:
			{
#line 267 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
				result = FALSE;
#line 267 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
				return result;
#line 1571 "rygel-media-resource.c"
			}
		}
	}
}


gboolean rygel_media_resource_is_streamable (RygelMediaResource* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 271 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 272 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE);
#line 272 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0_;
#line 272 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 1589 "rygel-media-resource.c"
}


gboolean rygel_media_resource_is_cleartext_range_support_enabled (RygelMediaResource* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 276 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 277 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) (GUPNP_DLNA_FLAGS_CLEAR_TEXT_BYTE_SEEK_FULL | GUPNP_DLNA_FLAGS_LOP_CLEAR_TEXT_BYTE_SEEK));
#line 277 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0_;
#line 277 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 1604 "rygel-media-resource.c"
}


gboolean rygel_media_resource_supports_playspeed (RygelMediaResource* self) {
	gboolean result = FALSE;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
#line 281 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 282 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = self->play_speeds;
#line 282 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0__length1 = self->play_speeds_length1;
#line 282 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0__length1 > 0;
#line 282 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 1622 "rygel-media-resource.c"
}


gboolean rygel_media_resource_is_dlna_protocol_flag_set (RygelMediaResource* self, glong flags) {
	gboolean result = FALSE;
	GUPnPDLNAFlags _tmp0_ = 0;
	glong _tmp1_ = 0L;
#line 285 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 286 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = self->priv->_dlna_flags;
#line 286 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp1_ = flags;
#line 286 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = (_tmp0_ & _tmp1_) != 0;
#line 286 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 1640 "rygel-media-resource.c"
}


gboolean rygel_media_resource_is_dlna_operation_mode_set (RygelMediaResource* self, glong flags) {
	gboolean result = FALSE;
	GUPnPDLNAOperation _tmp0_ = 0;
	glong _tmp1_ = 0L;
#line 289 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 290 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = self->priv->_dlna_operation;
#line 290 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp1_ = flags;
#line 290 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = (_tmp0_ & _tmp1_) != 0;
#line 290 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 1658 "rygel-media-resource.c"
}


gchar* rygel_media_resource_to_string (RygelMediaResource* self) {
	gchar* result = NULL;
	GString* strbuf = NULL;
	const gchar* _tmp0_ = NULL;
	GString* _tmp1_ = NULL;
	GString* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp10_ = 0LL;
	glong _tmp17_ = 0L;
	gint _tmp24_ = 0;
	gint _tmp31_ = 0;
	gint _tmp38_ = 0;
	gint _tmp45_ = 0;
	gint _tmp52_ = 0;
	gint _tmp59_ = 0;
	gint _tmp66_ = 0;
	const gchar* _tmp73_ = NULL;
	const gchar* _tmp78_ = NULL;
	const gchar* _tmp79_ = NULL;
	GString* _tmp81_ = NULL;
	GString* _tmp82_ = NULL;
	GString* _tmp83_ = NULL;
	const gchar* _tmp84_ = NULL;
	const gchar* _tmp85_ = NULL;
	GString* _tmp87_ = NULL;
	GString* _tmp88_ = NULL;
	GString* _tmp89_ = NULL;
	const gchar* _tmp90_ = NULL;
	const gchar* _tmp91_ = NULL;
	GString* _tmp93_ = NULL;
	GString* _tmp94_ = NULL;
	GString* _tmp95_ = NULL;
	GString* _tmp96_ = NULL;
	GUPnPDLNAFlags _tmp97_ = 0;
	gboolean _tmp98_ = FALSE;
	gboolean _tmp100_ = FALSE;
	gboolean _tmp102_ = FALSE;
	gboolean _tmp104_ = FALSE;
	gboolean _tmp106_ = FALSE;
	gboolean _tmp108_ = FALSE;
	gboolean _tmp110_ = FALSE;
	gboolean _tmp112_ = FALSE;
	gboolean _tmp114_ = FALSE;
	gboolean _tmp116_ = FALSE;
	gboolean _tmp118_ = FALSE;
	gboolean _tmp120_ = FALSE;
	gboolean _tmp122_ = FALSE;
	GString* _tmp124_ = NULL;
	GString* _tmp125_ = NULL;
	gssize _tmp126_ = 0L;
	GUPnPDLNAConversion _tmp127_ = 0;
	GUPnPDLNAOperation _tmp130_ = 0;
	gchar** _tmp140_ = NULL;
	gint _tmp140__length1 = 0;
	const gchar* _tmp150_ = NULL;
	const gchar* _tmp151_ = NULL;
	GString* _tmp153_ = NULL;
	GString* _tmp154_ = NULL;
	GString* _tmp155_ = NULL;
	GString* _tmp156_ = NULL;
	const gchar* _tmp157_ = NULL;
	gchar* _tmp158_ = NULL;
#line 293 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = self->priv->name;
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp1_ = g_string_new (_tmp0_);
#line 294 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	strbuf = _tmp1_;
#line 295 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp2_ = strbuf;
#line 295 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_string_append_unichar (_tmp2_, (gunichar) '(');
#line 296 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp3_ = self->priv->_size;
#line 296 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp3_ >= ((gint64) 0)) {
#line 1740 "rygel-media-resource.c"
		GString* _tmp4_ = NULL;
		GString* _tmp5_ = NULL;
		gint64 _tmp6_ = 0LL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		GString* _tmp9_ = NULL;
#line 297 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp4_ = strbuf;
#line 297 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp5_ = g_string_append (_tmp4_, "size ");
#line 297 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp6_ = self->priv->_size;
#line 297 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp7_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp6_);
#line 297 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp8_ = _tmp7_;
#line 297 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp9_ = g_string_append (_tmp5_, _tmp8_);
#line 297 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_string_append_unichar (_tmp9_, (gunichar) ',');
#line 297 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_g_free0 (_tmp8_);
#line 1763 "rygel-media-resource.c"
	}
#line 300 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp10_ = self->priv->_cleartext_size;
#line 300 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp10_ >= ((gint64) 0)) {
#line 1769 "rygel-media-resource.c"
		GString* _tmp11_ = NULL;
		GString* _tmp12_ = NULL;
		gint64 _tmp13_ = 0LL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		GString* _tmp16_ = NULL;
#line 301 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp11_ = strbuf;
#line 301 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp12_ = g_string_append (_tmp11_, "cleartextsize ");
#line 301 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp13_ = self->priv->_cleartext_size;
#line 301 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp14_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp13_);
#line 301 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp15_ = _tmp14_;
#line 301 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp16_ = g_string_append (_tmp12_, _tmp15_);
#line 301 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_string_append_unichar (_tmp16_, (gunichar) ',');
#line 301 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_g_free0 (_tmp15_);
#line 1792 "rygel-media-resource.c"
	}
#line 304 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp17_ = self->priv->_duration;
#line 304 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp17_ >= ((glong) 0)) {
#line 1798 "rygel-media-resource.c"
		GString* _tmp18_ = NULL;
		GString* _tmp19_ = NULL;
		glong _tmp20_ = 0L;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		GString* _tmp23_ = NULL;
#line 305 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp18_ = strbuf;
#line 305 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp19_ = g_string_append (_tmp18_, "duration ");
#line 305 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp20_ = self->priv->_duration;
#line 305 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp21_ = g_strdup_printf ("%li", _tmp20_);
#line 305 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp22_ = _tmp21_;
#line 305 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp23_ = g_string_append (_tmp19_, _tmp22_);
#line 305 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_string_append_unichar (_tmp23_, (gunichar) ',');
#line 305 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_g_free0 (_tmp22_);
#line 1821 "rygel-media-resource.c"
	}
#line 308 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp24_ = self->priv->_bitrate;
#line 308 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp24_ >= 0) {
#line 1827 "rygel-media-resource.c"
		GString* _tmp25_ = NULL;
		GString* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		GString* _tmp30_ = NULL;
#line 309 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp25_ = strbuf;
#line 309 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp26_ = g_string_append (_tmp25_, "bitrate ");
#line 309 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp27_ = self->priv->_bitrate;
#line 309 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp28_ = g_strdup_printf ("%i", _tmp27_);
#line 309 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp29_ = _tmp28_;
#line 309 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp30_ = g_string_append (_tmp26_, _tmp29_);
#line 309 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_string_append_unichar (_tmp30_, (gunichar) ',');
#line 309 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_g_free0 (_tmp29_);
#line 1850 "rygel-media-resource.c"
	}
#line 312 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp31_ = self->priv->_bits_per_sample;
#line 312 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp31_ >= 0) {
#line 1856 "rygel-media-resource.c"
		GString* _tmp32_ = NULL;
		GString* _tmp33_ = NULL;
		gint _tmp34_ = 0;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		GString* _tmp37_ = NULL;
#line 313 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp32_ = strbuf;
#line 313 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp33_ = g_string_append (_tmp32_, "bits_per_sample ");
#line 313 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp34_ = self->priv->_bits_per_sample;
#line 313 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp35_ = g_strdup_printf ("%i", _tmp34_);
#line 313 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp36_ = _tmp35_;
#line 313 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp37_ = g_string_append (_tmp33_, _tmp36_);
#line 313 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_string_append_unichar (_tmp37_, (gunichar) ',');
#line 313 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_g_free0 (_tmp36_);
#line 1879 "rygel-media-resource.c"
	}
#line 316 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp38_ = self->priv->_width;
#line 316 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp38_ >= 0) {
#line 1885 "rygel-media-resource.c"
		GString* _tmp39_ = NULL;
		GString* _tmp40_ = NULL;
		gint _tmp41_ = 0;
		gchar* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		GString* _tmp44_ = NULL;
#line 317 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp39_ = strbuf;
#line 317 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp40_ = g_string_append (_tmp39_, "width ");
#line 317 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp41_ = self->priv->_width;
#line 317 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp42_ = g_strdup_printf ("%i", _tmp41_);
#line 317 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp43_ = _tmp42_;
#line 317 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp44_ = g_string_append (_tmp40_, _tmp43_);
#line 317 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_string_append_unichar (_tmp44_, (gunichar) ',');
#line 317 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_g_free0 (_tmp43_);
#line 1908 "rygel-media-resource.c"
	}
#line 320 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp45_ = self->priv->_height;
#line 320 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp45_ >= 0) {
#line 1914 "rygel-media-resource.c"
		GString* _tmp46_ = NULL;
		GString* _tmp47_ = NULL;
		gint _tmp48_ = 0;
		gchar* _tmp49_ = NULL;
		gchar* _tmp50_ = NULL;
		GString* _tmp51_ = NULL;
#line 321 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp46_ = strbuf;
#line 321 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp47_ = g_string_append (_tmp46_, "height ");
#line 321 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp48_ = self->priv->_height;
#line 321 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp49_ = g_strdup_printf ("%i", _tmp48_);
#line 321 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp50_ = _tmp49_;
#line 321 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp51_ = g_string_append (_tmp47_, _tmp50_);
#line 321 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_string_append_unichar (_tmp51_, (gunichar) ',');
#line 321 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_g_free0 (_tmp50_);
#line 1937 "rygel-media-resource.c"
	}
#line 324 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp52_ = self->priv->_color_depth;
#line 324 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp52_ >= 0) {
#line 1943 "rygel-media-resource.c"
		GString* _tmp53_ = NULL;
		GString* _tmp54_ = NULL;
		gint _tmp55_ = 0;
		gchar* _tmp56_ = NULL;
		gchar* _tmp57_ = NULL;
		GString* _tmp58_ = NULL;
#line 325 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp53_ = strbuf;
#line 325 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp54_ = g_string_append (_tmp53_, "color_depth ");
#line 325 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp55_ = self->priv->_color_depth;
#line 325 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp56_ = g_strdup_printf ("%i", _tmp55_);
#line 325 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp57_ = _tmp56_;
#line 325 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp58_ = g_string_append (_tmp54_, _tmp57_);
#line 325 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_string_append_unichar (_tmp58_, (gunichar) ',');
#line 325 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_g_free0 (_tmp57_);
#line 1966 "rygel-media-resource.c"
	}
#line 328 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp59_ = self->priv->_audio_channels;
#line 328 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp59_ >= 0) {
#line 1972 "rygel-media-resource.c"
		GString* _tmp60_ = NULL;
		GString* _tmp61_ = NULL;
		gint _tmp62_ = 0;
		gchar* _tmp63_ = NULL;
		gchar* _tmp64_ = NULL;
		GString* _tmp65_ = NULL;
#line 329 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp60_ = strbuf;
#line 329 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp61_ = g_string_append (_tmp60_, "audio_channels ");
#line 329 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp62_ = self->priv->_audio_channels;
#line 329 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp63_ = g_strdup_printf ("%i", _tmp62_);
#line 329 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp64_ = _tmp63_;
#line 329 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp65_ = g_string_append (_tmp61_, _tmp64_);
#line 329 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_string_append_unichar (_tmp65_, (gunichar) ',');
#line 329 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_g_free0 (_tmp64_);
#line 1995 "rygel-media-resource.c"
	}
#line 332 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp66_ = self->priv->_sample_freq;
#line 332 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp66_ >= 0) {
#line 2001 "rygel-media-resource.c"
		GString* _tmp67_ = NULL;
		GString* _tmp68_ = NULL;
		gint _tmp69_ = 0;
		gchar* _tmp70_ = NULL;
		gchar* _tmp71_ = NULL;
		GString* _tmp72_ = NULL;
#line 333 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp67_ = strbuf;
#line 333 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp68_ = g_string_append (_tmp67_, "sample_freq ");
#line 333 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp69_ = self->priv->_sample_freq;
#line 333 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp70_ = g_strdup_printf ("%i", _tmp69_);
#line 333 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp71_ = _tmp70_;
#line 333 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp72_ = g_string_append (_tmp68_, _tmp71_);
#line 333 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_string_append_unichar (_tmp72_, (gunichar) ',');
#line 333 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_g_free0 (_tmp71_);
#line 2024 "rygel-media-resource.c"
	}
#line 336 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp73_ = self->priv->_network;
#line 336 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp73_ != NULL) {
#line 2030 "rygel-media-resource.c"
		GString* _tmp74_ = NULL;
		GString* _tmp75_ = NULL;
		const gchar* _tmp76_ = NULL;
		GString* _tmp77_ = NULL;
#line 337 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp74_ = strbuf;
#line 337 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp75_ = g_string_append (_tmp74_, "network ");
#line 337 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp76_ = self->priv->_network;
#line 337 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp77_ = g_string_append (_tmp75_, _tmp76_);
#line 337 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_string_append_unichar (_tmp77_, (gunichar) ',');
#line 2045 "rygel-media-resource.c"
	}
#line 340 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp79_ = self->priv->_protocol;
#line 340 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp79_ == NULL) {
#line 340 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp78_ = "null";
#line 2053 "rygel-media-resource.c"
	} else {
		const gchar* _tmp80_ = NULL;
#line 340 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp80_ = self->priv->_protocol;
#line 340 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp78_ = _tmp80_;
#line 2060 "rygel-media-resource.c"
	}
#line 339 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp81_ = strbuf;
#line 339 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp82_ = g_string_append (_tmp81_, "protocol ");
#line 339 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp83_ = g_string_append (_tmp82_, _tmp78_);
#line 339 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_string_append_unichar (_tmp83_, (gunichar) ',');
#line 343 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp85_ = self->priv->_mime_type;
#line 343 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp85_ == NULL) {
#line 343 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp84_ = "null";
#line 2076 "rygel-media-resource.c"
	} else {
		const gchar* _tmp86_ = NULL;
#line 343 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp86_ = self->priv->_mime_type;
#line 343 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp84_ = _tmp86_;
#line 2083 "rygel-media-resource.c"
	}
#line 342 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp87_ = strbuf;
#line 342 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp88_ = g_string_append (_tmp87_, "mime_type ");
#line 342 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp89_ = g_string_append (_tmp88_, _tmp84_);
#line 342 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_string_append_unichar (_tmp89_, (gunichar) ',');
#line 346 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp91_ = self->priv->_dlna_profile;
#line 346 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp91_ == NULL) {
#line 346 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp90_ = "null";
#line 2099 "rygel-media-resource.c"
	} else {
		const gchar* _tmp92_ = NULL;
#line 346 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp92_ = self->priv->_dlna_profile;
#line 346 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp90_ = _tmp92_;
#line 2106 "rygel-media-resource.c"
	}
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp93_ = strbuf;
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp94_ = g_string_append (_tmp93_, "dlna_profile ");
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp95_ = g_string_append (_tmp94_, _tmp90_);
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_string_append_unichar (_tmp95_, (gunichar) ',');
#line 348 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp96_ = strbuf;
#line 348 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp97_ = self->priv->_dlna_flags;
#line 348 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_string_append_printf (_tmp96_, "dlna_flags %.8X [", (guint) _tmp97_);
#line 349 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp98_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_SENDER_PACED);
#line 349 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp98_) {
#line 2126 "rygel-media-resource.c"
		GString* _tmp99_ = NULL;
#line 350 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp99_ = strbuf;
#line 350 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_string_append (_tmp99_, "sp-flag ");
#line 2132 "rygel-media-resource.c"
	}
#line 352 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp100_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_TIME_BASED_SEEK);
#line 352 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp100_) {
#line 2138 "rygel-media-resource.c"
		GString* _tmp101_ = NULL;
#line 353 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp101_ = strbuf;
#line 353 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_string_append (_tmp101_, "lop-time ");
#line 2144 "rygel-media-resource.c"
	}
#line 355 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp102_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_BYTE_BASED_SEEK);
#line 355 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp102_) {
#line 2150 "rygel-media-resource.c"
		GString* _tmp103_ = NULL;
#line 356 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp103_ = strbuf;
#line 356 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_string_append (_tmp103_, "lop-byte ");
#line 2156 "rygel-media-resource.c"
	}
#line 358 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp104_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_S0_INCREASE);
#line 358 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp104_) {
#line 2162 "rygel-media-resource.c"
		GString* _tmp105_ = NULL;
#line 359 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp105_ = strbuf;
#line 359 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_string_append (_tmp105_, "s0-increase ");
#line 2168 "rygel-media-resource.c"
	}
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp106_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_SN_INCREASE);
#line 361 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp106_) {
#line 2174 "rygel-media-resource.c"
		GString* _tmp107_ = NULL;
#line 362 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp107_ = strbuf;
#line 362 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_string_append (_tmp107_, "sn-increase ");
#line 2180 "rygel-media-resource.c"
	}
#line 364 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp108_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE);
#line 364 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp108_) {
#line 2186 "rygel-media-resource.c"
		GString* _tmp109_ = NULL;
#line 365 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp109_ = strbuf;
#line 365 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_string_append (_tmp109_, "streaming ");
#line 2192 "rygel-media-resource.c"
	}
#line 367 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp110_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_INTERACTIVE_TRANSFER_MODE);
#line 367 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp110_) {
#line 2198 "rygel-media-resource.c"
		GString* _tmp111_ = NULL;
#line 368 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp111_ = strbuf;
#line 368 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_string_append (_tmp111_, "interactive ");
#line 2204 "rygel-media-resource.c"
	}
#line 370 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp112_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE);
#line 370 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp112_) {
#line 2210 "rygel-media-resource.c"
		GString* _tmp113_ = NULL;
#line 371 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp113_ = strbuf;
#line 371 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_string_append (_tmp113_, "background ");
#line 2216 "rygel-media-resource.c"
	}
#line 373 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp114_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_CONNECTION_STALL);
#line 373 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp114_) {
#line 2222 "rygel-media-resource.c"
		GString* _tmp115_ = NULL;
#line 374 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp115_ = strbuf;
#line 374 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_string_append (_tmp115_, "stall ");
#line 2228 "rygel-media-resource.c"
	}
#line 376 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp116_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_DLNA_V15);
#line 376 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp116_) {
#line 2234 "rygel-media-resource.c"
		GString* _tmp117_ = NULL;
#line 377 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp117_ = strbuf;
#line 377 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_string_append (_tmp117_, "v1.5 ");
#line 2240 "rygel-media-resource.c"
	}
#line 379 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp118_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_LINK_PROTECTED_CONTENT);
#line 379 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp118_) {
#line 2246 "rygel-media-resource.c"
		GString* _tmp119_ = NULL;
#line 380 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp119_ = strbuf;
#line 380 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_string_append (_tmp119_, "link-protected ");
#line 2252 "rygel-media-resource.c"
	}
#line 382 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp120_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_CLEAR_TEXT_BYTE_SEEK_FULL);
#line 382 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp120_) {
#line 2258 "rygel-media-resource.c"
		GString* _tmp121_ = NULL;
#line 383 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp121_ = strbuf;
#line 383 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_string_append (_tmp121_, "cleartext-full ");
#line 2264 "rygel-media-resource.c"
	}
#line 385 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp122_ = rygel_media_resource_is_dlna_protocol_flag_set (self, (glong) GUPNP_DLNA_FLAGS_LOP_CLEAR_TEXT_BYTE_SEEK);
#line 385 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp122_) {
#line 2270 "rygel-media-resource.c"
		GString* _tmp123_ = NULL;
#line 386 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp123_ = strbuf;
#line 386 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_string_append (_tmp123_, "cleartext-lop ");
#line 2276 "rygel-media-resource.c"
	}
#line 388 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp124_ = strbuf;
#line 388 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp125_ = strbuf;
#line 388 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp126_ = _tmp125_->len;
#line 388 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_string_overwrite (_tmp124_, (gsize) (_tmp126_ - 1), "],");
#line 390 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp127_ = self->priv->_dlna_conversion;
#line 390 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp127_ != GUPNP_DLNA_CONVERSION_NONE) {
#line 2290 "rygel-media-resource.c"
		GString* _tmp128_ = NULL;
		GUPnPDLNAConversion _tmp129_ = 0;
#line 391 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp128_ = strbuf;
#line 391 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp129_ = self->priv->_dlna_conversion;
#line 391 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_string_append_printf (_tmp128_, "dlna_conversion %1d,", (gint) _tmp129_);
#line 2299 "rygel-media-resource.c"
	}
#line 393 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp130_ = self->priv->_dlna_operation;
#line 393 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp130_ != GUPNP_DLNA_OPERATION_NONE) {
#line 2305 "rygel-media-resource.c"
		GString* _tmp131_ = NULL;
		GUPnPDLNAOperation _tmp132_ = 0;
		gboolean _tmp133_ = FALSE;
		gboolean _tmp135_ = FALSE;
		GString* _tmp137_ = NULL;
		GString* _tmp138_ = NULL;
		gssize _tmp139_ = 0L;
#line 394 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp131_ = strbuf;
#line 394 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp132_ = self->priv->_dlna_operation;
#line 394 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_string_append_printf (_tmp131_, "dlna_operation %.2X [", (guint) _tmp132_);
#line 395 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp133_ = rygel_media_resource_is_dlna_operation_mode_set (self, (glong) GUPNP_DLNA_OPERATION_RANGE);
#line 395 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		if (_tmp133_) {
#line 2323 "rygel-media-resource.c"
			GString* _tmp134_ = NULL;
#line 396 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
			_tmp134_ = strbuf;
#line 396 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
			g_string_append (_tmp134_, "byte-seek ");
#line 2329 "rygel-media-resource.c"
		}
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp135_ = rygel_media_resource_is_dlna_operation_mode_set (self, (glong) GUPNP_DLNA_OPERATION_TIMESEEK);
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		if (_tmp135_) {
#line 2335 "rygel-media-resource.c"
			GString* _tmp136_ = NULL;
#line 399 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
			_tmp136_ = strbuf;
#line 399 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
			g_string_append (_tmp136_, "time-seek ");
#line 2341 "rygel-media-resource.c"
		}
#line 401 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp137_ = strbuf;
#line 401 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp138_ = strbuf;
#line 401 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp139_ = _tmp138_->len;
#line 401 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_string_overwrite (_tmp137_, (gsize) (_tmp139_ - 1), "],");
#line 2351 "rygel-media-resource.c"
	}
#line 403 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp140_ = self->play_speeds;
#line 403 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp140__length1 = self->play_speeds_length1;
#line 403 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp140_ != NULL) {
#line 2359 "rygel-media-resource.c"
		GString* _tmp141_ = NULL;
		gchar** _tmp142_ = NULL;
		gint _tmp142__length1 = 0;
		GString* _tmp147_ = NULL;
		GString* _tmp148_ = NULL;
		gssize _tmp149_ = 0L;
#line 404 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp141_ = strbuf;
#line 404 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_string_append (_tmp141_, "play_speeds [");
#line 405 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp142_ = self->play_speeds;
#line 405 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp142__length1 = self->play_speeds_length1;
#line 2374 "rygel-media-resource.c"
		{
			gchar** speed_collection = NULL;
			gint speed_collection_length1 = 0;
			gint _speed_collection_size_ = 0;
			gint speed_it = 0;
#line 405 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
			speed_collection = _tmp142_;
#line 405 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
			speed_collection_length1 = _tmp142__length1;
#line 405 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
			for (speed_it = 0; speed_it < _tmp142__length1; speed_it = speed_it + 1) {
#line 2386 "rygel-media-resource.c"
				gchar* _tmp143_ = NULL;
				gchar* speed = NULL;
#line 405 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
				_tmp143_ = g_strdup (speed_collection[speed_it]);
#line 405 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
				speed = _tmp143_;
#line 2393 "rygel-media-resource.c"
				{
					GString* _tmp144_ = NULL;
					const gchar* _tmp145_ = NULL;
					GString* _tmp146_ = NULL;
#line 406 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
					_tmp144_ = strbuf;
#line 406 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
					_tmp145_ = speed;
#line 406 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
					_tmp146_ = g_string_append (_tmp144_, _tmp145_);
#line 406 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
					g_string_append_unichar (_tmp146_, (gunichar) ',');
#line 405 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
					_g_free0 (speed);
#line 2408 "rygel-media-resource.c"
				}
			}
		}
#line 408 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp147_ = strbuf;
#line 408 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp148_ = strbuf;
#line 408 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp149_ = _tmp148_->len;
#line 408 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_string_overwrite (_tmp147_, (gsize) (_tmp149_ - 1), "]");
#line 2420 "rygel-media-resource.c"
	}
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp151_ = self->priv->_uri;
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	if (_tmp151_ == NULL) {
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp150_ = "null";
#line 2428 "rygel-media-resource.c"
	} else {
		const gchar* _tmp152_ = NULL;
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp152_ = self->priv->_uri;
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		_tmp150_ = _tmp152_;
#line 2435 "rygel-media-resource.c"
	}
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp153_ = strbuf;
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp154_ = g_string_append (_tmp153_, ",uri ");
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_string_append (_tmp154_, _tmp150_);
#line 411 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp155_ = strbuf;
#line 411 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_string_append_unichar (_tmp155_, (gunichar) ')');
#line 413 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp156_ = strbuf;
#line 413 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp157_ = _tmp156_->str;
#line 413 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp158_ = g_strdup (_tmp157_);
#line 413 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp158_;
#line 413 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_g_string_free0 (strbuf);
#line 413 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 2459 "rygel-media-resource.c"
}


const gchar* rygel_media_resource_get_uri (RygelMediaResource* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = self->priv->_uri;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0_;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 2474 "rygel-media-resource.c"
}


void rygel_media_resource_set_uri (RygelMediaResource* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_if_fail (self != NULL);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = value;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_g_free0 (self->priv->_uri);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_uri = _tmp1_;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_notify ((GObject *) self, "uri");
#line 2493 "rygel-media-resource.c"
}


const gchar* rygel_media_resource_get_import_uri (RygelMediaResource* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = self->priv->_import_uri;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 2508 "rygel-media-resource.c"
}


void rygel_media_resource_set_import_uri (RygelMediaResource* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_if_fail (self != NULL);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = value;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_g_free0 (self->priv->_import_uri);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_import_uri = _tmp1_;
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_notify ((GObject *) self, "import-uri");
#line 2527 "rygel-media-resource.c"
}


const gchar* rygel_media_resource_get_extension (RygelMediaResource* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = self->priv->_extension;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0_;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 2542 "rygel-media-resource.c"
}


void rygel_media_resource_set_extension (RygelMediaResource* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_if_fail (self != NULL);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = value;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_g_free0 (self->priv->_extension);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_extension = _tmp1_;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_notify ((GObject *) self, "extension");
#line 2561 "rygel-media-resource.c"
}


gint64 rygel_media_resource_get_size (RygelMediaResource* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = self->priv->_size;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0_;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 2576 "rygel-media-resource.c"
}


void rygel_media_resource_set_size (RygelMediaResource* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_if_fail (self != NULL);
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = value;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_size = _tmp0_;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_notify ((GObject *) self, "size");
#line 2590 "rygel-media-resource.c"
}


gint64 rygel_media_resource_get_cleartext_size (RygelMediaResource* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = self->priv->_cleartext_size;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0_;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 2605 "rygel-media-resource.c"
}


void rygel_media_resource_set_cleartext_size (RygelMediaResource* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_if_fail (self != NULL);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = value;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_cleartext_size = _tmp0_;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_notify ((GObject *) self, "cleartext-size");
#line 2619 "rygel-media-resource.c"
}


glong rygel_media_resource_get_duration (RygelMediaResource* self) {
	glong result;
	glong _tmp0_ = 0L;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, 0L);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = self->priv->_duration;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0_;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 2634 "rygel-media-resource.c"
}


void rygel_media_resource_set_duration (RygelMediaResource* self, glong value) {
	glong _tmp0_ = 0L;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_if_fail (self != NULL);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = value;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_duration = _tmp0_;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_notify ((GObject *) self, "duration");
#line 2648 "rygel-media-resource.c"
}


gint rygel_media_resource_get_bitrate (RygelMediaResource* self) {
	gint result;
	gint _tmp0_ = 0;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = self->priv->_bitrate;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0_;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 2663 "rygel-media-resource.c"
}


void rygel_media_resource_set_bitrate (RygelMediaResource* self, gint value) {
	gint _tmp0_ = 0;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_if_fail (self != NULL);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = value;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_bitrate = _tmp0_;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_notify ((GObject *) self, "bitrate");
#line 2677 "rygel-media-resource.c"
}


gint rygel_media_resource_get_bits_per_sample (RygelMediaResource* self) {
	gint result;
	gint _tmp0_ = 0;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = self->priv->_bits_per_sample;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0_;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 2692 "rygel-media-resource.c"
}


void rygel_media_resource_set_bits_per_sample (RygelMediaResource* self, gint value) {
	gint _tmp0_ = 0;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_if_fail (self != NULL);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = value;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_bits_per_sample = _tmp0_;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_notify ((GObject *) self, "bits-per-sample");
#line 2706 "rygel-media-resource.c"
}


gint rygel_media_resource_get_color_depth (RygelMediaResource* self) {
	gint result;
	gint _tmp0_ = 0;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = self->priv->_color_depth;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0_;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 2721 "rygel-media-resource.c"
}


void rygel_media_resource_set_color_depth (RygelMediaResource* self, gint value) {
	gint _tmp0_ = 0;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_if_fail (self != NULL);
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = value;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_color_depth = _tmp0_;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_notify ((GObject *) self, "color-depth");
#line 2735 "rygel-media-resource.c"
}


gint rygel_media_resource_get_width (RygelMediaResource* self) {
	gint result;
	gint _tmp0_ = 0;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = self->priv->_width;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0_;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 2750 "rygel-media-resource.c"
}


void rygel_media_resource_set_width (RygelMediaResource* self, gint value) {
	gint _tmp0_ = 0;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_if_fail (self != NULL);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = value;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_width = _tmp0_;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_notify ((GObject *) self, "width");
#line 2764 "rygel-media-resource.c"
}


gint rygel_media_resource_get_height (RygelMediaResource* self) {
	gint result;
	gint _tmp0_ = 0;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = self->priv->_height;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0_;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 2779 "rygel-media-resource.c"
}


void rygel_media_resource_set_height (RygelMediaResource* self, gint value) {
	gint _tmp0_ = 0;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_if_fail (self != NULL);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = value;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_height = _tmp0_;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_notify ((GObject *) self, "height");
#line 2793 "rygel-media-resource.c"
}


gint rygel_media_resource_get_audio_channels (RygelMediaResource* self) {
	gint result;
	gint _tmp0_ = 0;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = self->priv->_audio_channels;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0_;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 2808 "rygel-media-resource.c"
}


void rygel_media_resource_set_audio_channels (RygelMediaResource* self, gint value) {
	gint _tmp0_ = 0;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_if_fail (self != NULL);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = value;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_audio_channels = _tmp0_;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_notify ((GObject *) self, "audio-channels");
#line 2822 "rygel-media-resource.c"
}


gint rygel_media_resource_get_sample_freq (RygelMediaResource* self) {
	gint result;
	gint _tmp0_ = 0;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = self->priv->_sample_freq;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0_;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 2837 "rygel-media-resource.c"
}


void rygel_media_resource_set_sample_freq (RygelMediaResource* self, gint value) {
	gint _tmp0_ = 0;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_if_fail (self != NULL);
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = value;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_sample_freq = _tmp0_;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_notify ((GObject *) self, "sample-freq");
#line 2851 "rygel-media-resource.c"
}


const gchar* rygel_media_resource_get_protocol (RygelMediaResource* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = self->priv->_protocol;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0_;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 2866 "rygel-media-resource.c"
}


void rygel_media_resource_set_protocol (RygelMediaResource* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_if_fail (self != NULL);
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = value;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_g_free0 (self->priv->_protocol);
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_protocol = _tmp1_;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_notify ((GObject *) self, "protocol");
#line 2885 "rygel-media-resource.c"
}


const gchar* rygel_media_resource_get_mime_type (RygelMediaResource* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = self->priv->_mime_type;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0_;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 2900 "rygel-media-resource.c"
}


void rygel_media_resource_set_mime_type (RygelMediaResource* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_if_fail (self != NULL);
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = value;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_g_free0 (self->priv->_mime_type);
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_mime_type = _tmp1_;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_notify ((GObject *) self, "mime-type");
#line 2919 "rygel-media-resource.c"
}


const gchar* rygel_media_resource_get_dlna_profile (RygelMediaResource* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = self->priv->_dlna_profile;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0_;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 2934 "rygel-media-resource.c"
}


void rygel_media_resource_set_dlna_profile (RygelMediaResource* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_if_fail (self != NULL);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = value;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_g_free0 (self->priv->_dlna_profile);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_dlna_profile = _tmp1_;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_notify ((GObject *) self, "dlna-profile");
#line 2953 "rygel-media-resource.c"
}


const gchar* rygel_media_resource_get_network (RygelMediaResource* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = self->priv->_network;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0_;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 2968 "rygel-media-resource.c"
}


void rygel_media_resource_set_network (RygelMediaResource* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_if_fail (self != NULL);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = value;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_g_free0 (self->priv->_network);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_network = _tmp1_;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_notify ((GObject *) self, "network");
#line 2987 "rygel-media-resource.c"
}


GUPnPDLNAConversion rygel_media_resource_get_dlna_conversion (RygelMediaResource* self) {
	GUPnPDLNAConversion result;
	GUPnPDLNAConversion _tmp0_ = 0;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = self->priv->_dlna_conversion;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0_;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 3002 "rygel-media-resource.c"
}


void rygel_media_resource_set_dlna_conversion (RygelMediaResource* self, GUPnPDLNAConversion value) {
	GUPnPDLNAConversion _tmp0_ = 0;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_if_fail (self != NULL);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = value;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_dlna_conversion = _tmp0_;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_notify ((GObject *) self, "dlna-conversion");
#line 3016 "rygel-media-resource.c"
}


GUPnPDLNAFlags rygel_media_resource_get_dlna_flags (RygelMediaResource* self) {
	GUPnPDLNAFlags result;
	GUPnPDLNAFlags _tmp0_ = 0;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = self->priv->_dlna_flags;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0_;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 3031 "rygel-media-resource.c"
}


void rygel_media_resource_set_dlna_flags (RygelMediaResource* self, GUPnPDLNAFlags value) {
	GUPnPDLNAFlags _tmp0_ = 0;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_if_fail (self != NULL);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = value;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_dlna_flags = _tmp0_;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_notify ((GObject *) self, "dlna-flags");
#line 3045 "rygel-media-resource.c"
}


GUPnPDLNAOperation rygel_media_resource_get_dlna_operation (RygelMediaResource* self) {
	GUPnPDLNAOperation result;
	GUPnPDLNAOperation _tmp0_ = 0;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = self->priv->_dlna_operation;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	result = _tmp0_;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	return result;
#line 3060 "rygel-media-resource.c"
}


void rygel_media_resource_set_dlna_operation (RygelMediaResource* self, GUPnPDLNAOperation value) {
	GUPnPDLNAOperation _tmp0_ = 0;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_return_if_fail (self != NULL);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_tmp0_ = value;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_dlna_operation = _tmp0_;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_notify ((GObject *) self, "dlna-operation");
#line 3074 "rygel-media-resource.c"
}


static void rygel_media_resource_class_init (RygelMediaResourceClass * klass) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	rygel_media_resource_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaResourcePrivate));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_resource_get_property;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_resource_set_property;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_resource_finalize;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_IMPORT_URI, g_param_spec_string ("import-uri", "import-uri", "import-uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_EXTENSION, g_param_spec_string ("extension", "extension", "extension", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_SIZE, g_param_spec_int64 ("size", "size", "size", G_MININT64, G_MAXINT64, (gint64) (-1), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_CLEARTEXT_SIZE, g_param_spec_int64 ("cleartext-size", "cleartext-size", "cleartext-size", G_MININT64, G_MAXINT64, (gint64) (-1), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_DURATION, g_param_spec_long ("duration", "duration", "duration", G_MINLONG, G_MAXLONG, (glong) (-1), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_BITRATE, g_param_spec_int ("bitrate", "bitrate", "bitrate", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_BITS_PER_SAMPLE, g_param_spec_int ("bits-per-sample", "bits-per-sample", "bits-per-sample", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_COLOR_DEPTH, g_param_spec_int ("color-depth", "color-depth", "color-depth", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_WIDTH, g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_HEIGHT, g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_AUDIO_CHANNELS, g_param_spec_int ("audio-channels", "audio-channels", "audio-channels", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_SAMPLE_FREQ, g_param_spec_int ("sample-freq", "sample-freq", "sample-freq", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_PROTOCOL, g_param_spec_string ("protocol", "protocol", "protocol", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_MIME_TYPE, g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_DLNA_PROFILE, g_param_spec_string ("dlna-profile", "dlna-profile", "dlna-profile", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_NETWORK, g_param_spec_string ("network", "network", "network", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_DLNA_CONVERSION, g_param_spec_flags ("dlna-conversion", "dlna-conversion", "dlna-conversion", gupnp_dlna_conversion_get_type (), GUPNP_DLNA_CONVERSION_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_DLNA_FLAGS, g_param_spec_flags ("dlna-flags", "dlna-flags", "dlna-flags", gupnp_dlna_flags_get_type (), GUPNP_DLNA_FLAGS_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RESOURCE_DLNA_OPERATION, g_param_spec_flags ("dlna-operation", "dlna-operation", "dlna-operation", gupnp_dlna_operation_get_type (), GUPNP_DLNA_OPERATION_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3129 "rygel-media-resource.c"
}


static void rygel_media_resource_instance_init (RygelMediaResource * self) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv = RYGEL_MEDIA_RESOURCE_GET_PRIVATE (self);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_extension = NULL;
#line 43 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_size = (gint64) (-1);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_cleartext_size = (gint64) (-1);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_duration = (glong) (-1);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_bitrate = -1;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_bits_per_sample = -1;
#line 48 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_color_depth = -1;
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_width = -1;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_height = -1;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_audio_channels = -1;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_sample_freq = -1;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_protocol = NULL;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_mime_type = NULL;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_dlna_profile = NULL;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_network = NULL;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->play_speeds = NULL;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->play_speeds_length1 = 0;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_dlna_conversion = GUPNP_DLNA_CONVERSION_NONE;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_dlna_flags = GUPNP_DLNA_FLAGS_NONE;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->priv->_dlna_operation = GUPNP_DLNA_OPERATION_NONE;
#line 3176 "rygel-media-resource.c"
}


static void rygel_media_resource_finalize (GObject* obj) {
	RygelMediaResource * self;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_g_free0 (self->priv->name);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_g_free0 (self->priv->_uri);
#line 41 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_g_free0 (self->priv->_import_uri);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_g_free0 (self->priv->_extension);
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_g_free0 (self->priv->_protocol);
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_g_free0 (self->priv->_mime_type);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_g_free0 (self->priv->_dlna_profile);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	_g_free0 (self->priv->_network);
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	self->play_speeds = (_vala_array_free (self->play_speeds, self->play_speeds_length1, (GDestroyNotify) g_free), NULL);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	G_OBJECT_CLASS (rygel_media_resource_parent_class)->finalize (obj);
#line 3204 "rygel-media-resource.c"
}


/**
 * Represents a media resource (Music, Video, Image, etc).
 */
GType rygel_media_resource_get_type (void) {
	static volatile gsize rygel_media_resource_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_resource_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaResourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_resource_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaResource), 0, (GInstanceInitFunc) rygel_media_resource_instance_init, NULL };
		GType rygel_media_resource_type_id;
		rygel_media_resource_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaResource", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_resource_type_id__volatile, rygel_media_resource_type_id);
	}
	return rygel_media_resource_type_id__volatile;
}


static void _vala_rygel_media_resource_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaResource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	switch (property_id) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_URI:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_value_set_string (value, rygel_media_resource_get_uri (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_IMPORT_URI:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_value_set_string (value, rygel_media_resource_get_import_uri (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_EXTENSION:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_value_set_string (value, rygel_media_resource_get_extension (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_SIZE:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_value_set_int64 (value, rygel_media_resource_get_size (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_CLEARTEXT_SIZE:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_value_set_int64 (value, rygel_media_resource_get_cleartext_size (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_DURATION:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_value_set_long (value, rygel_media_resource_get_duration (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_BITRATE:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_value_set_int (value, rygel_media_resource_get_bitrate (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_BITS_PER_SAMPLE:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_value_set_int (value, rygel_media_resource_get_bits_per_sample (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_COLOR_DEPTH:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_value_set_int (value, rygel_media_resource_get_color_depth (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_WIDTH:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_value_set_int (value, rygel_media_resource_get_width (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_HEIGHT:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_value_set_int (value, rygel_media_resource_get_height (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_AUDIO_CHANNELS:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_value_set_int (value, rygel_media_resource_get_audio_channels (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_SAMPLE_FREQ:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_value_set_int (value, rygel_media_resource_get_sample_freq (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_PROTOCOL:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_value_set_string (value, rygel_media_resource_get_protocol (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_MIME_TYPE:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_value_set_string (value, rygel_media_resource_get_mime_type (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_DLNA_PROFILE:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_value_set_string (value, rygel_media_resource_get_dlna_profile (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_NETWORK:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_value_set_string (value, rygel_media_resource_get_network (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_DLNA_CONVERSION:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_value_set_flags (value, rygel_media_resource_get_dlna_conversion (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_DLNA_FLAGS:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_value_set_flags (value, rygel_media_resource_get_dlna_flags (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_DLNA_OPERATION:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		g_value_set_flags (value, rygel_media_resource_get_dlna_operation (self));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 3348 "rygel-media-resource.c"
		default:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 3354 "rygel-media-resource.c"
	}
}


static void _vala_rygel_media_resource_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaResource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
	switch (property_id) {
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_URI:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		rygel_media_resource_set_uri (self, g_value_get_string (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_IMPORT_URI:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		rygel_media_resource_set_import_uri (self, g_value_get_string (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_EXTENSION:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		rygel_media_resource_set_extension (self, g_value_get_string (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_SIZE:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		rygel_media_resource_set_size (self, g_value_get_int64 (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_CLEARTEXT_SIZE:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		rygel_media_resource_set_cleartext_size (self, g_value_get_int64 (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_DURATION:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		rygel_media_resource_set_duration (self, g_value_get_long (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_BITRATE:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		rygel_media_resource_set_bitrate (self, g_value_get_int (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_BITS_PER_SAMPLE:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		rygel_media_resource_set_bits_per_sample (self, g_value_get_int (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_COLOR_DEPTH:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		rygel_media_resource_set_color_depth (self, g_value_get_int (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_WIDTH:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		rygel_media_resource_set_width (self, g_value_get_int (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_HEIGHT:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		rygel_media_resource_set_height (self, g_value_get_int (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_AUDIO_CHANNELS:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		rygel_media_resource_set_audio_channels (self, g_value_get_int (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_SAMPLE_FREQ:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		rygel_media_resource_set_sample_freq (self, g_value_get_int (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_PROTOCOL:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		rygel_media_resource_set_protocol (self, g_value_get_string (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_MIME_TYPE:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		rygel_media_resource_set_mime_type (self, g_value_get_string (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_DLNA_PROFILE:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		rygel_media_resource_set_dlna_profile (self, g_value_get_string (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_NETWORK:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		rygel_media_resource_set_network (self, g_value_get_string (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_DLNA_CONVERSION:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		rygel_media_resource_set_dlna_conversion (self, g_value_get_flags (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_DLNA_FLAGS:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		rygel_media_resource_set_dlna_flags (self, g_value_get_flags (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		case RYGEL_MEDIA_RESOURCE_DLNA_OPERATION:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		rygel_media_resource_set_dlna_operation (self, g_value_get_flags (value));
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 3484 "rygel-media-resource.c"
		default:
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/jens/Source/rygel/src/librygel-server/rygel-media-resource.vala"
		break;
#line 3490 "rygel-media-resource.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



