/* rygel-http-time-seek-request.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-http-time-seek-request.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>


#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;
typedef struct _RygelHTTPSeekRequestPrivate RygelHTTPSeekRequestPrivate;

#define RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST (rygel_http_time_seek_request_get_type ())
#define RYGEL_HTTP_TIME_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, RygelHTTPTimeSeekRequest))
#define RYGEL_HTTP_TIME_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, RygelHTTPTimeSeekRequestClass))
#define RYGEL_IS_HTTP_TIME_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST))
#define RYGEL_IS_HTTP_TIME_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST))
#define RYGEL_HTTP_TIME_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, RygelHTTPTimeSeekRequestClass))

typedef struct _RygelHTTPTimeSeekRequest RygelHTTPTimeSeekRequest;
typedef struct _RygelHTTPTimeSeekRequestClass RygelHTTPTimeSeekRequestClass;
typedef struct _RygelHTTPTimeSeekRequestPrivate RygelHTTPTimeSeekRequestPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_PLAY_SPEED (rygel_play_speed_get_type ())
#define RYGEL_PLAY_SPEED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeed))
#define RYGEL_PLAY_SPEED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeedClass))
#define RYGEL_IS_PLAY_SPEED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED))
#define RYGEL_IS_PLAY_SPEED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED))
#define RYGEL_PLAY_SPEED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeedClass))

typedef struct _RygelPlaySpeed RygelPlaySpeed;
typedef struct _RygelPlaySpeedClass RygelPlaySpeedClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelHTTPSeekRequest {
	GObject parent_instance;
	RygelHTTPSeekRequestPrivate * priv;
};

struct _RygelHTTPSeekRequestClass {
	GObjectClass parent_class;
};

struct _RygelHTTPTimeSeekRequest {
	RygelHTTPSeekRequest parent_instance;
	RygelHTTPTimeSeekRequestPrivate * priv;
	gint64 start_time;
	gint64 end_time;
	gint64 range_duration;
	gint64 total_duration;
};

struct _RygelHTTPTimeSeekRequestClass {
	RygelHTTPSeekRequestClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekRequestError;
#define RYGEL_HTTP_SEEK_REQUEST_ERROR rygel_http_seek_request_error_quark ()
struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPGet {
	RygelHTTPRequest parent_instance;
	RygelHTTPGetPrivate * priv;
	RygelHTTPSeekRequest* seek;
	RygelPlaySpeedRequest* speed_request;
	RygelHTTPGetHandler* handler;
};

struct _RygelHTTPGetClass {
	RygelHTTPRequestClass parent_class;
};

typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()

static gpointer rygel_http_time_seek_request_parent_class = NULL;

GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_http_time_seek_request_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_TIME_SEEK_REQUEST_DUMMY_PROPERTY
};
#define RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER "TimeSeekRange.dlna.org"
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
gpointer rygel_play_speed_ref (gpointer instance);
void rygel_play_speed_unref (gpointer instance);
GParamSpec* rygel_param_spec_play_speed (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_play_speed (GValue* value, gpointer v_object);
void rygel_value_take_play_speed (GValue* value, gpointer v_object);
gpointer rygel_value_get_play_speed (const GValue* value);
GType rygel_play_speed_get_type (void) G_GNUC_CONST;
GQuark rygel_http_seek_request_error_quark (void);
RygelHTTPTimeSeekRequest* rygel_http_time_seek_request_new (RygelHTTPGet* request, RygelPlaySpeed* speed, GError** error);
RygelHTTPTimeSeekRequest* rygel_http_time_seek_request_construct (GType object_type, RygelHTTPGet* request, RygelPlaySpeed* speed, GError** error);
RygelHTTPSeekRequest* rygel_http_seek_request_construct (GType object_type);
gboolean rygel_play_speed_is_positive (RygelPlaySpeed* self);
gboolean rygel_play_speed_is_normal_rate (RygelPlaySpeed* self);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
gint64 rygel_http_get_handler_get_resource_duration (RygelHTTPGetHandler* self);
#define RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED ((gint64) (-1))
static gboolean rygel_http_time_seek_request_parse_npt_time (const gchar* range_token, gint64* value);
gchar* rygel_http_time_seek_request_to_string (RygelHTTPTimeSeekRequest* self);
gboolean rygel_http_time_seek_request_supported (RygelHTTPGet* request);
GQuark rygel_client_hacks_error_quark (void);
RygelClientHacks* rygel_client_hacks_create (SoupMessage* message, GError** error);
gboolean rygel_client_hacks_force_seek (RygelClientHacks* self);
gboolean rygel_http_get_handler_supports_time_seek (RygelHTTPGetHandler* self);
gboolean rygel_http_time_seek_request_requested (RygelHTTPGet* request);
static gboolean rygel_http_time_seek_request_parse_npt_seconds (const gchar* range_token, gint64* value);
static void rygel_http_time_seek_request_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
     * Create a HTTPTimeSeekRequest corresponding with a HTTPGet that contains a
     * TimeSeekRange.dlna.org header value.
     *
     * Note: This constructor will check the syntax of the request (per DLNA 7.5.4.3.2.24.3)
     *       as well as perform some range validation. If the provided request is associated
     *       with a handler that can provide content duration, the start and end time will
     *       be checked for out-of-bounds conditions. Additionally, the start and end will
     *       be checked according to playspeed direction (with rate +1.0 assumed when speed
     *       is not provided). When speed is provided, the range end parameter check is
     *       relaxed when the rate is not +1.0 (per DLNA 7.5.4.3.2.24.4).
     *
     * @param request The HTTP GET/HEAD request
     * @speed speed An associated speed request
     */
static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1198 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1198 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 304 "rygel-http-time-seek-request.c"
		glong _tmp4_ = 0L;
#line 1199 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1199 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1199 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 312 "rygel-http-time-seek-request.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 324 "rygel-http-time-seek-request.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1208 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 348 "rygel-http-time-seek-request.c"
		glong _tmp2_ = 0L;
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 354 "rygel-http-time-seek-request.c"
	} else {
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 358 "rygel-http-time-seek-request.c"
	}
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 362 "rygel-http-time-seek-request.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 374 "rygel-http-time-seek-request.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1214 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1214 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1214 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 384 "rygel-http-time-seek-request.c"
	}
#line 1217 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1217 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 390 "rygel-http-time-seek-request.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1218 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1218 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1218 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1219 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1219 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 404 "rygel-http-time-seek-request.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1221 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1221 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1221 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 414 "rygel-http-time-seek-request.c"
	}
#line 1223 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1223 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 420 "rygel-http-time-seek-request.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1224 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1224 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1224 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 429 "rygel-http-time-seek-request.c"
	}
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 449 "rygel-http-time-seek-request.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1278 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1278 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 469 "rygel-http-time-seek-request.c"
}


RygelHTTPTimeSeekRequest* rygel_http_time_seek_request_construct (GType object_type, RygelHTTPGet* request, RygelPlaySpeed* speed, GError** error) {
	RygelHTTPTimeSeekRequest * self = NULL;
	gboolean _tmp0_ = FALSE;
	RygelPlaySpeed* _tmp1_ = NULL;
	gboolean positive_rate = FALSE;
	gboolean _tmp4_ = FALSE;
	RygelPlaySpeed* _tmp5_ = NULL;
	gboolean trick_mode = FALSE;
	RygelHTTPGet* _tmp8_ = NULL;
	RygelHTTPGetHandler* _tmp9_ = NULL;
	gint64 _tmp10_ = 0LL;
	gint64 _tmp11_ = 0LL;
	gchar* range = NULL;
	RygelHTTPGet* _tmp12_ = NULL;
	SoupMessage* _tmp13_ = NULL;
	SoupMessageHeaders* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	gchar* parsed_range = NULL;
	const gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	gchar** range_tokens = NULL;
	const gchar* _tmp29_ = NULL;
	gchar** _tmp30_ = NULL;
	gchar** _tmp31_ = NULL;
	gint range_tokens_length1 = 0;
	gint _range_tokens_size_ = 0;
	gint64 start = 0LL;
	gchar** _tmp32_ = NULL;
	gint _tmp32__length1 = 0;
	const gchar* _tmp33_ = NULL;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp37_ = FALSE;
	gint64 _tmp38_ = 0LL;
	gint64 end = 0LL;
	gchar** _tmp49_ = NULL;
	gint _tmp49__length1 = 0;
	const gchar* _tmp50_ = NULL;
	gboolean _tmp51_ = FALSE;
	GError * _inner_error_ = NULL;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	g_return_val_if_fail (request != NULL, NULL);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	self = (RygelHTTPTimeSeekRequest*) rygel_http_seek_request_construct (object_type);
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp1_ = speed;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	if (_tmp1_ == NULL) {
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp0_ = TRUE;
#line 528 "rygel-http-time-seek-request.c"
	} else {
		RygelPlaySpeed* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp2_ = speed;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp3_ = rygel_play_speed_is_positive (_tmp2_);
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp0_ = _tmp3_;
#line 538 "rygel-http-time-seek-request.c"
	}
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	positive_rate = _tmp0_;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp5_ = speed;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	if (_tmp5_ != NULL) {
#line 546 "rygel-http-time-seek-request.c"
		RygelPlaySpeed* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp6_ = speed;
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp7_ = rygel_play_speed_is_normal_rate (_tmp6_);
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp4_ = !_tmp7_;
#line 555 "rygel-http-time-seek-request.c"
	} else {
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp4_ = FALSE;
#line 559 "rygel-http-time-seek-request.c"
	}
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	trick_mode = _tmp4_;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp8_ = request;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp9_ = _tmp8_->handler;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp10_ = rygel_http_get_handler_get_resource_duration (_tmp9_);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	self->total_duration = _tmp10_;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp11_ = self->total_duration;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	if (_tmp11_ <= ((gint64) 0)) {
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		self->total_duration = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
#line 577 "rygel-http-time-seek-request.c"
	}
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp12_ = request;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp13_ = ((RygelHTTPRequest*) _tmp12_)->msg;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp14_ = _tmp13_->request_headers;
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp15_ = soup_message_headers_get_one (_tmp14_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp16_ = g_strdup (_tmp15_);
#line 82 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	range = _tmp16_;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp17_ = range;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	if (_tmp17_ == NULL) {
#line 595 "rygel-http-time-seek-request.c"
		GError* _tmp18_ = NULL;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp18_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "%s not present", RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_inner_error_ = _tmp18_;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			g_propagate_error (error, _inner_error_);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_g_free0 (range);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_g_object_unref0 (self);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			return NULL;
#line 611 "rygel-http-time-seek-request.c"
		} else {
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_g_free0 (range);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			g_clear_error (&_inner_error_);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			return NULL;
#line 621 "rygel-http-time-seek-request.c"
		}
	}
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp19_ = range;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp20_ = g_str_has_prefix (_tmp19_, "npt=");
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	if (!_tmp20_) {
#line 630 "rygel-http-time-seek-request.c"
		const gchar* _tmp21_ = NULL;
		GError* _tmp22_ = NULL;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp21_ = range;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp22_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid %s value (missing npt field): '%s'", RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp21_);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_inner_error_ = _tmp22_;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			g_propagate_error (error, _inner_error_);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_g_free0 (range);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_g_object_unref0 (self);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			return NULL;
#line 649 "rygel-http-time-seek-request.c"
		} else {
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_g_free0 (range);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			g_clear_error (&_inner_error_);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			return NULL;
#line 659 "rygel-http-time-seek-request.c"
		}
	}
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp23_ = range;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp24_ = string_substring (_tmp23_, (glong) 4, (glong) (-1));
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	parsed_range = _tmp24_;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp25_ = parsed_range;
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp26_ = string_contains (_tmp25_, "-");
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	if (!_tmp26_) {
#line 674 "rygel-http-time-seek-request.c"
		const gchar* _tmp27_ = NULL;
		GError* _tmp28_ = NULL;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp27_ = range;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp28_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid %s request with no '-': '%s'", RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp27_);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_inner_error_ = _tmp28_;
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			g_propagate_error (error, _inner_error_);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_g_free0 (parsed_range);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_g_free0 (range);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_g_object_unref0 (self);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			return NULL;
#line 695 "rygel-http-time-seek-request.c"
		} else {
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_g_free0 (parsed_range);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_g_free0 (range);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			g_clear_error (&_inner_error_);
#line 97 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			return NULL;
#line 707 "rygel-http-time-seek-request.c"
		}
	}
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp29_ = parsed_range;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp31_ = _tmp30_ = g_strsplit (_tmp29_, "-", 2);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	range_tokens = _tmp31_;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	range_tokens_length1 = _vala_array_length (_tmp30_);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_range_tokens_size_ = range_tokens_length1;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	start = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp32_ = range_tokens;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp32__length1 = range_tokens_length1;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp33_ = _tmp32_[0];
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp34_ = rygel_http_time_seek_request_parse_npt_time (_tmp33_, &start);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	if (!_tmp34_) {
#line 732 "rygel-http-time-seek-request.c"
		const gchar* _tmp35_ = NULL;
		GError* _tmp36_ = NULL;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp35_ = range;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp36_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid %s value (no start): '%s'", RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp35_);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_inner_error_ = _tmp36_;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			g_propagate_error (error, _inner_error_);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_g_free0 (parsed_range);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_g_free0 (range);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_g_object_unref0 (self);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			return NULL;
#line 755 "rygel-http-time-seek-request.c"
		} else {
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_g_free0 (parsed_range);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_g_free0 (range);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			g_clear_error (&_inner_error_);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			return NULL;
#line 769 "rygel-http-time-seek-request.c"
		}
	}
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp38_ = self->total_duration;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	if (_tmp38_ != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
#line 776 "rygel-http-time-seek-request.c"
		gint64 _tmp39_ = 0LL;
		gint64 _tmp40_ = 0LL;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp39_ = start;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp40_ = self->total_duration;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp37_ = _tmp39_ > _tmp40_;
#line 785 "rygel-http-time-seek-request.c"
	} else {
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp37_ = FALSE;
#line 789 "rygel-http-time-seek-request.c"
	}
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	if (_tmp37_) {
#line 793 "rygel-http-time-seek-request.c"
		gboolean _tmp41_ = FALSE;
		gboolean _tmp42_ = FALSE;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp42_ = trick_mode;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		if (_tmp42_) {
#line 800 "rygel-http-time-seek-request.c"
			gboolean _tmp43_ = FALSE;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_tmp43_ = positive_rate;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_tmp41_ = !_tmp43_;
#line 806 "rygel-http-time-seek-request.c"
		} else {
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_tmp41_ = FALSE;
#line 810 "rygel-http-time-seek-request.c"
		}
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		if (_tmp41_) {
#line 814 "rygel-http-time-seek-request.c"
			gint64 _tmp44_ = 0LL;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_tmp44_ = self->total_duration;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			self->start_time = _tmp44_;
#line 820 "rygel-http-time-seek-request.c"
		} else {
			gint64 _tmp45_ = 0LL;
			gint64 _tmp46_ = 0LL;
			GError* _tmp47_ = NULL;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_tmp45_ = start;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_tmp46_ = self->total_duration;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_tmp47_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE, "Invalid %s start time %lldns is beyond the content duration of %lldns", RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp45_, _tmp46_);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_inner_error_ = _tmp47_;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				g_propagate_error (error, _inner_error_);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				_g_free0 (parsed_range);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				_g_free0 (range);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				_g_object_unref0 (self);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				return NULL;
#line 847 "rygel-http-time-seek-request.c"
			} else {
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				_g_free0 (parsed_range);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				_g_free0 (range);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				g_clear_error (&_inner_error_);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				return NULL;
#line 861 "rygel-http-time-seek-request.c"
			}
		}
	} else {
		gint64 _tmp48_ = 0LL;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp48_ = start;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		self->start_time = _tmp48_;
#line 870 "rygel-http-time-seek-request.c"
	}
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	end = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp49_ = range_tokens;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp49__length1 = range_tokens_length1;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp50_ = _tmp49_[1];
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp51_ = rygel_http_time_seek_request_parse_npt_time (_tmp50_, &end);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	if (_tmp51_) {
#line 884 "rygel-http-time-seek-request.c"
		gboolean _tmp52_ = FALSE;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp52_ = positive_rate;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		if (_tmp52_) {
#line 890 "rygel-http-time-seek-request.c"
			gboolean _tmp53_ = FALSE;
			gint64 _tmp54_ = 0LL;
			gint64 _tmp63_ = 0LL;
			gint64 _tmp64_ = 0LL;
			gint64 _tmp65_ = 0LL;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_tmp54_ = self->total_duration;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			if (_tmp54_ != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
#line 900 "rygel-http-time-seek-request.c"
				gint64 _tmp55_ = 0LL;
				gint64 _tmp56_ = 0LL;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				_tmp55_ = end;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				_tmp56_ = self->total_duration;
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				_tmp53_ = _tmp55_ > _tmp56_;
#line 909 "rygel-http-time-seek-request.c"
			} else {
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				_tmp53_ = FALSE;
#line 913 "rygel-http-time-seek-request.c"
			}
#line 131 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			if (_tmp53_) {
#line 917 "rygel-http-time-seek-request.c"
				gboolean _tmp57_ = FALSE;
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				_tmp57_ = trick_mode;
#line 132 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				if (_tmp57_) {
#line 923 "rygel-http-time-seek-request.c"
					gint64 _tmp58_ = 0LL;
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					_tmp58_ = self->total_duration;
#line 133 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					self->end_time = _tmp58_;
#line 929 "rygel-http-time-seek-request.c"
				} else {
					gint64 _tmp59_ = 0LL;
					gint64 _tmp60_ = 0LL;
					GError* _tmp61_ = NULL;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					_tmp59_ = end;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					_tmp60_ = self->total_duration;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					_tmp61_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE, "Invalid %s end time %lldns is beyond the content duration of %lldns", RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp59_, _tmp60_);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					_inner_error_ = _tmp61_;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
						g_propagate_error (error, _inner_error_);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
						range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
						_g_free0 (parsed_range);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
						_g_free0 (range);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
						_g_object_unref0 (self);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
						return NULL;
#line 956 "rygel-http-time-seek-request.c"
					} else {
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
						range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
						_g_free0 (parsed_range);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
						_g_free0 (range);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
						g_clear_error (&_inner_error_);
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
						return NULL;
#line 970 "rygel-http-time-seek-request.c"
					}
				}
			} else {
				gint64 _tmp62_ = 0LL;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				_tmp62_ = end;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				self->end_time = _tmp62_;
#line 979 "rygel-http-time-seek-request.c"
			}
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_tmp63_ = self->end_time;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_tmp64_ = self->start_time;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			self->range_duration = _tmp63_ - _tmp64_;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_tmp65_ = self->range_duration;
#line 145 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			if (_tmp65_ <= ((gint64) 0)) {
#line 991 "rygel-http-time-seek-request.c"
				const gchar* _tmp66_ = NULL;
				GError* _tmp67_ = NULL;
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				_tmp66_ = range;
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				_tmp67_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid %s value (start time after end time - forward scan): '%s'", RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp66_);
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				_inner_error_ = _tmp67_;
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					g_propagate_error (error, _inner_error_);
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					_g_free0 (parsed_range);
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					_g_free0 (range);
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					_g_object_unref0 (self);
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					return NULL;
#line 1014 "rygel-http-time-seek-request.c"
				} else {
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					_g_free0 (parsed_range);
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					_g_free0 (range);
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					g_clear_error (&_inner_error_);
#line 146 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					return NULL;
#line 1028 "rygel-http-time-seek-request.c"
				}
			}
		} else {
			gint64 _tmp68_ = 0LL;
			gint64 _tmp69_ = 0LL;
			gint64 _tmp70_ = 0LL;
			gint64 _tmp71_ = 0LL;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_tmp68_ = end;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			self->end_time = _tmp68_;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_tmp69_ = self->start_time;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_tmp70_ = self->end_time;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			self->range_duration = _tmp69_ - _tmp70_;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_tmp71_ = self->range_duration;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			if (_tmp71_ <= ((gint64) 0)) {
#line 1050 "rygel-http-time-seek-request.c"
				const gchar* _tmp72_ = NULL;
				GError* _tmp73_ = NULL;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				_tmp72_ = range;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				_tmp73_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid %s value (start time before end time - reverse scan): '%s'", RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp72_);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				_inner_error_ = _tmp73_;
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					g_propagate_error (error, _inner_error_);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					_g_free0 (parsed_range);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					_g_free0 (range);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					_g_object_unref0 (self);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					return NULL;
#line 1073 "rygel-http-time-seek-request.c"
				} else {
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					_g_free0 (parsed_range);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					_g_free0 (range);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					g_clear_error (&_inner_error_);
#line 156 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					return NULL;
#line 1087 "rygel-http-time-seek-request.c"
				}
			}
		}
	} else {
		gint64 _tmp74_ = 0LL;
#line 163 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		self->end_time = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp74_ = self->total_duration;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		if (_tmp74_ == RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
#line 165 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			self->range_duration = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
#line 1101 "rygel-http-time-seek-request.c"
		} else {
			gboolean _tmp75_ = FALSE;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_tmp75_ = positive_rate;
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			if (_tmp75_) {
#line 1108 "rygel-http-time-seek-request.c"
				gint64 _tmp76_ = 0LL;
				gint64 _tmp77_ = 0LL;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				_tmp76_ = self->total_duration;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				_tmp77_ = self->start_time;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				self->range_duration = _tmp76_ - _tmp77_;
#line 1117 "rygel-http-time-seek-request.c"
			} else {
				gint64 _tmp78_ = 0LL;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				_tmp78_ = self->start_time;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				self->range_duration = _tmp78_;
#line 1124 "rygel-http-time-seek-request.c"
			}
		}
	}
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_g_free0 (parsed_range);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_g_free0 (range);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	return self;
#line 1136 "rygel-http-time-seek-request.c"
}


RygelHTTPTimeSeekRequest* rygel_http_time_seek_request_new (RygelHTTPGet* request, RygelPlaySpeed* speed, GError** error) {
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	return rygel_http_time_seek_request_construct (RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, request, speed, error);
#line 1143 "rygel-http-time-seek-request.c"
}


gchar* rygel_http_time_seek_request_to_string (RygelHTTPTimeSeekRequest* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp5_ = 0LL;
	gchar* _tmp6_ = NULL;
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp1_ = self->end_time;
#line 178 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	if (_tmp1_ != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
#line 1159 "rygel-http-time-seek-request.c"
		gint64 _tmp2_ = 0LL;
		gchar* _tmp3_ = NULL;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp2_ = self->end_time;
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp3_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp2_);
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_g_free0 (_tmp0_);
#line 179 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp0_ = _tmp3_;
#line 1170 "rygel-http-time-seek-request.c"
	} else {
		gchar* _tmp4_ = NULL;
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp4_ = g_strdup ("*");
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_g_free0 (_tmp0_);
#line 180 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp0_ = _tmp4_;
#line 1179 "rygel-http-time-seek-request.c"
	}
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp5_ = self->start_time;
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp6_ = g_strdup_printf ("HTTPTimeSeekRequest (npt=%lld-%s)", _tmp5_, _tmp0_);
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	result = _tmp6_;
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_g_free0 (_tmp0_);
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	return result;
#line 1191 "rygel-http-time-seek-request.c"
}


/**
     * Return true if time-seek is supported.
     *
     * This method utilizes elements associated with the request to determine if a
     * TimeSeekRange request is supported for the given request/resource.
     */
gboolean rygel_http_time_seek_request_supported (RygelHTTPGet* request) {
	gboolean result = FALSE;
	gboolean force_seek = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GError * _inner_error_ = NULL;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	g_return_val_if_fail (request != NULL, FALSE);
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	force_seek = FALSE;
#line 1211 "rygel-http-time-seek-request.c"
	{
		RygelClientHacks* hack = NULL;
		RygelHTTPGet* _tmp0_ = NULL;
		SoupMessage* _tmp1_ = NULL;
		RygelClientHacks* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp0_ = request;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp2_ = rygel_client_hacks_create (_tmp1_, &_inner_error_);
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		hack = _tmp2_;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1228 "rygel-http-time-seek-request.c"
			goto __catch51_g_error;
		}
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp3_ = rygel_client_hacks_force_seek (hack);
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		force_seek = _tmp3_;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_g_object_unref0 (hack);
#line 1237 "rygel-http-time-seek-request.c"
	}
	goto __finally51;
	__catch51_g_error:
	{
		GError* _error_ = NULL;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_error_ = _inner_error_;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_inner_error_ = NULL;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_g_error_free0 (_error_);
#line 1249 "rygel-http-time-seek-request.c"
	}
	__finally51:
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		g_clear_error (&_inner_error_);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		return FALSE;
#line 1260 "rygel-http-time-seek-request.c"
	}
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp5_ = force_seek;
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	if (_tmp5_) {
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp4_ = TRUE;
#line 1268 "rygel-http-time-seek-request.c"
	} else {
		RygelHTTPGet* _tmp6_ = NULL;
		RygelHTTPGetHandler* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp6_ = request;
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp7_ = _tmp6_->handler;
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp8_ = rygel_http_get_handler_supports_time_seek (_tmp7_);
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp4_ = _tmp8_;
#line 1281 "rygel-http-time-seek-request.c"
	}
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	result = _tmp4_;
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	return result;
#line 1287 "rygel-http-time-seek-request.c"
}


/**
     * Return true of the HTTPGet contains a TimeSeekRange request.
     */
gboolean rygel_http_time_seek_request_requested (RygelHTTPGet* request) {
	gboolean result = FALSE;
	RygelHTTPGet* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupMessageHeaders* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 203 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	g_return_val_if_fail (request != NULL, FALSE);
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp0_ = request;
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp2_ = _tmp1_->request_headers;
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp3_ = soup_message_headers_get_one (_tmp2_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER);
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	result = _tmp3_ != NULL;
#line 204 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	return result;
#line 1314 "rygel-http-time-seek-request.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 996 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 997 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 997 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 997 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 997 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 1332 "rygel-http-time-seek-request.c"
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
#line 789 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (str != NULL, 0.0);
#line 790 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 790 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
#line 790 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 790 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 1350 "rygel-http-time-seek-request.c"
}


static gboolean rygel_http_time_seek_request_parse_npt_seconds (const gchar* range_token, gint64* value) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar _tmp1_ = '\0';
	gboolean _tmp2_ = FALSE;
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	g_return_val_if_fail (range_token != NULL, FALSE);
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp0_ = range_token;
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp1_ = string_get (_tmp0_, (glong) 0);
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp2_ = g_ascii_isdigit (_tmp1_);
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	if (_tmp2_) {
#line 1369 "rygel-http-time-seek-request.c"
		const gchar* _tmp3_ = NULL;
		gdouble _tmp4_ = 0.0;
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp3_ = range_token;
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp4_ = double_parse (_tmp3_);
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		*value = (gint64) (_tmp4_ * G_TIME_SPAN_SECOND);
#line 1378 "rygel-http-time-seek-request.c"
	} else {
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		result = FALSE;
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		return result;
#line 1384 "rygel-http-time-seek-request.c"
	}
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	result = TRUE;
#line 215 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	return result;
#line 1390 "rygel-http-time-seek-request.c"
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 900 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 900 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 901 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 901 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = needle;
#line 901 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
#line 901 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 903 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 903 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 1417 "rygel-http-time-seek-request.c"
		gchar* _tmp4_ = NULL;
#line 904 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 904 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 904 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 1425 "rygel-http-time-seek-request.c"
	} else {
#line 906 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = -1;
#line 906 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 1431 "rygel-http-time-seek-request.c"
	}
}


static gboolean rygel_http_time_seek_request_parse_npt_time (const gchar* range_token, gint64* value) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint64 seconds_sum = 0LL;
	gint time_factor = 0;
	gchar** time_tokens = NULL;
	gint time_tokens_length1 = 0;
	gint _time_tokens_size_ = 0;
	const gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	const gchar* _tmp11_ = NULL;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint64 _tmp26_ = 0LL;
#line 221 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp0_ = range_token;
#line 221 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	if (_tmp0_ == NULL) {
#line 222 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		result = FALSE;
#line 222 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		return result;
#line 1465 "rygel-http-time-seek-request.c"
	}
#line 225 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp1_ = range_token;
#line 225 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp2_ = string_index_of (_tmp1_, ":", 0);
#line 225 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	if (_tmp2_ == (-1)) {
#line 1473 "rygel-http-time-seek-request.c"
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp3_ = range_token;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp4_ = rygel_http_time_seek_request_parse_npt_seconds (_tmp3_, value);
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		result = _tmp4_;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		return result;
#line 1484 "rygel-http-time-seek-request.c"
	}
#line 229 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	seconds_sum = (gint64) 0;
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	time_factor = 0;
#line 233 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	seconds_sum = (gint64) 0;
#line 234 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	time_factor = 3600;
#line 236 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp5_ = range_token;
#line 236 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, ":", 3);
#line 236 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 236 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	time_tokens = _tmp7_;
#line 236 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	time_tokens_length1 = _vala_array_length (_tmp6_);
#line 236 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_time_tokens_size_ = time_tokens_length1;
#line 237 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp10_ = time_tokens;
#line 237 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp10__length1 = time_tokens_length1;
#line 237 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp11_ = _tmp10_[0];
#line 237 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	if (_tmp11_ == NULL) {
#line 237 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp9_ = TRUE;
#line 1516 "rygel-http-time-seek-request.c"
	} else {
		gchar** _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
		const gchar* _tmp13_ = NULL;
#line 238 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp12_ = time_tokens;
#line 238 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp12__length1 = time_tokens_length1;
#line 238 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp13_ = _tmp12_[1];
#line 238 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp9_ = _tmp13_ == NULL;
#line 1529 "rygel-http-time-seek-request.c"
	}
#line 237 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	if (_tmp9_) {
#line 237 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp8_ = TRUE;
#line 1535 "rygel-http-time-seek-request.c"
	} else {
		gchar** _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		const gchar* _tmp15_ = NULL;
#line 239 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp14_ = time_tokens;
#line 239 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp14__length1 = time_tokens_length1;
#line 239 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp15_ = _tmp14_[2];
#line 239 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		_tmp8_ = _tmp15_ == NULL;
#line 1548 "rygel-http-time-seek-request.c"
	}
#line 237 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	if (_tmp8_) {
#line 240 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		result = FALSE;
#line 240 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 240 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		return result;
#line 1558 "rygel-http-time-seek-request.c"
	}
#line 243 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp16_ = time_tokens;
#line 243 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp16__length1 = time_tokens_length1;
#line 1564 "rygel-http-time-seek-request.c"
	{
		gchar** time_collection = NULL;
		gint time_collection_length1 = 0;
		gint _time_collection_size_ = 0;
		gint time_it = 0;
#line 243 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		time_collection = _tmp16_;
#line 243 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		time_collection_length1 = _tmp16__length1;
#line 243 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
		for (time_it = 0; time_it < _tmp16__length1; time_it = time_it + 1) {
#line 1576 "rygel-http-time-seek-request.c"
			gchar* _tmp17_ = NULL;
			gchar* time = NULL;
#line 243 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			_tmp17_ = g_strdup (time_collection[time_it]);
#line 243 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
			time = _tmp17_;
#line 1583 "rygel-http-time-seek-request.c"
			{
				const gchar* _tmp18_ = NULL;
				gchar _tmp19_ = '\0';
				gboolean _tmp20_ = FALSE;
				gint _tmp25_ = 0;
#line 244 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				_tmp18_ = time;
#line 244 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				_tmp19_ = string_get (_tmp18_, (glong) 0);
#line 244 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				_tmp20_ = g_ascii_isdigit (_tmp19_);
#line 244 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				if (_tmp20_) {
#line 1597 "rygel-http-time-seek-request.c"
					gint64 _tmp21_ = 0LL;
					const gchar* _tmp22_ = NULL;
					gdouble _tmp23_ = 0.0;
					gint _tmp24_ = 0;
#line 245 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					_tmp21_ = seconds_sum;
#line 245 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					_tmp22_ = time;
#line 245 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					_tmp23_ = double_parse (_tmp22_);
#line 245 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					_tmp24_ = time_factor;
#line 245 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					seconds_sum = _tmp21_ + ((gint64) ((_tmp23_ * G_TIME_SPAN_SECOND) * _tmp24_));
#line 1612 "rygel-http-time-seek-request.c"
				} else {
#line 247 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					result = FALSE;
#line 247 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					_g_free0 (time);
#line 247 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 247 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
					return result;
#line 1622 "rygel-http-time-seek-request.c"
				}
#line 249 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				_tmp25_ = time_factor;
#line 249 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				time_factor = _tmp25_ / 60;
#line 243 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
				_g_free0 (time);
#line 1630 "rygel-http-time-seek-request.c"
			}
		}
	}
#line 251 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	_tmp26_ = seconds_sum;
#line 251 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	*value = _tmp26_;
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	result = TRUE;
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	return result;
#line 1644 "rygel-http-time-seek-request.c"
}


static void rygel_http_time_seek_request_class_init (RygelHTTPTimeSeekRequestClass * klass) {
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	rygel_http_time_seek_request_parent_class = g_type_class_peek_parent (klass);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_time_seek_request_finalize;
#line 1653 "rygel-http-time-seek-request.c"
}


static void rygel_http_time_seek_request_instance_init (RygelHTTPTimeSeekRequest * self) {
}


static void rygel_http_time_seek_request_finalize (GObject* obj) {
	RygelHTTPTimeSeekRequest * self;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, RygelHTTPTimeSeekRequest);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-request.vala"
	G_OBJECT_CLASS (rygel_http_time_seek_request_parent_class)->finalize (obj);
#line 1667 "rygel-http-time-seek-request.c"
}


/**
 * This class represents a DLNA TimeSeekRange request.
 *
 * A TimeSeekRange request can only have a time range ("npt=start-end").
 */
GType rygel_http_time_seek_request_get_type (void) {
	static volatile gsize rygel_http_time_seek_request_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_time_seek_request_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTimeSeekRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_time_seek_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTimeSeekRequest), 0, (GInstanceInitFunc) rygel_http_time_seek_request_instance_init, NULL };
		GType rygel_http_time_seek_request_type_id;
		rygel_http_time_seek_request_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK_REQUEST, "RygelHTTPTimeSeekRequest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_time_seek_request_type_id__volatile, rygel_http_time_seek_request_type_id);
	}
	return rygel_http_time_seek_request_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



